/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.instrument;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.instrument.CharacterRangeTableAttribute;
import com.sun.tdk.jcov.instrument.DataClass;
import com.sun.tdk.jcov.instrument.DataPackage;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.DeferringMethodClassAdapter;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.instrument.InstrumentationParams;
import com.sun.tdk.jcov.instrument.InvokeClassAdapter;
import com.sun.tdk.jcov.instrument.OffsetLabelingClassReader;
import com.sun.tdk.jcov.instrument.OverriddenClassWriter;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.runtime.Collect;
import com.sun.tdk.jcov.runtime.FileSaver;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.util.DebugUtils;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public class ClassMorph {
    private DataRoot root;
    private final String outputFile;
    private HashMap<String, Long> instrumented = new HashMap();
    private HashMap<String, byte[]> instrumentedValues = new HashMap();
    private static final boolean IS_SELFTEST = System.getProperty("jcov.selftest") != null;
    private final InstrumentationParams params;
    private boolean rtClassesInstrumented = false;
    private static final Logger logger;
    public static final OptionDescr DSC_FLUSH_CLASSES;

    public ClassMorph(String filename, DataRoot root, InstrumentationParams params) {
        this.outputFile = filename;
        this.root = root;
        this.params = params;
        this.rtClassesInstrumented = params.isDataSaveSpecified();
        this.findAlreadyInstrumentedAndSetID();
    }

    public ClassMorph(InstrumentationParams params, String template) {
        this(template, new DataRoot(params), params);
        this.root.getXMLHeadProperties().put("os.name", System.getProperty("os.name"));
        this.root.getXMLHeadProperties().put("os.arch", System.getProperty("os.arch"));
        this.root.getXMLHeadProperties().put("os.version", System.getProperty("os.version"));
        this.root.getXMLHeadProperties().put("user.name", System.getProperty("user.name"));
        this.root.getXMLHeadProperties().put("java.version", System.getProperty("java.version"));
        this.root.getXMLHeadProperties().put("java.runtime.version", System.getProperty("java.runtime.version"));
    }

    public boolean isTransformable(String className) {
        if (className.equals("java/lang/Object") && !this.params.isDynamicCollect() && this.params.isIncluded(className)) {
            logger.log(Level.WARNING, "java.lang.Object can't be statically instrumented and was excluded");
            return false;
        }
        if (className.startsWith("com/sun/tdk/jcov") && !IS_SELFTEST || className.startsWith("org/objectweb/asm")) {
            logger.log(Level.INFO, "{0} - skipped (should not perform self-instrument)", className);
            return false;
        }
        if (className.startsWith("sun/reflect/Generated")) {
            logger.log(Level.WARNING, "{0} - skipped (should not instrument generated classes)");
            return false;
        }
        return true;
    }

    public boolean isAlreadyTransformed(String className) {
        return this.instrumented.containsKey(className);
    }

    public boolean shouldTransform(String className) {
        return this.isTransformable(className) && !this.isAlreadyTransformed(className) && this.params.isIncluded(className);
    }

    public byte[] morph(byte[] classfileBuffer, ClassLoader loader, String flushPath) throws IOException {
        boolean shouldFlush;
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (classfileBuffer[0] != -54 || classfileBuffer[1] != -2 || classfileBuffer[2] != -70 || classfileBuffer[3] != -66) {
            throw new IOException("Not a java classfile (0xCAFEBABE header not found)");
        }
        OffsetLabelingClassReader cr = new OffsetLabelingClassReader(classfileBuffer);
        String fullname = cr.getClassName();
        if (!this.isTransformable(fullname)) {
            return null;
        }
        boolean bl = shouldFlush = flushPath != null;
        if (this.isAlreadyTransformed(fullname)) {
            long cs = ClassMorph.computeCheckSum(classfileBuffer);
            Long oldCs = this.instrumented.get(fullname);
            if (oldCs > 0L) {
                if (cs == oldCs && flushPath != null) {
                    logger.log(Level.FINE, "{0} - instrumented copy used", fullname);
                    return DebugUtils.readClass(fullname, flushPath);
                }
                logger.log(Level.WARNING, "application has different classes with the same name: {0}", fullname);
            }
        }
        if (this.params.isClassesReload() && !this.shouldTransform(fullname) && this.isAlreadyTransformed(fullname) && this.params.isDynamicCollect()) {
            return this.instrumentedValues.get(fullname);
        }
        if (!this.shouldTransform(fullname)) {
            if (!this.params.isDynamicCollect() || !this.params.isCallerFilterOn() && !this.params.isInstrumentFields()) {
                if (this.isAlreadyTransformed(fullname)) {
                    logger.log(Level.INFO, "{0} - skipped (already instrumented)", fullname);
                }
                if (!this.params.isIncluded(fullname)) {
                    logger.log(Level.INFO, "{0} - skipped (is not included or is excluded explicitly)", fullname);
                }
                return null;
            }
            OverriddenClassWriter cw = new OverriddenClassWriter(cr, 1, loader);
            ClassVisitor cv = shouldFlush ? new TraceClassVisitor(cw, DebugUtils.getPrintWriter(fullname, flushPath)) : cw;
            cv = new InvokeClassAdapter(cv, this.params);
            cr.accept(cv, 0);
            byte[] res = cw.toByteArray();
            if (shouldFlush) {
                DebugUtils.flushInstrumentedClass(flushPath, fullname, res);
            }
            if (!this.params.isDynamicCollect() && !this.rtClassesInstrumented && this.isPreVMLoadClass(fullname)) {
                this.rtClassesInstrumented = true;
                logger.log(Level.WARNING, "It's possible that you are instrumenting classes which are loaded before VM is loaded. It's recomended to add saveatend at java/lang/Shutdown.runHooks method. Data could be lost otherwise.");
            }
            return res;
        }
        long checksum = this.params.isDynamicCollect() ? -1L : ClassMorph.computeCheckSum(classfileBuffer);
        int opt = 1;
        if (this.params.isStackMapShouldBeUpdated() && this.params.isDynamicCollect() && classfileBuffer[7] == 50) {
            classfileBuffer[7] = 49;
        }
        if (classfileBuffer[7] > 49) {
            opt = 2;
        }
        OverriddenClassWriter cw = new OverriddenClassWriter(cr, opt, loader);
        DataClass k = new DataClass(this.root.rootId(), fullname, checksum, false);
        ClassVisitor cv = cw;
        cv = new DeferringMethodClassAdapter(cv, k, this.params);
        cr.accept(cv, new Attribute[]{new CharacterRangeTableAttribute(this.root.rootId())}, 0);
        if (k.hasModifier(4096) && !this.params.isInstrumentSynthetic()) {
            return null;
        }
        this.root.addClass(k);
        this.instrumented.put(fullname, checksum);
        this.instrumentedValues.put(fullname, cw.toByteArray());
        byte[] res = cw.toByteArray();
        if (shouldFlush) {
            DebugUtils.flushInstrumentedClass(flushPath, fullname, res);
        }
        if (!this.params.isDynamicCollect() && !this.rtClassesInstrumented && this.isPreVMLoadClass(fullname)) {
            this.rtClassesInstrumented = true;
            logger.log(Level.WARNING, "It's possible that you are instrumenting classes which are loaded before VM is loaded. It's recomended to add saveatend at java/lang/Shutdown.runHooks method. Data could be lost otherwise.");
        }
        return res;
    }

    public static long computeCheckSum(byte[] classfileBuffer) {
        int name_index;
        int k;
        int clone_attr_count;
        int i = 0;
        i += 4;
        int cp_count = (classfileBuffer[i += 4] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
        i += 2;
        HashMap<Integer, String> cp_utf8_cache = new HashMap<Integer, String>();
        block13: for (int j = 0; j < cp_count - 1; ++j) {
            byte cp_type = classfileBuffer[i++];
            switch (cp_type) {
                case 1: {
                    int utf8_length = (classfileBuffer[i] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
                    String sval = new String(classfileBuffer, i += 2, utf8_length, Charset.forName("UTF-8"));
                    cp_utf8_cache.put(j + 1, sval);
                    i += utf8_length;
                    continue block13;
                }
                case 3: 
                case 4: {
                    i += 4;
                    continue block13;
                }
                case 5: 
                case 6: {
                    ++j;
                    i += 8;
                    continue block13;
                }
                case 7: {
                    i += 2;
                    continue block13;
                }
                case 8: {
                    i += 2;
                    continue block13;
                }
                case 9: 
                case 10: 
                case 11: {
                    i += 4;
                    continue block13;
                }
                case 12: {
                    i += 4;
                    continue block13;
                }
                case 15: {
                    i += 3;
                    continue block13;
                }
                case 16: {
                    i += 2;
                    continue block13;
                }
                case 18: {
                    i += 4;
                    continue block13;
                }
                case 19: 
                case 20: {
                    i += 4;
                    continue block13;
                }
                default: {
                    logger.log(Level.SEVERE, "SHOULD NOT OCCUR: unknown cp_type: {0}", cp_type);
                }
            }
        }
        i += 2;
        i += 2;
        int i_count = (classfileBuffer[i += 2] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
        i += 2;
        int fld_count = (classfileBuffer[i += 2 * i_count] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
        byte[] clone = new byte[classfileBuffer.length];
        int clone_ptr = i += 2;
        System.arraycopy(classfileBuffer, 0, clone, 0, clone_ptr);
        for (int j = 0; j < fld_count; ++j) {
            int f_start = i;
            int attr_count = (classfileBuffer[i += 6] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
            i += 2;
            int[][] attr_ptrs = new int[attr_count][2];
            clone_attr_count = 0;
            for (k = 0; k < attr_count; ++k) {
                name_index = (classfileBuffer[i] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
                long fld_attr_length = (classfileBuffer[i += 2] & 0xFF) << 24 | (classfileBuffer[i + 1] & 0xFF) << 16 | (classfileBuffer[i + 2] & 0xFF) << 8 | classfileBuffer[i + 3] & 0xFF;
                i += 4;
                i = (int)((long)i + fld_attr_length);
                if (((String)cp_utf8_cache.get(name_index)).contains("Deprecated")) continue;
                attr_ptrs[clone_attr_count][1] = 6 + (int)fld_attr_length;
                attr_ptrs[clone_attr_count][0] = i - attr_ptrs[clone_attr_count][1];
                ++clone_attr_count;
            }
            System.arraycopy(classfileBuffer, f_start, clone, clone_ptr, 6);
            clone_ptr += 6;
            clone[clone_ptr++] = (byte)(clone_attr_count >> 8);
            clone[clone_ptr++] = (byte)clone_attr_count;
            for (int l = 0; l < clone_attr_count; ++l) {
                System.arraycopy(classfileBuffer, attr_ptrs[l][0], clone, clone_ptr, attr_ptrs[l][1]);
                clone_ptr += attr_ptrs[l][1];
            }
        }
        int mth_count = (classfileBuffer[i] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
        clone[clone_ptr] = classfileBuffer[i];
        clone[++clone_ptr] = classfileBuffer[++i];
        ++clone_ptr;
        ++i;
        TreeMap<String, byte[]> methods = new TreeMap<String, byte[]>();
        for (int j = 0; j < mth_count; ++j) {
            int m_start = i;
            int name_index2 = (classfileBuffer[i += 2] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
            int descriptor_index = (classfileBuffer[i += 2] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
            int attr_count = (classfileBuffer[i += 2] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
            i += 2;
            int[][] attr_ptrs = new int[attr_count][2];
            int clone_attr_count2 = 0;
            int whole_attr_length = 0;
            for (int k2 = 0; k2 < attr_count; ++k2) {
                int attr_name_index = (classfileBuffer[i] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
                long mth_attr_length = (classfileBuffer[i += 2] & 0xFF) << 24 | (classfileBuffer[i + 1] & 0xFF) << 16 | (classfileBuffer[i + 2] & 0xFF) << 8 | classfileBuffer[i + 3] & 0xFF;
                i += 4;
                i = (int)((long)i + mth_attr_length);
                if (((String)cp_utf8_cache.get(attr_name_index)).contains("Deprecated")) continue;
                attr_ptrs[clone_attr_count2][1] = 6 + (int)mth_attr_length;
                whole_attr_length += attr_ptrs[clone_attr_count2][1];
                attr_ptrs[clone_attr_count2][0] = i - attr_ptrs[clone_attr_count2][1];
                ++clone_attr_count2;
            }
            byte[] data = new byte[8 + whole_attr_length];
            System.arraycopy(classfileBuffer, m_start, data, 0, 6);
            data[6] = (byte)(clone_attr_count2 >> 8);
            data[7] = (byte)clone_attr_count2;
            int data_ptr = 0;
            for (int l = 0; l < clone_attr_count2; ++l) {
                System.arraycopy(classfileBuffer, attr_ptrs[l][0], data, data_ptr + 8, attr_ptrs[l][1]);
                data_ptr += attr_ptrs[l][1];
            }
            methods.put((String)cp_utf8_cache.get(name_index2) + (String)cp_utf8_cache.get(descriptor_index), data);
        }
        for (byte[] data : methods.values()) {
            System.arraycopy(data, 0, clone, clone_ptr, data.length);
            clone_ptr += data.length;
        }
        TreeMap attributes = new TreeMap();
        int attr_count = (classfileBuffer[i] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
        i += 2;
        clone_attr_count = 0;
        for (k = 0; k < attr_count; ++k) {
            name_index = (classfileBuffer[i] & 0xFF) << 8 | classfileBuffer[i + 1] & 0xFF;
            long class_attr_length = (classfileBuffer[i += 2] & 0xFF) << 24 | (classfileBuffer[i + 1] & 0xFF) << 16 | (classfileBuffer[i + 2] & 0xFF) << 8 | classfileBuffer[i + 3] & 0xFF;
            i += 4;
            i = (int)((long)i + class_attr_length);
            if (((String)cp_utf8_cache.get(name_index)).contains("Deprecated") || ((String)cp_utf8_cache.get(name_index)).contains("EnclosingMethod")) continue;
            ++clone_attr_count;
            byte[] data = new byte[6 + (int)class_attr_length];
            System.arraycopy(classfileBuffer, i - data.length, data, 0, data.length);
            attributes.put(cp_utf8_cache.get(name_index), data);
        }
        clone[clone_ptr++] = (byte)(clone_attr_count >> 8);
        clone[clone_ptr++] = (byte)clone_attr_count;
        for (byte[] data : attributes.values()) {
            System.arraycopy(data, 0, clone, clone_ptr, data.length);
            clone_ptr += data.length;
        }
        Adler32 adler = new Adler32();
        adler.update(clone, 0, clone_ptr);
        long checksum = adler.getValue();
        return checksum;
    }

    private void findAlreadyInstrumentedAndSetID() {
        try {
            DataRoot r;
            if (this.outputFile == null) {
                return;
            }
            File file = new File(this.outputFile);
            if (!file.exists()) {
                return;
            }
            if (this.params.isDynamicCollect()) {
                r = Reader.readXMLHeader(this.outputFile);
            } else {
                r = Reader.readXML(this.outputFile, true, null);
                for (DataPackage pack : r.getPackages()) {
                    for (DataClass clazz : pack.getClasses()) {
                        this.instrumented.put(clazz.getFullname(), clazz.getChecksum());
                    }
                }
            }
            Collect.setSlot(r.getCount());
            r.destroy();
        }
        catch (FileFormatException ffe) {
            System.err.println("Wrong format of the output file: " + this.outputFile + ". " + "Delete output file to receive coverage data");
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void saveData(InstrumentationOptions.MERGE merge) {
        FileSaver fileSaver = FileSaver.getFileSaver(this.root, this.outputFile, this.outputFile, merge, true, false);
        fileSaver.saveResults();
    }

    public void saveData(String outputFile, InstrumentationOptions.MERGE merge) {
        FileSaver fileSaver = FileSaver.getFileSaver(this.root, outputFile, outputFile, merge, true, false);
        fileSaver.saveResults();
    }

    public void saveData(String outputTemplateFile, String initialTemplatePath, InstrumentationOptions.MERGE merge) {
        FileSaver fileSaver = FileSaver.getFileSaver(this.root, outputTemplateFile, initialTemplatePath, merge, true, false);
        fileSaver.saveResults();
    }

    private boolean isPreVMLoadClass(String fullname) {
        return fullname.startsWith("java/lang") || fullname.startsWith("sun") || fullname.startsWith("java/util");
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(ClassMorph.class.getName());
        DSC_FLUSH_CLASSES = new OptionDescr("flush", null, "flush instrumented classes", 1, null, "Specify path to directory, where to store instrumented classes.\nDirectory should exist. Classes will be saved in respect to their package hierarchy.\nDefault value is \"none\". Pushing it means you don't want to flush classes.", "none");
    }
}

