/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.data;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.tools.ScaleCompressor;
import com.sun.tdk.jcov.util.Utils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Scale {
    public static final String sccsVersion = "%I% $LastChangedDate: 2012-06-20 12:45:52 +0400 (Wed, 20 Jun 2012) $";
    private static Scale buf_scale = new Scale();
    protected byte[] bytes;
    protected int size;

    private Scale() {
    }

    public Scale(char[] scale, int len, int size, ScaleCompressor compressor, boolean compressed) throws FileFormatException {
        this.size = size;
        this.bytes = new byte[Scale.bytesRequiredFor(size)];
        if (compressed) {
            try {
                compressor.decompress(scale, len, this.bytes, size);
            }
            catch (Exception e) {
                throw new FileFormatException(e);
            }
        } else {
            int l = (size + 7) / 8;
            for (int i = 0; i < l; ++i) {
                byte b1;
                int ind = 2 * i;
                char val = scale[ind];
                byte by = b1 = val >= 'a' ? (byte)(10 + val - 97) : (byte)(val - 48);
                if (ind + 1 < scale.length) {
                    val = scale[ind + 1];
                    byte b2 = val >= 'a' ? (byte)(10 + val - 97) : (byte)(val - 48);
                    this.bytes[i] = (byte)(b1 | b2 << 4);
                    continue;
                }
                this.bytes[i] = b1;
            }
            if (1 <= size % 8 && size % 8 <= 4) {
                int lastByte = this.bytes.length - 1;
                this.bytes[lastByte] = (byte)(this.bytes[lastByte] & 0xF);
            }
        }
    }

    public int size() {
        return this.size;
    }

    public int getSetBitsCount() {
        int res = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.isBitSet(i)) continue;
            ++res;
        }
        return res;
    }

    public boolean isBitSet(int pos) {
        if (pos < 0 || pos >= this.size) {
            return false;
        }
        int ind = pos / 8;
        byte val = this.bytes[ind];
        int sft = pos % 8;
        byte mask = (byte)(1 << sft);
        return (val & mask) != 0;
    }

    public void setBit(int pos, boolean to_one) {
        if (pos < 0 || pos >= this.size) {
            return;
        }
        int ind = pos / 8;
        int sft = pos % 8;
        byte val = this.bytes[ind];
        byte mask = (byte)(1 << sft);
        this.bytes[ind] = to_one ? (byte)((val | mask) & 0xFF) : (byte)(val & ~mask & 0xFF);
    }

    static int bytesRequiredFor(int scale_size) {
        return (scale_size + 8 - 1) / 8;
    }

    static Scale createZeroScale(int size) {
        Scale res = new Scale();
        res.size = size;
        res.bytes = new byte[Scale.bytesRequiredFor(size)];
        return res;
    }

    void addZeroes(int num, boolean add_before) {
        int new_size = num + this.size;
        int new_len = Scale.bytesRequiredFor(new_size);
        int bytes_extra = new_len - this.bytes.length;
        byte[] sav = this.bytes;
        if (bytes_extra > 0) {
            this.bytes = new byte[sav.length + bytes_extra];
        }
        if (add_before) {
            if (Scale.buf_scale.bytes.length < sav.length) {
                Scale.buf_scale.bytes = new byte[sav.length];
            }
            System.arraycopy(sav, 0, Scale.buf_scale.bytes, 0, sav.length);
            Scale.buf_scale.size = this.size;
            int i = 0;
            while (i < this.bytes.length) {
                this.bytes[i++] = 0;
            }
            this.size = num;
            Scale.merge(this, buf_scale);
        } else {
            int len;
            int rmndr;
            if (bytes_extra > 0) {
                System.arraycopy(sav, 0, this.bytes, 0, sav.length);
            }
            if ((rmndr = (len = Scale.bytesRequiredFor(this.size)) * 8 - this.size) > 0) {
                byte mask = (byte)((1 << 8 - rmndr) - 1);
                int n = len - 1;
                this.bytes[n] = (byte)(this.bytes[n] & mask);
            }
            int i = len;
            while (i < new_len) {
                this.bytes[i++] = 0;
            }
            this.size = new_size;
        }
    }

    public static Scale merge(Scale s1, Scale s2, long count1, long count2) {
        Scale res;
        if (s1 == null) {
            res = s2 == null ? Scale.merge(count1, count2) : Scale.merge(count1, s2);
        } else {
            if (s2 == null) {
                Scale.merge(s1, count2);
            } else {
                Scale.merge(s1, s2);
            }
            res = s1;
        }
        return res;
    }

    static Scale merge(long count0, long count1) {
        Scale res = new Scale();
        res.bytes = new byte[1];
        res.size = 2;
        if (count0 > 0L) {
            count0 = 1L;
        }
        if (count1 > 0L) {
            count1 = 1L;
        }
        res.bytes[0] = (byte)(count0 | count1 << 1);
        return res;
    }

    static Scale merge(long count, Scale scale) {
        Scale res = new Scale();
        res.bytes = new byte[Scale.bytesRequiredFor(scale.size + 1)];
        res.size = 1;
        if (count > 0L) {
            res.bytes[0] = 1;
        }
        Scale.merge(res, scale);
        return res;
    }

    static void merge(Scale scale, long count) {
        int i = scale.size / 8;
        int j = scale.size % 8;
        ++scale.size;
        if (i >= scale.bytes.length) {
            byte[] sav = scale.bytes;
            scale.bytes = new byte[i + 1];
            System.arraycopy(sav, 0, scale.bytes, 0, i);
            sav = null;
        }
        if (count == 0L) {
            return;
        }
        int n = i;
        scale.bytes[n] = (byte)(scale.bytes[n] | (byte)(1 << j));
    }

    static void merge(Scale dst, Scale src) {
        int old_dst_len = Scale.bytesRequiredFor(dst.size);
        int new_dst_len = Scale.bytesRequiredFor(dst.size + src.size);
        int src_len = Scale.bytesRequiredFor(src.size);
        if (dst.bytes.length * 8 < dst.size + src.size) {
            byte[] sav = dst.bytes;
            dst.bytes = new byte[new_dst_len];
            System.arraycopy(sav, 0, dst.bytes, 0, old_dst_len);
            sav = null;
        }
        byte[] dst_bytes = dst.bytes;
        byte[] src_bytes = src.bytes;
        if (dst.size % 8 == 0) {
            System.arraycopy(src_bytes, 0, dst_bytes, old_dst_len, src_len);
            dst.size += src.size;
        } else {
            int j;
            int dst_rmndr = dst.size % 8;
            int src_rmndr = src.size % 8;
            byte dst_mask = (byte)((1 << dst_rmndr) - 1);
            int i = old_dst_len - 1;
            for (j = 0; j < src_len - 1; ++j) {
                dst_bytes[i] = (byte)((dst_bytes[i] & dst_mask | src_bytes[j] << dst_rmndr) & 0xFF);
                dst_bytes[i + 1] = (byte)(src_bytes[j] >>> 8 - dst_rmndr & 0xFF);
                ++i;
            }
            dst_bytes[i] = (byte)(dst_bytes[i] & dst_mask | src_bytes[j] << dst_rmndr);
            if (i < dst_bytes.length - 1) {
                int src_mask = src_rmndr == 0 ? 255 : (1 << src_rmndr) - 1;
                dst_bytes[i + 1] = (byte)((src_bytes[j] & src_mask) >>> 8 - dst_rmndr & 0xFF);
            }
            dst.size += src.size;
        }
    }

    public int convertToChars(boolean compress, StringBuffer buf, ScaleCompressor compressor) {
        if (compress) {
            return compressor.compress(this.bytes, buf, this.size);
        }
        int res = Utils.halfBytesRequiredFor(this.size);
        for (int i = res - 1; i >= 0; --i) {
            buf.setCharAt(i, Utils.int2HexChar(Utils.getHalfByteAt(i, this.bytes)));
        }
        return res;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.size + this.size / 4);
        for (int i = 0; i < this.size; ++i) {
            if (i % 4 == 0 && i != 0 && i <= this.size - 1) {
                buf.append('_');
            }
            char ch = this.isBitSet(i) ? (char)'1' : '0';
            buf.append(ch);
        }
        return buf.toString();
    }

    public static Scale illuminateDuplicates(Scale scale, int new_size, ArrayList pairs) {
        if (scale == null) {
            return null;
        }
        for (Utils.Pair p : pairs) {
            scale.setBit(p.a, scale.isBitSet(p.a) | scale.isBitSet(p.b));
        }
        Scale old = scale;
        scale = Scale.createZeroScale(new_size);
        Iterator it = pairs.iterator();
        int iremove = it.hasNext() ? ((Utils.Pair)it.next()).b : new_size;
        int old_size = old.size;
        int inew = 0;
        for (int iold = 0; inew < new_size && iold < old_size; ++inew, ++iold) {
            while (iold == iremove) {
                iremove = it.hasNext() ? ((Utils.Pair)it.next()).b : old_size;
                ++iold;
            }
            scale.setBit(inew, old.isBitSet(iold));
        }
        return scale;
    }

    public static Scale expandScale(Scale scale, int new_size, boolean add_before, long dataCount) {
        if (scale == null) {
            scale = Scale.createZeroScale(new_size);
            if (dataCount > 0L) {
                int pos = add_before ? new_size - 1 : 0;
                scale.setBit(pos, true);
            }
        } else if (new_size > scale.size) {
            scale.addZeroes(new_size - scale.size, add_before);
            if (dataCount > 0L) {
                int pos = add_before ? 0 : new_size - 1;
                scale.setBit(pos, true);
            }
        }
        return scale;
    }

    public void writeObject(DataOutput out) throws IOException {
        out.writeShort(this.bytes.length);
        out.write(this.bytes);
    }

    public Scale(DataInput in) throws IOException {
        short len = in.readShort();
        this.bytes = new byte[len];
        in.readFully(this.bytes);
    }

    static {
        Scale.buf_scale.bytes = new byte[1024];
    }
}

