/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.ant;

import com.sun.tdk.jcov.RepGen;
import com.sun.tdk.jcov.ant.AntableSPI;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.processing.ProcessingException;
import com.sun.tdk.jcov.report.DefaultReportGeneratorSPI;
import com.sun.tdk.jcov.report.ReportGeneratorSPI;
import com.sun.tdk.jcov.runtime.PropertyFinder;
import com.sun.tdk.jcov.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.PatternSet;

public class Report
extends Task
implements DynamicAttribute {
    private PatternSet filter;
    public File srcRootPath;
    public boolean noAbstract = false;
    public boolean isPublicAPI = false;
    public boolean noline = false;
    public boolean noblock = false;
    public boolean nobranch = false;
    public boolean nomethod = false;
    public boolean nofields = false;
    public String customFilter;
    public String customReportSPI;
    public ReportGeneratorSPI customReportSPIInstance;
    public String format = "html";
    public File destdir = new File("report");
    public File propfile = null;
    public File filename;
    public File testlist;
    public boolean rewrite;
    public File fmlist;
    public LinkedList<FM> fm = new LinkedList();
    private boolean customAttributes;

    public void setDynamicAttribute(String attrName, String attrVal) throws BuildException {
        boolean ok = false;
        if (this.customReportSPIInstance != null && this.customReportSPIInstance instanceof AntableSPI) {
            ok = ((AntableSPI)((Object)this.customReportSPIInstance)).handleAttribute(attrName, attrVal);
        }
        if (!ok) {
            try {
                IntrospectionHelper.getHelper(this.customReportSPIInstance.getClass()).setAttribute(this.getProject(), (Object)this.customReportSPIInstance, attrName, attrVal);
            }
            catch (Exception ex) {
                throw new UnsupportedAttributeException("report has no such attribute '" + attrName + "' neither in Report ServiceProvider '" + this.customReportSPIInstance.getClass() + "'", attrName);
            }
        } else {
            this.customAttributes = true;
        }
    }

    public void maybeConfigure() throws BuildException {
        RuntimeConfigurable rt = this.getRuntimeConfigurableWrapper();
        boolean found = false;
        for (Map.Entry o : rt.getAttributeMap().entrySet()) {
            Map.Entry e = o;
            if (!"ReportSPI".equalsIgnoreCase(e.getKey().toString())) continue;
            try {
                this.customReportSPI = e.getValue().toString();
                this.customReportSPIInstance = (ReportGeneratorSPI)Class.forName(this.customReportSPI).newInstance();
                found = true;
                break;
            }
            catch (ClassNotFoundException ex) {
                throw new BuildException("Can't create report generator " + this.customReportSPI, (Throwable)ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException("Can't create report generator " + this.customReportSPI, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new BuildException("Can't create report generator " + this.customReportSPI, (Throwable)ex);
            }
            catch (ClassCastException ex) {
                throw new BuildException("Can't create report generator " + this.customReportSPI + " - not a ReportGeneratorSPI", (Throwable)ex);
            }
        }
        if (!found) {
            this.customReportSPIInstance = new DefaultReportGeneratorSPI();
        }
        super.maybeConfigure();
    }

    public void execute() throws BuildException {
        RepGen repGen = new RepGen();
        if (this.propfile != null) {
            PropertyFinder.setPropertiesFile(this.propfile.getPath());
        }
        if (this.customReportSPIInstance.getClass() == DefaultReportGeneratorSPI.class && !this.customAttributes) {
            this.nomethod = Boolean.valueOf(PropertyFinder.findValue("nomethod", String.valueOf(this.nomethod)));
            this.noblock = Boolean.valueOf(PropertyFinder.findValue("noblock", String.valueOf(this.noblock)));
            this.nobranch = Boolean.valueOf(PropertyFinder.findValue("nobranch", String.valueOf(this.nobranch)));
            this.noline = Boolean.valueOf(PropertyFinder.findValue("noline", String.valueOf(this.noline)));
            this.nofields = Boolean.valueOf(PropertyFinder.findValue("nofields", String.valueOf(this.nofields)));
            ((DefaultReportGeneratorSPI)this.customReportSPIInstance).handleAttribute("hideMethods", String.valueOf(this.nomethod));
            ((DefaultReportGeneratorSPI)this.customReportSPIInstance).handleAttribute("hideBlocks", String.valueOf(this.noblock));
            ((DefaultReportGeneratorSPI)this.customReportSPIInstance).handleAttribute("hideBranches", String.valueOf(this.nobranch));
            ((DefaultReportGeneratorSPI)this.customReportSPIInstance).handleAttribute("hideLines", String.valueOf(this.noline));
            ((DefaultReportGeneratorSPI)this.customReportSPIInstance).handleAttribute("hideFields", String.valueOf(this.nofields));
        }
        this.initRepGen(repGen);
        try {
            if (this.rewrite && this.destdir != null && this.destdir.exists()) {
                Delete d = new Delete();
                d.setProject(this.getProject());
                d.setDir(this.destdir);
                d.setTaskName("rewrite");
                d.perform();
            }
            if (this.filename == null) {
                throw new BuildException("Input jcov file needed to generate report");
            }
            repGen.generateReport(this.format, this.destdir.getPath(), new Result(this.filename.getPath(), this.testlist != null ? this.testlist.getPath() : null), this.srcRootPath != null ? this.srcRootPath.getPath() : repGen.getSrcRootPath());
        }
        catch (ProcessingException ex) {
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.propfile != null) {
            PropertyFinder.cleanProperties();
        }
    }

    public void initRepGen(RepGen repGen) {
        try {
            repGen.resetDefaults();
        }
        catch (Exception ex) {
            Logger.getLogger(Report.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.customFilter != null && !this.customFilter.equals(repGen.getFilter())) {
            repGen.setFilter(this.customFilter);
        }
        String[] fms = repGen.getFms();
        if (this.fm.size() > 0) {
            fms = new String[this.fm.size()];
            int i = 0;
            for (FM f : this.fm) {
                fms[i++] = f.value;
            }
            repGen.setFms(fms);
        }
        if (this.filter != null) {
            String[] excl;
            String[] includes = repGen.getInclude();
            String[] excludes = repGen.getExclude();
            String[] incl = this.filter.getIncludePatterns(this.getProject());
            if (incl != null) {
                includes = incl;
            }
            if ((excl = this.filter.getExcludePatterns(this.getProject())) != null) {
                excludes = excl;
            }
            repGen.setFilters(includes, excludes, fms);
        }
        if (repGen.isIsPublicAPI() != this.isPublicAPI) {
            repGen.setIsPublicAPI(this.isPublicAPI);
        }
        if (repGen.isNoAbstract() != this.noAbstract) {
            repGen.setNoAbstract(this.noAbstract);
        }
        repGen.setReportGeneratorSPIs(new ReportGeneratorSPI[]{this.customReportSPIInstance});
    }

    public void setOutput(File path) {
        this.destdir = path;
    }

    public void setPropfile(File path) {
        this.propfile = path;
    }

    public void setNoline(boolean noline) {
        this.noline = noline;
    }

    public void setNoblock(boolean noblock) {
        this.noblock = noblock;
    }

    public void setNobranch(boolean nobranch) {
        this.nobranch = nobranch;
    }

    public void setNomethod(boolean nomethod) {
        this.nomethod = nomethod;
    }

    public void setNofields(boolean nofields) {
        this.nofields = nofields;
    }

    public void setJcovFile(File filename) {
        this.filename = filename;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSource(File source) {
        this.srcRootPath = source;
    }

    public void setHideAbstract(Boolean value) {
        this.noAbstract = value;
    }

    public void setPublicApi(Boolean isPublicApi) {
        this.isPublicAPI = isPublicApi;
    }

    public void setFilter(String filter) {
        this.customFilter = filter;
    }

    public void setTestList(File testlist) {
        this.testlist = testlist;
    }

    public void setReportSPI(String spi) {
        this.customReportSPI = spi;
    }

    public void setRewrite(boolean rewrite) {
        this.rewrite = rewrite;
    }

    public PatternSet createFilter() {
        PatternSet ps;
        if (this.filter != null) {
            throw new BuildException("Filter should be only one");
        }
        this.filter = ps = new PatternSet();
        return ps;
    }

    public void setTest(boolean test) {
        if (test) {
            System.setProperty("test.mode", "true");
        }
    }

    public void setFmlist(File fmlist) throws IOException {
        String[] lines;
        for (String s : lines = Utils.readLines(fmlist.getPath())) {
            this.fm.add(new FM(s));
        }
        this.fmlist = fmlist;
    }

    public FM createFM() {
        FM f = new FM();
        this.fm.add(f);
        return f;
    }

    public static class FM {
        private String value;

        public FM() {
        }

        public FM(String value) {
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

