/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov;

import com.sun.tdk.jcov.data.FileFormatException;
import com.sun.tdk.jcov.data.Result;
import com.sun.tdk.jcov.data.ScaleOptions;
import com.sun.tdk.jcov.filter.MemberFilter;
import com.sun.tdk.jcov.instrument.DataRoot;
import com.sun.tdk.jcov.instrument.InstrumentationOptions;
import com.sun.tdk.jcov.io.ClassSignatureFilter;
import com.sun.tdk.jcov.io.Reader;
import com.sun.tdk.jcov.runtime.FileSaver;
import com.sun.tdk.jcov.tools.EnvHandler;
import com.sun.tdk.jcov.tools.JCovCMDTool;
import com.sun.tdk.jcov.tools.JCovTool;
import com.sun.tdk.jcov.tools.OptionDescr;
import com.sun.tdk.jcov.tools.ScaleCompressor;
import com.sun.tdk.jcov.tools.SimpleScaleCompressor;
import com.sun.tdk.jcov.util.Utils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Merger
extends JCovCMDTool {
    public static final String LOOSE_0 = "0";
    public static final String LOOSE_1 = "1";
    public static final String LOOSE_2 = "2";
    public static final String LOOSE_3 = "3";
    public static final String LOOSE_BLOCKS = "blocks";
    private String outTestList;
    private String output;
    private String skippedPath;
    private String template;
    private String[] srcs;
    private BreakOnError boe = BreakOnError.NONE;
    private boolean read_scales = false;
    private ClassSignatureFilter readFilter = null;
    private int loose_lvl = 0;
    private String[] include = new String[]{".*"};
    private String[] exclude = new String[]{""};
    private String[] fm = null;
    private boolean compress;
    private boolean sigmerge = false;
    private boolean addMissing = true;
    private boolean warningCritical = false;
    private static ScaleCompressor compressor = new SimpleScaleCompressor();
    private static final Logger logger;
    static final OptionDescr DSC_SKIPPED;
    static final OptionDescr DSC_TEMPLATE;
    static final OptionDescr DSC_BREAKERR;
    static final OptionDescr DSC_OUTPUT;
    static final OptionDescr DSC_FILELIST;
    static final OptionDescr DSC_SCALE;
    static final OptionDescr DSC_COMPRESS;
    static final OptionDescr DSC_VERBOSE;
    static final OptionDescr DSC_OUTPUT_TEST_LIST;
    static final OptionDescr DSC_LOOSE;
    static final OptionDescr DSC_WARNINGS;

    @Deprecated
    public static void innerMain(String[] args, PrintStream logStream) throws Exception {
        Merger merger = new Merger();
        merger.run(args);
    }

    public static void main(String[] args) {
        Merger merger = new Merger();
        try {
            int res = merger.run(args);
            System.exit(res);
        }
        catch (Exception ex) {
            System.exit(1);
        }
    }

    public void write(Merge merge, String outputPath, String outputTestList, String skippedPath) throws IOException {
        FileSaver saver = FileSaver.getFileSaver(merge.result, outputPath, this.template, InstrumentationOptions.MERGE.MERGE, false, this.read_scales);
        if (this.compress) {
            merge.result.getScaleOpts().setScalesCompressed(true);
        }
        try {
            logger.log(Level.INFO, "- Writing result to {0}", outputPath);
            saver.saveResults(outputPath);
        }
        catch (Exception ex) {
            throw new IOException("Can't write result file", ex);
        }
        try {
            if (merge.resultTestList != null) {
                Utils.writeLines(outputTestList, merge.resultTestList);
            }
        }
        catch (IOException ex) {
            throw new IOException("Cannot create resulting test list: " + outputTestList + ": ", ex);
        }
        try {
            if (skippedPath != null && merge.getSkippedCount() > 0) {
                Utils.writeLines(skippedPath, merge.getSkippedFiles().toArray(new String[merge.getSkippedFiles().size()]));
            }
        }
        catch (IOException ex) {
            throw new IOException("Cannot create skipped files list: " + skippedPath + ": ", ex);
        }
    }

    public Merge mergeAndWrite(String[] jcovFiles, String outTestList, String output, String template, String skippedPath) throws IOException {
        Result[] results;
        this.output = output;
        this.outTestList = outTestList;
        this.template = template;
        this.srcs = jcovFiles;
        this.skippedPath = skippedPath;
        logger.log(Level.INFO, "- Reading test lists");
        try {
            results = Merger.initResults(jcovFiles, this.read_scales);
        }
        catch (IOException ex) {
            throw new IOException("Can't read test lists", ex);
        }
        Merge merge = new Merge(results, template);
        return this.mergeAndWrite(merge, outTestList, output, skippedPath);
    }

    public Merge mergeAndWrite(Merge merge, String outTestList, String output, String skippedPath) throws IOException {
        this.merge(merge, outTestList, false);
        if (merge.result != null && output != null && !"".equals(output)) {
            this.write(merge, output, outTestList, skippedPath);
        }
        return merge;
    }

    public void merge(Merge merge, String outTestList) {
        this.merge(merge, outTestList, false);
    }

    public void merge(Merge merge, String outTestList, boolean ignoreOriginalScales) {
        int i;
        this.readFilter = new ClassSignatureFilter(this.include, this.exclude, this.fm);
        DataRoot merged = null;
        DataRoot rNext = null;
        logger.log(Level.INFO, "- Merging started");
        int filesMerged = 0;
        for (i = 0; i < merge.jcovFiles.length; ++i) {
            String mergingRes = merge.jcovFiles[i].getResultPath();
            try {
                if (i == 0 && merge.template != null) {
                    logger.log(Level.INFO, "-- Reading jcov template {0}", merge.template);
                    merged = Reader.readXML(merge.template, this.read_scales, (MemberFilter)this.readFilter);
                    merged.getScaleOpts().setScaleSize(0);
                    if (this.sigmerge) {
                        merged.truncateToMethods();
                    }
                    if (merged.getParams().isDynamicCollect()) {
                        logger.log(Level.SEVERE, "File {0} is dynamic collected coverage data and can't be used as template", merge.template);
                        merge.errors++;
                        break;
                    }
                    if (outTestList != null && this.read_scales && merged.getScaleOpts().getScaleSize() == 0) {
                        merged.createScales();
                    }
                    logger.log(Level.INFO, "-- Merging all with template {0}. Java version: {1}, generated {2}", new Object[]{merge.template, merged.getXMLHeadProperties().get("java.runtime.version"), merged.getXMLHeadProperties().get("coverage.created.date")});
                    ++filesMerged;
                }
                logger.log(Level.FINE, "-- Reading jcov file {0}", mergingRes);
                rNext = Reader.readXML(mergingRes, this.read_scales, (MemberFilter)this.readFilter);
                if (outTestList != null) {
                    logger.log(Level.FINE, "-- Reading testlist for jcov file {0}", mergingRes);
                    if (ignoreOriginalScales) {
                        rNext.cleanScales();
                        rNext.createScales();
                    }
                    ScaleOptions scaleOpts = rNext.getScaleOpts();
                    String[] tlist = merge.jcovFiles[i].getTestList();
                    if (scaleOpts.getScaleSize() != tlist.length) {
                        logger.log(Level.SEVERE, "Inconsistent scale sizes: in file {0}: {1}; expected: {2}", new Object[]{mergingRes, scaleOpts.getScaleSize(), tlist.length});
                        if (this.boe == BreakOnError.SKIP) {
                            merge.addSkippedFile(mergingRes);
                            continue;
                        }
                        merge.errors++;
                        if (this.boe == BreakOnError.ERROR || this.boe == BreakOnError.FILE) break;
                    }
                    scaleOpts.setTestList(tlist);
                    scaleOpts.setOutTestList(outTestList);
                }
                if (merged == null) {
                    merged = rNext;
                    logger.log(Level.INFO, "-- Merging all with {0}. Java version: {1}, generated {2}", new Object[]{mergingRes, merged.getXMLHeadProperties().get("java.runtime.version"), merged.getXMLHeadProperties().get("coverage.created.date")});
                    if (this.sigmerge) {
                        merged.truncateToMethods();
                    }
                    if (this.read_scales && merged.getScaleOpts().getScaleSize() == 0) {
                        merged.createScales();
                    }
                    ++filesMerged;
                    continue;
                }
                logger.log(Level.INFO, "-- Merging {0}", mergingRes);
                if (this.sigmerge) {
                    merged.mergeOnSignatures(rNext, this.addMissing);
                } else {
                    DataRoot.CompatibilityCheckResult localErrors = merged.checkCompatibility(rNext, this.loose_lvl, this.boe == BreakOnError.ERROR);
                    merge.errors += localErrors.errors;
                    merge.warnings += localErrors.warnings;
                    if (this.warningCritical) {
                        localErrors.errors += localErrors.warnings;
                    }
                    if (localErrors.errors != 0) {
                        if (this.boe == BreakOnError.SKIP) {
                            logger.log(Level.INFO, "-- File {0} has {1} critical error(s) and will be skipped", new Object[]{mergingRes, localErrors.errors});
                            merge.addSkippedFile(mergingRes);
                            continue;
                        }
                        if (this.boe == BreakOnError.FILE || this.boe == BreakOnError.ERROR) {
                            logger.log(Level.SEVERE, "-- File {0} has {1} critical error(s). Stopping merging process (break on error set)", new Object[]{mergingRes, localErrors.errors});
                            break;
                        }
                        logger.log(Level.INFO, "-- File {0} has {1} critical errors", new Object[]{mergingRes, localErrors.errors});
                    }
                    merged.merge(rNext, this.addMissing);
                }
                ++filesMerged;
                continue;
            }
            catch (FileFormatException ex) {
                merge.errors++;
                if (this.boe == BreakOnError.SKIP) {
                    logger.log(Level.SEVERE, "Skipping malformed xml file {0}: " + ex.getMessage(), new Object[]{mergingRes});
                    merge.addSkippedFile(mergingRes);
                    continue;
                }
                if (this.boe == BreakOnError.FILE || this.boe == BreakOnError.ERROR) {
                    if (i == 0 && merge.template != null) {
                        logger.log(Level.SEVERE, "Stopping on malformed xml template {0}: {1}", new Object[]{merge.template, ex.getMessage()});
                        break;
                    }
                    logger.log(Level.SEVERE, "Stopping on malformed xml file {0}: {1}", new Object[]{mergingRes, ex.getMessage()});
                    break;
                }
                logger.log(Level.SEVERE, "Malformed xml file: " + ex.getMessage(), mergingRes);
                continue;
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "Critical error while merging file " + mergingRes, th);
                th.printStackTrace();
                merge.errors++;
                return;
            }
        }
        if (outTestList != null) {
            if (merge.errors == 0 || this.boe == BreakOnError.SKIP) {
                logger.log(Level.INFO, "- Generating result testlist");
                if (merge.getSkippedCount() > 0) {
                    Result[] newres = new Result[merge.jcovFiles.length - merge.getSkippedCount()];
                    int newresI = 0;
                    block4: for (int i2 = 0; i2 < merge.jcovFiles.length; ++i2) {
                        for (int j = 0; j < merge.getSkippedCount(); ++j) {
                            if (merge.jcovFiles[i2].getResultPath().equals(merge.getSkippedFiles().get(j))) continue block4;
                        }
                        newres[newresI++] = merge.jcovFiles[i2];
                    }
                    Merge.access$102(merge, this.generateTestList(outTestList, newres, merged, merge.template != null));
                } else {
                    Merge.access$102(merge, this.generateTestList(outTestList, merge.jcovFiles, merged, merge.template != null));
                }
            } else {
                logger.log(Level.SEVERE, "Don't generating result testlist - errors occurred");
            }
        }
        if (merge.errors > 0 && this.boe != BreakOnError.SKIP || this.boe == BreakOnError.TEST) {
            logger.log(Level.SEVERE, "- Merging failed. Use \"-boe skip\" option to ignore bad files.");
            return;
        }
        logger.log(Level.INFO, "- Merging complete");
        if (merge.getSkippedCount() > 0) {
            logger.log(Level.SEVERE, "- {0} files were skipped: ", merge.getSkippedCount());
            i = 1;
            for (String skipped : merge.getSkippedFiles()) {
                logger.log(Level.SEVERE, "-- {0}", skipped);
            }
        }
        if (filesMerged < 2) {
            if (merge.getSkippedCount() > 0) {
                logger.log(Level.SEVERE, "- Not enough correct files to perform merging. Found {0} correct files and {1} were skipped due to errors while needed at least 2 correct files", new Object[]{filesMerged, merge.getSkippedCount()});
            } else {
                logger.log(Level.SEVERE, "- Not enough correct files to perform merging. Found {0} correct files while needed at least 2", filesMerged);
            }
            return;
        }
        merge.result = merged;
    }

    protected int run() throws Exception {
        Result[] results;
        try {
            results = Merger.initResults(this.srcs, this.read_scales);
        }
        catch (IOException ex) {
            throw new IOException("Can't read test lists", ex);
        }
        Merge merge = new Merge(results, this.template);
        this.mergeAndWrite(merge, this.outTestList, this.output, this.skippedPath);
        if (this.boe == BreakOnError.TEST || this.warningCritical) {
            return merge.errors + merge.warnings;
        }
        return merge.errors;
    }

    protected String usageString() {
        return "java com.sun.tdk.jcov.Merger [options] <filenames>";
    }

    protected String exampleString() {
        return "java -cp jcov.jar com.sun.tdk.jcov.Merger -include java.lang.* -scale -output merged.xml test1.xml test2.xml";
    }

    protected String getDescr() {
        return "merges several jcov data files";
    }

    private String[] generateTestList(String outTestList, Result[] results, Object root, boolean cleanTmpl) {
        ArrayList<String> testList = new ArrayList<String>();
        ArrayList<Utils.Pair> pairs = new ArrayList<Utils.Pair>();
        int cur = 0;
        int length = cleanTmpl ? results.length + 1 : results.length;
        for (int i = 0; i < length; ++i) {
            String[] tlist = cleanTmpl ? (i == 0 ? new String[]{results[0].getTestList()[0]} : results[i - 1].getTestList()) : results[i].getTestList();
            for (int j = 0; j < tlist.length; ++j) {
                int found = testList.indexOf(tlist[j]);
                if (found < 0) {
                    testList.add(tlist[j]);
                } else {
                    pairs.add(new Utils.Pair(found, cur));
                }
                ++cur;
            }
        }
        if (root instanceof DataRoot) {
            ((DataRoot)root).illuminateDuplicatesInScales(pairs);
        }
        return testList.toArray(new String[testList.size()]);
    }

    public static Result[] initResults(String[] jcov_files, boolean initTestlists) throws IOException {
        Result[] results = new Result[jcov_files.length];
        for (int i = 0; i < jcov_files.length; ++i) {
            results[i] = new Result();
            String str = jcov_files[i];
            int k = str.indexOf(37);
            if (k < 0) {
                k = str.indexOf(35);
                if (k < 0) {
                    results[i].setResultPath(str);
                    if (!initTestlists) continue;
                    results[i].setDefaultName();
                    continue;
                }
                results[i].setResultPath(str.substring(0, k));
                if (!initTestlists) continue;
                results[i].setTestName(str.substring(k + 1));
                continue;
            }
            results[i].setResultPath(str.substring(0, k));
            if (!initTestlists) continue;
            results[i].readTestList(str.substring(k + 1));
        }
        return results;
    }

    public static String[] initTestList(String path) throws IOException {
        return Utils.readLines(path);
    }

    public static String[] initTestList(String path, int first, int last) throws IOException {
        return Utils.readLines(path, first, last);
    }

    public static Result parseResultFromString(String jcov_file) throws IOException {
        int k = jcov_file.indexOf(37);
        Result res = k < 0 ? ((k = jcov_file.indexOf(35)) > 0 ? new Result(jcov_file.substring(0, k), new String[]{jcov_file.substring(k + 1)}) : new Result(jcov_file)) : new Result(jcov_file.substring(0, k), jcov_file.substring(k + 1));
        return res;
    }

    public void setDefaultReadingFilter(String[] include, String[] exclude, String[] fm) {
        this.include = include;
        this.exclude = exclude;
        this.fm = fm;
        this.readFilter = new ClassSignatureFilter(include, exclude, fm);
    }

    public void setReadingFilter(ClassSignatureFilter filter) {
        this.readFilter = filter;
    }

    public BreakOnError getBreakOnError() {
        return this.boe;
    }

    public void setBreakOnError(BreakOnError boe) {
        this.boe = boe;
    }

    public static ScaleCompressor getCompressor() {
        return compressor;
    }

    public static void setCompressor(ScaleCompressor compressor) {
        Merger.compressor = compressor;
    }

    public int getLoose_lvl() {
        return this.loose_lvl;
    }

    public void setLoose_lvl(int loose_lvl) {
        this.loose_lvl = loose_lvl;
    }

    public boolean isRead_scales() {
        return this.read_scales;
    }

    public void setRead_scales(boolean read_scales) {
        this.read_scales = read_scales;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setFilters(String[] include, String[] exclude, String[] classModifiers) {
        if (include == null) {
            include = new String[]{".*"};
        }
        this.include = include;
        if (exclude == null) {
            exclude = new String[]{""};
        }
        this.exclude = exclude;
        this.fm = classModifiers;
    }

    public void setClassModifiers(String[] fm) {
        this.fm = fm;
    }

    public void resetDefaults() {
        try {
            this.handleEnv_(this.defineHandler());
            this.setBreakOnError(BreakOnError.NONE);
            this.setRead_scales(false);
            this.setReadingFilter(null);
            this.setLoose_lvl(0);
            this.setCompress(false);
            this.warningCritical = false;
        }
        catch (JCovTool.EnvHandlingException envHandlingException) {
            // empty catch block
        }
    }

    public String[] getExclude() {
        return this.exclude;
    }

    public String[] getInclude() {
        return this.include;
    }

    public String[] getFm() {
        return this.fm;
    }

    public boolean isAddMissing() {
        return this.addMissing;
    }

    public void setAddMissing(boolean addMissing) {
        this.addMissing = addMissing;
    }

    public void setSigmerge(boolean sigmerge) {
        this.sigmerge = sigmerge;
    }

    public boolean isSigmerge() {
        return this.sigmerge;
    }

    public boolean isWarningCritical() {
        return this.warningCritical;
    }

    public void setWarningCritical(boolean warningCritical) {
        this.warningCritical = warningCritical;
    }

    protected EnvHandler defineHandler() {
        return new EnvHandler(new OptionDescr[]{DSC_OUTPUT, DSC_FILELIST, InstrumentationOptions.DSC_INCLUDE, InstrumentationOptions.DSC_EXCLUDE, InstrumentationOptions.DSC_FM, InstrumentationOptions.DSC_INCLUDE_LIST, InstrumentationOptions.DSC_EXCLUDE_LIST, InstrumentationOptions.DSC_FM_LIST, DSC_SCALE, DSC_OUTPUT_TEST_LIST, DSC_VERBOSE, DSC_LOOSE, DSC_COMPRESS, DSC_BREAKERR, DSC_WARNINGS, DSC_TEMPLATE, DSC_SKIPPED}, (JCovTool)this);
    }

    private int handleEnv_(EnvHandler opts) throws JCovTool.EnvHandlingException {
        if (opts.isSet(DSC_FILELIST)) {
            String val = opts.getValue(DSC_FILELIST);
            int start = -1;
            int end = -1;
            String file = val;
            int ind = val.indexOf(",");
            if (ind != -1) {
                file = val.substring(0, ind);
                String rest = val.substring(ind + 1);
                int second_ind = rest.indexOf(",");
                if (second_ind == -1) {
                    start = Integer.parseInt(rest);
                } else {
                    start = Integer.parseInt(rest.substring(0, second_ind));
                    end = Integer.parseInt(rest.substring(second_ind + 1, rest.length()));
                }
            }
            Utils.checkFileNotNull(file, "filelist filename", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_CANREAD, Utils.CheckOptions.FILE_ISFILE);
            try {
                this.srcs = Utils.readLines(file, start, end);
            }
            catch (IOException ex) {
                throw new JCovTool.EnvHandlingException("Can't read filelist " + val, ex);
            }
        }
        this.include = InstrumentationOptions.handleInclude(opts);
        this.exclude = InstrumentationOptions.handleExclude(opts);
        this.fm = InstrumentationOptions.handleFM(opts);
        this.read_scales = opts.isSet(DSC_SCALE);
        if (opts.isSet(DSC_LOOSE)) {
            String loose = opts.getValue(DSC_LOOSE);
            if (LOOSE_BLOCKS.equals(loose)) {
                this.sigmerge = true;
            } else {
                try {
                    this.loose_lvl = Utils.checkedToInt(loose, "loose level", Utils.CheckOptions.INT_POSITIVE);
                }
                catch (NumberFormatException nfe) {
                    throw new JCovTool.EnvHandlingException("Can't parse loose level " + loose, nfe);
                }
            }
        }
        this.outTestList = null;
        if (opts.isSet(DSC_OUTPUT_TEST_LIST)) {
            this.outTestList = opts.getValue(DSC_OUTPUT_TEST_LIST);
            Utils.checkFileNotNull(this.outTestList, "output testlist filename", Utils.CheckOptions.FILE_CANWRITE, Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_PARENTEXISTS);
            this.read_scales = true;
        }
        this.skippedPath = opts.getValue(DSC_SKIPPED);
        String boestr = opts.getValue(DSC_BREAKERR);
        this.boe = "error".equalsIgnoreCase(boestr) ? BreakOnError.ERROR : ("test".equalsIgnoreCase(boestr) ? BreakOnError.TEST : ("file".equalsIgnoreCase(boestr) ? BreakOnError.FILE : ("skip".equalsIgnoreCase(boestr) ? BreakOnError.SKIP : BreakOnError.NONE)));
        this.template = opts.getValue(DSC_TEMPLATE);
        Utils.checkFileCanBeNull(this.template, "template filename", Utils.CheckOptions.FILE_EXISTS, Utils.CheckOptions.FILE_ISFILE, Utils.CheckOptions.FILE_CANREAD);
        this.addMissing = this.template == null;
        this.output = opts.getValue(DSC_OUTPUT);
        Utils.checkFileNotNull(this.output, "output filename", Utils.CheckOptions.FILE_NOTISDIR, Utils.CheckOptions.FILE_CANWRITE, Utils.CheckOptions.FILE_PARENTEXISTS);
        this.compress = opts.isSet(DSC_COMPRESS);
        if (opts.isSet(DSC_VERBOSE)) {
            logger.setLevel(Level.INFO);
        }
        this.warningCritical = opts.isSet(DSC_WARNINGS);
        return 0;
    }

    protected int handleEnv(EnvHandler opts) throws JCovTool.EnvHandlingException {
        this.srcs = opts.getTail();
        int code = this.handleEnv_(opts);
        if (this.srcs == null || this.srcs.length == 0) {
            throw new JCovTool.EnvHandlingException("No input files specified");
        }
        return code;
    }

    static {
        Utils.initLogger();
        logger = Logger.getLogger(Merger.class.getName());
        DSC_SKIPPED = new OptionDescr("outSkipped", "path for list of skipped files", 1, "Sets path to the list of files that were skipped during the merge by '-boe skip' option");
        DSC_TEMPLATE = new OptionDescr("template", new String[]{"tmpl", "t"}, "template path", 1, "Sets path to the template used for merging. Only data in template will be merged");
        DSC_BREAKERR = new OptionDescr("breakonerror", new String[]{"boe", "onerror"}, "break on error", (String[][])new String[][]{{"file", "break when finished merging first file with errors"}, {"error", "break on the first occurred error"}, {"test", "don't break on any error and don't write result file"}, {"skip", "merge all correct files. Attention: first jcov file is always considered to be correct. Use '-template' option to ensure correct results."}, {"none", "don't break on any error and write result file if all passed. Neither result file neither testlist would be written if any error will occur."}}, "Sets type of handling errors in merging process. Can be 'none', 'test', 'error', 'skip' and 'file'", "file");
        DSC_OUTPUT = new OptionDescr("merger.output", new String[]{"output", "o"}, "output file", 1, "Output file for generating new profiler data file.", "merged.xml");
        DSC_FILELIST = new OptionDescr("filelist", "file to read jcov input files from", 1, "Text file to read jcov data files for merge from. One file name per line.\nThe option allows to specify a range of lines to be read:\n-filelist=<file>,first_line,last_line");
        DSC_SCALE = new OptionDescr("scale", "process/generate test scales", "Process/generate test scale that lets find tests covering specific\ncode sections (no scale by default)");
        DSC_COMPRESS = new OptionDescr("compress", "compress test scales", "Compress test scales.");
        DSC_VERBOSE = new OptionDescr("verbose", new String[]{"v"}, "verbose mode", "Enables verbose mode");
        DSC_OUTPUT_TEST_LIST = new OptionDescr("outTestList", "", 1, "Generate summary test list. Test names will be extracted from the filename\noperands, which may be specified in one of the following ways:\n    a.jcov#test_a    coverage file for 'test_a'\n    b.jcov%test.lst  coverage file for tests listed in 'test.lst'\n    testC/c.jcov     coverage file for 'testC/c.jcov'");
        DSC_LOOSE = new OptionDescr("loose", "looseness level", new String[][]{{LOOSE_0, "none (strict)"}, {LOOSE_1, "moderate"}, {LOOSE_2, "high"}, {LOOSE_3, "highest"}, {LOOSE_BLOCKS, "drop blocks"}}, "Sets the \"looseness\" level of merger operation.\n0 - default strict mode. All errors are treated as fatal.\n1 - warning instead of an error when merging two classes with the same name and common timestamp, whose coverage item counts don't match.\n2 - warning instead of an error when merging two classes with the same name and the same arbitrary timestamp, whose coverage item counts don't match.\nAlso allows to merge without warning DATA: B and DATA: C classes\n3 - warning instead of any error\nblocks - all blocks information would be dropped. JCov data will be truncated to method coverage without any checks in block structure and then merged by signatures", LOOSE_0);
        DSC_WARNINGS = new OptionDescr("critwarn", "", 0, "Count warnings as errors", "When set JCov will process warnings (e.g. java version missmatch) just as errors");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Merge {
        private final Result[] jcovFiles;
        private final String template;
        private DataRoot result;
        private List<String> skippedFiles;
        private int errors;
        private int warnings;
        private String[] resultTestList;

        public Merge(Result[] files, String template) {
            this.jcovFiles = files;
            this.template = template;
        }

        public Merge(String[] files, String[] testlists, String template) throws IOException {
            this.jcovFiles = new Result[files.length];
            for (int i = 0; i < files.length; ++i) {
                this.jcovFiles[i] = testlists.length > i && testlists[i] != null ? new Result(files[i], testlists[i]) : new Result(files[i]);
            }
            this.template = template;
        }

        public List<String> getSkippedFiles() {
            return this.skippedFiles;
        }

        public String[] getResultTestList() {
            return this.resultTestList;
        }

        public int getSkippedCount() {
            if (this.skippedFiles == null) {
                return 0;
            }
            return this.skippedFiles.size();
        }

        public int getErrors() {
            return this.errors;
        }

        public int getWarnings() {
            return this.warnings;
        }

        void addSkippedFile(String file) {
            if (this.skippedFiles == null) {
                this.skippedFiles = new LinkedList<String>();
            }
            this.skippedFiles.add(file);
        }

        public DataRoot getResult() {
            return this.result;
        }

        static /* synthetic */ String[] access$102(Merge x0, String[] x1) {
            x0.resultTestList = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakOnError {
        FILE("file"),
        ERROR("error"),
        TEST("test"),
        NONE("none", "default"),
        SKIP("skip");

        private String[] aliases;

        private BreakOnError(String ... str) {
            this.aliases = str;
        }

        public static BreakOnError fromString(String name) {
            for (BreakOnError boe : BreakOnError.values()) {
                for (String s : boe.aliases) {
                    if (!s.equalsIgnoreCase(name)) continue;
                    return boe;
                }
            }
            return null;
        }

        public static BreakOnError getDefault() {
            return NONE;
        }
    }
}

