/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private static Version currentVersion;
    private Properties manifest;
    final String product;
    final String version;
    final String milestone;
    final String build;
    final String buildJavaVersion;
    final String buildDate;

    public static Version getCurrent() {
        if (currentVersion == null) {
            currentVersion = new Version();
        }
        return currentVersion;
    }

    private Version() {
        this.manifest = this.getManifestForClass(this.getClass());
        if (this.manifest == null) {
            this.manifest = new Properties();
        }
        this.product = this.manifest.getProperty("jtreg-Name");
        this.version = this.manifest.getProperty("jtreg-Version");
        this.milestone = this.manifest.getProperty("jtreg-Milestone");
        this.build = this.manifest.getProperty("jtreg-Build");
        this.buildJavaVersion = this.manifest.getProperty("jtreg-BuildJavaVersion");
        this.buildDate = this.manifest.getProperty("jtreg-BuildDate");
    }

    public Version(String string) {
        if (string != null) {
            Pattern pattern = Pattern.compile("([0-9.]+) ?(b[0-9]+)");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(string);
            }
            this.version = matcher.group(1);
            this.build = matcher.group(2);
        } else {
            this.version = null;
            this.build = null;
        }
        this.product = null;
        this.milestone = null;
        this.buildJavaVersion = null;
        this.buildDate = null;
    }

    String getProperty(String string, String string2) {
        return this.manifest.getProperty(string, string2);
    }

    private Properties getManifestForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL == null) {
            return null;
        }
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                int n;
                String string;
                URL uRL2;
                URL uRL3 = enumeration.nextElement();
                if (!uRL3.getProtocol().equals("jar") || !(uRL2 = new URL((string = uRL3.getPath()).substring(0, n = string.lastIndexOf("!")))).equals(uRL)) continue;
                Properties properties = new Properties();
                InputStream inputStream = uRL3.openStream();
                properties.load(inputStream);
                inputStream.close();
                return properties;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> clazz) {
        try {
            URL uRL = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
            if (uRL.getProtocol().equals("jar")) {
                String string = uRL.getPath();
                int n = string.lastIndexOf("!");
                return new URL(string.substring(0, n));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static int[] parseDottedInts(String string, int n) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[n];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    @Override
    public int compareTo(Version version) {
        int n;
        if (this.version == null || version.version == null) {
            return 0;
        }
        int[] nArray = Version.parseDottedInts(this.version, 10);
        int[] nArray2 = Version.parseDottedInts(version.version, 10);
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > nArray2[n]) {
                return 1;
            }
            if (nArray[n] >= nArray2[n]) continue;
            return -1;
        }
        n = this.getBuild();
        int n2 = version.getBuild();
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    private int getBuild() {
        if (this.build == null) {
            return 0;
        }
        String string = this.build.substring(1, this.build.length());
        return Integer.parseInt(string);
    }
}

