/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.BasicObserver;
import com.sun.javatest.regtest.CachingTestFilter;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.report.Report;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class TestStats {
    int[] counts = new int[4];
    int excluded;
    int ignored;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestStats.class);

    void register(Harness harness) {
        harness.addObserver(new BasicObserver(){
            RegressionParameters params;

            public void startingTestRun(Parameters parameters) {
                this.params = (RegressionParameters)parameters;
            }

            public void finishedTesting() {
                Object object;
                CachingTestFilter cachingTestFilter = this.params.getExcludeListFilter();
                if (cachingTestFilter != null) {
                    object = cachingTestFilter.getCache().values().iterator();
                    while (object.hasNext()) {
                        Boolean bl = (Boolean)object.next();
                        if (bl.booleanValue()) continue;
                        ++TestStats.this.excluded;
                    }
                }
                if ((object = this.params.getKeywordsFilter()) != null) {
                    for (Map.Entry entry : this.params.getKeywordsFilter().getCache().entrySet()) {
                        TestDescription testDescription = (TestDescription)entry.getKey();
                        boolean bl = (Boolean)entry.getValue();
                        if (bl || !testDescription.getKeywordTable().contains("ignore")) continue;
                        ++TestStats.this.ignored;
                    }
                }
            }

            public void finishedTest(TestResult testResult) {
                TestStats.this.add(testResult);
            }
        });
    }

    void add(TestResult testResult) {
        int n = testResult.getStatus().getType();
        this.counts[n] = this.counts[n] + 1;
    }

    void addAll(TestStats testStats) {
        for (int i = 0; i < this.counts.length; ++i) {
            int n = i;
            this.counts[n] = this.counts[n] + testStats.counts[i];
        }
    }

    boolean isOK() {
        return this.counts[1] == 0 && this.counts[2] == 0;
    }

    void showResultStats(PrintWriter printWriter) {
        String string;
        int n = this.counts[0];
        int n2 = this.counts[1];
        int n3 = this.counts[2];
        int n4 = this.counts[3];
        String string2 = n + n2 + n3 + n4 == 0 ? i18n.getString("main.noTests") : ((string = System.getProperty("jtreg.stats.format")) != null ? this.getText(string) : i18n.getString("main.tests", new Object[]{n, n > 0 && n2 + n3 + n4 > 0 ? 1 : 0, n2, n2 > 0 && n3 + n4 > 0 ? 1 : 0, n3, n3 > 0 && n4 > 0 ? 1 : 0, n4}));
        printWriter.println(string2);
    }

    public void report(Report report) throws IOException {
        File file = report.getReportDir();
        File file2 = new File(file, "text/stats.txt");
        this.report(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        try {
            this.showResultStats(printWriter);
            Object var4_3 = null;
            printWriter.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            printWriter.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    String getText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (true) {
            block21: {
                block23: {
                    char c;
                    block22: {
                        if (n2 >= string.length()) {
                            return stringBuilder.substring(0, n);
                        }
                        c = string.charAt(n2);
                        if (c != '%' || n2 + 1 >= string.length()) break block22;
                        c = string.charAt(++n2);
                        switch (c) {
                            case 'F': 
                            case 'e': 
                            case 'f': 
                            case 'i': 
                            case 'n': 
                            case 'p': 
                            case 'r': 
                            case 'x': {
                                int n3 = this.getNumber(c);
                                if (n3 >= 0) {
                                    stringBuilder.append(String.valueOf(n3));
                                    break;
                                }
                                stringBuilder.append("%").append(c);
                                break;
                            }
                            case ',': {
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(",");
                                }
                                break block21;
                            }
                            case ' ': {
                                if (stringBuilder.length() > 0 && !Character.isWhitespace(stringBuilder.charAt(stringBuilder.length() - 1))) {
                                    stringBuilder.append(' ');
                                }
                                break block21;
                            }
                            case '%': {
                                stringBuilder.append("%");
                                break;
                            }
                            case '?': {
                                int n3;
                                if (n2 + 1 < string.length()) {
                                    if ((c = string.charAt(++n2)) == '{') {
                                        n3 = string.indexOf("}", n2);
                                        if (n3 == -1) {
                                            stringBuilder.append("%?").append(string.substring(n2));
                                            n2 = string.length();
                                            break;
                                        }
                                        String string2 = string.substring(n2 + 1, n3);
                                        n2 = n3;
                                        if (string2.length() <= 0) break;
                                        c = string2.charAt(string2.length() - 1);
                                        int n4 = this.getNumber(c);
                                        if (n4 > 0) {
                                            stringBuilder.append(string2.substring(0, string2.length() - 1)).append(String.valueOf(n4));
                                            break;
                                        }
                                        if (n4 < 0) {
                                            stringBuilder.append("%?{").append(string2).append("}");
                                            break;
                                        }
                                        break block21;
                                    } else {
                                        n3 = this.getNumber(c);
                                        if (n3 > 0) {
                                            stringBuilder.append(String.valueOf(n3));
                                            break;
                                        }
                                        if (n3 < 0) {
                                            stringBuilder.append("%?").append(c);
                                            break;
                                        }
                                    }
                                    break block21;
                                } else {
                                    stringBuilder.append("%").append("?");
                                    break;
                                }
                            }
                            default: {
                                stringBuilder.append("%").append(c);
                                break;
                            }
                        }
                        break block23;
                    }
                    stringBuilder.append(c);
                }
                n = stringBuilder.length();
            }
            ++n2;
        }
    }

    int getNumber(char c) {
        switch (c) {
            case 'f': {
                return this.counts[1];
            }
            case 'F': {
                return this.counts[1] + this.counts[2];
            }
            case 'e': {
                return this.counts[2];
            }
            case 'i': {
                return this.ignored;
            }
            case 'n': {
                return this.counts[3];
            }
            case 'p': {
                return this.counts[0];
            }
            case 'r': {
                return this.counts[0] + this.counts[1] + this.counts[2];
            }
            case 'x': {
                return this.excluded;
            }
        }
        return -1;
    }
}

