/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.RegressionTestSuite;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.Version;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProperties {
    private final Cache cache;
    final boolean checkBugID;
    final Set<String> validKeys;
    final ExecMode defaultExecMode;
    final List<String> groupFiles;
    final Version requiredVersion;
    private static final boolean allowLocalKeys = Boolean.parseBoolean(System.getProperty("javatest.regtest.allowLocalKeys", "true"));
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionTestSuite.class);

    TestProperties(File file) throws TestSuite.Fault {
        this.cache = new Cache(this.canon(file));
        Cache.Entry entry = this.cache.getEntry(this.cache.rootDir);
        this.validKeys = entry.validKeys;
        String string = entry.properties.getProperty("checkBugID");
        this.checkBugID = string == null || !string.trim().equals("false");
        String string2 = entry.properties.getProperty("defaultExecMode");
        this.defaultExecMode = ExecMode.fromString(string2);
        String string3 = entry.properties.getProperty("groups");
        this.groupFiles = string3 == null ? Collections.emptyList() : Arrays.asList(string3.split("\\s+"));
        String string4 = entry.properties.getProperty("requiredVersion");
        this.requiredVersion = new Version(string4);
    }

    Set<String> getValidKeys(File file) throws TestSuite.Fault {
        if (!allowLocalKeys) {
            return this.validKeys;
        }
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.validKeys;
    }

    Set<String> getValidRequiresProperties(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.validRequiresProperties;
    }

    ExecMode getDefaultExecMode() {
        return this.defaultExecMode;
    }

    List<String> getGroupFiles() {
        return this.groupFiles;
    }

    boolean useBootClassPath(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.useBootClassPath;
    }

    boolean useOtherVM(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.useOtherVM;
    }

    boolean isTestNG(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.testNGRoot != null;
    }

    File getTestNGRoot(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.testNGRoot;
    }

    boolean needsExclusiveAccess(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.needsExclusiveAccess;
    }

    Set<String> getLibDirs(File file) throws TestSuite.Fault {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        Cache.Entry entry = this.cache.getEntry(file2);
        return entry.libDirs;
    }

    Version getRequiredVersion() {
        return this.requiredVersion;
    }

    private File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(file.getAbsoluteFile().toURI().normalize());
        }
    }

    static class Cache {
        Map<File, SoftReference<Entry>> map;
        Entry lastUsedEntry;
        File rootDir;

        Cache(File file) {
            this.rootDir = file;
            this.map = new HashMap<File, SoftReference<Entry>>();
        }

        synchronized Entry getEntry(File file) throws TestSuite.Fault {
            if (this.lastUsedEntry == null || !this.lastUsedEntry.dir.equals(file)) {
                this.lastUsedEntry = this.getEntryInternal(file);
            }
            return this.lastUsedEntry;
        }

        private Entry getEntryInternal(File file) throws TestSuite.Fault {
            Entry entry;
            SoftReference<Entry> softReference = this.map.get(file);
            Entry entry2 = entry = softReference == null ? null : softReference.get();
            if (entry == null) {
                Entry entry3 = file.equals(this.rootDir) ? null : this.getEntryInternal(file.getParentFile());
                entry = new Entry(entry3, file);
                this.map.put(file, new SoftReference<Entry>(entry));
            }
            return entry;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Entry {
            final Entry parent;
            final File dir;
            final Properties properties;
            final Set<String> validKeys;
            final Set<String> validRequiresProperties;
            final boolean useBootClassPath;
            private final Set<File> bootClassPathDirs;
            final boolean useOtherVM;
            private final Set<File> otherVMDirs;
            final boolean needsExclusiveAccess;
            private final Set<File> exclusiveAccessDirs;
            final File testNGRoot;
            private final Set<File> testNGDirs;
            final Set<String> libDirs;

            Entry(Entry entry, File file) throws TestSuite.Fault {
                this.parent = entry;
                this.dir = file;
                File file2 = new File(file, entry == null ? "TEST.ROOT" : "TEST.properties");
                if (file2.canRead()) {
                    this.properties = entry == null ? new Properties() : new Properties(entry.properties);
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                        this.properties.load(bufferedInputStream);
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new TestSuite.Fault(i18n, "suite.cantRead", file2);
                    }
                    this.validKeys = this.initSimpleSet(entry == null ? null : entry.validKeys, "keys");
                    this.validRequiresProperties = this.initSimpleSet(entry == null ? null : entry.validRequiresProperties, "requires.properties");
                    this.bootClassPathDirs = this.initFileSet(entry == null ? null : entry.bootClassPathDirs, "bootclasspath.dirs", file);
                    this.otherVMDirs = this.initFileSet(entry == null ? null : entry.otherVMDirs, "othervm.dirs", file);
                    this.exclusiveAccessDirs = this.initFileSet(entry == null ? null : entry.exclusiveAccessDirs, "exclusiveAccess.dirs", file);
                    this.testNGDirs = this.initFileSet(entry == null ? null : entry.testNGDirs, "TestNG.dirs", file);
                    this.libDirs = this.initLibDirSet(entry == null ? null : entry.libDirs, "lib.dirs", file);
                } else {
                    if (entry == null) {
                        throw new IllegalStateException("TEST.ROOT not found");
                    }
                    this.properties = entry.properties;
                    this.validKeys = entry.validKeys;
                    this.validRequiresProperties = entry.validRequiresProperties;
                    this.bootClassPathDirs = entry.bootClassPathDirs;
                    this.otherVMDirs = entry.otherVMDirs;
                    this.exclusiveAccessDirs = entry.exclusiveAccessDirs;
                    this.testNGDirs = entry.testNGDirs;
                    this.libDirs = entry.libDirs;
                }
                this.useBootClassPath = this.initUseBootClassPath(entry, file);
                this.useOtherVM = this.initUseOtherVM(entry, file);
                this.needsExclusiveAccess = this.initNeedsExclusiveAccess(entry, file);
                this.testNGRoot = this.initTestNGRoot(entry, file);
            }

            private Set<File> initFileSet(Set<File> set, String string, File file) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<File> linkedHashSet = set == null ? new LinkedHashSet<File>() : new LinkedHashSet<File>(set);
                    for (String string2 : stringArray) {
                        File file2 = this.toFile(file, string2);
                        if (file2 == null) continue;
                        linkedHashSet.add(file2);
                    }
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private Set<String> initLibDirSet(Set<String> set, String string, File file) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<String> linkedHashSet = set == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(set);
                    for (String string2 : stringArray) {
                        File file2 = this.toFile(file, string2);
                        if (file2 == null) continue;
                        linkedHashSet.add("/" + Cache.this.rootDir.toURI().relativize(file2.toURI()));
                    }
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private Set<String> initSimpleSet(Set<String> set, String string) {
                String[] stringArray = StringUtils.splitWS(this.properties.getProperty(string));
                if (set == null || stringArray.length > 0) {
                    LinkedHashSet<String> linkedHashSet = set == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(set);
                    linkedHashSet.addAll(Arrays.asList(stringArray));
                    return Collections.unmodifiableSet(linkedHashSet);
                }
                return set;
            }

            private boolean initUseBootClassPath(Entry entry, File file) {
                if (entry == null) {
                    return false;
                }
                if (entry.useBootClassPath) {
                    return true;
                }
                for (File file2 : this.bootClassPathDirs) {
                    if (!this.includes(file2, file)) continue;
                    return true;
                }
                return false;
            }

            private boolean initUseOtherVM(Entry entry, File file) {
                if (entry == null) {
                    return false;
                }
                if (entry.useOtherVM) {
                    return true;
                }
                for (File file2 : this.otherVMDirs) {
                    if (!this.includes(file2, file)) continue;
                    return true;
                }
                return false;
            }

            private boolean initNeedsExclusiveAccess(Entry entry, File file) {
                if (entry == null) {
                    return false;
                }
                if (entry.needsExclusiveAccess) {
                    return true;
                }
                for (File file2 : this.exclusiveAccessDirs) {
                    if (!this.includes(file2, file)) continue;
                    return true;
                }
                return false;
            }

            private File initTestNGRoot(Entry entry, File file) {
                if (entry == null) {
                    return null;
                }
                if (entry.testNGRoot != null) {
                    return entry.testNGRoot;
                }
                for (File file2 : this.testNGDirs) {
                    if (!this.includes(file2, file)) continue;
                    return file2;
                }
                return null;
            }

            private boolean includes(File file, File file2) {
                while (file2 != null) {
                    if (file.equals(file2)) {
                        return true;
                    }
                    file2 = file2.getParentFile();
                }
                return false;
            }

            private File toFile(File file, String string) {
                if (string.startsWith("/")) {
                    File file2 = new File(Cache.this.rootDir, string.substring(1));
                    if (file2.exists()) {
                        return new File(file2.toURI().normalize());
                    }
                } else {
                    File file3 = new File(file, string);
                    if (file3.exists()) {
                        return new File(file3.toURI().normalize());
                    }
                    file3 = new File(Cache.this.rootDir, string);
                    if (file3.exists()) {
                        return new File(file3.toURI().normalize());
                    }
                }
                return null;
            }
        }
    }
}

