/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.BuildAction;
import com.sun.javatest.regtest.MainAction;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.MainActionHelper;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.testng.IConfigurationListener;
import org.testng.IReporter;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestNG;
import org.testng.reporters.XMLReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGAction
extends MainAction {
    public static final String NAME = "testng";
    boolean userSpecified = false;
    private static final File TESTNG_RESULTS_XML = new File("testng-results.xml");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        this.userSpecified = string.startsWith("User specified action: run ");
        this.init(stringArray, stringArray2, string, regressionScript, TestNGRunner.class.getName());
    }

    @Override
    protected Status build() throws TestRunException {
        String[][] stringArray;
        if (this.userSpecified) {
            return super.build();
        }
        List<String> list = this.listClasses(this.script.getCompileSourcePath().split());
        JDK_Version jDK_Version = this.script.getCompileJDKVersion();
        if (jDK_Version.compareTo(JDK_Version.V1_6) >= 0) {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"implicit", "none"};
        } else {
            stringArray = new String[][]{};
        }
        String[][] stringArray2 = stringArray;
        String[] stringArray3 = list.toArray(new String[list.size()]);
        BuildAction buildAction = new BuildAction();
        return buildAction.build(stringArray2, stringArray3, "Named class compiled on demand", this.script);
    }

    List<String> listClasses(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            this.listClasses(file, null, arrayList);
        }
        return arrayList;
    }

    private void listClasses(File file, String string, List<String> list) {
        for (File file2 : file.listFiles()) {
            String string2 = file2.getName();
            if (file2.isDirectory()) {
                this.listClasses(file2, string == null ? string2 : string + "." + string2, list);
                continue;
            }
            if (!string2.endsWith(".java")) continue;
            String string3 = string2.substring(0, string2.length() - 5);
            list.add(string == null ? string3 : string + "." + string3);
        }
    }

    @Override
    public void endAction(Status status) {
        super.endAction(status);
        if (this.script.isCheck()) {
            return;
        }
        this.script.getTestNGReporter().add(this.script.getTestResult(), this.section);
        String string = this.script.getTestResult().getWorkRelativePath();
        String string2 = string.replaceAll("\\.jtr$", ".testng-results.xml");
        this.script.saveScratchFile(TESTNG_RESULTS_XML, new File(string2));
    }

    public static class RegressionListener
    implements ITestListener,
    IConfigurationListener {
        int count;
        int successCount;
        int failureCount;
        int skippedCount;
        int configSuccessCount;
        int configFailureCount;
        int configSkippedCount;
        int failedButWithinSuccessPercentageCount;

        public void onTestStart(ITestResult iTestResult) {
            ++this.count;
        }

        public void onTestSuccess(ITestResult iTestResult) {
            ++this.successCount;
            this.report(InfoKind.TEST, iTestResult);
        }

        public void onTestFailure(ITestResult iTestResult) {
            ++this.failureCount;
            this.report(InfoKind.TEST, iTestResult);
        }

        public void onTestSkipped(ITestResult iTestResult) {
            if (iTestResult.getThrowable() != null) {
                this.onTestFailure(iTestResult);
                return;
            }
            ++this.skippedCount;
            this.report(InfoKind.TEST, iTestResult);
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
            ++this.failedButWithinSuccessPercentageCount;
            this.report(InfoKind.TEST, iTestResult);
        }

        public void onStart(ITestContext iTestContext) {
        }

        public void onFinish(ITestContext iTestContext) {
        }

        public void onConfigurationSuccess(ITestResult iTestResult) {
            ++this.configSuccessCount;
            this.report(InfoKind.CONFIG, iTestResult);
        }

        public void onConfigurationFailure(ITestResult iTestResult) {
            ++this.configFailureCount;
            this.report(InfoKind.CONFIG, iTestResult);
        }

        public void onConfigurationSkip(ITestResult iTestResult) {
            ++this.configSkippedCount;
            this.report(InfoKind.CONFIG, iTestResult);
        }

        void report(InfoKind infoKind, ITestResult iTestResult) {
            String string;
            Throwable throwable = iTestResult.getThrowable();
            if (throwable != null && iTestResult.getStatus() != 1) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                string = "\n" + stringWriter;
            } else {
                string = "\n";
            }
            System.out.print(infoKind.toString().toLowerCase() + " " + iTestResult.getMethod().getMethod().getDeclaringClass().getName() + "." + iTestResult.getMethod().getMethodName() + this.formatParams(iTestResult) + ": " + this.statusToString(iTestResult.getStatus()) + string);
        }

        private String formatParams(ITestResult iTestResult) {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append('(');
            String string = "";
            for (Object object : iTestResult.getParameters()) {
                stringBuilder.append(string);
                this.formatParam(stringBuilder, object);
                string = ", ";
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private void formatParam(StringBuilder stringBuilder, Object object) {
            if (object instanceof String) {
                stringBuilder.append('\"');
                stringBuilder.append((String)object);
                stringBuilder.append('\"');
            } else {
                String string = String.valueOf(object);
                if (string.length() > 30) {
                    stringBuilder.append(object.getClass().getName());
                    stringBuilder.append('@');
                    stringBuilder.append(Integer.toHexString(System.identityHashCode(object)));
                } else {
                    stringBuilder.append(string);
                }
            }
        }

        private String statusToString(int n) {
            switch (n) {
                case 1: {
                    return "success";
                }
                case 2: {
                    return "failure";
                }
                case 3: {
                    return "skip";
                }
                case 4: {
                    return "success_percentage_failure";
                }
            }
            return "??";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum InfoKind {
            CONFIG,
            TEST;

        }
    }

    public static class TestNGRunner
    implements MainActionHelper.TestRunner {
        public static void main(String ... stringArray) throws Exception {
            TestNGRunner.main(null, stringArray);
        }

        public static void main(ClassLoader classLoader, String ... stringArray) throws Exception {
            if (stringArray.length != 2) {
                throw new Error("wrong number of arguments");
            }
            String string = stringArray[0];
            Class<?> clazz = classLoader == null ? Class.forName(stringArray[1]) : classLoader.loadClass(stringArray[1]);
            RegressionListener regressionListener = new RegressionListener();
            TestNG testNG = new TestNG(false);
            testNG.setDefaultSuiteName(string);
            testNG.setTestClasses(new Class[]{clazz});
            testNG.addListener((Object)regressionListener);
            testNG.addListener((IReporter)new XMLReporter());
            testNG.setOutputDirectory(new File(".").getPath());
            testNG.run();
            if (regressionListener.configFailureCount > 0 || regressionListener.failureCount > 0) {
                throw new Exception("failures: " + regressionListener.failureCount);
            }
        }
    }
}

