/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.Locations;
import com.sun.javatest.regtest.Lock;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.ProcessCommand;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.agent.RStatus;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellAction
extends Action {
    public static final String NAME = "shell";
    private static final String sep = ShellAction.getSeparator();
    private String shellFN;
    private List<String> shellArgs;
    private boolean reverseStatus = false;
    private int timeout = -1;
    private String manual = "unset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        super.init(stringArray, stringArray2, string, regressionScript);
        if (stringArray2.length == 0) {
            throw new ParseException("No script name provided for `shell'");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            String string3 = stringArray[i][1];
            if (string2.equals("fail")) {
                this.reverseStatus = this.parseFail(string3);
                continue;
            }
            if (string2.equals("timeout")) {
                this.timeout = this.parseTimeout(string3);
                continue;
            }
            if (string2.equals("manual")) {
                this.manual = this.parseShellManual(string3);
                continue;
            }
            throw new ParseException("Bad option for shell: " + string2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(0);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        this.shellFN = stringArray2[0];
        this.shellArgs = new ArrayList<String>();
        StringBuilder stringBuilder = null;
        for (int i = 1; i < stringArray2.length; ++i) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(stringArray2[i]);
            } else {
                stringBuilder.append(" ").append(stringArray2[i]);
            }
            if (!ShellAction.isEvenQuotes(stringBuilder)) continue;
            this.shellArgs.add(stringBuilder.toString().replace("'", ""));
            stringBuilder = null;
        }
        if (stringBuilder != null) {
            this.shellArgs.add(stringBuilder.toString());
        }
    }

    private static boolean isEvenQuotes(StringBuilder stringBuilder) {
        int n = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != '\'') continue;
            ++n;
        }
        return n % 2 == 0;
    }

    @Override
    public Set<File> getSourceFiles() {
        return Collections.singleton(new File(this.script.absTestSrcDir(), this.shellFN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run() throws TestRunException {
        Status status;
        this.startAction();
        File file = new File(this.script.absTestSrcDir(), this.shellFN);
        if (!file.exists()) {
            throw new TestRunException("Can't find source file: " + file);
        }
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            String string;
            ShellAction.mkdirs(this.script.absTestClsDir());
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.putAll(this.script.getEnvVars());
            Locations locations = this.script.locations;
            linkedHashMap.put("TESTSRC", this.fixupSep(locations.absTestSrcDir()));
            linkedHashMap.put("TESTSRCPATH", this.fixupSep(locations.absTestSrcPath()));
            linkedHashMap.put("TESTCLASSES", this.fixupSep(locations.absTestClsDir()));
            linkedHashMap.put("TESTCLASSPATH", this.fixupSep(locations.absTestClsPath()));
            linkedHashMap.put("COMPILEJAVA", this.fixupSep(this.script.getCompileJDK().getAbsolutePath()));
            linkedHashMap.put("TESTJAVA", this.fixupSep(this.script.getTestJDK().getAbsolutePath()));
            List<String> list = this.script.getTestVMOptions();
            linkedHashMap.put("TESTVMOPTS", this.fixupSep(StringUtils.join(list, " ")));
            List<String> list2 = this.script.getTestToolVMOptions();
            linkedHashMap.put("TESTTOOLVMOPTS", this.fixupSep(StringUtils.join(list2, " ")));
            List<String> list3 = this.script.getTestCompilerOptions();
            linkedHashMap.put("TESTJAVACOPTS", this.fixupSep(StringUtils.join(list3, " ")));
            List<String> list4 = this.script.getTestJavaOptions();
            linkedHashMap.put("TESTJAVAOPTS", this.fixupSep(StringUtils.join(list4, " ")));
            linkedHashMap.put("TESTTIMEOUTFACTOR", this.script.getTimeoutFactor() + "");
            File file2 = this.script.getNativeDir();
            if (file2 != null) {
                linkedHashMap.put("TESTNATIVEPATH", file2.getAbsolutePath());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("sh");
            arrayList.add(file.getPath());
            arrayList.addAll(this.shellArgs);
            PrintWriter printWriter = this.section.createOutput("System.out");
            PrintWriter printWriter2 = this.section.createOutput("System.err");
            Lock lock = this.script.getLockIfRequired();
            if (lock != null) {
                lock.lock();
            }
            try {
                if (showCmd) {
                    this.showCmd(NAME, arrayList, this.section);
                }
                this.recorder.exec(arrayList, linkedHashMap);
                ProcessCommand processCommand = new ProcessCommand().setExecDir(this.script.absTestScratchDir()).setCommand(arrayList).setEnvironment(linkedHashMap).setStreams(printWriter, printWriter2).setTimeout(this.timeout, TimeUnit.SECONDS);
                status = RStatus.normalize(processCommand.exec());
                string = null;
                if (lock != null) {
                    lock.unlock();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                if (printWriter2 != null) {
                    printWriter2.close();
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (lock != null) {
                    lock.unlock();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                if (printWriter2 != null) {
                    printWriter2.close();
                }
                throw throwable;
            }
            if (!status.isError()) {
                boolean bl = status.isPassed();
                int n = status.getType();
                if (bl && this.reverseStatus) {
                    string = "Execution passed unexpectedly";
                    n = 1;
                } else if (bl && !this.reverseStatus) {
                    string = "Execution successful";
                } else if (!bl && this.reverseStatus) {
                    string = "Execution failed as expected";
                    n = 0;
                } else {
                    string = "Execution failed";
                }
                if (n == 1 && !status.getReason().equals("") && !status.getReason().equals("Execution successful")) {
                    string = string + ": " + status.getReason();
                }
                status = RStatus.createStatus(n, string);
            }
        }
        this.endAction(status);
        return status;
    }

    private String fixupSep(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(this.fixupSep(file));
        }
        return stringBuilder.toString();
    }

    private String fixupSep(File file) {
        return this.fixupSep(file.getPath());
    }

    private String fixupSep(String string) {
        return sep == null ? string : string.replace(File.separator, sep);
    }

    private static String getSeparator() {
        return File.separatorChar == '\\' ? System.getProperty("javatest.shell.separator", "/") : null;
    }

    private String parseShellManual(String string) throws ParseException {
        if (string != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + string);
        }
        string = "novalue";
        return string;
    }
}

