/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.regtest.CachingTestFilter;
import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.Expr;
import com.sun.javatest.regtest.IgnoreKind;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.OS;
import com.sun.javatest.regtest.RegressionContext;
import com.sun.javatest.regtest.RegressionEnvironment;
import com.sun.javatest.regtest.RegressionTestSuite;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegressionParameters
extends BasicInterviewParameters
implements Parameters.EnvParameters {
    Map<TestDescription, String> filterFaults = new HashMap<TestDescription, String>();
    CachingTestFilter relevantTestFilter = UNSET;
    private CachingTestFilter excludeListFilter = UNSET;
    private CachingTestFilter keywordsFilter = UNSET;
    private static final CachingTestFilter UNSET = new CachingTestFilter(new TestFilter(){

        public String getName() {
            throw new IllegalStateException();
        }

        public String getDescription() {
            throw new IllegalStateException();
        }

        public String getReason() {
            throw new IllegalStateException();
        }

        public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
            throw new IllegalStateException();
        }
    });
    private static final String ENVVARS = ".envVars";
    private static final String CHECK = ".check";
    private static final String COMPILE_JDK = ".compilejdk";
    private static final String TEST_JDK = ".testjdk";
    private static final String EXEC_MODE = ".execMode";
    private static final String TEST_VM_OPTIONS = ".testVMOpts";
    private static final String TEST_COMPILER_OPTIONS = ".testCompilerOpts";
    private static final String TEST_JAVA_OPTIONS = ".testJavaOpts";
    private static final String IGNORE = ".ignore";
    private static final String RETAIN_ARGS = ".retain";
    private static final String JUNIT = ".junit";
    private static final String TESTNG = ".testng";
    private static final String TIMELIMIT = ".timeLimit";
    private static final String REPORTDIR = ".reportDir";
    private static final String EXCLUSIVE_LOCK = ".exclLock";
    private static final String NATIVEDIR = ".nativeDir";
    private Map<String, String> envVars;
    private boolean check;
    ExecMode execMode;
    IgnoreKind ignoreKind = IgnoreKind.ERROR;
    int timeLimit;
    private JDK compileJDK;
    private JDK testJDK;
    private File junitJar;
    private Boolean junitJarExists;
    private File testngJar;
    private Boolean testngJarExists;
    private SearchPath javaTestClassPath;
    private List<String> testVMOpts;
    private List<String> testCompilerOpts;
    private List<String> testJavaOpts;
    private File reportDir;
    private File exclusiveLock;
    private File nativeDir;
    private List<String> retainArgs;
    private final Set<Integer> retainStatusSet = new HashSet<Integer>(4);
    private Pattern retainFilesPattern;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionParameters.class);

    public RegressionParameters(String string, RegressionTestSuite regressionTestSuite) throws Interview.Fault {
        super(string, regressionTestSuite);
        this.setTitle("jtreg Configuration Editor");
        this.setEdited(false);
    }

    public void setTests(Collection<String> collection) {
        this.setTests(collection == null ? null : collection.toArray(new String[collection.size()]));
    }

    public void setTests(String[] stringArray) {
        Parameters.MutableTestsParameters mutableTestsParameters = (Parameters.MutableTestsParameters)this.getTestsParameters();
        mutableTestsParameters.setTests(stringArray);
    }

    public void setKeywordsExpr(String string) {
        Parameters.MutableKeywordsParameters mutableKeywordsParameters = (Parameters.MutableKeywordsParameters)this.getKeywordsParameters();
        mutableKeywordsParameters.setKeywords(3, string);
    }

    public void setConcurrency(int n) {
        Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)this.getConcurrencyParameters();
        mutableConcurrencyParameters.setConcurrency(n);
    }

    public void setTimeoutFactor(float f) {
        Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)this.getTimeoutFactorParameters();
        mutableTimeoutFactorParameters.setTimeoutFactor(f);
    }

    public void setExcludeLists(File[] fileArray) {
        Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)this.getExcludeListParameters();
        mutableExcludeListParameters.setExcludeFiles(fileArray);
    }

    public void setPriorStatusValues(boolean[] blArray) {
        Parameters.MutablePriorStatusParameters mutablePriorStatusParameters = (Parameters.MutablePriorStatusParameters)this.getPriorStatusParameters();
        mutablePriorStatusParameters.setPriorStatusValues(blArray);
    }

    @Override
    public TestEnvironment getEnv() {
        try {
            return new RegressionEnvironment(this);
        }
        catch (TestEnvironment.Fault fault) {
            return null;
        }
    }

    @Override
    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    @Override
    protected Question getEnvFirstQuestion() {
        return this.getEnvSuccessorQuestion();
    }

    @Override
    public TestFilter getRelevantTestFilter() {
        if (this.relevantTestFilter == UNSET) {
            TestFilter testFilter = this.getRequiresFilter();
            TestFilter testFilter2 = this.getTimeLimitFilter();
            TestFilter testFilter3 = testFilter2 == null ? testFilter : new CompositeFilter(new TestFilter[]{testFilter, testFilter2});
            this.relevantTestFilter = new CachingTestFilter(testFilter3);
        }
        return this.relevantTestFilter;
    }

    TestFilter getRequiresFilter() {
        return new TestFilter(){
            private final Expr.Context context;
            {
                this.context = new RegressionContext(RegressionParameters.this);
            }

            public String getName() {
                return "RequiresFilter";
            }

            public String getDescription() {
                return "Select tests that satisfy a given set of platform requirements";
            }

            public String getReason() {
                return "The platform does not meet the specified requirements";
            }

            public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
                try {
                    String string = testDescription.getParameter("requires");
                    if (string == null) {
                        return true;
                    }
                    return Expr.parse(string, this.context).evalBoolean(this.context);
                }
                catch (Expr.Fault fault) {
                    RegressionParameters.this.filterFaults.put(testDescription, "Error evaluating expression: " + fault.getMessage());
                    return true;
                }
            }
        };
    }

    TestFilter getTimeLimitFilter() {
        if (this.timeLimit <= 0) {
            return null;
        }
        return new TestFilter(){

            public String getName() {
                return "TestLimitFilter";
            }

            public String getDescription() {
                return "Select tests that do not exceed a specified timeout value";
            }

            public String getReason() {
                return "Test declares a timeout which exceeds the requested time limit";
            }

            public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
                String string = testDescription.getParameter("maxTimeout");
                if (string != null) {
                    try {
                        if (Integer.parseInt(string) > RegressionParameters.this.timeLimit) {
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
    }

    @Override
    public CachingTestFilter getExcludeListFilter() {
        OS oS = OS.current();
        final HashSet<String> hashSet = new HashSet<String>();
        for (String string : Arrays.asList(oS.name, oS.name.replaceAll("\\s", ""), oS.family, "generic")) {
            for (String string2 : Arrays.asList(null, oS.arch, oS.simple_arch, oS.version, oS.simple_version, "all")) {
                String string3 = string2 == null ? string : string + "-" + string2;
                hashSet.add(string3.toLowerCase());
            }
        }
        if (this.excludeListFilter == UNSET) {
            final ExcludeList excludeList = this.getExcludeList();
            this.excludeListFilter = excludeList == null ? null : new CachingTestFilter(new TestFilter(){

                public String getName() {
                    return "jtregExcludeListFilter";
                }

                public String getDescription() {
                    return "Select tests which are not excluded on any exclude list";
                }

                public String getReason() {
                    return "Test has been excluded by an exclude list";
                }

                public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
                    String[] stringArray;
                    ExcludeList.Entry entry = excludeList.getEntry(testDescription.getRootRelativeURL());
                    if (entry == null) {
                        return true;
                    }
                    String[] stringArray2 = entry.getPlatforms();
                    if ((stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0) && (stringArray = entry.getBugIdStrings()).length > 0 && !stringArray[0].matches("0|([1-9][0-9,]*)")) {
                        stringArray2 = stringArray;
                    }
                    if (stringArray2.length == 0 || stringArray2.length == 1 && stringArray2[0].length() == 0) {
                        return false;
                    }
                    for (String string : stringArray2) {
                        if (!hashSet.contains(string.toLowerCase())) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        return this.excludeListFilter;
    }

    @Override
    public CachingTestFilter getKeywordsFilter() {
        if (this.keywordsFilter == UNSET) {
            TestFilter testFilter = super.getKeywordsFilter();
            this.keywordsFilter = testFilter == null ? null : new CachingTestFilter(testFilter);
        }
        return this.keywordsFilter;
    }

    @Override
    public void load(Map map, boolean bl) throws Interview.Fault {
        super.load(map, bl);
        String string = this.getTag();
        String string2 = (String)map.get(string + ENVVARS);
        if (string2 != null) {
            this.setEnvVars(this.deserializeEnv(string2, "\n"));
        }
        if ((string2 = (String)map.get(string + CHECK)) != null) {
            this.setCheck(string2.equals("true"));
        }
        if ((string2 = (String)map.get(string + EXEC_MODE)) != null) {
            this.setExecMode(ExecMode.valueOf(string2));
        }
        if ((string2 = (String)map.get(string + IGNORE)) != null) {
            this.setIgnoreKind(IgnoreKind.valueOf(string2));
        }
        if ((string2 = (String)map.get(string + COMPILE_JDK)) != null) {
            this.setCompileJDK(JDK.of(string2));
        }
        if ((string2 = (String)map.get(string + TEST_JDK)) != null) {
            this.setTestJDK(JDK.of(string2));
        }
        if ((string2 = (String)map.get(string + TEST_VM_OPTIONS)) != null && string2.length() > 0) {
            this.setTestVMOptions(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = (String)map.get(string + TEST_COMPILER_OPTIONS)) != null && string2.length() > 0) {
            this.setTestCompilerOptions(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = (String)map.get(string + TEST_JAVA_OPTIONS)) != null && string2.length() > 0) {
            this.setTestJavaOptions(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = (String)map.get(string + RETAIN_ARGS)) != null && string2.length() > 0) {
            this.setRetainArgs(Arrays.asList(StringUtils.splitSeparator("\n", string2)));
        }
        if ((string2 = (String)map.get(string + JUNIT)) != null) {
            this.setJUnitJar(new File(string2));
        }
        if ((string2 = (String)map.get(string + TESTNG)) != null) {
            this.setTestNGJar(new File(string2));
        }
        if ((string2 = (String)map.get(string + TIMELIMIT)) != null) {
            this.setTimeLimit(Integer.parseInt(string2));
        }
        if ((string2 = (String)map.get(string + REPORTDIR)) != null) {
            this.setReportDir(new File(string2));
        }
        if ((string2 = (String)map.get(string + EXCLUSIVE_LOCK)) != null) {
            this.setExclusiveLock(new File(string2));
        }
        if ((string2 = (String)map.get(string + NATIVEDIR)) != null) {
            this.setNativeDir(new File(string2));
        }
    }

    @Override
    public void save(Map map) {
        this.save0(map);
        super.save(map);
    }

    private void save0(Map<String, String> map) {
        String string = this.getTag();
        if (this.envVars != null) {
            map.put(string + ENVVARS, this.serializeEnv(this.envVars, "\n"));
        }
        map.put(string + CHECK, String.valueOf(this.check));
        map.put(string + EXEC_MODE, String.valueOf((Object)this.execMode));
        map.put(string + IGNORE, String.valueOf((Object)this.ignoreKind));
        if (this.testJDK != null) {
            map.put(string + TEST_JDK, this.testJDK.getPath());
        }
        if (this.compileJDK != null) {
            map.put(string + COMPILE_JDK, this.compileJDK.getPath());
        }
        if (this.retainArgs != null && this.retainArgs.size() > 0) {
            map.put(string + RETAIN_ARGS, StringUtils.join(this.retainArgs, "\n"));
        }
        if (this.testVMOpts != null && this.testVMOpts.size() > 0) {
            map.put(string + TEST_VM_OPTIONS, StringUtils.join(this.testVMOpts, "\n"));
        }
        if (this.testCompilerOpts != null && this.testCompilerOpts.size() > 0) {
            map.put(string + TEST_COMPILER_OPTIONS, StringUtils.join(this.testCompilerOpts, "\n"));
        }
        if (this.testJavaOpts != null && this.testJavaOpts.size() > 0) {
            map.put(string + TEST_JAVA_OPTIONS, StringUtils.join(this.testJavaOpts, "\n"));
        }
        if (this.junitJar != null) {
            map.put(string + JUNIT, this.junitJar.getPath());
        }
        if (this.testngJar != null) {
            map.put(string + TESTNG, this.testngJar.getPath());
        }
        if (this.timeLimit > 0) {
            map.put(string + TIMELIMIT, String.valueOf(this.timeLimit));
        }
        if (this.reportDir != null) {
            map.put(string + REPORTDIR, this.reportDir.getPath());
        }
        if (this.exclusiveLock != null) {
            map.put(string + EXCLUSIVE_LOCK, this.exclusiveLock.getPath());
        }
        if (this.nativeDir != null) {
            map.put(string + NATIVEDIR, this.nativeDir.getPath());
        }
    }

    private Map<String, String> deserializeEnv(String string, String string2) {
        Map<String, String> map;
        if (string != null && string.length() != 0) {
            String[] stringArray;
            map = new LinkedHashMap<String, String>();
            for (String string3 : stringArray = StringUtils.splitSeparator(string2, string)) {
                String[] stringArray2 = StringUtils.splitSeparator("=", string3);
                map.put(stringArray2[0], stringArray2[1]);
            }
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    private String serializeEnv(Map<String, String> map, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = map.size();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
            if (--n == 0) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    Map<String, String> getEnvVars() {
        if (this.envVars == null) {
            String string = System.getProperty("envVars");
            this.envVars = this.deserializeEnv(string, ",");
        }
        return this.envVars;
    }

    void setEnvVars(Map<String, String> map) {
        this.envVars = map == null ? Collections.emptyMap() : map;
    }

    boolean isCheck() {
        return this.check;
    }

    void setCheck(boolean bl) {
        this.check = bl;
    }

    void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    ExecMode getExecMode() {
        return this.execMode;
    }

    void setIgnoreKind(IgnoreKind ignoreKind) {
        ((Object)((Object)ignoreKind)).getClass();
        this.ignoreKind = ignoreKind;
    }

    IgnoreKind getIgnoreKind() {
        return this.ignoreKind;
    }

    void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    int getTimeLimit() {
        return this.timeLimit;
    }

    void setCompileJDK(JDK jDK) {
        jDK.getClass();
        this.compileJDK = jDK;
    }

    JDK getCompileJDK() {
        return this.compileJDK;
    }

    void setTestJDK(JDK jDK) {
        jDK.getClass();
        this.testJDK = jDK;
    }

    JDK getTestJDK() {
        return this.testJDK;
    }

    void setJUnitJar(File file) {
        file.getClass();
        this.junitJar = file;
    }

    File getJUnitJar() {
        if (this.junitJar == null) {
            File file = ProductInfo.getJavaTestClassDir();
            this.junitJar = new File(file.getParentFile(), "junit.jar");
        }
        return this.junitJar;
    }

    boolean isJUnitAvailable() {
        if (this.junitJarExists == null) {
            this.junitJarExists = this.getJUnitJar().exists();
        }
        return this.junitJarExists;
    }

    void setTestNGJar(File file) {
        file.getClass();
        this.testngJar = file;
    }

    File getTestNGJar() {
        if (this.testngJar == null) {
            File file = ProductInfo.getJavaTestClassDir();
            this.testngJar = new File(file.getParentFile(), "testng.jar");
        }
        return this.testngJar;
    }

    boolean isTestNGAvailable() {
        if (this.testngJarExists == null) {
            this.testngJarExists = this.getTestNGJar().exists();
        }
        return this.testngJarExists;
    }

    SearchPath getJavaTestClassPath() {
        if (this.javaTestClassPath == null) {
            File file = ProductInfo.getJavaTestClassDir();
            this.javaTestClassPath = new SearchPath(file);
            if (file.getName().equals("javatest.jar")) {
                File file2 = file.getParentFile();
                this.javaTestClassPath.append(new File(file2, "jtreg.jar"));
            }
        }
        return this.javaTestClassPath;
    }

    List<String> getTestVMOptions() {
        if (this.testVMOpts == null) {
            this.testVMOpts = new ArrayList<String>();
        }
        return this.testVMOpts;
    }

    void setTestVMOptions(List<String> list) {
        this.testVMOpts = list;
    }

    List<String> getTestToolVMOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getTestVMOptions()) {
            arrayList.add("-J" + string);
        }
        return arrayList;
    }

    List<String> getTestVMJavaOptions() {
        if ((this.testVMOpts == null || this.testVMOpts.isEmpty()) && this.nativeDir == null) {
            return this.getTestJavaOptions();
        }
        if ((this.testJavaOpts == null || this.testJavaOpts.isEmpty()) && this.nativeDir == null) {
            return this.getTestVMOptions();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getTestVMOptions());
        arrayList.addAll(this.getTestJavaOptions());
        if (this.nativeDir != null) {
            arrayList.add("-Djava.library.path=" + this.nativeDir.getAbsolutePath());
        }
        return arrayList;
    }

    List<String> getTestCompilerOptions() {
        if (this.testCompilerOpts == null) {
            this.testCompilerOpts = new ArrayList<String>();
        }
        return this.testCompilerOpts;
    }

    void setTestCompilerOptions(List<String> list) {
        this.testCompilerOpts = list;
    }

    List<String> getTestJavaOptions() {
        if (this.testJavaOpts == null) {
            this.testJavaOpts = new ArrayList<String>();
        }
        return this.testJavaOpts;
    }

    void setTestJavaOptions(List<String> list) {
        this.testJavaOpts = list;
    }

    List<String> getRetainArgs() {
        return this.retainArgs;
    }

    void setRetainArgs(List<String> list) {
        this.retainArgs = list;
        this.retainStatusSet.clear();
        if (list == null) {
            this.retainFilesPattern = null;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (string.equals("all")) {
                this.retainStatusSet.add(0);
                this.retainStatusSet.add(1);
                this.retainStatusSet.add(2);
                continue;
            }
            if (string.equals("pass")) {
                this.retainStatusSet.add(0);
                continue;
            }
            if (string.equals("fail")) {
                this.retainStatusSet.add(1);
                continue;
            }
            if (string.equals("error")) {
                this.retainStatusSet.add(2);
                continue;
            }
            if (string.equals("none") || string.length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            boolean bl = false;
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '*': {
                        if (bl) {
                            stringBuilder.append("\\E");
                            bl = false;
                        }
                        stringBuilder.append(".*");
                        continue block4;
                    }
                    default: {
                        if (!bl) {
                            stringBuilder.append("\\Q");
                            bl = true;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            if (!bl) continue;
            stringBuilder.append("\\E");
        }
        this.retainFilesPattern = stringBuilder.length() == 0 ? null : Pattern.compile(stringBuilder.toString());
    }

    boolean isRetainEnabled() {
        return this.retainArgs != null;
    }

    Set<Integer> getRetainStatus() {
        return this.retainStatusSet;
    }

    Pattern getRetainFilesPattern() {
        return this.retainFilesPattern;
    }

    void setReportDir(File file) {
        file.getClass();
        this.reportDir = file;
    }

    File getReportDir() {
        return this.reportDir;
    }

    void setExclusiveLock(File file) {
        file.getClass();
        this.exclusiveLock = file;
    }

    File getExclusiveLock() {
        return this.exclusiveLock;
    }

    void setNativeDir(File file) {
        this.nativeDir = file;
    }

    File getNativeDir() {
        return this.nativeDir;
    }
}

