/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.Agent;
import com.sun.javatest.regtest.BuildAction;
import com.sun.javatest.regtest.ExecMode;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.Lock;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.ProcessCommand;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.TimeoutHandlerProvider;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.MainWrapper;
import com.sun.javatest.regtest.agent.RStatus;
import com.sun.javatest.regtest.agent.SearchPath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainAction
extends Action {
    public static final String NAME = "main";
    private final List<String> testJavaArgs = new ArrayList<String>();
    private final List<String> testClassArgs = new ArrayList<String>();
    private String driverClass = null;
    private String testClassName = null;
    private String policyFN = null;
    private String secureCN = null;
    private boolean overrideSysPolicy = false;
    protected boolean reverseStatus = false;
    protected boolean useBootClassPath = false;
    protected boolean othervm = false;
    protected boolean nativeCode = false;
    private int timeout = -1;
    private String manual = "unset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        this.init(stringArray, stringArray2, string, regressionScript, null);
    }

    void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript, String string2) throws ParseException {
        super.init(stringArray, stringArray2, string, regressionScript);
        if (stringArray2.length == 0) {
            throw new ParseException("No class provided for `main'");
        }
        for (String[] stringArray3 : stringArray) {
            String string3 = stringArray3[0];
            String string4 = stringArray3[1];
            if (string3.equals("fail")) {
                this.reverseStatus = this.parseFail(string4);
                continue;
            }
            if (string3.equals("manual")) {
                this.manual = this.parseMainManual(string4);
                continue;
            }
            if (string3.equals("timeout")) {
                this.timeout = this.parseTimeout(string4);
                continue;
            }
            if (string3.equals("othervm")) {
                this.othervm = true;
                continue;
            }
            if (string3.equals("native")) {
                this.nativeCode = true;
                continue;
            }
            if (string3.equals("bootclasspath")) {
                this.useBootClassPath = true;
                this.othervm = true;
                continue;
            }
            if (string3.equals("policy")) {
                this.overrideSysPolicy = true;
                this.policyFN = this.parsePolicy(string4);
                continue;
            }
            if (string3.equals("java.security.policy")) {
                String string5 = string4;
                if (string4.startsWith("=")) {
                    this.overrideSysPolicy = true;
                    string5 = string4.substring(1, string4.length());
                }
                this.policyFN = this.parsePolicy(string5);
                continue;
            }
            if (string3.equals("secure")) {
                this.secureCN = this.parseSecure(string4);
                continue;
            }
            throw new ParseException("Bad option for main: " + string3);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(0);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        if (string2 != null) {
            this.driverClass = string2;
        }
        if (regressionScript.useBootClassPath()) {
            this.othervm = true;
            this.useBootClassPath = true;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (this.testClassName == null) {
                if (stringArray2[i].startsWith("-")) {
                    this.testJavaArgs.add(stringArray2[i]);
                    if (!stringArray2[i].equals("-cp") && !stringArray2[i].equals("-classpath") || i + 1 >= stringArray2.length) continue;
                    this.testJavaArgs.add(stringArray2[++i]);
                    continue;
                }
                this.testClassName = stringArray2[i];
                continue;
            }
            this.testClassArgs.add(stringArray2[i]);
        }
        if (this.testClassName == null) {
            throw new ParseException("No class provided for `main'");
        }
        if (!this.othervm) {
            if (this.testJavaArgs.size() > 0) {
                throw new ParseException(this.testJavaArgs + ": vm option(s) found, need to specify /othervm");
            }
            if (this.policyFN != null) {
                throw new ParseException("`/policy' and `/java.security.policy` require use of `/othervm'");
            }
            if (this.secureCN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
    }

    public List<String> getJavaArgs() {
        return this.testJavaArgs;
    }

    public List<String> getClassArgs() {
        return this.testClassArgs;
    }

    public String getClassName() {
        return this.testClassName;
    }

    List<String> filterJavaOpts(List<String> list) {
        return list;
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        if (this.testClassName != null) {
            String[][] stringArray = new String[][]{};
            String[] stringArray2 = new String[]{this.testClassName.replace(File.separatorChar, '.')};
            try {
                BuildAction buildAction = new BuildAction();
                buildAction.init(stringArray, stringArray2, "Named class compiled on demand", this.script);
                linkedHashSet.addAll(buildAction.getSourceFiles());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.policyFN != null) {
            linkedHashSet.add(new File(this.policyFN));
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run() throws TestRunException {
        Status status = this.build();
        if (!status.isPassed()) {
            return status;
        }
        if (this.nativeCode && this.script.getNativeDir() == null) {
            return RStatus.error("Use -nativepath to specify the location of native code");
        }
        this.startAction();
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            Lock lock = this.script.getLockIfRequired();
            if (lock != null) {
                lock.lock();
            }
            try {
                switch (this.othervm ? ExecMode.OTHERVM : this.script.getExecMode()) {
                    case AGENTVM: {
                        status = this.runAgentJVM();
                        break;
                    }
                    case OTHERVM: {
                        status = this.runOtherJVM();
                        break;
                    }
                    case SAMEVM: {
                        status = this.runSameJVM();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                Object var4_3 = null;
                if (lock != null) {
                    lock.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (lock != null) {
                    lock.unlock();
                }
                throw throwable;
            }
        }
        this.endAction(status);
        return status;
    }

    protected Status build() throws TestRunException {
        String[][] stringArray = new String[][]{};
        String[] stringArray2 = new String[]{this.testClassName.replace(File.separatorChar, '.')};
        BuildAction buildAction = new BuildAction();
        return buildAction.build(stringArray, stringArray2, "Named class compiled on demand", this.script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        Object object;
        SearchPath searchPath;
        List<String> list;
        String string;
        if (this.driverClass == null) {
            string = this.testClassName;
            list = this.testClassArgs;
        } else {
            string = this.driverClass;
            list = new ArrayList<String>();
            list.add(this.script.getTestResult().getTestName());
            list.add(this.testClassName);
            list.addAll(this.testClassArgs);
        }
        File file = new File(this.script.absTestClsDir(), this.testClassName + ".jta");
        file.getParentFile().mkdirs();
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string + "\u0000");
            fileWriter.write(StringUtils.join(list) + "\u0000");
            fileWriter.close();
        }
        catch (IOException iOException) {
            return RStatus.error("Can't write `main' argument file");
        }
        catch (SecurityException securityException) {
            return RStatus.error("Unable to create `main' argument file");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.putAll(this.script.getEnvVars());
        SearchPath searchPath2 = new SearchPath();
        SearchPath searchPath3 = new SearchPath();
        (this.useBootClassPath ? searchPath3 : searchPath2).append(this.script.getJavaTestClassPath());
        searchPath2.append(this.script.getTestClassPath(this.useBootClassPath));
        searchPath3.append(this.script.getTestBootClassPath(this.useBootClassPath));
        SearchPath searchPath4 = searchPath = searchPath3.isEmpty() ? searchPath2 : searchPath3;
        if (this.script.isJUnitRequired()) {
            searchPath.append(this.script.getJUnitJar());
        }
        if (this.script.isTestNGRequired()) {
            searchPath.append(this.script.getTestNGJar());
        }
        if (!searchPath2.isEmpty()) {
            linkedHashMap.put("CLASSPATH", searchPath2.toString());
        }
        String string2 = this.script.getJavaProg();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!searchPath3.isEmpty()) {
            arrayList.add("-Xbootclasspath/a:" + searchPath3.toString());
        }
        arrayList.addAll(this.script.getTestVMJavaOptions());
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        linkedHashMap2.putAll(this.script.getTestProperties());
        if (this.policyFN != null) {
            String string3 = this.addGrantEntry(this.policyFN);
            linkedHashMap2.put("java.security.policy", this.overrideSysPolicy ? "=" + string3 : string3);
        }
        if (this.secureCN != null) {
            linkedHashMap2.put("java.security.manager", this.secureCN);
        } else if (this.policyFN != null) {
            linkedHashMap2.put("java.security.manager", "default");
        }
        arrayList.addAll(this.testJavaArgs);
        String string4 = MainWrapper.class.getName();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(file.getPath());
        arrayList2.addAll(list);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add(string2);
        for (Map.Entry object22 : linkedHashMap2.entrySet()) {
            arrayList3.add("-D" + (String)object22.getKey() + "=" + (String)object22.getValue());
        }
        arrayList3.addAll(this.filterJavaOpts(arrayList));
        arrayList3.add(string4);
        arrayList3.addAll(arrayList2);
        PrintWriter printWriter = this.section.createOutput("System.out");
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        try {
            if (showMode) {
                this.showMode(this.getName(), ExecMode.OTHERVM, this.section);
            }
            if (showCmd) {
                this.showCmd(this.getName(), arrayList3, this.section);
            }
            this.recorder.java(linkedHashMap, string2, linkedHashMap2, arrayList, string4, arrayList2);
            ProcessCommand processCommand = new ProcessCommand();
            processCommand.setExecDir(this.script.absTestScratchDir());
            processCommand.setStatusForExit(Status.exitCodes[0], RStatus.passed("Execution successful"));
            processCommand.setStatusForExit(Status.exitCodes[1], RStatus.failed("Execution failed"));
            processCommand.setDefaultStatus(RStatus.failed("Unexpected exit from test"));
            TimeoutHandler timeoutHandler = TimeoutHandlerProvider.createHandler(this.script, this.section);
            processCommand.setCommand(arrayList3).setEnvironment(linkedHashMap).setStreams(printWriter, printWriter2).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
            object = RStatus.normalize(processCommand.exec());
            Object var23_24 = null;
            printWriter.close();
            printWriter2.close();
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            printWriter.close();
            printWriter2.close();
            throw throwable;
        }
        object = this.checkReverse((Status)object, this.reverseStatus);
        return object;
    }

    protected Status runSameJVM() throws TestRunException {
        List<String> list;
        String string;
        SearchPath searchPath;
        if (this.driverClass == null) {
            searchPath = this.script.getTestClassPath();
            string = this.testClassName;
            list = this.testClassArgs;
        } else {
            searchPath = this.script.getTestClassPath();
            string = this.driverClass;
            list = new ArrayList<String>();
            list.add(this.script.getTestResult().getTestName());
            list.add(this.testClassName);
            list.addAll(this.testClassArgs);
        }
        if (showMode) {
            this.showMode(this.getName(), ExecMode.SAMEVM, this.section);
        }
        Map<String, String> map = this.script.getTestProperties();
        String string2 = this.script.getJavaProg();
        SearchPath searchPath2 = new SearchPath(this.script.getJavaTestClassPath(), this.script.getTestJDK().getJDKClassPath());
        if (this.script.isJUnitRequired()) {
            searchPath2.append(this.script.getJUnitJar());
        }
        if (this.script.isTestNGRequired()) {
            searchPath2.append(this.script.getTestNGJar());
        }
        searchPath2.append(searchPath);
        List<String> list2 = Arrays.asList("-classpath", searchPath2.toString());
        this.recorder.java(this.script.getEnvVars(), string2, map, list2, string, list);
        Status status = MainActionHelper.runClass(this.script.getTestResult().getTestName(), map, searchPath, string, list.toArray(new String[list.size()]), this.timeout, MainAction.getOutputHandler(this.section));
        status = this.checkReverse(status, this.reverseStatus);
        return status;
    }

    private Status runAgentJVM() throws TestRunException {
        Status status;
        Agent agent;
        List<String> list;
        String string;
        SearchPath searchPath;
        if (this.driverClass == null) {
            searchPath = this.script.getTestClassPath();
            string = this.testClassName;
            list = this.testClassArgs;
        } else {
            searchPath = this.script.getTestClassPath();
            string = this.driverClass;
            list = new ArrayList<String>();
            list.add(this.script.getTestResult().getTestName());
            list.add(this.testClassName);
            list.addAll(this.testClassArgs);
        }
        if (showMode) {
            this.showMode(this.getName(), ExecMode.AGENTVM, this.section);
        }
        Map<String, String> map = this.script.getTestProperties();
        JDK jDK = this.script.getTestJDK();
        SearchPath searchPath2 = new SearchPath(this.script.getJavaTestClassPath(), jDK.getJDKClassPath());
        if (this.script.isJUnitRequired()) {
            searchPath2.append(this.script.getJUnitJar());
        }
        if (this.script.isTestNGRequired()) {
            searchPath2.append(this.script.getTestNGJar());
        }
        String string2 = this.script.getJavaProg();
        SearchPath searchPath3 = new SearchPath(searchPath2, searchPath);
        List<String> list2 = Arrays.asList("-classpath", searchPath3.toString());
        this.recorder.java(this.script.getEnvVars(), string2, map, list2, string, list);
        try {
            agent = this.script.getAgent(jDK, searchPath2, this.filterJavaOpts(this.script.getTestVMJavaOptions()));
        }
        catch (IOException iOException) {
            return RStatus.error("Cannot get VM for test: " + iOException);
        }
        TimeoutHandler timeoutHandler = TimeoutHandlerProvider.createHandler(this.script, this.section);
        try {
            status = agent.doMainAction(this.script.getTestResult().getTestName(), map, searchPath, string, list, this.timeout, timeoutHandler, this.section);
        }
        catch (Agent.Fault fault) {
            status = fault.getCause() instanceof IOException ? RStatus.error(String.format("Agent communication error: %s; check console log for any additional details", fault.getCause())) : RStatus.error(String.format("Agent error: %s; check console log for any additional details", fault.getCause()));
        }
        if (status.isError()) {
            this.script.closeAgent(agent);
        }
        status = this.checkReverse(status, this.reverseStatus);
        return status;
    }

    private String parseMainManual(String string) throws ParseException {
        if (string != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + string);
        }
        string = "novalue";
        return string;
    }

    private Status checkReverse(Status status, boolean bl) {
        if (!status.isError() && !status.getReason().startsWith("Unexpected exit from test")) {
            String string;
            boolean bl2 = status.isPassed();
            int n = status.getType();
            if (bl2 && bl) {
                string = "Execution passed unexpectedly";
                n = 1;
            } else if (bl2 && !bl) {
                string = "Execution successful";
            } else if (!bl2 && bl) {
                string = "Execution failed as expected";
                n = 0;
            } else {
                string = "Execution failed";
            }
            if (n == 1 && status.getReason() != null && !status.getReason().equals("Execution successful")) {
                string = string + ": " + status.getReason();
            }
            status = RStatus.createStatus(n, string);
        }
        return status;
    }
}

