/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.regtest.RegressionEnvironment;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringUtils;
import com.sun.javatest.regtest.TestRunException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locations {
    private final RegressionParameters params;
    private final String relTestDir;
    private final File absBaseSrcDir;
    private final File absTestSrcDir;
    private final File absBaseClsDir;
    private final File absTestClsDir;
    private final List<LibLocn> libList;
    private static final String[] extns = new String[]{".java", ".jasm", ".jcod"};
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> uniqueNum = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return uniqueId.getAndIncrement();
        }
    };
    public static final String CANT_FIND_CLASS = "Can't find source for class: ";
    public static final String LIB_LIST = " in directory-list: ";
    public static final String PATH_TESTCLASS = "Unable to locate test class directory!?";

    Locations(RegressionEnvironment regressionEnvironment, TestDescription testDescription) throws RegressionScript.TestClassException {
        Object object;
        this.params = regressionEnvironment.params;
        String string = testDescription.getParameter("packageRoot");
        this.relTestDir = string != null ? string : ((object = testDescription.getRootRelativeFile().getParent()) == null ? "" : object);
        this.absBaseSrcDir = this.params.getTestSuite().getRootDir();
        this.absTestSrcDir = new File(this.absBaseSrcDir, this.relTestDir);
        try {
            object = regressionEnvironment.lookup("testClassDir");
            if (object == null || ((String[])object).length != 1) {
                throw new RegressionScript.TestClassException(PATH_TESTCLASS);
            }
            this.absBaseClsDir = this.getThreadSafeDir(object[0]);
            this.absTestClsDir = new File(this.absBaseClsDir, this.relTestDir);
        }
        catch (TestEnvironment.Fault fault) {
            throw new RegressionScript.TestClassException(PATH_TESTCLASS);
        }
        this.libList = new ArrayList<LibLocn>();
        object = testDescription.getParameter("library");
        for (String string2 : StringUtils.splitWS((String)object)) {
            boolean bl = string2.startsWith("/");
            File file = bl ? this.absBaseSrcDir : this.absTestSrcDir;
            File file2 = bl ? this.absBaseClsDir : this.absTestClsDir;
            this.libList.add(new LibLocn(string2, Locations.normalize(new File(file, string2)), Locations.normalize(new File(file2, string2))));
        }
    }

    File absTestSrcDir() {
        return this.absTestSrcDir;
    }

    List<File> absTestSrcPath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.absTestSrcDir);
        for (LibLocn libLocn : this.libList) {
            arrayList.add(libLocn.absSrcDir);
        }
        return arrayList;
    }

    List<File> absSrcLibList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (LibLocn libLocn : this.libList) {
            arrayList.add(libLocn.absSrcDir);
        }
        return arrayList;
    }

    List<File> absSrcJarLibList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (LibLocn libLocn : this.libList) {
            File file = libLocn.absSrcDir;
            if (!file.getName().endsWith(".jar") || !file.exists()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    File absBaseClsDir() {
        return this.absBaseClsDir;
    }

    File absTestClsDir() {
        return this.absTestClsDir;
    }

    List<File> absTestClsPath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.absTestClsDir);
        for (LibLocn libLocn : this.libList) {
            arrayList.add(libLocn.absClsDir);
        }
        return arrayList;
    }

    List<File> absClsLibList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (LibLocn libLocn : this.libList) {
            arrayList.add(libLocn.absClsDir);
        }
        return arrayList;
    }

    List<ClassLocn> locateClasses(String string) throws TestRunException {
        if (string.equals("*")) {
            return this.locateClassesInPackage(null);
        }
        if (string.endsWith(".*")) {
            return this.locateClassesInPackage(string.substring(0, string.length() - 2));
        }
        return Collections.singletonList(this.locateClass(string));
    }

    private ClassLocn locateClass(String string) throws TestRunException {
        for (String string2 : extns) {
            String string3;
            String string32 = string.replace('.', File.separatorChar) + string2;
            String string4 = string.replace('.', File.separatorChar) + ".class";
            File file = new File(this.absTestSrcDir, string32);
            if (file.exists()) {
                File file4 = new File(this.absTestClsDir, string4);
                LibLocn libLocn = new LibLocn(null, this.absTestSrcDir, this.absTestClsDir);
                return new ClassLocn(string, libLocn, file, file4);
            }
            for (LibLocn libLocn : this.libList) {
                file = new File(libLocn.absSrcDir, string32);
                if (!file.exists()) continue;
                File file2 = new File(libLocn.absClsDir, string4);
                return new ClassLocn(string, libLocn, file, file2);
            }
            int n = string32.lastIndexOf(File.separatorChar);
            if (n < 0 || !(file = new File(this.absTestSrcDir, string3 = string32.substring(n + 1))).exists()) continue;
            File file3 = new File(this.absTestClsDir, string4);
            LibLocn libLocn = new LibLocn(null, this.absTestSrcDir, this.absTestClsDir);
            return new ClassLocn(string, libLocn, file, file3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.absTestSrcDir).append(" ");
        for (LibLocn libLocn : this.libList) {
            stringBuilder.append(libLocn.absSrcDir).append(" ");
        }
        throw new TestRunException(CANT_FIND_CLASS + string + LIB_LIST + stringBuilder);
    }

    private List<ClassLocn> locateClassesInPackage(String string) throws TestRunException {
        ArrayList<ClassLocn> arrayList = new ArrayList<ClassLocn>();
        LibLocn libLocn = new LibLocn(null, this.absTestSrcDir, this.absTestClsDir);
        this.locateClassesInPackage(string, libLocn, arrayList);
        for (LibLocn libLocn2 : this.libList) {
            this.locateClassesInPackage(string, libLocn2, arrayList);
        }
        return arrayList;
    }

    private void locateClassesInPackage(String string, LibLocn libLocn, List<ClassLocn> list) throws TestRunException {
        File file;
        File file2;
        if (string == null) {
            file2 = libLocn.absSrcDir;
            file = libLocn.absClsDir;
        } else {
            File[] fileArray = string.replace('.', File.separatorChar);
            file2 = new File(libLocn.absSrcDir, (String)fileArray);
            file = new File(libLocn.absClsDir, (String)fileArray);
        }
        if (!file2.isDirectory()) {
            return;
        }
        for (File file3 : file2.listFiles()) {
            String string2;
            if (!file3.isFile() || !(string2 = file3.getName()).endsWith(".java") && !string2.endsWith(".jasm") && !string2.endsWith(".jcod")) continue;
            String string3 = string2.substring(0, string2.length() - 5);
            String string4 = string == null ? string3 : string + "." + string3;
            File file4 = new File(file, string3 + ".class");
            list.add(new ClassLocn(string4, libLocn, file3, file4));
        }
    }

    File absTestSrcFile(File file) {
        if (file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return new File(this.absTestSrcDir, file.getPath());
    }

    private static File normalize(File file) {
        return new File(file.toURI().normalize());
    }

    private File getThreadSafeDir(String string) {
        return this.params.getConcurrency() == 1 ? new File(string) : new File(string, String.valueOf(Locations.getCurrentThreadId()));
    }

    private static int getCurrentThreadId() {
        return uniqueNum.get();
    }

    static class ClassLocn {
        final String name;
        final LibLocn lib;
        final File absSrcFile;
        final File absClsFile;

        ClassLocn(String string, LibLocn libLocn, File file, File file2) {
            this.name = string;
            this.lib = libLocn;
            this.absSrcFile = file;
            this.absClsFile = file2;
        }

        boolean isUpToDate() {
            return this.absClsFile.exists() && this.absClsFile.canRead() && this.absClsFile.lastModified() > this.absSrcFile.lastModified();
        }
    }

    static class LibLocn {
        final String name;
        final File absSrcDir;
        final File absClsDir;

        LibLocn(String string, File file, File file2) {
            this.name = string;
            this.absSrcDir = file;
            this.absClsDir = file2;
        }

        public String toString() {
            return "LibLocn(" + this.name + ",src:" + this.absSrcDir + ",cls:" + this.absClsDir + ")";
        }
    }
}

