/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.regtest.Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelpSearchNavigator;
import javax.swing.JFrame;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Help {
    private List<Option> options;
    private List<VersionHelper> versionHelpers = new ArrayList<VersionHelper>();
    private boolean releaseNotesFlag;
    private boolean tagSpecFlag;
    private boolean versionFlag;
    private List<String> commandLineHelpQuery;
    private String onlineHelpQuery;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Help(List<Option> list) {
        this.options = list;
    }

    boolean isEnabled() {
        return this.versionFlag || this.releaseNotesFlag || this.tagSpecFlag || this.commandLineHelpQuery != null || this.onlineHelpQuery != null;
    }

    void addVersionHelper(VersionHelper versionHelper) {
        this.versionHelpers.add(versionHelper);
    }

    void addJarVersionHelper(final String string, final File file, final String string2) {
        this.addVersionHelper(new VersionHelper(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void showVersion(PrintWriter printWriter) {
                try {
                    JarFile jarFile = new JarFile(file);
                    String string3 = (String)jarFile.getManifest().getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION);
                    if (string3 == null && string2 != null) {
                        Properties properties = new Properties();
                        InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(string2));
                        try {
                            properties.load(inputStream);
                            string3 = properties.getProperty("version");
                            Object var7_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    printWriter.println(string + ": version " + (string3 == null ? "unknown" : string3));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    void setVersionFlag(boolean bl) {
        this.versionFlag = bl;
    }

    void setReleaseNotes(boolean bl) {
        this.releaseNotesFlag = bl;
    }

    void setTagSpec(boolean bl) {
        this.tagSpecFlag = bl;
    }

    void setCommandLineHelpQuery(String string) {
        if (this.commandLineHelpQuery == null) {
            this.commandLineHelpQuery = new ArrayList<String>();
        }
        if (string != null && string.trim().length() > 0) {
            this.commandLineHelpQuery.addAll(Arrays.asList(string.trim().split("\\s+")));
        }
    }

    void setOnlineHelpQuery(String string) {
        if (string == null || string.length() == 0) {
            if (this.onlineHelpQuery == null) {
                this.onlineHelpQuery = "";
            }
        } else {
            this.onlineHelpQuery = this.onlineHelpQuery == null ? string : this.onlineHelpQuery + " " + string;
        }
    }

    void show(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.show(printWriter);
        printWriter.flush();
    }

    boolean show(PrintWriter printWriter) {
        boolean bl = false;
        if (this.releaseNotesFlag) {
            this.showReleaseNotes(printWriter);
        }
        if (this.tagSpecFlag) {
            this.showTagSpec(printWriter);
        }
        if (this.versionFlag) {
            this.showVersion(printWriter);
        }
        if (this.commandLineHelpQuery != null) {
            this.showCommandLineHelp(printWriter);
        }
        if (this.onlineHelpQuery != null) {
            bl = this.showOnlineHelp(printWriter);
        }
        return bl;
    }

    void showReleaseNotes(PrintWriter printWriter) {
        File file = this.getHomeDir();
        File file2 = new File(file, "README");
        if (file2.exists()) {
            printWriter.println(i18n.getString("help.releaseNotes", file2.getAbsolutePath()));
        } else {
            printWriter.println(i18n.getString("help.cantFindReleaseNotes"));
        }
    }

    void showTagSpec(PrintWriter printWriter) {
        File file = this.getDocDir();
        File file2 = new File(file, "tag-spec.txt");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            printWriter.println(i18n.getString("help.cantFindSpec"));
        }
        catch (IOException iOException) {
            printWriter.println(i18n.getString("help.cantReadSpec", iOException));
        }
    }

    void showVersion(PrintWriter printWriter) {
        Version version = Version.getCurrent();
        String string = i18n.getString("help.version.unknown");
        String string2 = "jtreg";
        String string3 = version.getProperty(string2 + "-Name", string);
        String string4 = version.getProperty(string2 + "-Version", string);
        String string5 = version.getProperty(string2 + "-Milestone", string);
        String string6 = version.getProperty(string2 + "-Build", string);
        String string7 = version.getProperty(string2 + "-BuildJavaVersion", string);
        String string8 = version.getProperty(string2 + "-BuildDate", string);
        String string9 = System.getProperty("java.home");
        String string10 = System.getProperty("java.version");
        File file = this.getClassPathFileForClass(Main.class);
        String string11 = file == null ? string : file.getPath();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Object[] objectArray = new Object[]{string3, string4, string5, string6, string11, string10, string9, string7, string8};
        printWriter.println(i18n.getString("help.version.txt", objectArray));
        printWriter.println(i18n.getString("help.copyright.txt"));
        for (VersionHelper versionHelper : this.versionHelpers) {
            versionHelper.showVersion(printWriter);
        }
    }

    private File getHomeDir() {
        File file = this.getClassPathFileForClass(Main.class);
        if (file == null) {
            return null;
        }
        File file2 = file.getParentFile();
        File file3 = file2.getParentFile();
        return file3;
    }

    private File getDocDir() {
        File file = this.getHomeDir();
        File file2 = new File(new File(file, "doc"), "jtreg");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> clazz) {
        try {
            URL uRL = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
            if (uRL.getProtocol().equals("jar")) {
                String string = uRL.getPath();
                int n = string.lastIndexOf("!");
                return new URL(string.substring(0, n));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private File getClassPathFileForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL.getProtocol().equals("file")) {
            return new File(uRL.getPath());
        }
        return null;
    }

    private Properties getManifestForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL == null) {
            return null;
        }
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                int n;
                String string;
                URL uRL2;
                URL uRL3 = enumeration.nextElement();
                if (!uRL3.getProtocol().equals("jar") || !(uRL2 = new URL((string = uRL3.getPath()).substring(0, n = string.lastIndexOf("!")))).equals(uRL)) continue;
                Properties properties = new Properties();
                InputStream inputStream = uRL3.openStream();
                properties.load(inputStream);
                inputStream.close();
                return properties;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    void showCommandLineHelp(PrintWriter printWriter) {
        Object object;
        String[] stringArray;
        Object object2;
        Integer n;
        HelpTree helpTree = new HelpTree();
        Integer n2 = Integer.getInteger("javatest.help.nodeIndent");
        if (n2 != null) {
            helpTree.setNodeIndent(n2);
        }
        if ((n = Integer.getInteger("javatest.help.descIndent")) != null) {
            helpTree.setDescriptionIndent(n);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Option object42 : this.options) {
            linkedHashSet.add(object42.group);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : linkedHashSet) {
            linkedHashMap.put(string, new TreeMap(new CaseInsensitiveStringComparator()));
        }
        for (Option option : this.options) {
            if (option.names.length <= 0) continue;
            ((SortedMap)linkedHashMap.get(option.group)).put(option.names[0], option);
        }
        for (String string : linkedHashSet) {
            object2 = (SortedMap)linkedHashMap.get(string);
            if (object2.isEmpty()) continue;
            stringArray = new ArrayList();
            for (Option option : object2.values()) {
                stringArray.add(this.createOptionHelpNode(option));
            }
            object = new HelpTree.Node(i18n, "help." + string.toString().toLowerCase(), stringArray.toArray(new HelpTree.Node[stringArray.size()]));
            helpTree.addNode((HelpTree.Node)object);
        }
        HelpTree.Node node = new HelpTree.Node(i18n, "help.tests", new String[]{"at", "groups"});
        helpTree.addNode(node);
        String string = Help.getProgramName();
        try {
            object2 = new WrapWriter(printWriter);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.isEmpty()) {
                ((Writer)object2).write(i18n.getString("help.cmd.proto", string));
                ((Writer)object2).write("\n\n");
                ((Writer)object2).write(i18n.getString("help.cmd.introHead"));
                ((WrapWriter)object2).write('\n');
                helpTree.writeSummary((Writer)object2);
            } else if (this.commandLineHelpQuery.contains("all")) {
                ((Writer)object2).write(i18n.getString("help.cmd.proto", string));
                ((Writer)object2).write("\n\n");
                ((Writer)object2).write(i18n.getString("help.cmd.fullHead"));
                ((WrapWriter)object2).write('\n');
                helpTree.write((Writer)object2);
            } else {
                stringArray = this.commandLineHelpQuery.toArray(new String[this.commandLineHelpQuery.size()]);
                object = helpTree.find(stringArray);
                if (object != null) {
                    helpTree.write((Writer)object2, (HelpTree.Selection)object);
                } else {
                    ((Writer)object2).write(i18n.getString("help.cmd.noEntriesFound"));
                    ((Writer)object2).write("\n\n");
                    ((Writer)object2).write(i18n.getString("help.cmd.summaryHead"));
                    ((WrapWriter)object2).write('\n');
                    helpTree.writeSummary((Writer)object2);
                }
            }
            ((WrapWriter)object2).write('\n');
            ((Writer)object2).write(i18n.getString("help.cmd.tail"));
            ((Writer)object2).write("\n\n");
            ((Writer)object2).write(i18n.getString("help.cmd.ant"));
            ((Writer)object2).write("\n\n");
            ((Writer)object2).write(i18n.getString("help.copyright.txt"));
            ((Writer)object2).write("\n\n");
            ((WrapWriter)object2).flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HelpTree.Node createOptionHelpNode(Option option) {
        String string = "help." + option.group.toString().toLowerCase() + "." + option.names[0].replaceAll("[^A-Za-z0-9.]+", "_");
        String string2 = option.argType == Option.ArgType.NONE ? null : i18n.getString(string + ".arg");
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (String string3 : option.names) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("  |  ");
            }
            stringBuilder.append("-");
            stringBuilder.append(string3);
            switch (option.argType) {
                case NONE: {
                    continue block7;
                }
                case OLD: 
                case STD: 
                case FILE: {
                    stringBuilder.append(":").append(string2);
                    continue block7;
                }
                case REST: {
                    stringBuilder.append(" ").append(string2);
                    continue block7;
                }
                case WILDCARD: {
                    stringBuilder.append(string2);
                    continue block7;
                }
                case OPT: {
                    stringBuilder.append("  |  -").append(string3).append(":").append(string2);
                    continue block7;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        String string4 = stringBuilder.toString();
        String string5 = i18n.getString(string + ".desc");
        String[] stringArray = option.getChoices();
        if (stringArray == null || stringArray.length == 0) {
            return new HelpTree.Node(string4, string5);
        }
        HelpTree.Node[] nodeArray = new HelpTree.Node[stringArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = new HelpTree.Node(stringArray[i], i18n.getString(string + "." + stringArray[i] + ".desc"));
        }
        return new HelpTree.Node(string4, string5, nodeArray);
    }

    private static String getProgramName() {
        String string = System.getProperty("program");
        if (string != null) {
            return string;
        }
        List<File> list = new SearchPath(System.getProperty("java.class.path")).split();
        if (list.size() == 1 && list.get(0).getName().equals("jtreg.jar")) {
            return "java -jar jtreg.jar ";
        }
        return "java " + Main.class.getName();
    }

    boolean showOnlineHelp(PrintWriter printWriter) {
        printWriter.println(i18n.getString("help.onlineHelp.pleaseWait"));
        printWriter.flush();
        URL uRL = HelpSet.findHelpSet(null, "com/sun/javatest/regtest/help/jtreg.hs");
        if (uRL == null) {
            throw new AssertionError((Object)"cant find jtreg helpset");
        }
        try {
            HelpSet helpSet = new HelpSet(null, uRL);
            CustomHelpBroker customHelpBroker = new CustomHelpBroker(helpSet);
            if (this.onlineHelpQuery != null && this.onlineHelpQuery.length() > 0) {
                customHelpBroker.search(this.onlineHelpQuery);
            } else {
                customHelpBroker.setCurrentID("home");
            }
            customHelpBroker.setDisplayed(true);
            return true;
        }
        catch (HelpSetException helpSetException) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null || string2 == null) {
                return string == null ? -1 : 1;
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomHelpBroker
    extends DefaultHelpBroker {
        private boolean first = true;

        CustomHelpBroker(HelpSet helpSet) {
            super(helpSet);
            ExitCount.inc();
        }

        void search(String string) {
            this.initPresentation();
            JFrame jFrame = (JFrame)this.getHelpWindow();
            Container container = jFrame.getContentPane();
            JHelpSearchNavigator jHelpSearchNavigator = (JHelpSearchNavigator)this.findComponent(container, JHelpSearchNavigator.class);
            if (jHelpSearchNavigator == null) {
                return;
            }
            JTextField jTextField = (JTextField)this.findComponent(jHelpSearchNavigator, JTextField.class);
            if (jTextField == null) {
                return;
            }
            jTextField.setText(string);
            jTextField.postActionEvent();
            this.setCurrentView("Search");
        }

        @Override
        public void setDisplayed(boolean bl) {
            super.setDisplayed(bl);
            JFrame jFrame = (JFrame)this.getHelpWindow();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    if (CustomHelpBroker.this.first) {
                        Window window = windowEvent.getWindow();
                        window.setLocationRelativeTo(null);
                        CustomHelpBroker.this.first = false;
                    }
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ExitCount.dec();
                }
            });
        }

        private Component findComponent(Container container, Class<?> clazz) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component;
                Component component2 = container.getComponent(i);
                if (clazz.isInstance(component2)) {
                    return component2;
                }
                if (!(component2 instanceof Container) || (component = this.findComponent((Container)component2, clazz)) == null) continue;
                return component;
            }
            return null;
        }

        private Window getHelpWindow() {
            return this.getWindowPresentation().getHelpWindow();
        }
    }

    static interface VersionHelper {
        public void showVersion(PrintWriter var1);
    }
}

