/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.CompileAction;
import com.sun.javatest.regtest.Locations;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.TestRunException;
import com.sun.javatest.regtest.agent.RStatus;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAction
extends Action {
    public static final String NAME = "build";
    private String implicitOpt;
    private static final boolean IGNORE_SYMBOL_FILE = true;

    @Override
    public String getName() {
        return NAME;
    }

    public Status build(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws TestRunException {
        this.init(stringArray, stringArray2, string, regressionScript);
        return this.run();
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        super.init(stringArray, stringArray2, string, regressionScript);
        for (String[] stringArray3 : stringArray) {
            if (!stringArray3[0].equals("implicit") || !stringArray3[1].equals("none")) {
                throw new ParseException("Unexpected options for `build'");
            }
            this.implicitOpt = "-implicit:none";
        }
        if (stringArray2.length == 0) {
            throw new ParseException("No classname(s) provided for `build'");
        }
        for (String[] stringArray3 : stringArray2) {
            if (stringArray3.indexOf(File.separatorChar) == -1 && stringArray3.indexOf(47) == -1) continue;
            throw new ParseException("Bad classname provided for `build': " + (String)stringArray3);
        }
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (String string : this.args) {
            try {
                for (Locations.ClassLocn classLocn : this.script.locations.locateClasses(string)) {
                    linkedHashSet.add(classLocn.absSrcFile);
                }
            }
            catch (TestRunException testRunException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }

    @Override
    public Status run() throws TestRunException {
        Status status;
        String[] stringArray;
        Serializable serializable;
        this.startAction();
        PrintWriter printWriter = this.section.getMessageWriter();
        long l = System.currentTimeMillis();
        LinkedHashMap<File, String[]> linkedHashMap = new LinkedHashMap<File, String[]>();
        for (String object : this.args) {
            for (Locations.ClassLocn classLocn : this.script.locations.locateClasses(object)) {
                if (classLocn.absSrcFile.lastModified() > l) {
                    printWriter.println(String.format("WARNING: file %s has a modification time in the future: %s", classLocn.absSrcFile, DateFormat.getDateTimeInstance().format(new Date(classLocn.absSrcFile.lastModified()))));
                    printWriter.println("Unexpected results may occur");
                }
                if (classLocn.isUpToDate()) continue;
                serializable = classLocn.lib.absClsDir;
                stringArray = (String[])linkedHashMap.get(serializable);
                if (stringArray == null) {
                    stringArray = new ArrayList();
                    linkedHashMap.put((File)serializable, stringArray);
                }
                stringArray.add(classLocn.absSrcFile);
            }
        }
        if (linkedHashMap.isEmpty()) {
            status = RStatus.passed("All files up to date");
        } else {
            status = null;
            for (File file : this.script.locations.absClsLibList()) {
                file.mkdirs();
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                File file = (File)entry.getKey();
                List list = (List)entry.getValue();
                CompileAction compileAction = new CompileAction();
                String[][] stringArray2 = new String[][]{};
                serializable = new ArrayList();
                serializable.add("-XDignore.symbol.file=true");
                if (this.implicitOpt != null) {
                    serializable.add(this.implicitOpt);
                }
                serializable.addAll(this.asStrings(list));
                stringArray = serializable.toArray(new String[serializable.size()]);
                Status status2 = compileAction.compile(file, stringArray2, stringArray, ".class file out of date or does not exist", this.script);
                if (status2.isPassed()) continue;
                status = status2;
                break;
            }
            if (status == null) {
                status = RStatus.passed("Build successful");
            }
        }
        this.endAction(status);
        return status;
    }

    private List<String> asStrings(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (File file : list) {
            arrayList.add(file.getPath());
        }
        return arrayList;
    }
}

