/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.diff.DiffReader;
import com.sun.javatest.diff.HTMLWriter;
import com.sun.javatest.diff.MultiMap;
import com.sun.javatest.diff.Reporter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLReporter
extends Reporter {
    private String[] statusStrings;
    protected final HTMLWriter out;
    private MultiMap<String, TestResult> table;
    private int size;
    private static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3c.org/TR/1999/REC-html401-19991224/loose.dtd\">";
    private static final String THEAD = "thead";
    private static final String TBODY = "tbody";
    private static final String CLASS = "class";
    private static final String FRAME = "frame";
    private static final String RULES = "rules";
    private static final String BOX = "box";
    private static final String GROUPS = "groups";
    private static final String HEAD = "head";
    private static final String ODD = "odd";
    private static final String EVEN = "even";
    private static final String PASS = "pass";
    private static final String FAIL = "fail";
    private static final String ERROR = "error";
    private static final String NOT_RUN = "notRun";
    private boolean compact = Boolean.TRUE.equals(Boolean.getBoolean("jtdiff.html.compact"));
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(HTMLReporter.class);

    public HTMLReporter(Writer writer) throws IOException {
        this.out = new HTMLWriter(writer, DOCTYPE);
        this.out.setI18NResourceBundle(i18n);
    }

    @Override
    public void write(MultiMap<String, TestResult> multiMap) throws IOException {
        this.table = multiMap;
        this.size = multiMap.getColumns();
        this.startReport(this.title);
        this.out.startTag("h1");
        if (this.title == null) {
            this.out.writeI18N("html.head.notitle");
        } else {
            this.out.writeI18N("html.head.title", this.title);
        }
        this.out.endTag("h1");
        this.writeIndexTable();
        this.writeMainTable();
        this.writeSummary();
        this.endReport();
    }

    protected void startReport(String string) throws IOException {
        this.out.startTag("html");
        this.writeHead(string);
        this.out.startTag("body");
    }

    protected void endReport() throws IOException {
        this.out.startTag("hr");
        this.out.writeI18N("html.generatedAt", new Date());
        this.out.endTag("body");
        this.out.endTag("html");
        this.out.flush();
    }

    protected void writeHead(String string) throws IOException {
        this.out.startTag(HEAD);
        this.out.startTag("title");
        if (string == null) {
            this.out.writeI18N("html.head.notitle");
        } else {
            this.out.writeI18N("html.head.title", string);
        }
        this.out.endTag("title");
        this.out.startTag("style");
        this.out.writeAttr("type", "text/css");
        this.out.write("\n");
        this.out.write("table   { background-color:white }");
        this.out.write("tr.head { background-color:#dddddd }");
        this.out.write("tr.odd  { background-color:#eeeeee }");
        this.out.write("tr.even { background-color:white } ");
        this.out.write("td { padding: 0 .5em }");
        this.out.write("td.pass { background-color:#ddffdd } ");
        this.out.write("td.fail { background-color:#ffdddd } ");
        this.out.write("td.error { background-color:#ddddff } ");
        this.out.write("td.notRun { background-color:#dddddd } ");
        this.out.write("th { padding: 0 .5em }");
        this.out.write("hr      { margin-top:30px; }");
        this.out.write("\n");
        this.out.endTag("style");
        this.out.endTag(HEAD);
    }

    private void writeIndexTable() throws IOException {
        int n;
        this.out.startTag("h2");
        this.out.writeI18N("html.head.sets");
        this.out.endTag("h2");
        this.out.startTag("table");
        this.out.writeAttr(FRAME, BOX);
        this.out.writeAttr(RULES, GROUPS);
        this.out.startTag(THEAD);
        this.out.startTag("tr");
        this.out.writeAttr(CLASS, HEAD);
        this.out.startTag("th");
        this.out.writeI18N("html.th.set");
        this.out.endTag("th");
        this.out.startTag("th");
        this.out.writeI18N("html.th.location");
        this.out.endTag("th");
        this.writeIndexTableInfoHeadings();
        for (n = 0; n < 4; ++n) {
            this.out.startTag("th");
            switch (n) {
                case 0: {
                    this.out.writeI18N("html.th.pass");
                    break;
                }
                case 1: {
                    this.out.writeI18N("html.th.fail");
                    break;
                }
                case 2: {
                    this.out.writeI18N("html.th.error");
                    break;
                }
                default: {
                    this.out.writeI18N("html.th.notRun");
                }
            }
            this.out.endTag("th");
        }
        this.out.startTag("th");
        this.out.writeI18N("html.th.total");
        this.out.endTag("th");
        this.out.endTag("tr");
        this.out.endTag(THEAD);
        this.out.startTag(TBODY);
        for (n = 0; n < this.size; ++n) {
            this.out.startTag("tr");
            this.out.writeAttr(CLASS, n % 2 == 0 ? EVEN : ODD);
            this.out.startTag("td");
            this.out.write(String.valueOf(n + 1));
            this.out.endTag("td");
            this.out.startTag("td");
            this.out.write(this.table.getColumnName(n));
            this.writeIndexTableInfoValues(this.table.getColumnName(n));
            this.out.endTag("td");
            int n2 = 0;
            int[] nArray = (int[])this.testCounts.get(n);
            for (int i = 0; i < 4; ++i) {
                this.out.startTag("td");
                if (nArray[i] > 0) {
                    this.out.write(String.valueOf(nArray[i]));
                } else {
                    this.out.writeEntity("&nbsp;");
                }
                n2 += nArray[i];
                this.out.endTag("td");
            }
            this.out.startTag("td");
            this.out.write(String.valueOf(n2));
            this.out.endTag("td");
            this.out.endTag("tr");
        }
        this.out.endTag(TBODY);
        this.out.endTag("table");
    }

    protected void writeIndexTableInfoHeadings() throws IOException {
    }

    protected void writeIndexTableInfoValues(String string) throws IOException {
    }

    private void writeMainTable() throws IOException {
        this.diffs = 0;
        for (Map.Entry<String, MultiMap.Entry<TestResult>> entry : this.table.entrySet()) {
            int n;
            String string = entry.getKey();
            MultiMap.Entry<TestResult> entry2 = entry.getValue();
            if (entry2.allEqual(this.comparator)) continue;
            if (this.diffs == 0) {
                this.out.startTag("h2");
                this.out.writeI18N("html.head.differences");
                this.out.endTag("h2");
                this.out.startTag("table");
                this.out.writeAttr(FRAME, BOX);
                this.out.writeAttr(RULES, GROUPS);
                this.out.startTag(THEAD);
                this.out.startTag("tr");
                this.out.writeAttr(CLASS, HEAD);
                this.out.startTag("th");
                this.out.writeI18N("html.th.test");
                this.out.endTag("th");
                for (n = 0; n < entry2.getSize(); ++n) {
                    this.out.startTag("th");
                    if (this.compact) {
                        this.out.write(String.valueOf(n + 1));
                    } else {
                        this.out.writeI18N("html.th.setN", n + 1);
                    }
                    this.out.endTag("th");
                }
                this.out.endTag("tr");
                this.out.endTag(THEAD);
                this.out.startTag(TBODY);
            }
            this.out.startTag("tr");
            this.out.writeAttr(CLASS, this.diffs % 2 == 0 ? EVEN : ODD);
            this.out.startTag("td");
            this.out.write(string);
            this.out.endTag("td");
            for (n = 0; n < entry2.getSize(); ++n) {
                Object object;
                File file;
                TestResult testResult = entry2.get(n);
                File file2 = file = testResult == null ? null : testResult.getFile();
                if (file == null && (object = ((DiffReader)this.readers.get(n)).getWorkDirectory()) != null) {
                    file = new File((File)object, testResult.getWorkRelativePath());
                }
                this.out.startTag("td");
                object = testResult == null ? null : testResult.getStatus();
                this.out.writeAttr(CLASS, this.getClassAttr((Status)object));
                String string2 = this.getText((Status)object);
                if (file != null && file.exists()) {
                    this.out.startTag("a");
                    this.out.writeAttr("href", file.toURI().toString());
                    if (string2.startsWith("&")) {
                        this.out.writeEntity(string2);
                    } else {
                        this.out.write(string2);
                    }
                    this.out.endTag("a");
                } else if (string2.startsWith("&")) {
                    this.out.writeEntity(string2);
                } else {
                    this.out.write(string2);
                }
                this.out.endTag("td");
            }
            this.out.endTag("tr");
            ++this.diffs;
        }
        if (this.diffs > 0) {
            this.out.endTag(TBODY);
            this.out.endTag("table");
        }
    }

    private void writeSummary() throws IOException {
        this.out.startTag("p");
        if (this.diffs == 0) {
            this.out.writeI18N("html.diffs.none");
        } else {
            this.out.writeI18N("html.diffs.count", this.diffs);
        }
        this.out.endTag("p");
    }

    protected String getClassAttr(Status status) {
        switch (status == null ? 3 : status.getType()) {
            case 0: {
                return PASS;
            }
            case 1: {
                return FAIL;
            }
            case 2: {
                return ERROR;
            }
        }
        return NOT_RUN;
    }

    protected String getText(Status status) {
        if (this.statusStrings == null) {
            this.statusStrings = new String[4];
            if (this.compact) {
                this.statusStrings[0] = i18n.getString("html.pass.compact");
                this.statusStrings[1] = i18n.getString("html.fail.compact");
                this.statusStrings[2] = i18n.getString("html.error.compact");
                this.statusStrings[3] = i18n.getString("html.notRun.compact");
            } else {
                this.statusStrings[0] = i18n.getString("html.pass");
                this.statusStrings[1] = i18n.getString("html.fail");
                this.statusStrings[2] = i18n.getString("html.error");
                this.statusStrings[3] = i18n.getString("html.notRun");
            }
        }
        return this.statusStrings[status == null ? 3 : status.getType()];
    }
}

