/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XPrintStream {
    private final ByteArrayOutputStream bstream;
    private final PrintStream ps;
    private final PrintWriter out;
    private final PrintWriter err;
    private static final String INDENT = "    ";

    XPrintStream(PrintWriter out, PrintWriter err, String encoding) throws UnsupportedEncodingException {
        this.out = out;
        this.err = err;
        this.bstream = new ByteArrayOutputStream();
        this.ps = new PrintStream((OutputStream)this.bstream, false, encoding);
    }

    void indent() {
        this.ps.print(INDENT);
    }

    public void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.indent();
        }
    }

    public void println(String in) {
        this.ps.println(in);
    }

    public void print(String in) {
        this.ps.print(in);
    }

    public void print(double d) {
        this.ps.print(d);
    }

    public void sanitize(String in) {
        if (in == null) {
            return;
        }
        block9: for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '&': {
                    this.ps.print("&amp;");
                    continue block9;
                }
                case '<': {
                    this.ps.print("&lt;");
                    continue block9;
                }
                case '>': {
                    this.ps.print("&gt;");
                    continue block9;
                }
                case '\"': {
                    this.ps.print("&quot;");
                    continue block9;
                }
                case '\'': {
                    this.ps.print("&apos;");
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    this.ps.print(ch);
                    continue block9;
                }
                case '\\': {
                    if (i + 1 < in.length() && in.charAt(i + 1) == 'u') {
                        this.ps.print("\\uu");
                        ++i;
                        continue block9;
                    }
                    this.ps.print(ch);
                    continue block9;
                }
                default: {
                    if (ch < ' ' || !Character.isDefined(ch)) {
                        this.ps.printf("\\u%04x", ch);
                        continue block9;
                    }
                    this.ps.print(ch);
                }
            }
        }
    }

    public void close() {
        this.ps.close();
    }

    public String toString() {
        return this.bstream.toString();
    }

    public void writeTo(OutputStream os) throws IOException {
        this.bstream.writeTo(os);
    }

    public void verifyXML(File xmlFile) throws IOException {
        try {
            SAXParserFactory sax = SAXParserFactory.newInstance();
            sax.setValidating(false);
            SAXParser parser = sax.newSAXParser();
            XMLReader xmlreader = parser.getXMLReader();
            xmlreader.parse(new InputSource(new ByteArrayInputStream(this.bstream.toByteArray())));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            this.err.println("File: " + String.valueOf(xmlFile) + ":" + String.valueOf(ex));
            this.err.println(this.toString());
        }
    }
}

