/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import java.util.HashSet;
import java.util.List;

public class Verbose {
    public static final Verbose DEFAULT = new Verbose(Mode.DEFAULT);
    public static final Verbose SUMMARY = new Verbose(Mode.SUMMARY);
    public static final Verbose ALL = new Verbose(Mode.FULL);
    public static final Verbose PASS = new Verbose(Mode.FULL, Mode.BRIEF, Mode.BRIEF);
    public static final Verbose FAIL = new Verbose(Mode.BRIEF, Mode.FULL, Mode.BRIEF);
    public static final Verbose ERROR = new Verbose(Mode.BRIEF, Mode.BRIEF, Mode.FULL);
    public static final Verbose TIME = new Verbose(Mode.SUMMARY, true, false);
    public final Mode passMode;
    public final Mode failMode;
    public final Mode errorMode;
    public final boolean time;
    public final boolean multiRun;

    public static String[] values() {
        return new String[]{"default", "summary", "all", "pass", "fail", "error", "nopass", "time", "multirun"};
    }

    public static Verbose decode(String s) {
        HashSet<String> opts = new HashSet<String>(List.of(s.split(",")));
        boolean defaultOpt = opts.contains("default");
        boolean summaryOpt = opts.contains("summary");
        boolean allOpt = opts.contains("all");
        boolean passOpt = opts.contains("pass");
        boolean failOpt = opts.contains("fail");
        boolean errorOpt = opts.contains("error");
        boolean nopassOpt = opts.contains("nopass");
        boolean timeOpt = opts.contains("time");
        boolean multiRunOpt = opts.contains("multirun");
        if (defaultOpt) {
            if (summaryOpt || allOpt || passOpt || failOpt || errorOpt || nopassOpt) {
                throw new IllegalArgumentException(s);
            }
            return new Verbose(Mode.DEFAULT, timeOpt, multiRunOpt);
        }
        if (summaryOpt || allOpt || passOpt || failOpt || errorOpt || nopassOpt) {
            Mode shortMode;
            if (passOpt && nopassOpt) {
                throw new IllegalArgumentException(s);
            }
            Mode mode = shortMode = summaryOpt ? Mode.SUMMARY : Mode.BRIEF;
            return new Verbose(nopassOpt ? Mode.NONE : (allOpt || passOpt ? Mode.FULL : shortMode), allOpt || failOpt ? Mode.FULL : shortMode, allOpt || errorOpt ? Mode.FULL : shortMode, timeOpt, multiRunOpt);
        }
        if (timeOpt) {
            return new Verbose(Mode.SUMMARY, true, multiRunOpt);
        }
        return new Verbose(Mode.DEFAULT, false, multiRunOpt);
    }

    private static Mode check(Mode currentMode, Mode newMode) {
        if (newMode == null) {
            throw new NullPointerException();
        }
        if (currentMode == null || currentMode == newMode) {
            return newMode;
        }
        return newMode;
    }

    Verbose(Mode m) {
        this(m, false, false);
    }

    Verbose(Mode m, boolean time, boolean multiRun) {
        this(m, m, m, time, multiRun);
    }

    Verbose(Mode p, Mode f, Mode e) {
        this(p, f, e, false, false);
    }

    Verbose(Mode p, Mode f, Mode e, boolean t, boolean m) {
        this.passMode = p;
        this.failMode = f;
        this.errorMode = e;
        this.time = t;
        this.multiRun = m;
    }

    boolean isDefault() {
        return this.passMode == Mode.DEFAULT && this.failMode == Mode.DEFAULT && this.errorMode == Mode.DEFAULT;
    }

    public String toString() {
        return "Verbose[p=" + String.valueOf((Object)this.passMode) + ",f=" + String.valueOf((Object)this.failMode) + ",e=" + String.valueOf((Object)this.errorMode) + ",t=" + this.time + ",m=" + this.multiRun + "]";
    }

    public static enum Mode {
        NONE,
        DEFAULT,
        SUMMARY,
        BRIEF,
        FULL;

    }
}

