/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.config.CachingTestFilter;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.report.Report;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TestStats {
    public int[] counts = new int[4];
    int excluded;
    int ignored;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestStats.class);

    public void register(Harness h) {
        h.addObserver(new BasicObserver(){
            RegressionParameters params;

            @Override
            public void startingTestRun(Parameters params) {
                this.params = (RegressionParameters)params;
            }

            @Override
            public void finishedTesting() {
                RegressionParameters.KeywordsTestFilter kf;
                CachingTestFilter ef = this.params.getExcludeListFilter();
                if (ef != null) {
                    for (CachingTestFilter.Entry e : ef.getCacheEntries()) {
                        if (e.value.booleanValue()) continue;
                        ++TestStats.this.excluded;
                    }
                }
                if ((kf = this.params.getKeywordsFilter()) != null) {
                    TestStats.this.ignored = kf.ignored.size();
                }
            }

            @Override
            public void finishedTest(TestResult tr) {
                TestStats.this.add(tr);
            }
        });
    }

    public void add(TestResult tr) {
        int n = tr.getStatus().getType();
        this.counts[n] = this.counts[n] + 1;
    }

    public void addAll(TestStats other) {
        for (int i = 0; i < this.counts.length; ++i) {
            int n = i;
            this.counts[n] = this.counts[n] + other.counts[i];
        }
    }

    public boolean isOK() {
        return this.counts[1] == 0 && this.counts[2] == 0;
    }

    public void showResultStats(PrintWriter out) {
        String format;
        int p = this.counts[0];
        int f = this.counts[1];
        int e = this.counts[2];
        int nr = this.counts[3];
        String msg = p + f + e + nr == 0 ? i18n.getString("stats.noTests") : ((format = System.getProperty("jtreg.stats.format")) != null ? this.getText(format) : i18n.getString("stats.tests", p, p > 0 && f + e + nr > 0 ? 1 : 0, f, f > 0 && e + nr > 0 ? 1 : 0, e, e > 0 && nr > 0 ? 1 : 0, nr));
        out.println(msg);
    }

    public void report(Report report) throws IOException {
        File reportDir = report.getReportDir();
        File reportTextDir = new File(reportDir, "text");
        reportTextDir.mkdirs();
        File file = new File(reportTextDir, "stats.txt");
        this.report(file);
    }

    public void report(File file) throws IOException {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            this.showResultStats(out);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    String getText(String format) {
        StringBuilder sb = new StringBuilder();
        int sbLen = 0;
        int i = 0;
        while (true) {
            block21: {
                block23: {
                    char c;
                    block22: {
                        if (i >= format.length()) {
                            return sb.substring(0, sbLen);
                        }
                        c = format.charAt(i);
                        if (c != '%' || i + 1 >= format.length()) break block22;
                        c = format.charAt(++i);
                        switch (c) {
                            case 'F': 
                            case 'e': 
                            case 'f': 
                            case 'i': 
                            case 'n': 
                            case 'p': 
                            case 'r': 
                            case 'x': {
                                int count = this.getNumber(c);
                                if (count >= 0) {
                                    sb.append(String.valueOf(count));
                                    break;
                                }
                                sb.append("%").append(c);
                                break;
                            }
                            case ',': {
                                if (sb.length() > 0) {
                                    sb.append(",");
                                }
                                break block21;
                            }
                            case ' ': {
                                if (sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                                    sb.append(' ');
                                }
                                break block21;
                            }
                            case '%': {
                                sb.append("%");
                                break;
                            }
                            case '?': {
                                int count;
                                if (i + 1 < format.length()) {
                                    if ((c = format.charAt(++i)) == '{') {
                                        int j = format.indexOf("}", i);
                                        if (j == -1) {
                                            sb.append("%?").append(format.substring(i));
                                            i = format.length();
                                            break;
                                        }
                                        String text = format.substring(i + 1, j);
                                        i = j;
                                        if (text.length() <= 0) break;
                                        c = text.charAt(text.length() - 1);
                                        int count2 = this.getNumber(c);
                                        if (count2 > 0) {
                                            sb.append(text, 0, text.length() - 1).append(String.valueOf(count2));
                                            break;
                                        }
                                        if (count2 < 0) {
                                            sb.append("%?{").append(text).append("}");
                                            break;
                                        }
                                        break block21;
                                    } else {
                                        count = this.getNumber(c);
                                        if (count > 0) {
                                            sb.append(String.valueOf(count));
                                            break;
                                        }
                                        if (count < 0) {
                                            sb.append("%?").append(c);
                                            break;
                                        }
                                    }
                                    break block21;
                                } else {
                                    sb.append("%").append("?");
                                    break;
                                }
                            }
                            default: {
                                sb.append("%").append(c);
                                break;
                            }
                        }
                        break block23;
                    }
                    sb.append(c);
                }
                sbLen = sb.length();
            }
            ++i;
        }
    }

    int getNumber(char c) {
        switch (c) {
            case 'f': {
                return this.counts[1];
            }
            case 'F': {
                return this.counts[1] + this.counts[2];
            }
            case 'e': {
                return this.counts[2];
            }
            case 'i': {
                return this.ignored;
            }
            case 'n': {
                return this.counts[3];
            }
            case 'p': {
                return this.counts[0];
            }
            case 'r': {
                return this.counts[0] + this.counts[1] + this.counts[2];
            }
            case 'x': {
                return this.excluded;
            }
        }
        return -1;
    }
}

