/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.agent.ActionHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SummaryReporter {
    private static final Map<WorkDirectory, Map<Class<?>, SummaryReporter>> instanceMap = new WeakHashMap();

    public static synchronized SummaryReporter forTestNG(WorkDirectory wd) {
        return instanceMap.computeIfAbsent(wd, wd_ -> new HashMap()).computeIfAbsent(TestNGSummaryReporter.class, c_ -> new TestNGSummaryReporter());
    }

    public static synchronized SummaryReporter forJUnit(WorkDirectory wd) {
        return instanceMap.computeIfAbsent(wd, wd_ -> new HashMap()).computeIfAbsent(JUnitSummaryReporter.class, c_ -> new JUnitSummaryReporter());
    }

    public abstract boolean isEmpty();

    public abstract void add(TestResult var1, TestResult.Section var2);

    public abstract void writeReport(File var1) throws IOException;

    private static class TestNGSummaryReporter
    extends SummaryReporter {
        private final Map<String, Info> infoMap = new TreeMap<String, Info>();
        static final String testsPrefix = "Total tests run:";
        static final Pattern testsPattern = Pattern.compile("[^0-9]+([0-9]+)[^0-9]+([0-9]+)[^0-9]+([0-9]+)[^0-9]*");
        static final String configPrefix = "Configuration Failures:";
        static final Pattern configPattern = Pattern.compile("[^0-9]+([0-9]+)[^0-9]+([0-9]+)[^0-9]*");

        private TestNGSummaryReporter() {
        }

        @Override
        public boolean isEmpty() {
            return this.infoMap.isEmpty();
        }

        @Override
        public synchronized void add(TestResult tr, TestResult.Section s) {
            try {
                String out;
                Info info;
                TestDescription td = tr.getDescription();
                String group = td.getParameter("packageRoot");
                if (group == null) {
                    group = td.getRootRelativePath();
                }
                if ((info = this.infoMap.get(group)) == null) {
                    info = new Info();
                    this.infoMap.put(group, info);
                }
                if ((out = s.getOutput(ActionHelper.OutputHandler.OutputKind.STDOUT.name)) != null) {
                    Matcher cm;
                    Matcher tm = this.getMatcher(out, testsPrefix, testsPattern);
                    if (tm != null && tm.matches()) {
                        info.count += Integer.parseInt(tm.group(1));
                        info.failureCount += Integer.parseInt(tm.group(2));
                        info.skippedCount += Integer.parseInt(tm.group(3));
                    }
                    if ((cm = this.getMatcher(out, configPrefix, configPattern)) != null && cm.matches()) {
                        info.configFailureCount += Integer.parseInt(cm.group(1));
                        info.configSkippedCount += Integer.parseInt(cm.group(2));
                    }
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
        }

        private Matcher getMatcher(String out, String prefix, Pattern p) {
            int pos = out.lastIndexOf(prefix);
            if (pos == -1) {
                return null;
            }
            int endPos = out.indexOf("\n", pos);
            if (endPos == -1) {
                return null;
            }
            return p.matcher(out.substring(pos, endPos));
        }

        @Override
        public void writeReport(File reportDir) throws IOException {
            File reportTextDir = new File(reportDir, "text");
            reportTextDir.mkdirs();
            File f = new File(reportTextDir, "testng.txt");
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));){
                for (Map.Entry<String, Info> e : this.infoMap.entrySet()) {
                    out.println(e.getKey() + " " + String.valueOf(e.getValue()));
                }
            }
        }

        static class Info {
            int count;
            int failureCount;
            int skippedCount;
            int configFailureCount;
            int configSkippedCount;

            Info() {
            }

            public String toString() {
                return "total: " + this.count + ", passed: " + (this.count - this.failureCount - this.skippedCount) + ", failed: " + this.failureCount + ", skipped: " + this.skippedCount + ", config failed: " + this.configFailureCount + ", config skipped: " + this.configSkippedCount;
            }
        }
    }

    private static class JUnitSummaryReporter
    extends SummaryReporter {
        private final Map<String, Info> infoMap = new TreeMap<String, Info>();
        static final Pattern infoPattern = Pattern.compile("(?s)\\[ JUnit Containers:.*JUnit Tests:.*]");
        static final Pattern numberPattern = Pattern.compile("[0-9]+");

        private JUnitSummaryReporter() {
        }

        @Override
        public boolean isEmpty() {
            return this.infoMap.isEmpty();
        }

        @Override
        public synchronized void add(TestResult tr, TestResult.Section s) {
            try {
                Matcher m1;
                TestDescription td = tr.getDescription();
                String group = td.getParameter("packageRoot");
                if (group == null) {
                    group = td.getRootRelativePath();
                }
                Info info = this.infoMap.computeIfAbsent(group, g -> new Info());
                String out = s.getOutput(ActionHelper.OutputHandler.OutputKind.STDERR.name);
                if (out != null && (m1 = infoPattern.matcher(out)).find()) {
                    Matcher m2 = numberPattern.matcher(m1.group());
                    info.containers.count += this.nextInt(m2);
                    info.containers.started += this.nextInt(m2);
                    info.containers.succeeded += this.nextInt(m2);
                    info.containers.failed += this.nextInt(m2);
                    info.containers.aborted += this.nextInt(m2);
                    info.containers.skipped += this.nextInt(m2);
                    info.tests.count += this.nextInt(m2);
                    info.tests.started += this.nextInt(m2);
                    info.tests.succeeded += this.nextInt(m2);
                    info.tests.failed += this.nextInt(m2);
                    info.tests.aborted += this.nextInt(m2);
                    info.tests.skipped += this.nextInt(m2);
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
        }

        private int nextInt(Matcher m) {
            return m.find() ? Integer.parseInt(m.group()) : 0;
        }

        @Override
        public void writeReport(File reportDir) throws IOException {
            File reportTextDir = new File(reportDir, "text");
            reportTextDir.mkdirs();
            File f = new File(reportTextDir, "junit.txt");
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));){
                for (Map.Entry<String, Info> e : this.infoMap.entrySet()) {
                    out.println(e.getKey() + " " + String.valueOf(e.getValue()));
                }
            }
        }

        static class Info {
            final Counts containers = new Counts();
            final Counts tests = new Counts();

            Info() {
            }

            public String toString() {
                return "containers: " + String.valueOf(this.containers) + "; tests: " + String.valueOf(this.tests);
            }
        }

        static class Counts {
            int count;
            int started;
            int succeeded;
            int failed;
            int aborted;
            int skipped;

            Counts() {
            }

            public String toString() {
                return this.count + ", skipped: " + this.skipped + ", started: " + this.started + ", succeeded: " + this.succeeded + ", failed: " + this.failed + ", aborted: " + this.aborted;
            }
        }
    }
}

