/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.report.Report;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class ElapsedTimeHandler {
    private int resolution;
    private Table table;

    public ElapsedTimeHandler() {
        this(1);
    }

    public ElapsedTimeHandler(int resolution) {
        this.resolution = resolution;
        this.table = new Table(resolution);
    }

    public void register(Harness h) {
        h.addObserver(new BasicObserver(){
            private Map<TestResult, Long> startTimes;

            @Override
            public void startingTestRun(Parameters p) {
                this.startTimes = new WeakHashMap<TestResult, Long>();
            }

            @Override
            public synchronized void startingTest(TestResult tr) {
                this.startTimes.put(tr, System.currentTimeMillis());
            }

            @Override
            public synchronized void finishedTest(TestResult tr) {
                Long start = this.startTimes.remove(tr);
                if (start == null) {
                    return;
                }
                ElapsedTimeHandler.this.table.record(start, System.currentTimeMillis());
            }

            @Override
            public void stoppingTestRun() {
                this.startTimes = null;
            }
        });
    }

    public void report(Report report) throws IOException {
        File reportDir = report.getReportDir();
        File reportTextDir = new File(reportDir, "text");
        reportTextDir.mkdirs();
        File file = new File(reportTextDir, "timeStats.txt");
        this.report(file);
    }

    public void report(File file) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            if (this.resolution == 1) {
                out.write(String.format("%5s,%5s%n", "time", "count"));
            } else {
                out.write(String.format("%5s,%5s,%5s", "time", "blk", "count"));
            }
            for (Map.Entry e : this.table.entrySet()) {
                int k = (Integer)e.getKey();
                int v = (Integer)e.getValue();
                if (this.resolution == 1) {
                    out.write(String.format("%5d,%5d%n", k, v));
                    continue;
                }
                out.write(String.format("%5d,%5d,%5d%n", k * this.resolution, k, v));
            }
            out.write(String.format("%n", new Object[0]));
            out.write(String.format("Mean               %6.2fs%n", this.table.getMean() * (double)this.resolution));
            out.write(String.format("Standard deviation %6.2fs%n", this.table.getStdDev() * (double)this.resolution));
            int e = this.table.getElapsedTime();
            int mins = e / 60;
            int secs = e % 60;
            out.write(String.format("Total elapsed time %dm %ds%n", mins, secs));
        }
    }

    class Table
    extends TreeMap<Integer, Integer> {
        private static final long serialVersionUID = 0L;
        int resolution;
        int count;
        double total;
        double totalSquares;
        long earliest;
        long latest;

        Table(int resolution) {
            this.resolution = resolution;
        }

        void record(long start, long end) {
            if (this.earliest == 0L || start < this.earliest) {
                this.earliest = start;
            }
            if (this.latest == 0L || end > this.latest) {
                this.latest = end;
            }
            int elapsed = (int)((end - start) / 1000L);
            int bucket = elapsed / this.resolution;
            this.inc(bucket);
        }

        void inc(int bucket) {
            Integer value = (Integer)this.get(bucket);
            this.put(bucket, value == null ? 1 : value + 1);
            ++this.count;
            this.total += (double)bucket;
            this.totalSquares += (double)(bucket * bucket);
        }

        double getMean() {
            return this.total / (double)this.count;
        }

        double getStdDev() {
            double mean = this.total / (double)this.count;
            return Math.sqrt(this.totalSquares / (double)this.count - mean * mean);
        }

        int getElapsedTime() {
            if (this.earliest == 0L && this.latest == 0L) {
                return 0;
            }
            if (this.earliest == 0L || this.latest == 0L) {
                throw new IllegalStateException();
            }
            return (int)((this.latest - this.earliest) / 1000L);
        }
    }
}

