/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModuleConfig {
    private final String title;
    private List<String> addMods;
    private List<String> limitMods;
    private Map<String, List<String>> addExports;
    private Map<String, List<String>> addOpens;
    private Map<String, List<String>> addReads;
    private SearchPath modulePath;
    private SearchPath classPath;
    private SearchPath sourcePath;
    private SearchPath bootClassPathAppend;
    private Map<String, SearchPath> patch;

    ModuleConfig(String title) {
        this.title = title;
    }

    ModuleConfig setFromOpts(JDKOpts opts) {
        this.setFromOpts(opts.toList());
        return this;
    }

    ModuleConfig setFromOpts(List<String> opts) {
        JDKOpts.OptionHandler h = new JDKOpts.OptionHandler(){

            @Override
            protected void handleOption(JDKOpts.Option option, String opt, String arg) {
                switch (option) {
                    case ADD_EXPORTS: {
                        ModuleConfig.this.setAddExports(StringUtils.beforePart(arg, '='), StringUtils.split(StringUtils.afterPart(arg, '='), ','));
                        break;
                    }
                    case ADD_MODULES: {
                        ModuleConfig.this.setAddModules(StringUtils.split(arg, ','));
                        break;
                    }
                    case ADD_EXPORTS_PRIVATE: 
                    case ADD_OPENS: {
                        ModuleConfig.this.setAddOpens(StringUtils.beforePart(arg, '='), StringUtils.split(StringUtils.afterPart(arg, '='), ','));
                        break;
                    }
                    case ADD_READS: {
                        ModuleConfig.this.setAddReads(StringUtils.beforePart(arg, '='), StringUtils.split(StringUtils.afterPart(arg, '='), ','));
                        break;
                    }
                    case CLASS_PATH: {
                        ModuleConfig.this.setClassPath(new SearchPath(arg));
                        break;
                    }
                    case SOURCE_PATH: {
                        ModuleConfig.this.setSourcePath(new SearchPath(arg));
                        break;
                    }
                    case LIMIT_MODULES: {
                        ModuleConfig.this.setLimitModules(StringUtils.split(arg, ','));
                        break;
                    }
                    case MODULE_PATH: {
                        ModuleConfig.this.setModulePath(new SearchPath(arg));
                        break;
                    }
                    case PATCH_MODULE: {
                        ModuleConfig.this.setPatchPath(StringUtils.beforePart(arg, '='), new SearchPath(StringUtils.afterPart(arg, '=')));
                    }
                }
            }

            @Override
            protected void handleUnknown(String opt) {
            }
        };
        h.handleOptions(opts);
        return this;
    }

    ModuleConfig setAddModules(List<String> mods) {
        this.addMods = mods;
        return this;
    }

    ModuleConfig setLimitModules(List<String> mods) {
        this.limitMods = mods;
        return this;
    }

    ModuleConfig setAddExportsToUnnamed(Set<String> modules) {
        for (String module : modules) {
            if (!module.contains("/")) continue;
            this.setAddExports(module, Collections.singletonList("ALL-UNNAMED"));
        }
        return this;
    }

    ModuleConfig setAddOpensToUnnamed(Set<String> modules) {
        for (String module : modules) {
            if (!module.contains("/")) continue;
            this.setAddOpens(module, Collections.singletonList("ALL-UNNAMED"));
        }
        return this;
    }

    ModuleConfig setAddExports(String modulePackage, List<String> targetModules) {
        if (this.addExports == null) {
            this.addExports = new TreeMap<String, List<String>>();
        }
        this.addExports.put(modulePackage, targetModules);
        return this;
    }

    ModuleConfig setAddOpens(String modulePackage, List<String> targetModules) {
        if (this.addOpens == null) {
            this.addOpens = new TreeMap<String, List<String>>();
        }
        this.addOpens.put(modulePackage, targetModules);
        return this;
    }

    ModuleConfig setAddReads(String module, List<String> targetModules) {
        if (this.addReads == null) {
            this.addReads = new TreeMap<String, List<String>>();
        }
        this.addReads.put(module, targetModules);
        return this;
    }

    ModuleConfig setBootClassPathAppend(SearchPath bootClassPathAppend) {
        this.bootClassPathAppend = bootClassPathAppend;
        return this;
    }

    ModuleConfig setClassPath(SearchPath classPath) {
        this.classPath = classPath;
        return this;
    }

    ModuleConfig setSourcePath(SearchPath sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    ModuleConfig setModulePath(SearchPath modulePath) {
        this.modulePath = modulePath;
        return this;
    }

    ModuleConfig setPatchPath(String module, SearchPath patchPath) {
        if (this.patch == null) {
            this.patch = new TreeMap<String, SearchPath>();
        }
        this.patch.put(module, patchPath);
        return this;
    }

    void write(PrintWriter pw) {
        String label;
        Table table = new Table();
        if (this.addMods != null && !this.addMods.isEmpty()) {
            table.addRow("add modules:", StringUtils.join(this.addMods, " "));
        }
        if (this.limitMods != null && !this.limitMods.isEmpty()) {
            table.addRow("limit modules:", StringUtils.join(this.limitMods, " "));
        }
        if (this.addExports != null && !this.addExports.isEmpty()) {
            label = "add exports:";
            for (Map.Entry<String, List<String>> entry : this.addExports.entrySet()) {
                table.addRow(label, entry.getKey(), StringUtils.join((Collection)entry.getValue(), " "));
                label = "";
            }
        }
        if (this.addOpens != null && !this.addOpens.isEmpty()) {
            label = "add opens:";
            for (Map.Entry entry : this.addOpens.entrySet()) {
                table.addRow(label, (String)entry.getKey(), StringUtils.join((Collection)entry.getValue(), " "));
                label = "";
            }
        }
        if (this.addReads != null && !this.addReads.isEmpty()) {
            label = "add reads:";
            for (Map.Entry entry : this.addReads.entrySet()) {
                table.addRow(label, (String)entry.getKey(), StringUtils.join((Collection)entry.getValue(), " "));
                label = "";
            }
        }
        if (this.modulePath != null) {
            label = "module path:";
            for (Path path : this.modulePath.asList()) {
                table.addRow(label, path.toString());
                label = "";
            }
        }
        if (this.sourcePath != null) {
            label = "source path:";
            for (Path path : this.sourcePath.asList()) {
                table.addRow(label, path.toString());
                label = "";
            }
        }
        if (this.classPath != null) {
            label = "class path:";
            for (Path path : this.classPath.asList()) {
                table.addRow(label, path.toString());
                label = "";
            }
        }
        if (this.bootClassPathAppend != null) {
            label = "boot class path (append):";
            for (Path path : this.bootClassPathAppend.asList()) {
                table.addRow(label, path.toString());
                label = "";
            }
        }
        if (this.patch != null) {
            label = "patch:";
            for (Map.Entry entry : this.patch.entrySet()) {
                String module = (String)entry.getKey();
                for (Path file : ((SearchPath)entry.getValue()).asList()) {
                    table.addRow(label, module, file.toString());
                    label = "";
                    module = "";
                }
            }
        }
        if (table.rows.isEmpty()) {
            return;
        }
        pw.println(this.title);
        table.write(pw, 2);
        pw.println();
    }

    private static class Table {
        List<List<String>> rows = new ArrayList<List<String>>();

        private Table() {
        }

        void addRow(String ... items) {
            this.rows.add(List.of(items));
        }

        void write(PrintWriter pw, int indent) {
            int col;
            int maxCols = 0;
            for (List<String> row : this.rows) {
                maxCols = Math.max(maxCols, row.size());
            }
            int[] widths = new int[maxCols];
            for (List<String> row : this.rows) {
                col = 0;
                for (String item : row) {
                    if (col < row.size() - 1) {
                        widths[col] = Math.max(widths[col], item.length());
                    }
                    ++col;
                }
            }
            for (List<String> row : this.rows) {
                this.space(pw, indent);
                col = 0;
                for (String item : row) {
                    if (item == null) {
                        this.space(pw, widths[col]);
                    } else {
                        pw.write(item);
                        this.space(pw, widths[col] - item.length());
                    }
                    if (widths[col] > 0) {
                        pw.write(" ");
                    }
                    ++col;
                }
                pw.println();
            }
        }

        private void space(PrintWriter pw, int spaces) {
            for (int i = 0; i < spaces; ++i) {
                pw.print(" ");
            }
        }
    }
}

