/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.ExtraPropDefns;
import com.sun.javatest.regtest.config.RegressionKeywords;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.StringUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TestProperties {
    private final TestFinder.ErrorHandler errHandler;
    private final Cache cache;
    final boolean checkBugID;
    final Set<String> validKeys;
    final ExecMode defaultExecMode;
    final List<String> groupFiles;
    final Version requiredVersion;
    final ExtraPropDefns extraPropDefns;
    private static final boolean allowLocalKeys = Boolean.parseBoolean(System.getProperty("javatest.regtest.allowLocalKeys", "true"));
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionTestSuite.class);

    TestProperties(File rootDir, TestFinder.ErrorHandler errHandler) {
        this.errHandler = errHandler;
        this.cache = new Cache(this.canon(rootDir));
        Cache.Entry e = this.cache.getEntry(this.cache.rootDir);
        this.validKeys = e.validKeys;
        String bug = e.properties.getProperty("checkBugID");
        this.checkBugID = bug == null || !bug.trim().equals("false");
        String mode = e.properties.getProperty("defaultExecMode");
        this.defaultExecMode = ExecMode.fromString(mode);
        String gf = e.properties.getProperty("groups");
        this.groupFiles = gf == null ? Collections.emptyList() : List.of(gf.split("\\s+"));
        String version = e.properties.getProperty("requiredVersion");
        this.requiredVersion = new Version(version);
        String epd = e.properties.getProperty("requires.extraPropDefns");
        this.extraPropDefns = epd == null ? new ExtraPropDefns() : new ExtraPropDefns(epd, e.properties.getProperty("requires.extraPropDefns.libs"), e.properties.getProperty("requires.extraPropDefns.bootlibs"), e.properties.getProperty("requires.extraPropDefns.javacOpts"), e.properties.getProperty("requires.extraPropDefns.vmOpts"));
    }

    Set<String> getValidKeys(File file) throws TestSuite.Fault {
        if (!allowLocalKeys) {
            return this.validKeys;
        }
        return this.getEntry((File)file).validKeys;
    }

    Set<String> getValidRequiresProperties(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).validRequiresProperties;
    }

    ExecMode getDefaultExecMode() {
        return this.defaultExecMode;
    }

    List<String> getGroupFiles() {
        return this.groupFiles;
    }

    boolean useBootClassPath(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).useBootClassPath;
    }

    boolean useOtherVM(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).useOtherVM;
    }

    boolean isTestNG(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).testNGRoot != null;
    }

    File getTestNGRoot(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).testNGRoot;
    }

    boolean isJUnit(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).junitRoot != null;
    }

    File getJUnitRoot(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).junitRoot;
    }

    boolean needsExclusiveAccess(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).needsExclusiveAccess;
    }

    Set<String> getLibDirs(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).libDirs;
    }

    Set<String> getLibBuildArgs(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).libBuildArgs;
    }

    Set<String> getModules(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).modules;
    }

    Version getRequiredVersion() {
        return this.requiredVersion;
    }

    Set<File> getExternalLibs(File file) throws TestSuite.Fault {
        return this.getEntry((File)file).extLibRoots;
    }

    ExtraPropDefns getExtraPropDefns() {
        return this.extraPropDefns;
    }

    int getMaxOutputSize(File file) {
        return this.getEntry((File)file).maxOutputSize;
    }

    boolean getAllowSmartActionArgs(File file) {
        return this.getEntry((File)file).allowSmartActionArgs;
    }

    boolean getEnablePreview(File file) {
        return this.getEntry((File)file).enablePreview;
    }

    private Cache.Entry getEntry(File file) {
        File dir = file.isDirectory() ? file : file.getParentFile();
        return this.cache.getEntry(dir);
    }

    private void error(I18NResourceBundle i18n, String key, Object ... args) {
        this.errHandler.error(i18n.getString(key, args));
    }

    private File canon(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return new File(f.getAbsoluteFile().toURI().normalize());
        }
    }

    class Cache {
        Map<File, SoftReference<Entry>> map;
        Entry lastUsedEntry;
        File rootDir;

        Cache(File rootDir) {
            this.rootDir = rootDir;
            this.map = new HashMap<File, SoftReference<Entry>>();
        }

        synchronized Entry getEntry(File dir) {
            if (this.lastUsedEntry == null || !this.lastUsedEntry.dir.equals(dir)) {
                this.lastUsedEntry = this.getEntryInternal(dir);
            }
            return this.lastUsedEntry;
        }

        private Entry getEntryInternal(File dir) {
            Entry e;
            SoftReference<Entry> ref = this.map.get(dir);
            Entry entry = e = ref == null ? null : ref.get();
            if (e == null) {
                Entry parent = dir.equals(this.rootDir) ? null : this.getEntryInternal(dir.getParentFile());
                e = new Entry(parent, dir);
                this.map.put(dir, new SoftReference<Entry>(e));
            }
            return e;
        }

        class Entry {
            final Entry parent;
            final File dir;
            final Properties properties;
            final Set<String> validKeys;
            final Set<String> validRequiresProperties;
            final boolean useBootClassPath;
            private final Set<File> bootClassPathDirs;
            final boolean useOtherVM;
            private final Set<File> otherVMDirs;
            final boolean needsExclusiveAccess;
            private final Set<File> exclusiveAccessDirs;
            final File testNGRoot;
            private final Set<File> testNGDirs;
            final File junitRoot;
            private final Set<File> junitDirs;
            final Set<String> libDirs;
            final Set<String> libBuildArgs;
            final Set<File> extLibRoots;
            final Set<String> modules;
            final int maxOutputSize;
            final boolean allowSmartActionArgs;
            final boolean enablePreview;

            Entry(Entry parent, File dir) {
                this.parent = parent;
                this.dir = dir;
                File file = new File(dir, parent == null ? "TEST.ROOT" : "TEST.properties");
                if (file.canRead()) {
                    this.properties = parent == null ? new Properties() : new Properties(parent.properties);
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                        this.properties.load(in);
                    }
                    catch (IOException e) {
                        TestProperties.this.error(i18n, "props.cantRead", file);
                    }
                    this.validKeys = this.initKeywordSet(parent == null ? null : parent.validKeys, "keys");
                    this.validRequiresProperties = this.initSimpleSet(parent == null ? null : parent.validRequiresProperties, "requires.properties");
                    this.bootClassPathDirs = this.initFileSet(parent == null ? null : parent.bootClassPathDirs, "bootclasspath.dirs", dir);
                    this.otherVMDirs = this.initFileSet(parent == null ? null : parent.otherVMDirs, "othervm.dirs", dir);
                    this.exclusiveAccessDirs = this.initFileSet(parent == null ? null : parent.exclusiveAccessDirs, "exclusiveAccess.dirs", dir);
                    this.testNGDirs = this.initFileSet(parent == null ? null : parent.testNGDirs, "TestNG.dirs", dir);
                    this.junitDirs = this.initFileSet(parent == null ? null : parent.junitDirs, "JUnit.dirs", dir);
                    this.libDirs = this.initLibDirSet(parent == null ? null : parent.libDirs, "lib.dirs", dir);
                    this.libBuildArgs = this.initSimpleSet(parent == null ? null : parent.libBuildArgs, "lib.build");
                    this.extLibRoots = this.initFileSet(parent == null ? null : parent.extLibRoots, "external.lib.roots", dir);
                    this.modules = this.initSimpleSet(parent == null ? null : parent.modules, "modules");
                    this.maxOutputSize = this.getInt("maxOutputSize", -1);
                    this.allowSmartActionArgs = this.initAllowSmartActionArgs(parent);
                    this.enablePreview = this.initEnablePreview(parent);
                } else {
                    if (parent == null) {
                        throw new IllegalStateException("TEST.ROOT not found");
                    }
                    this.properties = parent.properties;
                    this.validKeys = parent.validKeys;
                    this.validRequiresProperties = parent.validRequiresProperties;
                    this.bootClassPathDirs = parent.bootClassPathDirs;
                    this.otherVMDirs = parent.otherVMDirs;
                    this.exclusiveAccessDirs = parent.exclusiveAccessDirs;
                    this.testNGDirs = parent.testNGDirs;
                    this.junitDirs = parent.junitDirs;
                    this.libDirs = parent.libDirs;
                    this.libBuildArgs = parent.libBuildArgs;
                    this.extLibRoots = parent.extLibRoots;
                    this.modules = parent.modules;
                    this.maxOutputSize = parent.maxOutputSize;
                    this.allowSmartActionArgs = parent.allowSmartActionArgs;
                    this.enablePreview = parent.enablePreview;
                }
                this.useBootClassPath = this.initUseBootClassPath(parent, dir);
                this.useOtherVM = this.initUseOtherVM(parent, dir);
                this.needsExclusiveAccess = this.initNeedsExclusiveAccess(parent, dir);
                this.testNGRoot = this.initTestNGRoot(parent, dir);
                this.junitRoot = this.initJUnitRoot(parent, dir);
            }

            private int getInt(String propertyName, int defaultValue) {
                String v = this.properties.getProperty(propertyName);
                try {
                    if (v != null) {
                        return Integer.parseInt(v.trim());
                    }
                }
                catch (NumberFormatException e) {
                    TestProperties.this.error(i18n, "props.bad.value", propertyName, v);
                }
                return defaultValue;
            }

            private Set<File> initFileSet(Set<File> parent, String propertyName, File baseDir) {
                String[] values = StringUtils.splitWS(this.properties.getProperty(propertyName));
                if (parent == null || values.length > 0) {
                    LinkedHashSet<File> set = parent == null ? new LinkedHashSet<File>() : new LinkedHashSet<File>(parent);
                    for (String v : values) {
                        File f = this.toFile(baseDir, v);
                        if (f == null) continue;
                        set.add(f);
                    }
                    return Collections.unmodifiableSet(set);
                }
                return parent;
            }

            private Set<String> initLibDirSet(Set<String> parent, String propertyName, File baseDir) {
                String[] values = StringUtils.splitWS(this.properties.getProperty(propertyName));
                if (parent == null || values.length > 0) {
                    LinkedHashSet<Object> set = parent == null ? new LinkedHashSet<Object>() : new LinkedHashSet<String>(parent);
                    for (String v : values) {
                        if (v.startsWith("/")) {
                            set.add(v);
                            continue;
                        }
                        File f = this.toFile(baseDir, v);
                        if (f == null) continue;
                        set.add("/" + Cache.this.rootDir.toPath().relativize(f.toPath()).toString().replace(File.separatorChar, '/'));
                    }
                    return Collections.unmodifiableSet(set);
                }
                return parent;
            }

            private Set<String> initKeywordSet(Set<String> parent, String propertyName) {
                String[] values = StringUtils.splitWS(this.properties.getProperty(propertyName));
                if (parent == null || values.length > 0) {
                    LinkedHashSet<String> set = parent == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(parent);
                    for (String v : values) {
                        try {
                            RegressionKeywords.validateKey(v);
                            set.add(v.replace("-", "_"));
                        }
                        catch (RegressionKeywords.Fault e) {
                            File file = new File(this.dir, parent == null ? "TEST.ROOT" : "TEST.properties");
                            TestProperties.this.error(i18n, "props.bad.keyword", file, v, e.getMessage());
                        }
                    }
                    return Collections.unmodifiableSet(set);
                }
                return parent;
            }

            private Set<String> initSimpleSet(Set<String> parent, String propertyName) {
                String[] values = StringUtils.splitWS(this.properties.getProperty(propertyName));
                if (parent == null || values.length > 0) {
                    LinkedHashSet<String> set = parent == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(parent);
                    set.addAll(List.of(values));
                    return Collections.unmodifiableSet(set);
                }
                return parent;
            }

            private boolean initUseBootClassPath(Entry parent, File dir) {
                if (parent == null) {
                    return false;
                }
                if (parent.useBootClassPath) {
                    return true;
                }
                for (File bootClassPathDir : this.bootClassPathDirs) {
                    if (!this.includes(bootClassPathDir, dir)) continue;
                    return true;
                }
                return false;
            }

            private boolean initUseOtherVM(Entry parent, File dir) {
                if (parent == null) {
                    return false;
                }
                if (parent.useOtherVM) {
                    return true;
                }
                for (File otherVMDir : this.otherVMDirs) {
                    if (!this.includes(otherVMDir, dir)) continue;
                    return true;
                }
                return false;
            }

            private boolean initNeedsExclusiveAccess(Entry parent, File dir) {
                if (parent == null) {
                    return false;
                }
                if (parent.needsExclusiveAccess) {
                    return true;
                }
                for (File exclusiveAccessDir : this.exclusiveAccessDirs) {
                    if (!this.includes(exclusiveAccessDir, dir)) continue;
                    return true;
                }
                return false;
            }

            private File initTestNGRoot(Entry parent, File dir) {
                if (parent == null) {
                    return null;
                }
                if (parent.testNGRoot != null) {
                    return parent.testNGRoot;
                }
                for (File testNGDir : this.testNGDirs) {
                    if (!this.includes(testNGDir, dir)) continue;
                    return testNGDir;
                }
                return null;
            }

            private File initJUnitRoot(Entry parent, File dir) {
                if (parent == null) {
                    return null;
                }
                if (parent.junitRoot != null) {
                    return parent.junitRoot;
                }
                for (File junitDir : this.junitDirs) {
                    if (!this.includes(junitDir, dir)) continue;
                    return junitDir;
                }
                return null;
            }

            private boolean includes(File dir, File file) {
                while (file != null) {
                    if (dir.equals(file)) {
                        return true;
                    }
                    file = file.getParentFile();
                }
                return false;
            }

            private boolean initAllowSmartActionArgs(Entry parent) {
                if (this.properties.containsKey("allowSmartActionArgs")) {
                    return this.properties.getProperty("allowSmartActionArgs").equals("true");
                }
                if (parent != null) {
                    return parent.allowSmartActionArgs;
                }
                String rv = this.properties.getProperty("requiredVersion");
                if (rv != null) {
                    return new Version(rv).compareTo(new Version("4.2 b14")) >= 0;
                }
                return false;
            }

            private boolean initEnablePreview(Entry parent) {
                if (this.properties.containsKey("enablePreview")) {
                    return this.properties.getProperty("enablePreview").equals("true");
                }
                if (parent != null) {
                    return parent.enablePreview;
                }
                return false;
            }

            private File toFile(File baseDir, String v) {
                if (v.startsWith("/")) {
                    File f = new File(Cache.this.rootDir, v.substring(1));
                    if (f.exists()) {
                        return new File(f.toURI().normalize());
                    }
                } else {
                    File f = new File(baseDir, v);
                    if (f.exists()) {
                        return new File(f.toURI().normalize());
                    }
                    f = new File(Cache.this.rootDir, v);
                    if (f.exists()) {
                        return new File(f.toURI().normalize());
                    }
                }
                return null;
            }
        }
    }
}

