/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.interview.Interview;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.ExtraPropDefns;
import com.sun.javatest.regtest.config.GroupManager;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestFinder;
import com.sun.javatest.regtest.config.TestProperties;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.tool.RegressionContextManager;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class RegressionTestSuite
extends TestSuite {
    static Map<File, SoftReference<RegressionTestSuite>> cache;
    private static ParametersFactory factory;
    private final TestFinder.ErrorHandler errHandler;
    private final TestProperties properties;
    private static final I18NResourceBundle i18n;

    public static RegressionTestSuite open(File testSuiteRoot, TestFinder.ErrorHandler errHandler) throws TestSuite.Fault {
        SoftReference<RegressionTestSuite> ref;
        RegressionTestSuite ts;
        if (cache == null) {
            cache = new HashMap<File, SoftReference<RegressionTestSuite>>();
        }
        RegressionTestSuite regressionTestSuite = ts = (ref = cache.get(testSuiteRoot)) == null ? null : ref.get();
        if (ts == null) {
            ts = new RegressionTestSuite(testSuiteRoot, errHandler);
            cache.put(testSuiteRoot, new SoftReference<RegressionTestSuite>(ts));
        }
        return ts;
    }

    public RegressionTestSuite(File testSuiteRoot, TestFinder.ErrorHandler errHandler) throws TestSuite.Fault {
        super(testSuiteRoot, RegressionTestSuite.createTSInfo(), RegressionTestSuite.class.getClassLoader());
        this.properties = new TestProperties(this.getRootDir(), errHandler);
        this.errHandler = errHandler;
        this.setTestFinder(this.createTestFinder());
    }

    private static Map<String, String> createTSInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tmcontext", RegressionContextManager.class.getName());
        return map;
    }

    @Override
    public String getName() {
        return this.getPath();
    }

    @Override
    protected TestFinder createTestFinder() throws TestSuite.Fault {
        try {
            RegressionTestFinder f = new RegressionTestFinder(this.properties, this.errHandler);
            f.init(new String[0], this.getRoot(), null);
            return f;
        }
        catch (TestFinder.Fault e) {
            throw new Error();
        }
    }

    @Override
    public boolean getTestRefreshBehavior(int event) {
        switch (event) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return super.getTestRefreshBehavior(event);
    }

    @Override
    public Script createScript(TestDescription td, String[] exclTestCases, TestEnvironment scriptEnv, WorkDirectory workDir, BackupPolicy backupPolicy) throws TestSuite.Fault {
        RegressionScript s = new RegressionScript();
        s.initTestDescription(td);
        s.initExcludedTestCases(exclTestCases);
        s.initTestEnvironment(scriptEnv);
        s.initWorkDir(workDir);
        s.initBackupPolicy(backupPolicy);
        s.initClassLoader(this.getClassLoader());
        return s;
    }

    public static void setParametersFactory(ParametersFactory factory) {
        RegressionTestSuite.factory = factory;
    }

    @Override
    public RegressionParameters createInterview() throws TestSuite.Fault {
        try {
            return factory != null ? factory.create(this) : new RegressionParameters("regtest", this, System.err::println);
        }
        catch (Interview.Fault e) {
            throw new TestSuite.Fault(i18n, "suite.cantCreateInterview", (Object)e.getMessage());
        }
    }

    @Override
    public URL[] getFilesForTest(TestDescription td) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        try {
            urls.add(td.getFile().toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            RegressionParameters params = this.createInterview();
            Set<File> files = RegressionScript.getSourceFiles(params, td);
            for (File file : files) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (TestSuite.Fault fault) {
            // empty catch block
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public GroupManager getGroupManager(PrintWriter out) throws IOException {
        GroupManager g = new GroupManager(out, this.getRootDir().toPath(), this.properties.getGroupFiles());
        RegressionTestFinder tf = (RegressionTestFinder)this.getTestFinder();
        g.setAllowedExtensions(tf.getAllowedExtensions());
        g.setIgnoredDirectories(tf.getIgnoredDirectories());
        return g;
    }

    @Override
    public boolean needServices() {
        return false;
    }

    public ExecMode getDefaultExecMode() {
        return this.properties.getDefaultExecMode();
    }

    public boolean useBootClassPath(String rootRelativePath) throws TestSuite.Fault {
        return this.properties.useBootClassPath(new File(this.getRootDir(), rootRelativePath));
    }

    public boolean useOtherVM(TestDescription td) throws TestSuite.Fault {
        return this.properties.useOtherVM(td.getFile());
    }

    public boolean needsExclusiveAccess(TestDescription td) throws TestSuite.Fault {
        return this.properties.needsExclusiveAccess(td.getFile());
    }

    public Version getRequiredVersion() {
        return this.properties.getRequiredVersion();
    }

    public Set<String> getLibDirs(TestDescription td) throws TestSuite.Fault {
        return this.properties.getLibDirs(td.getFile());
    }

    public Set<String> getLibBuildArgs(TestDescription td) throws TestSuite.Fault {
        return this.properties.getLibBuildArgs(td.getFile());
    }

    public Set<File> getExternalLibRoots(TestDescription td) throws TestSuite.Fault {
        return this.properties.getExternalLibs(td.getFile());
    }

    public Set<String> getDefaultModules(TestDescription td) throws TestSuite.Fault {
        return this.properties.getModules(td.getFile());
    }

    public ExtraPropDefns getExtraPropDefns() {
        return this.properties.getExtraPropDefns();
    }

    public int getMaxOutputSize(TestDescription td) throws TestSuite.Fault {
        return this.properties.getMaxOutputSize(td.getFile());
    }

    public boolean getAllowSmartActionArgs(TestDescription td) throws TestSuite.Fault {
        return this.properties.getAllowSmartActionArgs(td.getFile());
    }

    public boolean getEnablePreview(TestDescription td) throws TestSuite.Fault {
        return this.properties.getEnablePreview(td.getFile());
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(RegressionTestSuite.class);
    }

    public static interface ParametersFactory {
        public RegressionParameters create(RegressionTestSuite var1) throws TestSuite.Fault;
    }
}

