/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.CachingTestFilter;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.IgnoreKind;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.RegressionContext;
import com.sun.javatest.regtest.config.RegressionEnvironment;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.exec.TimeoutHandlerProvider;
import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.regtest.util.StringUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RegressionParameters
extends BasicInterviewParameters
implements Parameters.EnvParameters {
    private final Consumer<String> logger;
    public Map<String, String> filterFaults = new HashMap<String, String>();
    private Expr.Context exprContext;
    TestFilter relevantTestFilter = UNSET;
    private CachingTestFilter excludeListFilter = UNSET;
    private TestFilter matchListFilter = UNSET;
    private KeywordsTestFilter keywordsFilter = UNSET_KEYWORDS_FILTER;
    private static final CachingTestFilter UNSET = new CachingTestFilter("", "", ""){

        @Override
        public String getCacheKey(TestDescription td) {
            throw new IllegalStateException();
        }

        @Override
        public boolean getCacheableValue(TestDescription td) {
            throw new IllegalStateException();
        }
    };
    private static final KeywordsTestFilter UNSET_KEYWORDS_FILTER = new KeywordsTestFilter(UNSET);
    private CachingTestFilter priorStatusFilter = UNSET;
    private static final String ENVVARS = ".envVars";
    private static final String CHECK = ".check";
    private static final String COMPILE_JDK = ".compilejdk";
    private static final String TEST_JDK = ".testjdk";
    private static final String EXEC_MODE = ".execMode";
    private static final String TEST_VM_OPTIONS = ".testVMOpts";
    private static final String TEST_COMPILER_OPTIONS = ".testCompilerOpts";
    private static final String TEST_JAVA_OPTIONS = ".testJavaOpts";
    private static final String IGNORE = ".ignore";
    private static final String RETAIN_ARGS = ".retain";
    private static final String JUNIT = ".junit";
    private static final String TESTNG = ".testng";
    private static final String ASMTOOLS = ".asmtools";
    private static final String TIMELIMIT = ".timeLimit";
    private static final String REPORTDIR = ".reportDir";
    private static final String EXCLUSIVE_LOCK = ".exclLock";
    private static final String NATIVEDIR = ".nativeDir";
    private static final String TIMEOUT_HANDLER = ".timeoutHandler";
    private static final String TIMEOUT_HANDLER_PATH = ".timeoutHandlerPath";
    private static final String TIMEOUT_HANDLER_TIMEOUT = ".timeoutHandlerTimeout";
    private static final String CUSTOM_TEST_THREAD_FACTORY = ".testThreadFactory";
    private static final String CUSTOM_TEST_THREAD_FACTORY_PATH = ".testThreadFactoryPath";
    private static final String TEST_QUERIES = ".testQueries";
    private Map<String, String> envVars;
    private boolean check;
    ExecMode execMode;
    IgnoreKind ignoreKind = IgnoreKind.ERROR;
    int timeLimit;
    private JDK compileJDK;
    private JDK testJDK;
    private SearchPath junitPath;
    private SearchPath testngPath;
    private SearchPath asmToolsPath;
    private SearchPath javaTestClassPath;
    private List<String> testVMOpts;
    private List<String> testCompilerOpts;
    private List<String> testJavaOpts;
    private List<String> testDebugOpts;
    private Path reportDir;
    private Path exclusiveLock;
    private Path nativeDir;
    private String timeoutHandlerClassName;
    private List<Path> timeoutHandlerPath;
    private long timeoutHandlerTimeout;
    private String testThreadFactory;
    private String testThreadFactoryPath;
    private List<Path> matchLists;
    private boolean useWindowsSubsystemForLinux;
    private List<String> testQueries;
    private static final Pattern UNSET_PATTERN = Pattern.compile("");
    private Pattern refIgnoreLinesPattern = UNSET_PATTERN;
    private TimeoutHandlerProvider timeoutHandlerProvider;
    private Map<String, String> basicTestProperties;
    private List<String> retainArgs;
    private final Set<Integer> retainStatusSet = new HashSet<Integer>(4);
    private Pattern retainFilesPattern;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionParameters.class);

    public RegressionParameters(String tag, RegressionTestSuite testSuite, Consumer<String> logger) throws Interview.Fault {
        super(tag, testSuite);
        this.logger = logger;
        this.setTitle("jtreg Configuration Editor");
        this.setEdited(false);
    }

    @Override
    public RegressionTestSuite getTestSuite() {
        return (RegressionTestSuite)super.getTestSuite();
    }

    public void setTests(Collection<String> tests) {
        this.setTests(tests == null ? null : tests.toArray(new String[0]));
    }

    public void setTests(String[] tests) {
        Parameters.MutableTestsParameters mtp = (Parameters.MutableTestsParameters)this.getTestsParameters();
        mtp.setTests(tests);
    }

    public void setKeywordsExpr(String expr) {
        Parameters.MutableKeywordsParameters mkp = (Parameters.MutableKeywordsParameters)this.getKeywordsParameters();
        mkp.setKeywords(3, expr);
    }

    @Override
    protected int getMaxConcurrency() {
        return 256;
    }

    public void setConcurrency(int conc) {
        Parameters.MutableConcurrencyParameters mcp = (Parameters.MutableConcurrencyParameters)this.getConcurrencyParameters();
        mcp.setConcurrency(conc);
    }

    public void setTimeoutFactor(float tfac) {
        Parameters.MutableTimeoutFactorParameters mtfp = (Parameters.MutableTimeoutFactorParameters)this.getTimeoutFactorParameters();
        mtfp.setTimeoutFactor(tfac);
    }

    public void setExcludeLists(Path[] files) {
        Parameters.MutableExcludeListParameters mep = (Parameters.MutableExcludeListParameters)this.getExcludeListParameters();
        mep.setExcludeFiles(FileUtils.toFiles(files));
    }

    public void setPriorStatusValues(boolean[] b) {
        Parameters.MutablePriorStatusParameters mpsp = (Parameters.MutablePriorStatusParameters)this.getPriorStatusParameters();
        mpsp.setPriorStatusValues(b);
    }

    @Override
    public TestEnvironment getEnv() {
        try {
            return new RegressionEnvironment(this);
        }
        catch (TestEnvironment.Fault e) {
            return null;
        }
    }

    @Override
    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    @Override
    protected Question getEnvFirstQuestion() {
        return this.getEnvSuccessorQuestion();
    }

    public void initExprContext() throws JDK.Fault {
        this.exprContext = new RegressionContext(this, this.logger);
    }

    public Expr.Context getExprContext() {
        return this.exprContext;
    }

    @Override
    public TestFilter getRelevantTestFilter() {
        if (this.relevantTestFilter == UNSET) {
            TestFilter mlf;
            ArrayList<TestFilter> filters = new ArrayList<TestFilter>();
            TestFilter mf = this.getModulesFilter();
            if (mf != null) {
                filters.add(mf);
            }
            TestFilter rf = this.getRequiresFilter();
            filters.add(rf);
            TestFilter tlf = this.getTimeLimitFilter();
            if (tlf != null) {
                filters.add(tlf);
            }
            if ((mlf = this.getMatchListFilter()) != null) {
                filters.add(mlf);
            }
            final CompositeFilter f = new CompositeFilter(filters.toArray(new TestFilter[0]));
            return new CachingTestFilter(((TestFilter)f).getName(), ((TestFilter)f).getDescription(), ((TestFilter)f).getReason()){

                @Override
                protected String getCacheKey(TestDescription td) {
                    return td.getRootRelativeURL();
                }

                @Override
                protected boolean getCacheableValue(TestDescription td) throws TestFilter.Fault {
                    return f.accepts(td);
                }
            };
        }
        return this.relevantTestFilter;
    }

    TestFilter getModulesFilter() {
        JDK jdk = this.getTestJDK();
        if (jdk == null || jdk.getVersion(this, this.logger).compareTo(JDK_Version.V9) < 0) {
            return null;
        }
        final Set<String> availModules = jdk.getSystemModules(this, this.logger);
        if (availModules.isEmpty()) {
            return null;
        }
        return new CachingTestFilter("ModulesFilter", "Select tests for which all required modules are available", "A required module is not available"){
            private static final String MODULES = "modules";

            @Override
            protected String getCacheKey(TestDescription td) {
                return td.getParameter(MODULES);
            }

            @Override
            public boolean getCacheableValue(TestDescription td) {
                String reqdModules = td.getParameter(MODULES);
                if (reqdModules == null) {
                    return true;
                }
                for (String m : reqdModules.split(" ")) {
                    String name;
                    if (m.length() == 0) continue;
                    int slash = m.indexOf("/");
                    String string = name = slash == -1 ? m : m.substring(0, slash);
                    if (availModules.contains(name)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    TestFilter getRequiresFilter() {
        return new CachingTestFilter("RequiresFilter", "Select tests that satisfy a given set of platform requirements", "The platform does not meet the specified requirements"){
            private static final String REQUIRES = "requires";

            @Override
            protected String getCacheKey(TestDescription td) {
                return td.getParameter(REQUIRES);
            }

            @Override
            public boolean getCacheableValue(TestDescription td) {
                try {
                    String requires = td.getParameter(REQUIRES);
                    if (requires == null) {
                        return true;
                    }
                    return Expr.parse(requires, RegressionParameters.this.exprContext).evalBoolean(RegressionParameters.this.exprContext);
                }
                catch (Expr.Fault ex) {
                    RegressionParameters.this.filterFaults.put(td.getRootRelativeURL(), "Error evaluating expression: " + ex.getMessage());
                    return true;
                }
            }
        };
    }

    TestFilter getTimeLimitFilter() {
        if (this.timeLimit <= 0) {
            return null;
        }
        return new CachingTestFilter("TestLimitFilter", "Select tests that do not exceed a specified timeout value", "Test declares a timeout which exceeds the requested time limit"){
            final String MAX_TIMEOUT = "maxTimeout";
            {
                this.MAX_TIMEOUT = "maxTimeout";
            }

            @Override
            protected String getCacheKey(TestDescription td) {
                return td.getParameter("maxTimeout");
            }

            @Override
            public boolean getCacheableValue(TestDescription td) {
                String maxTimeoutValue = td.getParameter("maxTimeout");
                if (maxTimeoutValue != null) {
                    try {
                        int maxTimeout = Integer.parseInt(maxTimeoutValue);
                        if (maxTimeout == 0 || maxTimeout > RegressionParameters.this.timeLimit) {
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
    }

    @Override
    public CachingTestFilter getExcludeListFilter() {
        if (this.excludeListFilter == UNSET) {
            final ExcludeList el = this.getExcludeList();
            this.excludeListFilter = el == null ? null : new CachingTestFilter("jtregExcludeListFilter", "Select tests which are not excluded on any exclude list", "Test has been excluded by an exclude list"){
                final TestListWithPlatforms list;
                {
                    super(name, description, reason);
                    this.list = new TestListWithPlatforms(el, RegressionParameters.this.getTestOS());
                }

                @Override
                protected String getCacheKey(TestDescription td) {
                    return td.getRootRelativeURL();
                }

                @Override
                public boolean getCacheableValue(TestDescription td) {
                    return !this.list.match(td);
                }
            };
        }
        return this.excludeListFilter;
    }

    private TestFilter getMatchListFilter() {
        if (this.matchListFilter == UNSET) {
            List<Path> matchList = this.getMatchLists();
            if (matchList.isEmpty()) {
                this.matchListFilter = null;
            } else {
                ExcludeList el;
                try {
                    el = new ExcludeList((File[])matchList.stream().map(Path::toFile).toArray(File[]::new));
                }
                catch (ExcludeList.Fault | IOException e) {
                    throw new Error(e);
                }
                this.matchListFilter = new CachingTestFilter("jtregMatchListFilter", "Select tests which are in a match list", "Test has not been matched by a match list"){
                    final TestListWithPlatforms list;
                    {
                        super(name, description, reason);
                        this.list = new TestListWithPlatforms(el, RegressionParameters.this.getTestOS());
                    }

                    @Override
                    protected String getCacheKey(TestDescription td) {
                        return td.getRootRelativeURL();
                    }

                    @Override
                    public boolean getCacheableValue(TestDescription td) {
                        return this.list.match(td);
                    }
                };
            }
        }
        return this.matchListFilter;
    }

    @Override
    public KeywordsTestFilter getKeywordsFilter() {
        if (this.keywordsFilter == UNSET_KEYWORDS_FILTER) {
            TestFilter f = super.getKeywordsFilter();
            this.keywordsFilter = f == null ? null : new KeywordsTestFilter(f);
        }
        return this.keywordsFilter;
    }

    @Override
    public TestFilter getPriorStatusFilter() {
        if (this.priorStatusFilter == UNSET) {
            final TestFilter psf = super.getPriorStatusFilter();
            this.priorStatusFilter = psf == null ? null : new CachingTestFilter("jtregPriorStatusFilter", "Select tests which match a specified status", "Test did not match a specified status"){

                @Override
                protected String getCacheKey(TestDescription td) {
                    return td.getRootRelativeURL();
                }

                @Override
                public boolean getCacheableValue(TestDescription td) throws TestFilter.Fault {
                    return psf.accepts(td);
                }
            };
        }
        return this.priorStatusFilter;
    }

    @Override
    public void load(Map<String, String> data, boolean checkChecksum) throws Interview.Fault {
        super.load(data, checkChecksum);
        String prefix = this.getTag();
        try {
            String v = data.get(prefix + ENVVARS);
            if (v != null) {
                this.setEnvVars(this.deserializeEnv(v, "\n"));
            }
            if ((v = data.get(prefix + CHECK)) != null) {
                this.setCheck(v.equals("true"));
            }
            if ((v = data.get(prefix + EXEC_MODE)) != null) {
                this.setExecMode(ExecMode.valueOf(v));
            }
            if ((v = data.get(prefix + IGNORE)) != null) {
                this.setIgnoreKind(IgnoreKind.valueOf(v));
            }
            if ((v = data.get(prefix + COMPILE_JDK)) != null) {
                this.setCompileJDK(JDK.of(v));
            }
            if ((v = data.get(prefix + TEST_JDK)) != null) {
                this.setTestJDK(JDK.of(v));
            }
            if ((v = data.get(prefix + TEST_VM_OPTIONS)) != null && v.length() > 0) {
                this.setTestVMOptions(List.of(StringUtils.splitSeparator("\n", v)));
            }
            if ((v = data.get(prefix + TEST_COMPILER_OPTIONS)) != null && v.length() > 0) {
                this.setTestCompilerOptions(List.of(StringUtils.splitSeparator("\n", v)));
            }
            if ((v = data.get(prefix + TEST_JAVA_OPTIONS)) != null && v.length() > 0) {
                this.setTestJavaOptions(List.of(StringUtils.splitSeparator("\n", v)));
            }
            if ((v = data.get(prefix + RETAIN_ARGS)) != null && v.length() > 0) {
                this.setRetainArgs(List.of(StringUtils.splitSeparator("\n", v)));
            }
            if ((v = data.get(prefix + JUNIT)) != null) {
                this.setJUnitPath(new SearchPath(v));
            }
            if ((v = data.get(prefix + TESTNG)) != null) {
                this.setTestNGPath(new SearchPath(v));
            }
            if ((v = data.get(prefix + ASMTOOLS)) != null) {
                this.setAsmToolsPath(new SearchPath(v));
            }
            if ((v = data.get(prefix + TIMELIMIT)) != null) {
                this.setTimeLimit(Integer.parseInt(v));
            }
            if ((v = data.get(prefix + REPORTDIR)) != null) {
                this.setReportDir(Path.of(v, new String[0]));
            }
            if ((v = data.get(prefix + EXCLUSIVE_LOCK)) != null) {
                this.setExclusiveLock(Path.of(v, new String[0]));
            }
            if ((v = data.get(prefix + NATIVEDIR)) != null) {
                this.setNativeDir(Path.of(v, new String[0]));
            }
            if ((v = data.get(prefix + TIMEOUT_HANDLER)) != null) {
                this.setTimeoutHandler(v);
            }
            if ((v = data.get(prefix + TIMEOUT_HANDLER_PATH)) != null) {
                this.setTimeoutHandlerPath(v);
            }
            if ((v = data.get(prefix + TIMEOUT_HANDLER_TIMEOUT)) != null) {
                this.setTimeoutHandlerTimeout(v);
            }
            if ((v = data.get(prefix + CUSTOM_TEST_THREAD_FACTORY)) != null) {
                this.setTestThreadFactory(v);
            }
            if ((v = data.get(prefix + CUSTOM_TEST_THREAD_FACTORY_PATH)) != null) {
                this.setTestThreadFactoryPath(v);
            }
            if ((v = data.get(prefix + TEST_QUERIES)) != null) {
                this.setTestQueries(List.of(StringUtils.splitSeparator("\n", v)));
            }
        }
        catch (InvalidPathException e) {
            throw new Interview.Fault((ResourceBundle)i18n, "rp.badPath", e.getInput(), e.getMessage());
        }
    }

    @Override
    public void save(Map<String, String> data) {
        super.save(data);
        String prefix = this.getTag();
        if (this.envVars != null) {
            data.put(prefix + ENVVARS, this.serializeEnv(this.envVars, "\n"));
        }
        data.put(prefix + CHECK, String.valueOf(this.check));
        data.put(prefix + EXEC_MODE, String.valueOf((Object)this.execMode));
        data.put(prefix + IGNORE, String.valueOf((Object)this.ignoreKind));
        if (this.testJDK != null) {
            data.put(prefix + TEST_JDK, this.testJDK.getPath());
        }
        if (this.compileJDK != null) {
            data.put(prefix + COMPILE_JDK, this.compileJDK.getPath());
        }
        if (this.retainArgs != null && this.retainArgs.size() > 0) {
            data.put(prefix + RETAIN_ARGS, StringUtils.join(this.retainArgs, "\n"));
        }
        if (this.testVMOpts != null && this.testVMOpts.size() > 0) {
            data.put(prefix + TEST_VM_OPTIONS, StringUtils.join(this.testVMOpts, "\n"));
        }
        if (this.testCompilerOpts != null && this.testCompilerOpts.size() > 0) {
            data.put(prefix + TEST_COMPILER_OPTIONS, StringUtils.join(this.testCompilerOpts, "\n"));
        }
        if (this.testJavaOpts != null && this.testJavaOpts.size() > 0) {
            data.put(prefix + TEST_JAVA_OPTIONS, StringUtils.join(this.testJavaOpts, "\n"));
        }
        if (this.junitPath != null) {
            data.put(prefix + JUNIT, this.junitPath.toString());
        }
        if (this.testngPath != null) {
            data.put(prefix + TESTNG, this.testngPath.toString());
        }
        if (this.asmToolsPath != null) {
            data.put(prefix + ASMTOOLS, this.asmToolsPath.toString());
        }
        if (this.timeLimit > 0) {
            data.put(prefix + TIMELIMIT, String.valueOf(this.timeLimit));
        }
        if (this.reportDir != null) {
            data.put(prefix + REPORTDIR, this.reportDir.toString());
        }
        if (this.exclusiveLock != null) {
            data.put(prefix + EXCLUSIVE_LOCK, this.exclusiveLock.toString());
        }
        if (this.nativeDir != null) {
            data.put(prefix + NATIVEDIR, this.nativeDir.toString());
        }
        if (this.timeoutHandlerClassName != null) {
            data.put(prefix + TIMEOUT_HANDLER, this.timeoutHandlerClassName);
        }
        if (this.timeoutHandlerPath != null) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (Path file : this.timeoutHandlerPath) {
                sb.append(sep).append(file);
                sep = File.pathSeparator;
            }
            data.put(prefix + TIMEOUT_HANDLER_PATH, sb.toString());
        }
        if (this.timeoutHandlerTimeout != -1L) {
            data.put(prefix + TIMEOUT_HANDLER_TIMEOUT, String.valueOf(this.timeoutHandlerTimeout));
        }
        if (this.testThreadFactory != null) {
            data.put(prefix + CUSTOM_TEST_THREAD_FACTORY, this.testThreadFactory);
        }
        if (this.testThreadFactoryPath != null) {
            data.put(prefix + CUSTOM_TEST_THREAD_FACTORY_PATH, this.testThreadFactoryPath);
        }
        if (this.testQueries != null) {
            data.put(prefix + TEST_QUERIES, StringUtils.join(this.testQueries, "\n"));
        }
    }

    private Map<String, String> deserializeEnv(String envString, String sep) {
        if (envString != null && envString.length() != 0) {
            String[] envArr;
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            for (String e : envArr = StringUtils.splitSeparator(sep, envString)) {
                String[] split = StringUtils.splitSeparator("=", e);
                env.put(split[0], split[1]);
            }
            return Collections.unmodifiableMap(env);
        }
        return Collections.emptyMap();
    }

    private String serializeEnv(Map<String, String> env, String sep) {
        StringBuilder envString = new StringBuilder();
        int cnt = env.size();
        for (Map.Entry<String, String> var : env.entrySet()) {
            envString.append(var.getKey()).append("=").append(var.getValue());
            if (--cnt == 0) continue;
            envString.append(sep);
        }
        return envString.toString();
    }

    public Map<String, String> getEnvVars() {
        if (this.envVars == null) {
            String envVarStr = System.getProperty("envVars");
            this.envVars = this.deserializeEnv(envVarStr, ",");
        }
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(envVars));
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setIgnoreKind(IgnoreKind ignoreKind) {
        this.ignoreKind = Objects.requireNonNull(ignoreKind);
    }

    public IgnoreKind getIgnoreKind() {
        return this.ignoreKind;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    int getTimeLimit() {
        return this.timeLimit;
    }

    public void setCompileJDK(JDK compileJDK) {
        this.compileJDK = Objects.requireNonNull(compileJDK);
    }

    public JDK getCompileJDK() {
        return this.compileJDK;
    }

    public void setTestJDK(JDK testJDK) {
        this.testJDK = Objects.requireNonNull(testJDK);
    }

    public JDK getTestJDK() {
        return this.testJDK;
    }

    public void setJUnitPath(SearchPath junitPath) {
        this.junitPath = Objects.requireNonNull(junitPath);
    }

    public SearchPath getJUnitPath() {
        return this.junitPath;
    }

    public boolean isJUnitAvailable() {
        return this.junitPath != null && !this.junitPath.isEmpty();
    }

    public void setTestNGPath(SearchPath testngPath) {
        this.testngPath = Objects.requireNonNull(testngPath);
    }

    public SearchPath getTestNGPath() {
        return this.testngPath;
    }

    public boolean isTestNGAvailable() {
        return this.testngPath != null && !this.testngPath.isEmpty();
    }

    public void setAsmToolsPath(SearchPath asmToolsPath) {
        this.asmToolsPath = Objects.requireNonNull(asmToolsPath);
    }

    public SearchPath getAsmToolsPath() {
        return this.asmToolsPath;
    }

    public SearchPath getJavaTestClassPath() {
        if (this.javaTestClassPath == null) {
            Path jtClsDir = ProductInfo.getJavaTestClassDir().toPath();
            this.javaTestClassPath = new SearchPath(jtClsDir);
            if (jtClsDir.getFileName().toString().equals("javatest.jar")) {
                Path installDir = jtClsDir.getParent();
                Path jtreg = installDir.resolve("jtreg.jar");
                if (Files.exists(jtreg, new LinkOption[0])) {
                    this.javaTestClassPath.append(jtreg);
                } else {
                    try {
                        URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                        this.javaTestClassPath.append(Path.of(location.toURI()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Computation of Java test class-path failed", e);
                    }
                }
            }
        }
        return this.javaTestClassPath;
    }

    public List<String> getTestVMOptions() {
        if (this.testVMOpts == null) {
            this.testVMOpts = Collections.emptyList();
        }
        return this.testVMOpts;
    }

    public void setTestVMOptions(List<String> testVMOpts) {
        this.testVMOpts = Collections.unmodifiableList(new ArrayList<String>(testVMOpts));
    }

    public List<String> getTestToolVMOptions() {
        ArrayList<CallSite> testToolVMOpts = new ArrayList<CallSite>();
        for (String s : this.getTestVMOptions()) {
            testToolVMOpts.add((CallSite)((Object)("-J" + s)));
        }
        return Collections.unmodifiableList(testToolVMOpts);
    }

    public List<String> getTestVMJavaOptions() {
        if ((this.testVMOpts == null || this.testVMOpts.isEmpty()) && this.nativeDir == null) {
            return this.getTestJavaOptions();
        }
        if ((this.testJavaOpts == null || this.testJavaOpts.isEmpty()) && this.nativeDir == null) {
            return this.getTestVMOptions();
        }
        ArrayList<Object> opts = new ArrayList<Object>();
        opts.addAll(this.getTestVMOptions());
        opts.addAll(this.getTestJavaOptions());
        if (this.nativeDir != null) {
            opts.add("-Djava.library.path=" + String.valueOf(this.nativeDir.toAbsolutePath()));
        }
        return Collections.unmodifiableList(opts);
    }

    public List<String> getTestCompilerOptions() {
        if (this.testCompilerOpts == null) {
            this.testCompilerOpts = Collections.emptyList();
        }
        return this.testCompilerOpts;
    }

    public void setTestCompilerOptions(List<String> testCompilerOpts) {
        this.testCompilerOpts = Collections.unmodifiableList(new ArrayList<String>(testCompilerOpts));
    }

    public List<String> getTestJavaOptions() {
        if (this.testJavaOpts == null) {
            this.testJavaOpts = Collections.emptyList();
        }
        return this.testJavaOpts;
    }

    public void setTestJavaOptions(List<String> testJavaOpts) {
        this.testJavaOpts = Collections.unmodifiableList(new ArrayList<String>(testJavaOpts));
    }

    public List<String> getTestDebugOptions() {
        if (this.testDebugOpts == null) {
            this.testDebugOpts = Collections.emptyList();
        }
        return this.testDebugOpts;
    }

    public void setTestDebugOptions(List<String> testJavaOpts) {
        this.testDebugOpts = Collections.unmodifiableList(new ArrayList<String>(testJavaOpts));
    }

    List<String> getRetainArgs() {
        return this.retainArgs;
    }

    public void setRetainArgs(List<String> retainArgs) {
        this.retainStatusSet.clear();
        if (retainArgs == null || retainArgs.contains("lastRun")) {
            this.retainFilesPattern = null;
            return;
        }
        this.retainArgs = Collections.unmodifiableList(new ArrayList<String>(retainArgs));
        StringBuilder sb = new StringBuilder();
        for (String arg : retainArgs) {
            if (arg.equals("all")) {
                this.retainStatusSet.add(0);
                this.retainStatusSet.add(1);
                this.retainStatusSet.add(2);
                continue;
            }
            if (arg.equals("pass")) {
                this.retainStatusSet.add(0);
                continue;
            }
            if (arg.equals("fail")) {
                this.retainStatusSet.add(1);
                continue;
            }
            if (arg.equals("error")) {
                this.retainStatusSet.add(2);
                continue;
            }
            if (arg.equals("none") || arg.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            boolean inQuote = false;
            block4: for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                switch (c) {
                    case '*': {
                        if (inQuote) {
                            sb.append("\\E");
                            inQuote = false;
                        }
                        sb.append(".*");
                        continue block4;
                    }
                    default: {
                        if (!inQuote) {
                            sb.append("\\Q");
                            inQuote = true;
                        }
                        sb.append(c);
                    }
                }
            }
            if (!inQuote) continue;
            sb.append("\\E");
        }
        this.retainFilesPattern = sb.length() == 0 ? null : Pattern.compile(sb.toString());
    }

    public boolean isRetainEnabled() {
        return this.retainArgs != null;
    }

    public Set<Integer> getRetainStatus() {
        return this.retainStatusSet;
    }

    public Pattern getRetainFilesPattern() {
        return this.retainFilesPattern;
    }

    public void setReportDir(Path reportDir) {
        this.reportDir = Objects.requireNonNull(reportDir);
    }

    public Path getReportDir() {
        return this.reportDir;
    }

    public void setExclusiveLock(Path exclusiveLock) {
        this.exclusiveLock = Objects.requireNonNull(exclusiveLock);
    }

    public Path getExclusiveLock() {
        return this.exclusiveLock;
    }

    public void setNativeDir(Path nativeDir) {
        this.nativeDir = nativeDir;
    }

    public Path getNativeDir() {
        return this.nativeDir;
    }

    public void setTimeoutHandler(String timeoutHandlerClassName) {
        this.timeoutHandlerClassName = Objects.requireNonNull(timeoutHandlerClassName);
    }

    String getTimeoutHandler() {
        return this.timeoutHandlerClassName;
    }

    void setTimeoutHandlerPath(String timeoutHandlerPath) {
        Objects.requireNonNull(timeoutHandlerPath);
        this.timeoutHandlerPath = new ArrayList<Path>();
        for (String f : timeoutHandlerPath.split(File.pathSeparator)) {
            if (f.length() <= 0) continue;
            this.timeoutHandlerPath.add(Path.of(f, new String[0]));
        }
    }

    public void setTimeoutHandlerPath(List<Path> timeoutHandlerPath) {
        this.timeoutHandlerPath = Objects.requireNonNull(timeoutHandlerPath);
    }

    List<Path> getTimeoutHandlerPath() {
        return this.timeoutHandlerPath;
    }

    public void setTimeoutHandlerTimeout(long timeout) {
        this.timeoutHandlerTimeout = timeout;
    }

    private void setTimeoutHandlerTimeout(String timeout) {
        this.timeoutHandlerTimeout = Long.parseLong(timeout);
    }

    long getTimeoutHandlerTimeout() {
        return this.timeoutHandlerTimeout;
    }

    public void setTestThreadFactory(String testThreadFactory) {
        this.testThreadFactory = testThreadFactory;
    }

    public String getTestThreadFactory() {
        return this.testThreadFactory;
    }

    public void setTestThreadFactoryPath(String testThreadFactoryPath) {
        this.testThreadFactoryPath = testThreadFactoryPath;
    }

    public String getTestThreadFactoryPath() {
        return this.testThreadFactoryPath;
    }

    public void setMatchLists(Path[] files) {
        this.matchLists = List.of(files);
    }

    List<Path> getMatchLists() {
        return Collections.unmodifiableList(this.matchLists);
    }

    public void setUseWindowsSubsystemForLinux(boolean useWindowsSubsystemForLinux) {
        this.useWindowsSubsystemForLinux = useWindowsSubsystemForLinux;
    }

    public boolean useWindowsSubsystemForLinux() {
        return this.useWindowsSubsystemForLinux;
    }

    public void setTestQueries(List<String> testQueries) {
        this.testQueries = testQueries;
    }

    public List<String> getTestQueries() {
        return this.testQueries;
    }

    public String getTestQuery(String test) {
        if (this.testQueries != null) {
            for (String tq : this.testQueries) {
                int sep;
                if (!test.equals(tq.substring(0, sep = tq.indexOf("?")))) continue;
                return tq.substring(sep + 1);
            }
        }
        return null;
    }

    public Pattern getRefIgnoreLinesPattern() {
        if (this.refIgnoreLinesPattern == UNSET_PATTERN) {
            String re;
            String refIgnoreLines = System.getenv("JTREG_REF_IGNORE_LINES");
            if (refIgnoreLines != null) {
                re = Arrays.stream(refIgnoreLines.trim().split("\\s+")).map(s -> "(" + s + ")").collect(Collectors.joining("|"));
            } else {
                Map<String, String> envVars = this.getEnvVars();
                re = Stream.of("JAVA_TOOL_OPTIONS", "_JAVA_OPTIONS").filter(envVars::containsKey).map(e -> "(Picked up " + e + ":.*)").collect(Collectors.joining("|"));
            }
            try {
                this.refIgnoreLinesPattern = re.isEmpty() ? null : Pattern.compile(re);
            }
            catch (PatternSyntaxException e2) {
                this.refIgnoreLinesPattern = null;
                throw e2;
            }
        }
        return this.refIgnoreLinesPattern;
    }

    public TimeoutHandlerProvider getTimeoutHandlerProvider() throws MalformedURLException {
        if (this.timeoutHandlerProvider == null) {
            this.timeoutHandlerProvider = new TimeoutHandlerProvider();
            this.timeoutHandlerProvider.setClassName(this.timeoutHandlerClassName);
            if (this.timeoutHandlerPath != null && !this.timeoutHandlerPath.isEmpty()) {
                this.timeoutHandlerProvider.setClassPath(this.timeoutHandlerPath);
            }
            if (this.timeoutHandlerTimeout != -1L) {
                this.timeoutHandlerProvider.setTimeout(this.timeoutHandlerTimeout);
            }
        }
        return this.timeoutHandlerProvider;
    }

    public Map<String, String> getBasicTestProperties() {
        if (this.basicTestProperties == null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.put(map, "test.vm.opts", this.getTestVMOptions(), v -> StringUtils.join(v, " "));
            this.put(map, "test.tool.vm.opts", this.getTestToolVMOptions(), v -> StringUtils.join(v, " "));
            this.put(map, "test.compiler.opts", this.getTestCompilerOptions(), v -> StringUtils.join(v, " "));
            this.put(map, "test.java.opts", this.getTestJavaOptions(), v -> StringUtils.join(v, " "));
            this.put(map, "test.jdk", this.getTestJDK(), JDK::getAbsolutePath);
            this.put(map, "compile.jdk", this.getCompileJDK(), JDK::getAbsolutePath);
            this.put(map, "test.timeout.factor", Float.valueOf(this.getTimeoutFactor()), String::valueOf);
            this.put(map, "test.nativepath", this.getNativeDir(), p -> p.toAbsolutePath().toString());
            this.put(map, "test.root", this.getTestSuite().getRootDir(), File::getAbsolutePath);
            this.basicTestProperties = map;
        }
        return this.basicTestProperties;
    }

    private <T> void put(Map<String, String> map, String name, T value, Function<T, String> toString) {
        if (value != null) {
            map.put(name, toString.apply(value));
        }
    }

    public OS getTestOS() {
        JDK jdk = this.getTestJDK();
        if (jdk == null) {
            return OS.current();
        }
        try {
            return OS.forProps(this.testJDK.getProperties(this, this.logger));
        }
        catch (JDK.Fault f) {
            throw new IllegalStateException(f);
        }
    }

    public static class KeywordsTestFilter
    extends TestFilter {
        private final TestFilter delegate;
        public final Set<String> ignored = new HashSet<String>();

        KeywordsTestFilter(TestFilter delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public String getReason() {
            return this.delegate.getReason();
        }

        @Override
        public boolean accepts(TestDescription td) throws TestFilter.Fault {
            boolean ok = this.delegate.accepts(td);
            if (!ok && td.getKeywordTable().contains("ignore")) {
                this.ignored.add(td.getRootRelativeURL());
            }
            return ok;
        }
    }

    private static class TestListWithPlatforms {
        private final ExcludeList el;
        private final Set<String> osPlatforms;

        private static Set<String> getPlatforms(OS os) {
            HashSet<String> platforms = new HashSet<String>();
            for (String p : List.of(os.name, os.name.replaceAll("\\s", ""), os.family, "generic")) {
                for (String q : List.of("", os.arch, os.simple_arch, os.version, os.simple_version, "all")) {
                    String ep = q.isEmpty() ? p : p + "-" + q;
                    platforms.add(ep.toLowerCase());
                }
            }
            return platforms;
        }

        TestListWithPlatforms(ExcludeList el, OS os) {
            this.el = el;
            this.osPlatforms = TestListWithPlatforms.getPlatforms(os);
        }

        public boolean match(TestDescription td) {
            String[] bugIds;
            ExcludeList.Entry e = this.el.getEntry(td.getRootRelativeURL());
            if (e == null) {
                return false;
            }
            String[] platforms = e.getPlatforms();
            if ((platforms.length == 0 || platforms.length == 1 && platforms[0].length() == 0) && (bugIds = e.getBugIdStrings()).length > 0 && !bugIds[0].matches("0|([1-9][0-9,]*)")) {
                platforms = bugIds;
            }
            if (platforms.length == 0 || platforms.length == 1 && platforms[0].length() == 0) {
                return true;
            }
            for (String p : platforms) {
                if (!this.osPlatforms.contains(p.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }
}

