/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.RegressionParameters;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

public class RegressionContext
implements Expr.Context {
    private static final String VM_PREFIX = "-XX:";
    private static final String ON_PREFIX = "-XX:+";
    private static final String OFF_PREFIX = "-XX:-";
    private static final String GC_PREFIX = "-XX:+Use";
    private static final String GC_SUFFIX = "GC";
    private static final String MODE_MIXED = "Xmixed";
    private static final String MODE_INT = "Xint";
    private static final String MODE_COMP = "Xcomp";
    private final RegressionParameters params;
    private final Map<String, String> values;
    private final Set<String> validPropNames;

    static RegressionContext getDefault() {
        try {
            return new RegressionContext(null, System.err::println);
        }
        catch (JDK.Fault f) {
            throw new IllegalStateException(f);
        }
    }

    RegressionContext(RegressionParameters params, Consumer<String> logger) throws JDK.Fault {
        OS os;
        JDK_Version jdkVersion;
        this.params = params;
        this.validPropNames = null;
        this.values = new HashMap<String, String>();
        this.values.put("null", "null");
        if (params == null) {
            jdkVersion = null;
            os = OS.current();
        } else {
            JDK jdk = params.getTestJDK();
            Properties jdkProps = jdk.getProperties(params, logger);
            for (Map.Entry<Object, Object> e : jdkProps.entrySet()) {
                this.values.put((String)e.getKey(), (String)e.getValue());
            }
            jdkVersion = JDK_Version.forName(jdkProps.getProperty("java.specification.version"));
            os = OS.forProps(jdkProps);
        }
        this.values.put("jdk.version", jdkVersion != null ? jdkVersion.name() : "unknown");
        this.values.put("jdk.version.major", jdkVersion != null ? String.valueOf(jdkVersion.major) : "0");
        this.values.put("os.name", os.name);
        this.values.put("os.arch", os.arch);
        this.values.put("os.simpleArch", os.simple_arch);
        this.values.put("os.version", os.version);
        this.values.put("os.simpleVersion", os.simple_version);
        this.values.put("os.family", os.family);
        this.values.put("os.processors", String.valueOf(os.processors));
        this.values.put("os.maxMemory", String.valueOf(os.maxMemory));
        this.values.put("os.maxSwap", String.valueOf(os.maxSwap));
        this.processVMOptions(params == null ? Collections.emptyList() : params.getTestVMJavaOptions());
    }

    RegressionContext(RegressionContext base, Set<String> validPropNames) {
        this.params = base.params;
        this.values = base.values;
        this.validPropNames = validPropNames;
    }

    @Override
    public boolean isValidName(String name) {
        if (this.validPropNames == null) {
            return true;
        }
        if (this.values.containsKey(name)) {
            return true;
        }
        if (name.startsWith("vm.opt.")) {
            return true;
        }
        return this.validPropNames.contains(name);
    }

    @Override
    public String get(String name) throws Expr.Fault {
        String v = this.values.get(name);
        if (v == null) {
            return "null";
        }
        if (v.startsWith("__ERROR__")) {
            String reason = v.substring("__ERROR__".length()).trim();
            if (reason.isEmpty()) {
                reason = "error determining value";
            }
            throw new Expr.Fault(name + ": " + reason);
        }
        return v;
    }

    public String toString() {
        return this.values.toString();
    }

    private void processVMOptions(List<String> vmOptions) {
        String gc = null;
        String compMode = null;
        HashMap<String, Boolean> vmBools = new HashMap<String, Boolean>();
        HashMap<String, String> vmProps = new HashMap<String, String>();
        for (String opt : vmOptions) {
            int eq;
            if (opt.equals("-Xmixed")) {
                compMode = MODE_MIXED;
                continue;
            }
            if (opt.equals("-Xint")) {
                compMode = MODE_INT;
                continue;
            }
            if (opt.equals("-Xcomp")) {
                compMode = MODE_COMP;
                continue;
            }
            if (opt.startsWith(GC_PREFIX) && opt.endsWith(GC_SUFFIX)) {
                gc = opt.substring(GC_PREFIX.length(), opt.length() - GC_SUFFIX.length());
                vmBools.put(opt.substring(ON_PREFIX.length()), true);
                continue;
            }
            if (opt.startsWith(ON_PREFIX)) {
                vmBools.put(opt.substring(ON_PREFIX.length()), true);
                continue;
            }
            if (opt.startsWith(OFF_PREFIX)) {
                vmBools.put(opt.substring(OFF_PREFIX.length()), false);
                continue;
            }
            if (!opt.startsWith(VM_PREFIX) || (eq = opt.indexOf(61)) <= 0) continue;
            String vmPropName = opt.substring(VM_PREFIX.length(), eq);
            String vmPropValue = opt.substring(eq + 1);
            vmProps.put(vmPropName, vmPropValue);
        }
        String NULL = "null";
        this.putIfAbsent(this.values, "vm.flavor", NULL);
        this.putIfAbsent(this.values, "vm.bits", NULL);
        this.putIfAbsent(this.values, "vm.gc", gc != null ? gc : NULL);
        this.putIfAbsent(this.values, "vm.compMode", compMode != null ? compMode : NULL);
        for (Map.Entry e : vmBools.entrySet()) {
            this.putIfAbsent(this.values, "vm.opt." + (String)e.getKey(), String.valueOf(e.getValue()));
        }
        for (Map.Entry e : vmProps.entrySet()) {
            this.putIfAbsent(this.values, "vm.opt." + (String)e.getKey(), String.valueOf(e.getValue()));
        }
    }

    private void putIfAbsent(Map<String, String> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

