/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Properties;

public class OS {
    public final String name;
    public final String arch;
    public final String version;
    public final String family;
    public final String simple_arch;
    public final String simple_version;
    public final int processors;
    public final long maxMemory;
    public final long maxSwap;
    private static OS current;

    public static OS current() {
        if (current == null) {
            String name = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            String version = System.getProperty("os.version");
            current = new OS(name, arch, version);
        }
        return current;
    }

    public static OS forProps(Properties sysProps) {
        String name = sysProps.getProperty("os.name");
        String arch = sysProps.getProperty("os.arch");
        String version = sysProps.getProperty("os.version");
        return new OS(name == null ? "unknown" : name, arch == null ? "unknown" : arch, version == null ? "unknown" : version);
    }

    public OS(String name, String arch, String version) {
        char c;
        int index;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.family = name.startsWith("AIX") ? "aix" : (name.startsWith("Linux") ? "linux" : (name.startsWith("Mac") || name.startsWith("Darwin") ? "mac" : (name.startsWith("OS400") || name.startsWith("OS/400") ? "os400" : (name.startsWith("SunOS") || name.startsWith("Solaris") ? "solaris" : (name.startsWith("Windows") ? "windows" : name.replaceFirst("^([^ ]+).*", "$1"))))));
        this.simple_arch = arch.contains("64") && !arch.equals("ia64") && !arch.equals("ppc64") && !arch.equals("ppc64le") && !arch.equals("zArch_64") && !arch.equals("loongarch64") && !arch.equals("riscv64") && !arch.equals("aarch64") ? "x64" : (arch.contains("86") ? "i586" : (arch.equals("ppc") || arch.equals("powerpc") ? "ppc" : (arch.equals("s390x") || arch.equals("zArch_64") ? "s390x" : (arch.equals("mips64") || arch.equals("mips64el") ? "mips64" : arch))));
        String UNKNOWN = "99.99";
        for (index = 0; index < version.length() && (Character.isDigit(c = version.charAt(index)) || c == '.'); ++index) {
        }
        ArrayList<Integer> v = new ArrayList<Integer>();
        for (String s : version.substring(0, index).split("\\.")) {
            if (s.length() <= 0) continue;
            v.add(Integer.valueOf(s));
        }
        switch (v.size()) {
            case 0: {
                this.simple_version = "99.99";
                break;
            }
            case 1: {
                this.simple_version = String.valueOf(v.get(0)) + ".0";
                break;
            }
            default: {
                this.simple_version = String.valueOf(v.get(0)) + "." + String.valueOf(v.get(1));
            }
        }
        this.processors = Runtime.getRuntime().availableProcessors();
        OperatingSystemMXBean osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.maxMemory = osMXBean.getTotalPhysicalMemorySize();
        this.maxSwap = osMXBean.getTotalSwapSpaceSize();
    }

    public String toString() {
        return "[name:" + this.name + ",arch:" + this.arch + ",version:" + this.version + ",family:" + this.family + ",simple_arch:" + this.simple_arch + ",simple_version:" + this.simple_version + ",processors:" + this.processors + ",maxMemory:" + this.maxMemory + ",maxSwap:" + this.maxSwap + "]";
    }
}

