/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtraPropDefns {
    private final List<String> files;
    private final List<String> libs;
    private final List<String> bootLibs;
    private final List<String> javacOpts;
    private final List<String> vmOpts;
    private final PrintStream log;
    private Path classDir;
    private Path bootClassDir;
    private List<String> classes;
    private static final boolean trace = Boolean.getBoolean("trace.extraPropDefns");
    private static final Pattern commentPattern = Pattern.compile("(?s)(\\s+//.*?\n|/\\*.*?\\*/)");
    private static final Pattern packagePattern = Pattern.compile("package\\s+(((?:\\w+\\.)*)\\w+)\\s*;");
    private static final Pattern classPattern = Pattern.compile("(?:public\\s+)?(?:class|enum|interface|record)\\s+(\\w+)");

    ExtraPropDefns() {
        this(null, null, null, null, null);
    }

    ExtraPropDefns(String classes, String libs, String bootLibs, String javacOpts, String vmOpts) {
        this.files = this.asList(classes);
        this.libs = this.asList(libs);
        this.bootLibs = this.asList(bootLibs);
        this.javacOpts = this.asList(javacOpts);
        this.vmOpts = this.asList(vmOpts);
        this.log = System.err;
    }

    void compile(RegressionParameters params, JDK jdk, File outDir) throws Fault {
        this.compile(params, jdk, outDir.toPath());
    }

    void compile(RegressionParameters params, JDK jdk, Path outDir) throws Fault {
        Path baseDir = params.getTestSuite().getRootDir().toPath();
        this.classDir = outDir.resolve("classes");
        this.bootClassDir = outDir.resolve("bootClasses");
        this.compile(jdk, this.bootClassDir, new SearchPath(), baseDir, this.bootLibs, true);
        this.compile(jdk, this.classDir, new SearchPath(this.bootClassDir), baseDir, this.libs, true);
        this.classes = this.compile(jdk, this.classDir, new SearchPath(this.bootClassDir), baseDir, this.files, false);
    }

    Path getClassDir() {
        return this.classDir;
    }

    Path getBootClassDir() {
        return this.bootClassDir;
    }

    List<String> getClasses() {
        return this.classes;
    }

    List<String> getVMOpts() {
        return this.vmOpts;
    }

    private List<String> compile(JDK jdk, Path classDir, SearchPath classpath, Path srcDir, List<String> files, boolean allowDirs) throws Fault {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<String> javacArgs = new ArrayList<String>();
        javacArgs.add("-d");
        javacArgs.add(classDir.toString());
        try {
            Files.createDirectories(classDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Fault("cannot create classes directory", e);
        }
        javacArgs.add("-classpath");
        javacArgs.add(new SearchPath(classDir).append(classpath).toString());
        javacArgs.addAll(this.javacOpts);
        ArrayList<CallSite> needCompileReasons = new ArrayList<CallSite>();
        for (String e : files) {
            boolean optional;
            if (e.startsWith("[") && e.endsWith("]")) {
                optional = true;
                e = e.substring(1, e.length() - 1);
            } else {
                optional = false;
            }
            Path f = srcDir.resolve(e);
            if (!Files.exists(f, new LinkOption[0])) {
                if (optional) continue;
                System.err.println("Cannot find file " + e + " for extra property definitions");
                continue;
            }
            for (Path sf : this.expandJavaFiles(f, allowDirs)) {
                javacArgs.add(sf.toString());
                String cn = this.getClassNameFromFile(sf);
                classNames.add(cn);
                if (!needCompileReasons.isEmpty() && !trace) continue;
                Path cf = classDir.resolve(cn.replace(".", File.separator) + ".class");
                if (Files.exists(cf, new LinkOption[0])) {
                    if (FileUtils.compareLastModifiedTimes(sf, cf) <= 0) continue;
                    needCompileReasons.add((CallSite)((Object)("Class file is out of date; class file: " + String.valueOf(cf) + ", source file: " + String.valueOf(sf))));
                    continue;
                }
                needCompileReasons.add((CallSite)((Object)("Class file not found; class file: " + String.valueOf(cf) + ", source file: " + String.valueOf(sf))));
            }
        }
        if (!needCompileReasons.isEmpty()) {
            if (trace) {
                PrintStream out = System.err;
                out.println("Compiling extra property definition files: " + String.valueOf(javacArgs));
                needCompileReasons.forEach(out::println);
            }
            ArrayList<String> pArgs = new ArrayList<String>();
            pArgs.add(jdk.getJavacProg().toString());
            pArgs.addAll(javacArgs);
            try {
                Process p = new ProcessBuilder(pArgs).redirectErrorStream(true).start();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        this.log.println(line);
                    }
                }
                int rc = p.waitFor();
                if (rc != 0) {
                    throw new Fault("Compilation of extra property definition files failed. rc=" + rc);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new Fault("Compilation of extra property definition files failed.", e);
            }
        }
        return classNames;
    }

    private List<Path> expandJavaFiles(Path file, boolean allowDirs) throws Fault {
        ArrayList<Path> results = new ArrayList<Path>();
        this.expandJavaFiles(file, allowDirs, true, results);
        return results;
    }

    private void expandJavaFiles(Path file, boolean allowDirs, boolean rejectBadFiles, List<Path> results) throws Fault {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            if (file.getFileName().toString().endsWith(".java")) {
                results.add(file);
            } else if (rejectBadFiles) {
                throw new Fault("unexpected file found in extra property definition files: " + String.valueOf(file));
            }
        } else if (Files.isDirectory(file, new LinkOption[0])) {
            if (allowDirs) {
                for (Path child : FileUtils.listFiles(file)) {
                    this.expandJavaFiles(child, true, false, results);
                }
            } else if (rejectBadFiles) {
                throw new Fault("unexpected directory found in extra property definition files" + String.valueOf(file));
            }
        }
    }

    private String getClassNameFromFile(Path file) throws Fault {
        try {
            return this.getClassNameFromSource(Files.readString(file));
        }
        catch (IOException e) {
            throw new Fault("Problem reading " + String.valueOf(file), e);
        }
    }

    private String getClassNameFromSource(String source) throws Fault {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = commentPattern.matcher(source);
        int start = 0;
        while (matcher.find()) {
            sb.append(source, start, matcher.start());
            start = matcher.end();
        }
        sb.append(source.substring(start));
        source = sb.toString();
        String packageName = null;
        matcher = packagePattern.matcher(source);
        if (matcher.find()) {
            packageName = matcher.group(1);
        }
        if ((matcher = classPattern.matcher(source)).find()) {
            String className = matcher.group(1);
            return packageName == null ? className : packageName + "." + className;
        }
        throw new Fault("Could not extract the java class name from the provided source");
    }

    private List<String> asList(String s) {
        return s == null ? Collections.emptyList() : List.of(s.split("\\s+"));
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String msg) {
            super(msg);
        }

        Fault(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

