/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CachingTestFilter
extends TestFilter {
    private final String name;
    private final String description;
    private final String reason;
    private final Map<String, Entry> cache = new HashMap<String, Entry>();

    CachingTestFilter(String name, String description, String reason) {
        this.name = name;
        this.description = description;
        this.reason = reason;
    }

    protected abstract String getCacheKey(TestDescription var1);

    protected abstract boolean getCacheableValue(TestDescription var1) throws TestFilter.Fault;

    public Collection<Entry> getCacheEntries() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    public void clear() {
        this.cache.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public final boolean accepts(TestDescription td) throws TestFilter.Fault {
        String key = this.getCacheKey(td);
        Entry e = this.cache.get(key);
        if (e == null) {
            e = new Entry(td, this.getCacheableValue(td));
            this.cache.put(key, e);
        }
        return e.value;
    }

    public class Entry {
        public final TestDescription td;
        public final Boolean value;

        Entry(TestDescription td, Boolean v) {
            this.td = td;
            this.value = v;
        }
    }
}

