/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.MainActionHelper;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.IConfigurationListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.TestNG;
import org.testng.TestNGException;
import org.testng.reporters.XMLReporter;

public class TestNGRunner
implements MainActionHelper.TestRunner {
    public static void main(String ... args) throws Exception {
        TestNGRunner.main(null, args);
    }

    public static void main(ClassLoader loader, String ... args) throws Exception {
        ClassLoader cl;
        String className;
        if (args.length != 3) {
            throw new Error("wrong number of arguments");
        }
        String testName = args[0];
        boolean mixedMode = Boolean.parseBoolean(args[1]);
        String moduleClassName = args[2];
        int sep = moduleClassName.indexOf(47);
        String moduleName = sep == -1 ? null : moduleClassName.substring(0, sep);
        String string = className = sep == -1 ? moduleClassName : moduleClassName.substring(sep + 1);
        if (moduleName != null) {
            Class<?> layerClass;
            try {
                layerClass = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException e) {
                layerClass = Class.forName("java.lang.reflect.Layer");
            }
            Method bootMethod = layerClass.getMethod("boot", new Class[0]);
            Object bootLayer = bootMethod.invoke(null, new Object[0]);
            Method findLoaderMth = layerClass.getMethod("findLoader", String.class);
            cl = (ClassLoader)findLoaderMth.invoke(bootLayer, moduleName);
        } else {
            cl = loader != null ? loader : TestNGRunner.class.getClassLoader();
        }
        Class<?> mainClass = Class.forName(className, false, cl);
        String testQuery = System.getProperty("test.query");
        RegressionListener listener = new RegressionListener();
        TestNG testng = new TestNG(false);
        testng.setMixed(Boolean.valueOf(mixedMode));
        testng.setDefaultSuiteName(testName);
        testng.setTestClasses(new Class[]{mainClass});
        if (testQuery != null) {
            testng.setMethodInterceptor((IMethodInterceptor)new FilterMethods(className, testQuery));
        }
        testng.addListener((ITestNGListener)listener);
        testng.addListener((ITestNGListener)new XMLReporter());
        testng.setOutputDirectory(new File(".").getPath());
        testng.run();
        if (listener.configFailureCount > 0 || listener.failureCount > 0) {
            throw new Exception("failures: " + listener.failureCount);
        }
    }

    public static class RegressionListener
    implements ITestListener,
    IConfigurationListener {
        int count;
        int successCount;
        int failureCount;
        int skippedCount;
        int configSuccessCount;
        int configFailureCount;
        int configSkippedCount;
        int failedButWithinSuccessPercentageCount;

        public void onTestStart(ITestResult itr) {
            ++this.count;
        }

        public void onTestSuccess(ITestResult itr) {
            ++this.successCount;
            this.report(InfoKind.TEST, itr);
        }

        public void onTestFailure(ITestResult itr) {
            ++this.failureCount;
            this.report(InfoKind.TEST, itr);
        }

        public void onTestSkipped(ITestResult itr) {
            Throwable t = itr.getThrowable();
            if (t != null && !(t instanceof SkipException)) {
                this.onTestFailure(itr);
                return;
            }
            ++this.skippedCount;
            this.report(InfoKind.TEST, itr);
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult itr) {
            ++this.failedButWithinSuccessPercentageCount;
            this.report(InfoKind.TEST, itr);
        }

        public void onStart(ITestContext itc) {
        }

        public void onFinish(ITestContext itc) {
        }

        public void onConfigurationSuccess(ITestResult itr) {
            ++this.configSuccessCount;
            this.report(InfoKind.CONFIG, itr);
        }

        public void onConfigurationFailure(ITestResult itr) {
            ++this.configFailureCount;
            this.report(InfoKind.CONFIG, itr);
        }

        public void onConfigurationSkip(ITestResult itr) {
            ++this.configSkippedCount;
            this.report(InfoKind.CONFIG, itr);
        }

        void report(InfoKind k, ITestResult itr) {
            String suffix;
            Throwable t = itr.getThrowable();
            if (t != null && itr.getStatus() != 1) {
                StringWriter trace = new StringWriter();
                try (PrintWriter pw = new PrintWriter(trace);){
                    t.printStackTrace(pw);
                }
                suffix = "\n" + trace;
            } else {
                suffix = "\n";
            }
            System.out.print(k.toString().toLowerCase() + " " + itr.getMethod().getConstructorOrMethod().getDeclaringClass().getName() + "." + itr.getMethod().getMethodName() + this.formatParams(itr) + ": " + this.statusToString(itr.getStatus()) + suffix);
        }

        private String formatParams(ITestResult itr) {
            StringBuilder sb = new StringBuilder(80);
            sb.append('(');
            String sep = "";
            for (Object arg : itr.getParameters()) {
                sb.append(sep);
                this.formatParam(sb, arg);
                sep = ", ";
            }
            sb.append(")");
            return sb.toString();
        }

        private void formatParam(StringBuilder sb, Object param) {
            if (param instanceof String) {
                sb.append('\"');
                sb.append((String)param);
                sb.append('\"');
            } else {
                String value = String.valueOf(param);
                if (value.length() > 30) {
                    sb.append(param.getClass().getName());
                    sb.append('@');
                    sb.append(Integer.toHexString(System.identityHashCode(param)));
                } else {
                    sb.append(value);
                }
            }
        }

        private String statusToString(int s) {
            switch (s) {
                case 1: {
                    return "success";
                }
                case 2: {
                    return "failure";
                }
                case 3: {
                    return "skip";
                }
                case 4: {
                    return "success_percentage_failure";
                }
            }
            return "??";
        }

        static enum InfoKind {
            CONFIG,
            TEST;

        }
    }

    private static class FilterMethods
    implements IMethodInterceptor {
        private final String testClass;
        private final String testQuery;

        public FilterMethods(String testClass, String testQuery) {
            this.testClass = testClass;
            this.testQuery = testQuery;
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> ms, ITestContext c) {
            List<IMethodInstance> result = ms.stream().filter(mi -> this.testQuery.equals(mi.getMethod().getMethodName())).collect(Collectors.toList());
            if (result.isEmpty()) {
                throw new TestNGException("Could not find method with name [" + this.testQuery + "] in class [" + this.testClass + "]");
            }
            return result;
        }
    }
}

