/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class SearchPath {
    private final Set<Path> entries = new LinkedHashSet<Path>();
    private static final String PATHSEP = File.pathSeparator;

    public SearchPath() {
    }

    public SearchPath(Path ... entries) {
        this.append(entries);
    }

    public SearchPath(SearchPath ... paths) {
        this.append(paths);
    }

    public SearchPath(String ... paths) throws InvalidPathException {
        this.append(paths);
    }

    public SearchPath append(Collection<Path> entries) {
        for (Path e : entries) {
            if (!Files.exists(e, new LinkOption[0])) continue;
            this.entries.add(e);
        }
        return this;
    }

    public SearchPath append(Path ... entries) throws InvalidPathException {
        for (Path e : entries) {
            if (!Files.exists(e, new LinkOption[0])) continue;
            this.entries.add(e);
        }
        return this;
    }

    public SearchPath append(SearchPath ... paths) {
        for (SearchPath p : paths) {
            this.entries.addAll(p.entries);
        }
        return this;
    }

    public SearchPath append(String ... paths) throws InvalidPathException {
        for (String p : paths) {
            for (String q : p.split(Pattern.quote(PATHSEP))) {
                Path f;
                if (q.length() <= 0 || !Files.exists(f = Paths.get(q, new String[0]), new LinkOption[0])) continue;
                this.entries.add(f);
            }
        }
        return this;
    }

    public SearchPath removeAll(Collection<Path> entries) {
        this.entries.removeAll(entries);
        return this;
    }

    public SearchPath retainAll(Collection<Path> entries) {
        this.entries.retainAll(entries);
        return this;
    }

    public List<Path> asList() {
        return new ArrayList<Path>(this.entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Path e : this.entries) {
            if (sb.length() > 0) {
                sb.append(PATHSEP);
            }
            sb.append(e);
        }
        return sb.toString();
    }
}

