/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.MainActionHelper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class JUnitRunner
implements MainActionHelper.TestRunner {
    private static final String JUNIT_NO_DRIVER = "No JUnit driver -- install JUnit JAR file(s) next to jtreg.jar";
    private static final boolean JUNIT_RUN_WITH_JUNIT_4 = Flags.get("runWithJUnit4");

    public static void main(String ... args) throws Exception {
        JUnitRunner.main(null, args);
    }

    public static void main(ClassLoader loader, String ... args) throws Exception {
        ClassLoader cl;
        String className;
        if (args.length != 2) {
            throw new Error("wrong number of arguments");
        }
        String moduleClassName = args[1];
        int sep = moduleClassName.indexOf(47);
        String moduleName = sep == -1 ? null : moduleClassName.substring(0, sep);
        String string = className = sep == -1 ? moduleClassName : moduleClassName.substring(sep + 1);
        if (moduleName != null) {
            Class<?> layerClass;
            try {
                layerClass = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException e) {
                layerClass = Class.forName("java.lang.reflect.Layer");
            }
            Method bootMethod = layerClass.getMethod("boot", new Class[0]);
            Object bootLayer = bootMethod.invoke(null, new Object[0]);
            Method findLoaderMth = layerClass.getMethod("findLoader", String.class);
            cl = (ClassLoader)findLoaderMth.invoke(bootLayer, moduleName);
        } else {
            cl = loader != null ? loader : JUnitRunner.class.getClassLoader();
        }
        Class<?> mainClass = Class.forName(className, false, cl);
        if (JUNIT_RUN_WITH_JUNIT_4) {
            JUnitRunner.runWithJUnit4(mainClass);
        } else {
            JUnitRunner.runWithJUnitPlatform(mainClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithJUnit4(Class<?> mainClass) throws Exception {
        Result result;
        try {
            result = JUnitCore.runClasses((Class[])new Class[]{mainClass});
        }
        catch (NoClassDefFoundError ex) {
            throw new Exception(JUNIT_NO_DRIVER, ex);
        }
        if (!result.wasSuccessful()) {
            for (Failure failure : result.getFailures()) {
                StringWriter sw = new StringWriter();
                try (PrintWriter pw = new PrintWriter(sw);){
                    pw.println("JavaTest Message: JUnit Failure: " + failure);
                    failure.getException().printStackTrace(pw);
                }
                System.err.println(sw.toString());
            }
            throw new Exception("JUnit test failure");
        }
    }

    private static void runWithJUnitPlatform(Class<?> mainClass) throws Exception {
        Thread.currentThread().setContextClassLoader(mainClass.getClassLoader());
        try {
            String testQuery = System.getProperty("test.query");
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{testQuery == null ? DiscoverySelectors.selectClass(mainClass) : DiscoverySelectors.selectMethod(mainClass, (String)testQuery)}).build();
            SummaryGeneratingListener summaryGeneratingListener = new SummaryGeneratingListener();
            LauncherConfig launcherConfig = LauncherConfig.builder().addTestExecutionListeners(new TestExecutionListener[]{new PrintingListener(System.err)}).addTestExecutionListeners(new TestExecutionListener[]{summaryGeneratingListener}).build();
            try (LauncherSession session = LauncherFactory.openSession((LauncherConfig)launcherConfig);){
                session.getLauncher().execute(request, new TestExecutionListener[0]);
            }
            TestExecutionSummary summary = summaryGeneratingListener.getSummary();
            System.err.println(JUnitRunner.summarize(summary));
            if (summary.getTotalFailureCount() > 0L) {
                throw new Exception("JUnit test failure");
            }
        }
        catch (NoClassDefFoundError ex) {
            throw new Exception(JUNIT_NO_DRIVER, ex);
        }
    }

    static String summarize(TestExecutionSummary summary) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            if (summary.getTotalFailureCount() > 0L) {
                pw.println("JavaTest Message: JUnit Platform Failure(s): " + summary.getTotalFailureCount());
            }
            pw.println();
            pw.print("[ JUnit Containers: ");
            pw.print("found " + summary.getContainersFoundCount());
            pw.print(", started " + summary.getContainersStartedCount());
            pw.print(", succeeded " + summary.getContainersSucceededCount());
            pw.print(", failed " + summary.getContainersFailedCount());
            pw.print(", aborted " + summary.getContainersAbortedCount());
            pw.print(", skipped " + summary.getContainersSkippedCount());
            pw.println("]");
            pw.print("[ JUnit Tests: ");
            pw.print("found " + summary.getTestsFoundCount());
            pw.print(", started " + summary.getTestsStartedCount());
            pw.print(", succeeded " + summary.getTestsSucceededCount());
            pw.print(", failed " + summary.getTestsFailedCount());
            pw.print(", aborted " + summary.getTestsAbortedCount());
            pw.print(", skipped " + summary.getTestsSkippedCount());
            pw.println("]");
        }
        return sw.toString();
    }

    static class PrintingListener
    implements TestExecutionListener {
        final PrintWriter printer;
        final Lock lock;

        PrintingListener(PrintStream stream) {
            this(new PrintWriter(stream, true));
        }

        PrintingListener(PrintWriter printer) {
            this.printer = printer;
            this.lock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionSkipped(TestIdentifier identifier, String reason) {
            if (identifier.isTest()) {
                String status = "SKIPPED";
                String source = PrintingListener.toSourceString(identifier);
                String name = identifier.getDisplayName();
                this.lock.lock();
                try {
                    this.printer.printf("%-10s %s '%s' %s%n", status, source, name, reason);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionStarted(TestIdentifier identifier) {
            if (identifier.isTest()) {
                String status = "STARTED";
                String source = PrintingListener.toSourceString(identifier);
                String name = identifier.getDisplayName();
                this.lock.lock();
                try {
                    this.printer.printf("%-10s %s '%s'%n", status, source, name);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionFinished(TestIdentifier identifier, TestExecutionResult result) {
            this.lock.lock();
            try {
                TestExecutionResult.Status status = result.getStatus();
                if (status == TestExecutionResult.Status.ABORTED) {
                    result.getThrowable().ifPresent(this.printer::println);
                }
                if (status == TestExecutionResult.Status.FAILED) {
                    result.getThrowable().ifPresent(throwable -> throwable.printStackTrace(this.printer));
                }
                if (identifier.isTest()) {
                    String source = PrintingListener.toSourceString(identifier);
                    String name = identifier.getDisplayName();
                    this.printer.printf("%-10s %s '%s'%n", status, source, name);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void reportingEntryPublished(TestIdentifier identifier, ReportEntry entry) {
            this.lock.lock();
            try {
                this.printer.println(identifier.getDisplayName() + " -> " + entry.getTimestamp());
                entry.getKeyValuePairs().forEach((key, value) -> this.printer.println(key + " -> " + value));
            }
            finally {
                this.lock.unlock();
            }
        }

        private static String toSourceString(TestIdentifier identifier) {
            Optional optionalTestSource = identifier.getSource();
            if (!optionalTestSource.isPresent()) {
                return "<no test source>";
            }
            TestSource testSource = (TestSource)optionalTestSource.get();
            if (testSource instanceof MethodSource) {
                MethodSource source = (MethodSource)testSource;
                return source.getClassName() + "::" + source.getMethodName();
            }
            return testSource.toString();
        }
    }
}

