/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.RegressionSecurityManager;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ActionHelper {
    protected static final String EXEC_ERROR_CLEANUP = "Error while cleaning up threads after test";
    protected static final String EXEC_PASS = "Execution successful";
    protected static final String UNEXPECT_SYS_EXIT = "Unexpected exit from test";
    protected static final String AGENTVM_CANT_RESET_SECMGR = "Cannot reset security manager";
    protected static final String AGENTVM_CANT_RESET_SECPROVS = "Cannot reset security providers";
    protected static final String AGENTVM_CANT_RESET_PROPS = "Cannot reset system properties";

    private static <T> boolean equal(T[] a, T[] b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static Map<?, ?> copyProperties(Properties p) {
        HashMap h = new HashMap();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            h.put(key, p.get(key));
        }
        return h;
    }

    private static Properties newProperties(Map<?, ?> h) {
        Properties p = new Properties();
        p.putAll(h);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AStatus redirectOutput(PrintStream out, PrintStream err) {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            SecurityManager sc = System.getSecurityManager();
            if (sc instanceof RegressionSecurityManager) {
                boolean prev = ((RegressionSecurityManager)sc).setAllowSetIO(true);
                System.setOut(out);
                System.setErr(err);
                ((RegressionSecurityManager)sc).setAllowSetIO(prev);
            } else {
                System.setOut(out);
                System.setErr(err);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return AStatus.passed("OK");
        }
    }

    public static class PrintStringWriter
    extends PrintWriter {
        private final StringWriter w;

        public PrintStringWriter() {
            super(new StringWriter());
            this.w = (StringWriter)this.out;
        }

        public String getOutput() {
            return this.w.toString();
        }
    }

    public static interface OutputHandler {
        public PrintStream getPrintStream(OutputKind var1, boolean var2);

        public PrintWriter getPrintWriter(OutputKind var1, boolean var2);

        public static enum OutputKind {
            LOG(""),
            STDOUT("System.out"),
            STDERR("System.err"),
            DIRECT("direct"),
            DIRECT_LOG("direct.log");

            public final String name;

            private OutputKind(String name) {
                this.name = name;
            }
        }
    }

    static class SaveState {
        final SecurityManager secMgr;
        final PrintStream stdOut;
        final PrintStream stdErr;
        final Locale locale;
        final Provider[] securityProviders;
        static Map<?, ?> sysProps;

        SaveState() {
            if (sysProps == null) {
                sysProps = ActionHelper.copyProperties(System.getProperties());
            }
            this.stdOut = System.out;
            this.stdErr = System.err;
            this.locale = Locale.getDefault();
            this.secMgr = System.getSecurityManager();
            if (this.secMgr instanceof RegressionSecurityManager) {
                RegressionSecurityManager rsm = (RegressionSecurityManager)this.secMgr;
                rsm.setAllowPropertiesAccess(true);
                rsm.resetPropertiesModified();
            }
            this.securityProviders = Security.getProviders();
        }

        AStatus restore(String testName, AStatus status) {
            AStatus cleanupStatus;
            block12: {
                cleanupStatus = null;
                try {
                    if (System.getSecurityManager() != this.secMgr) {
                        AccessController.doPrivileged(() -> {
                            System.setSecurityManager(this.secMgr);
                            return null;
                        });
                    }
                }
                catch (SecurityException e) {
                    this.stdErr.println();
                    this.stdErr.println("***");
                    this.stdErr.println("*** " + testName);
                    this.stdErr.println("*** Cannot reset security manager after test");
                    this.stdErr.println("*** " + e.getMessage());
                    this.stdErr.println("***");
                    this.stdErr.println();
                    cleanupStatus = AStatus.error("Cannot reset security manager: " + e);
                }
                try {
                    Object[] sp = Security.getProviders();
                    if (!ActionHelper.equal(this.securityProviders, sp)) {
                        AccessController.doPrivileged(() -> this.lambda$restore$1((Provider[])sp));
                    }
                }
                catch (SecurityException e) {
                    cleanupStatus = AStatus.error("Cannot reset security providers: " + e);
                }
                SecurityManager sm = System.getSecurityManager();
                boolean resetAllSysProps = sm instanceof RegressionSecurityManager ? ((RegressionSecurityManager)sm).isPropertiesModified() : true;
                try {
                    if (resetAllSysProps) {
                        System.setProperties(ActionHelper.newProperties(SaveState.sysProps));
                    } else {
                        System.setProperty("java.class.path", (String)sysProps.get("java.class.path"));
                    }
                }
                catch (SecurityException e) {
                    if (cleanupStatus != null) break block12;
                    cleanupStatus = AStatus.error("Cannot reset system properties: " + e);
                }
            }
            AStatus stat = ActionHelper.redirectOutput(this.stdOut, this.stdErr);
            if (cleanupStatus == null && !stat.isPassed()) {
                cleanupStatus = stat;
            }
            if (this.locale != Locale.getDefault()) {
                Locale.setDefault(this.locale);
            }
            return cleanupStatus != null ? cleanupStatus : status;
        }

        private /* synthetic */ Object lambda$restore$1(Provider[] sp) {
            for (Provider p : sp) {
                Security.removeProvider(p.getName());
            }
            for (Provider p : this.securityProviders) {
                Security.addProvider(p);
            }
            return null;
        }
    }
}

