/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java;

import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Factory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.ClassSource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.ClasspathResourceSource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.FileEncoding;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.HeapSize;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.JavaVersion;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.MethodSource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.PackageSource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.Throwable;

public class JavaFactory {
    private JavaFactory() {
    }

    public static Factory<JavaVersion> javaVersion(String version) {
        return context -> new JavaVersion(context, version);
    }

    public static Factory<FileEncoding> fileEncoding(String fileEncoding) {
        return context -> new FileEncoding(context, fileEncoding);
    }

    public static Factory<HeapSize> heapSize() {
        return HeapSize::new;
    }

    public static Factory<ClassSource> classSource(String className) {
        return context -> new ClassSource(context).withClassName(className);
    }

    public static Factory<MethodSource> methodSource(String className, String methodName) {
        return context -> new MethodSource(context).withClassName(className).withMethodName(methodName);
    }

    public static Factory<ClasspathResourceSource> classpathResourceSource(String resourceName) {
        return context -> new ClasspathResourceSource(context).withResourceName(resourceName);
    }

    public static Factory<PackageSource> packageSource(String packageName) {
        return context -> new PackageSource(context).withName(packageName);
    }

    public static Factory<Throwable> throwable(java.lang.Throwable throwable) {
        return context -> new Throwable(context).withThrowable(throwable);
    }
}

