/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Element;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Factory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Attachments;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.CpuCores;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Data;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.DirectorySource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.FilePosition;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.FileSource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.HostName;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Infrastructure;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Metadata;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.OperatingSystem;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Reason;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Result;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Sources;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Tag;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Tags;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.UriSource;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.UserName;

public class CoreFactory {
    private CoreFactory() {
    }

    public static Factory<Infrastructure> infrastructure() {
        return Infrastructure::new;
    }

    public static Factory<HostName> hostName(String hostName) {
        return context -> new HostName(context, hostName);
    }

    public static Factory<UserName> userName(String userName) {
        return context -> new UserName(context, userName);
    }

    public static Factory<OperatingSystem> operatingSystem(String osName) {
        return context -> new OperatingSystem(context, osName);
    }

    public static Factory<CpuCores> cpuCores(int cpuCores) {
        return context -> new CpuCores(context, cpuCores);
    }

    public static Factory<Sources> sources() {
        return Sources::new;
    }

    public static Factory<Metadata> metadata() {
        return Metadata::new;
    }

    public static Factory<Tags> tags() {
        return Tags::new;
    }

    public static Factory<Tag> tag(String value) {
        return context -> new Tag(context, value);
    }

    public static Factory<Attachments> attachments() {
        return Attachments::new;
    }

    public static Factory<Data> data() {
        return Data::new;
    }

    public static Factory<Result> result(Result.Status status) {
        return context -> new Result(context).withStatus(status);
    }

    public static Factory<Reason> reason(String reason) {
        return context -> new Reason(context, reason);
    }

    public static Factory<FileSource> fileSource(File file) {
        return context -> new FileSource(context).withPath(file);
    }

    public static Factory<DirectorySource> directorySource(File dir) {
        return context -> new DirectorySource(context).withPath(dir);
    }

    public static Factory<UriSource> uriSource(URI uri) {
        return context -> new UriSource(context).withUri(uri);
    }

    public static <P extends Element<P>> Factory<FilePosition<P>> filePosition(int line, Optional<Integer> column) {
        return context -> {
            FilePosition filePosition = new FilePosition(context);
            filePosition.withAttribute(FilePosition.LINE, String.valueOf(line));
            column.ifPresent(value -> filePosition.withAttribute(FilePosition.COLUMN, value.toString()));
            return filePosition;
        };
    }
}

