/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class RecordData
extends Indenter {
    private final ClassData cls;
    private List<Component> components;

    public RecordData(ClassData cls) {
        this.cls = cls;
    }

    public RecordData read(DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        TraceUtils.traceln("components=" + count);
        this.components = new ArrayList<Component>(count);
        for (int i = 0; i < count; ++i) {
            this.components.add(new Component(this.cls).read(in));
        }
        return this;
    }

    public void print() throws IOException {
        int count = this.components.size();
        if (count > 0) {
            this.cls.out.println(this.getIndentString() + JasmTokens.Token.RECORD.parseKey() + this.getIndentString() + JasmTokens.Token.LBRACE.parseKey());
            for (int i = 0; i < count; ++i) {
                Component cn = this.components.get(i);
                cn.setIndent(this.indent() * 2);
                if (i != 0 && cn.getAnnotationsCount() > 0) {
                    cn.out.println();
                }
                cn.print();
            }
            this.cls.out.println(this.getIndentString() + JasmTokens.Token.RBRACE.parseKey());
            this.cls.out.println();
        }
    }

    private class Component
    extends MemberData {
        private int name_cpx;
        private int type_cpx;

        public Component(ClassData cls) {
            super(cls);
            this.memberType = "RecordData";
        }

        @Override
        protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
            boolean handled = true;
            switch (attrtag) {
                case ATT_Signature: {
                    if (this.signature != null) {
                        TraceUtils.traceln("Record attribute:  more than one attribute Signature are in component.attribute_info_attributes[attribute_count]");
                        TraceUtils.traceln("Last one will be used.");
                    }
                    this.signature = new SignatureData(this.cls).read(in, attrlen);
                    break;
                }
                default: {
                    handled = false;
                }
            }
            return handled;
        }

        public Component read(DataInputStream in) throws IOException {
            this.name_cpx = in.readUnsignedShort();
            this.type_cpx = in.readUnsignedShort();
            TraceUtils.traceln(2, "RecordComponent: name[" + this.name_cpx + "]=" + this.cls.pool.getString(this.name_cpx) + " descriptor[" + this.type_cpx + "]=" + this.cls.pool.getString(this.type_cpx));
            this.readAttributes(in);
            return this;
        }

        @Override
        public void print() throws IOException {
            super.printAnnotations(this.getIndentString());
            StringBuilder bodyPrefix = new StringBuilder(this.getIndentString());
            StringBuilder tailPrefix = new StringBuilder();
            if (this.isSynthetic) {
                bodyPrefix.append(JasmTokens.Token.SYNTHETIC.parseKey()).append(' ');
            }
            if (this.isDeprecated) {
                bodyPrefix.append(JasmTokens.Token.DEPRECATED.parseKey()).append(' ');
            }
            bodyPrefix.append(JasmTokens.Token.COMPONENT.parseKey()).append(' ');
            this.printVar(bodyPrefix, tailPrefix, this.name_cpx, this.type_cpx);
        }
    }
}

