/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.Options;

class InnerClassData
extends Indenter {
    ClassData cls;
    int inner_class_info_index;
    int outer_class_info_index;
    int inner_name_index;
    int access;

    public InnerClassData(ClassData cls) {
        this.cls = cls;
    }

    public void read(DataInputStream in) throws IOException {
        this.inner_class_info_index = in.readUnsignedShort();
        this.outer_class_info_index = in.readUnsignedShort();
        this.inner_name_index = in.readUnsignedShort();
        this.access = in.readUnsignedShort();
    }

    public void print() throws IOException {
        boolean pr_cpx = Options.OptionObject().contains(Options.PR.CPX);
        this.cls.out.print(this.getIndentString() + Modifiers.accessString(this.access, Tables.CF_Context.CTX_INNERCLASS));
        this.cls.out.print("InnerClass ");
        if (pr_cpx) {
            if (this.inner_name_index != 0) {
                this.cls.out.print("#" + this.inner_name_index + "= ");
            }
            this.cls.out.print("#" + this.inner_class_info_index);
            if (this.outer_class_info_index != 0) {
                this.cls.out.print(" of #" + this.outer_class_info_index);
            }
            this.cls.out.print("; // ");
        }
        if (this.inner_name_index != 0) {
            this.cls.out.print(this.cls.pool.getName(this.inner_name_index) + "=");
        }
        if (this.inner_class_info_index != 0) {
            this.cls.pool.PrintConstant(this.cls.out, this.inner_class_info_index);
        }
        if (this.outer_class_info_index != 0) {
            this.cls.out.print(" of ");
            this.cls.pool.PrintConstant(this.cls.out, this.outer_class_info_index);
        }
        if (pr_cpx) {
            this.cls.out.println();
        } else {
            this.cls.out.println(";");
        }
    }
}

