/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class FieldData
extends MemberData {
    protected int name_cpx;
    protected int type_cpx;
    protected int value_cpx = 0;

    public FieldData(ClassData cls) {
        super(cls);
        this.memberType = "FieldData";
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        boolean handled = true;
        switch (attrtag) {
            case ATT_Signature: {
                if (this.signature != null) {
                    TraceUtils.traceln("Record attribute:  more than one attribute Signature are in component.attribute_info_attributes[attribute_count]");
                    TraceUtils.traceln("Last one will be used.");
                }
                this.signature = new SignatureData(this.cls).read(in, attrlen);
                break;
            }
            case ATT_ConstantValue: {
                if (attrlen != 2) {
                    throw new ClassFormatError(String.format("%s: Invalid attribute length #%d", Tables.AttrTag.ATT_ConstantValue.printval(), attrlen));
                }
                this.value_cpx = in.readUnsignedShort();
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.type_cpx = in.readUnsignedShort();
        this.readAttributes(in);
        TraceUtils.traceln(2, String.format("FieldData: name[%d]=%s type[%d]=%s%s", this.name_cpx, this.cls.pool.getString(this.name_cpx), this.type_cpx, this.cls.pool.getString(this.type_cpx), this.signature != null ? this.signature : ""));
    }

    @Override
    public void print() throws IOException {
        super.printAnnotations(this.getIndentString());
        StringBuilder bodyPrefix = new StringBuilder(this.getIndentString()).append(Modifiers.accessString(this.access, Tables.CF_Context.CTX_FIELD));
        StringBuilder tailPrefix = new StringBuilder();
        if (this.isSynthetic) {
            bodyPrefix.append(JasmTokens.Token.SYNTHETIC.parseKey()).append(' ');
        }
        if (this.isDeprecated) {
            bodyPrefix.append(JasmTokens.Token.DEPRECATED.parseKey()).append(' ');
        }
        bodyPrefix.append(JasmTokens.Token.FIELDREF.parseKey()).append(' ');
        if (this.value_cpx != 0) {
            tailPrefix.append("\t= ").append(this.cls.pool.ConstantStrValue(this.value_cpx));
        }
        this.printVar(bodyPrefix, tailPrefix, this.name_cpx, this.type_cpx);
    }
}

