/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.common.Tool;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.FieldData;
import org.openjdk.asmtools.jdis.InnerClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.ModuleData;
import org.openjdk.asmtools.jdis.NestHostData;
import org.openjdk.asmtools.jdis.NestMembersData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.PermittedSubclassesData;
import org.openjdk.asmtools.jdis.RecordData;
import org.openjdk.asmtools.jdis.TextLines;
import org.openjdk.asmtools.jdis.TraceUtils;

public class ClassData
extends MemberData {
    protected Tool tool;
    protected int minor_version;
    protected int major_version;
    protected int this_cpx;
    protected int super_cpx;
    protected int source_cpx = 0;
    protected ConstantPool pool;
    protected int[] interfaces;
    protected ArrayList<FieldData> fields;
    protected ArrayList<MethodData> methods;
    protected RecordData record;
    protected ArrayList<InnerClassData> innerClasses;
    protected ArrayList<BootstrapMethodData> bootstrapMethods;
    protected ModuleData moduleData;
    protected NestHostData nestHost;
    protected NestMembersData nestMembers;
    protected PermittedSubclassesData permittedSubclassesData;
    protected PrintWriter out;
    protected String pkgPrefix = "";
    private TextLines sourceLines = null;
    private Path classFile = null;

    public ClassData(PrintWriter out, Tool tool) {
        this.out = out;
        this.tool = tool;
        this.memberType = "ClassData";
        TraceUtils.traceln("printOptions=" + this.options.toString());
        this.pool = new ConstantPool(this);
        this.init(this);
    }

    public void read(File in) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(in));){
            this.read(dis);
        }
        this.classFile = in.toPath();
    }

    public void read(String in) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(in));){
            this.read(dis);
        }
        this.classFile = Paths.get(in, new String[0]);
    }

    protected void readFields(DataInputStream in) throws IOException {
        int nfields = in.readUnsignedShort();
        TraceUtils.traceln("nfields=" + nfields);
        this.fields = new ArrayList(nfields);
        for (int k = 0; k < nfields; ++k) {
            FieldData field = new FieldData(this);
            TraceUtils.traceln("  FieldData: #" + k);
            field.read(in);
            this.fields.add(field);
        }
    }

    protected void readMethods(DataInputStream in) throws IOException {
        int nmethods = in.readUnsignedShort();
        TraceUtils.traceln("nmethods=" + nmethods);
        this.methods = new ArrayList(nmethods);
        for (int k = 0; k < nmethods; ++k) {
            MethodData method = new MethodData(this);
            TraceUtils.traceln("  MethodData: #" + k);
            method.read(in);
            this.methods.add(method);
        }
    }

    protected void readInterfaces(DataInputStream in) throws IOException {
        int numinterfaces = in.readUnsignedShort();
        TraceUtils.traceln("numinterfaces=" + numinterfaces);
        this.interfaces = new int[numinterfaces];
        for (int i = 0; i < numinterfaces; ++i) {
            short intrf_cpx = in.readShort();
            TraceUtils.traceln("  intrf_cpx[" + i + "]=" + intrf_cpx);
            this.interfaces[i] = intrf_cpx;
        }
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        boolean handled = true;
        switch (attrtag) {
            case ATT_SourceFile: {
                if (attrlen != 2) {
                    throw new ClassFormatError("ATT_SourceFile: Invalid attribute length");
                }
                this.source_cpx = in.readUnsignedShort();
                break;
            }
            case ATT_InnerClasses: {
                int num1 = in.readUnsignedShort();
                if (2 + num1 * 8 != attrlen) {
                    throw new ClassFormatError("ATT_InnerClasses: Invalid attribute length");
                }
                this.innerClasses = new ArrayList(num1);
                for (int j = 0; j < num1; ++j) {
                    InnerClassData innerClass = new InnerClassData(this);
                    innerClass.read(in);
                    this.innerClasses.add(innerClass);
                }
                break;
            }
            case ATT_BootstrapMethods: {
                int num2 = in.readUnsignedShort();
                this.bootstrapMethods = new ArrayList(num2);
                for (int j = 0; j < num2; ++j) {
                    BootstrapMethodData bsmData = new BootstrapMethodData(this);
                    bsmData.read(in);
                    this.bootstrapMethods.add(bsmData);
                }
                break;
            }
            case ATT_Module: {
                this.moduleData = new ModuleData(this);
                this.moduleData.read(in);
                break;
            }
            case ATT_NestHost: {
                this.nestHost = new NestHostData(this).read(in, attrlen);
                break;
            }
            case ATT_NestMembers: {
                this.nestMembers = new NestMembersData(this).read(in, attrlen);
                break;
            }
            case ATT_Record: {
                this.record = new RecordData(this).read(in);
                break;
            }
            case ATT_PermittedSubclasses: {
                this.permittedSubclassesData = new PermittedSubclassesData(this).read(in, attrlen);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    private void read(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("wrong magic: " + HexUtils.toHex(magic) + ", expected " + HexUtils.toHex(-889275714));
        }
        this.minor_version = in.readUnsignedShort();
        this.major_version = in.readUnsignedShort();
        this.pool.read(in);
        this.access = in.readUnsignedShort();
        this.this_cpx = in.readUnsignedShort();
        this.super_cpx = in.readUnsignedShort();
        TraceUtils.traceln("access=" + this.access + " " + Modifiers.accessString(this.access, Tables.CF_Context.CTX_INNERCLASS) + " this_cpx=" + this.this_cpx + " super_cpx=" + this.super_cpx);
        this.readInterfaces(in);
        this.readFields(in);
        this.readMethods(in);
        this.readAttributes(in);
        TraceUtils.traceln("", "<< Reading is done >>", "");
    }

    public String getSrcLine(int lnum) {
        String line;
        if (this.sourceLines == null) {
            return null;
        }
        try {
            line = this.sourceLines.getLine(lnum);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            line = "Line number " + lnum + " is out of bounds";
        }
        return line;
    }

    private <T extends AnnotationData> void printAnnotations(List<T> annotations) {
        if (annotations != null) {
            for (AnnotationData ad : annotations) {
                ad.print(this.out, "");
                this.out.println();
            }
        }
    }

    @Override
    public void print() throws IOException {
        int l;
        ConstantPool.Constant this_const;
        String className = "";
        String sourceName = null;
        if (this.isModuleUnit()) {
            this.printAnnotations(this.visibleAnnotations);
            this.printAnnotations(this.invisibleAnnotations);
        } else {
            className = this.pool.getClassName(this.this_cpx);
            int pkgPrefixLen = className.lastIndexOf("/") + 1;
            if (className.endsWith("package-info")) {
                this.printAnnotations(this.visibleAnnotations);
                this.printAnnotations(this.invisibleAnnotations);
                this.printAnnotations(this.visibleTypeAnnotations);
                this.printAnnotations(this.invisibleTypeAnnotations);
                if (pkgPrefixLen != 0) {
                    this.pkgPrefix = className.substring(0, pkgPrefixLen);
                    this.out.print("package  " + this.pkgPrefix.substring(0, pkgPrefixLen - 1) + " ");
                    this.out.print("version " + this.major_version + ":" + this.minor_version + ";");
                }
                this.out.println();
                return;
            }
            if (pkgPrefixLen != 0) {
                this.pkgPrefix = className.substring(0, pkgPrefixLen);
                this.out.println("package  " + this.pkgPrefix.substring(0, pkgPrefixLen - 1) + ";");
                className = this.pool.getShortClassName(this.this_cpx, this.pkgPrefix);
            }
            this.out.println();
            this.printAnnotations(this.visibleAnnotations);
            this.printAnnotations(this.invisibleAnnotations);
            this.printAnnotations(this.visibleTypeAnnotations);
            this.printAnnotations(this.invisibleTypeAnnotations);
            if ((this.access & 0x20) != 0) {
                this.out.print("super ");
                this.access &= 0xFFFFFFDF;
            }
        }
        if ((this.access & 0x400) != 0 && (this.access & 0x200) != 0 && !this.options.contains(Options.PR.CPX) && this.this_cpx != 0 && (this_const = this.pool.getConst(this.this_cpx)) != null && this_const.tag == ConstantPool.TAG.CONSTANT_CLASS) {
            this.out.print(Modifiers.accessString(this.access & 0xFFFFFBFF, Tables.CF_Context.CTX_CLASS));
            if (this.isSynthetic) {
                this.out.print("synthetic ");
            }
            if (this.isDeprecated) {
                this.out.print("deprecated ");
            }
            this.out.print(" " + this.pool.getShortClassName(this.this_cpx, this.pkgPrefix));
        } else if (this.isModuleUnit()) {
            this.out.print(this.moduleData.getModuleHeader());
        } else {
            this.out.print(Modifiers.accessString(this.access, Tables.CF_Context.CTX_CLASS));
            if (this.isSynthetic) {
                this.out.print("synthetic ");
            }
            if (this.isDeprecated) {
                this.out.print("deprecated ");
            }
            if (this.options.contains(Options.PR.CPX)) {
                this.out.print("\t#" + this.this_cpx + " //");
            }
            this.pool.PrintConstant(this.out, this.this_cpx);
        }
        this.out.println();
        if (!this.isModuleUnit() && !this.pool.getClassName(this.super_cpx).equals("java/lang/Object")) {
            this.out.print("\textends ");
            this.pool.printlnClassId(this.out, this.super_cpx);
            this.out.println();
        }
        if ((l = this.interfaces.length) > 0) {
            for (int k = 0; k < l; ++k) {
                if (k == 0) {
                    this.out.print("\timplements ");
                } else {
                    this.out.print("\t\t ");
                }
                boolean printComma = l > 1 && k < l - 1;
                this.pool.printlnClassId(this.out, this.interfaces[k], printComma);
                this.out.println();
            }
        }
        this.out.println("\tversion " + this.major_version + ":" + this.minor_version);
        this.out.println("{");
        if (this.options.contains(Options.PR.SRC) && this.source_cpx != 0 && (sourceName = this.pool.getString(this.source_cpx)) != null) {
            this.sourceLines = new TextLines(this.classFile.getParent(), sourceName);
        }
        if (this.options.contains(Options.PR.CP)) {
            this.pool.print(this.out);
        }
        if (!this.isModuleUnit()) {
            this.printMemberDataList(this.fields);
            this.printMemberDataList(this.methods);
            if (this.record != null) {
                this.record.print();
            }
            if (this.permittedSubclassesData != null) {
                this.permittedSubclassesData.print();
            }
            if (this.nestHost != null) {
                this.nestHost.print();
            }
            if (this.nestMembers != null) {
                this.nestMembers.print();
            }
            if (this.innerClasses != null && !this.innerClasses.isEmpty()) {
                for (InnerClassData icd : this.innerClasses) {
                    icd.print();
                }
                this.out.println();
            }
            if (this.options.contains(Options.PR.CPX) && this.bootstrapMethods != null && !this.bootstrapMethods.isEmpty()) {
                for (BootstrapMethodData bsmdd : this.bootstrapMethods) {
                    bsmdd.print();
                }
                this.out.println();
            }
            this.out.println(String.format("} // end Class %s%s", className, sourceName != null ? " compiled from \"" + sourceName + "\"" : ""));
        } else {
            this.moduleData.print();
            this.out.print("} // end Module ");
            this.out.print(this.moduleData.getModuleName());
            if (this.moduleData.getModuleVersion() != null) {
                this.out.print(" @" + this.moduleData.getModuleVersion());
            }
            this.out.println();
        }
        List<IOException> issues = this.getIssues();
        if (!issues.isEmpty()) {
            throw issues.get(0);
        }
    }

    private boolean isModuleUnit() {
        return this.moduleData != null;
    }

    private void printMemberDataList(List<? extends MemberData> list) throws IOException {
        int count;
        if (list != null && (count = list.size()) > 0) {
            for (int i = 0; i < count; ++i) {
                MemberData md = list.get(i);
                md.setIndent(2);
                if (i != 0 && md.getAnnotationsCount() > 0) {
                    this.out.println();
                }
                md.print();
            }
            this.out.println();
        }
    }

    private List<IOException> getIssues() {
        return this.pool.pool.stream().filter(Objects::nonNull).filter(c -> c.getIssue() != null).map(ConstantPool.Constant::getIssue).collect(Collectors.toList());
    }
}

