/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class AttrData {
    int name_cpx;
    byte[] data;
    ClassData cls;

    public AttrData(ClassData cls) {
        this.cls = cls;
    }

    public static int attributeTag(String tagname) {
        int intgr = Tables.attrtagValue(tagname);
        if (intgr == 0) {
            return -1;
        }
        return intgr;
    }

    public void read(int name_cpx, int attrlen, DataInputStream in) throws IOException {
        this.name_cpx = name_cpx;
        this.data = new byte[attrlen];
        TraceUtils.traceln(String.format("AttrData:#%d len=%d", name_cpx, attrlen));
        in.readFully(this.data);
    }
}

