/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcdec;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jcoder.JcodTokens;
import org.openjdk.asmtools.jdis.uEscWriter;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main {
    String program;
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    PrintWriter out;
    boolean DebugFlag = false;
    boolean printDetails = false;
    int shift = 0;
    private static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final int EXPORT_MAGIC = 16435934;
    static final int HEADER_MAGIC = -557121555;
    static String[] compNames = new String[]{"Header", "Directory", "Applet", "Import", "ConstantPool", "Class", "Method", "StaticField", "RefLocation", "Export", "Descriptor"};
    String[] cPoolStrings;
    ArrayList<Integer> methodsLengths = null;
    ArrayList<Integer> methodsOffsets = null;
    static String[] refNames = new String[]{"Classref", "InstanceFieldref", "VirtualMethodref", "SuperMethodref", "StaticFieldref", "StaticMethodref"};

    static String toHex(long val, int width) {
        StringBuffer s = new StringBuffer();
        for (int i = width * 2 - 1; i >= 0; --i) {
            s.append(hexTable[(int)(val >> 4 * i) & 0xF]);
        }
        return "0x" + s.toString();
    }

    static String toHex(long val) {
        int width;
        for (width = 8; width > 0 && val >> (width - 1) * 8 == 0L; --width) {
        }
        return Main.toHex(val, width);
    }

    void printByteHex(PrintWriter out, int b) {
        out.print(hexTable[b >> 4 & 0xF]);
        out.print(hexTable[b & 0xF]);
    }

    void out_begin(String s) {
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.println(s);
        ++this.shift;
    }

    void out_print(String s) {
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.print(s);
    }

    void out_println(String s) {
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.println(s);
    }

    void out_end(String s) {
        --this.shift;
        for (int i = 0; i < this.shift; ++i) {
            this.out.print("  ");
        }
        this.out.println(s);
    }

    String startArray(int length) {
        return "[" + (this.printDetails ? Integer.toString(length) : "") + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printBytes(DataInputStream in, int len) throws IOException {
        try {
            for (int i = 0; i < len; ++i) {
                if (i % 8 == 0) {
                    this.out_print("0x");
                }
                this.printByteHex(this.out, in.readByte());
                if (i % 8 != 7) continue;
                this.out.println(";");
            }
        }
        finally {
            if (len % 8 != 0) {
                this.out.println(";");
            }
        }
    }

    static String compName(int compNum) {
        try {
            return compNames[compNum - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "tag " + compNum + "???";
        }
    }

    void decodeAttr(DataInputStream in) throws IOException {
        int name_cpx = in.readUnsignedShort();
        int len = in.readInt();
        String AttrName = null;
        String endingComment = "Attr(#" + name_cpx + ")";
        try {
            endingComment = AttrName = this.cPoolStrings[name_cpx];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (this.printDetails) {
            this.out_begin("Attr(#" + name_cpx + ", " + len + ") { // " + AttrName);
        } else {
            this.out_begin("Attr(#" + name_cpx + ") { // " + AttrName);
        }
        if (AttrName == null) {
            this.printBytes(in, len);
        } else if (AttrName.equals("ConstantValue")) {
            if (len != 2) {
                this.out_println("// invalid length of ConstantValue attr: " + len + " (should be 2)");
                this.printBytes(in, len);
            } else {
                this.out_println("#" + in.readUnsignedShort() + ";");
            }
        } else {
            this.printBytes(in, len);
        }
        this.out_end("} // end " + endingComment);
    }

    void decodeExp(String inpName) throws IOException {
        int k;
        DataInputStream in = new DataInputStream(new FileInputStream(inpName));
        this.out_println("file " + inpName);
        this.out_begin("{  // export file");
        int magic = in.readInt();
        this.out_print(Main.toHex(magic, 4) + ";  // ");
        if (magic != 16435934) {
            this.out.print("wrong magic: 0x" + Integer.toString(16435934, 16) + " expected");
        } else {
            this.out_print("magic");
        }
        this.out.println();
        this.out_println(in.readUnsignedByte() + "b;  // minor version");
        this.out_println(in.readUnsignedByte() + "b;  // major version");
        int cp_count = in.readUnsignedShort();
        this.cPoolStrings = new String[cp_count];
        this.out_begin(this.startArray(cp_count) + " { //  Constant Pool");
        block12: for (int i = 0; i < cp_count; ++i) {
            int tag = in.readUnsignedByte();
            JcodTokens.ConstType tg = JcodTokens.constType(tag);
            switch (tg) {
                case CONSTANT_UTF8: {
                    String s;
                    this.out_print("Utf8 \"");
                    StringBuffer sb = new StringBuffer();
                    this.cPoolStrings[i] = s = in.readUTF();
                    block13: for (k = 0; k < s.length(); ++k) {
                        char c = s.charAt(k);
                        switch (c) {
                            case '\t': {
                                sb.append('\\').append('t');
                                continue block13;
                            }
                            case '\n': {
                                sb.append('\\').append('n');
                                continue block13;
                            }
                            case '\r': {
                                sb.append('\\').append('r');
                                continue block13;
                            }
                            case '\"': {
                                sb.append('\\').append('\"');
                                continue block13;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                    this.out.println(sb.append("\"; // #").append(i).toString());
                    continue block12;
                }
                case CONSTANT_INTEGER: {
                    this.out_println("int " + Main.toHex(in.readInt(), 4) + "; // #" + i);
                    continue block12;
                }
                case CONSTANT_CLASS: {
                    this.out_println("class #" + in.readUnsignedShort() + "; // #" + i);
                    continue block12;
                }
                case CONSTANT_JAVACARD_PACKAGE: {
                    this.out_begin("package { // #" + i);
                    this.out_println(Main.toHex(in.readUnsignedByte(), 1) + ";  // flags");
                    this.out_println("#" + in.readUnsignedShort() + "; // name");
                    this.out_println(in.readUnsignedByte() + "b;  // minor version");
                    this.out_println(in.readUnsignedByte() + "b;  // major version");
                    int aid_len = in.readUnsignedByte();
                    this.out_begin("Bytes" + this.startArray(aid_len) + "b {");
                    this.printBytes(in, aid_len);
                    this.out_end("};");
                    this.out_end("};");
                    continue block12;
                }
                default: {
                    throw new Error("invalid constant type: " + tag);
                }
            }
        }
        this.out_end("} // Constant pool");
        this.out_println("#" + in.readUnsignedShort() + ";  // this package");
        int class_count = in.readUnsignedByte();
        this.out_begin(this.startArray(class_count) + "b { //  classes");
        for (int i = 0; i < class_count; ++i) {
            this.out_begin("{ // class " + i);
            this.out_println(in.readUnsignedByte() + "b; // token");
            int flags = in.readUnsignedShort();
            this.out_print("0x");
            this.printByteHex(this.out, flags >> 8);
            this.printByteHex(this.out, flags);
            this.out.println("; // flags");
            this.out_println("#" + in.readUnsignedShort() + ";  // this class");
            int sup_count = in.readUnsignedShort();
            this.out_begin(this.startArray(sup_count) + " { // supers");
            for (int k2 = 0; k2 < sup_count; ++k2) {
                this.out_println("#" + in.readUnsignedShort() + ";");
            }
            this.out_end("} // supers");
            int int_count = in.readUnsignedByte();
            this.out_begin(this.startArray(int_count) + "b { // interfaces");
            for (k = 0; k < int_count; ++k) {
                this.out_println("#" + in.readUnsignedShort() + ";");
            }
            this.out_end("} // interfaces");
            int field_count = in.readUnsignedShort();
            this.out_begin(this.startArray(field_count) + " { // fields");
            for (int k3 = 0; k3 < field_count; ++k3) {
                this.out_begin("{ // field " + k3);
                this.out_println(in.readUnsignedByte() + "b; // token");
                int f_flags = in.readUnsignedShort();
                this.out_print("0x");
                this.printByteHex(this.out, f_flags >> 8);
                this.printByteHex(this.out, f_flags);
                this.out.println("; // flags");
                this.out_println("#" + in.readUnsignedShort() + ";  // this field name");
                this.out_println("#" + in.readUnsignedShort() + ";  // this field descriptor");
                int attr_count = in.readUnsignedShort();
                this.out_begin(this.startArray(attr_count) + " { // Attributes");
                for (int ai = 0; ai < attr_count; ++ai) {
                    this.decodeAttr(in);
                }
                this.out_end("} // Attributes");
                this.out_end("};");
            }
            this.out_end("} // fields");
            int mth_count = in.readUnsignedShort();
            this.out_begin(this.startArray(mth_count) + " { // methods");
            for (int k4 = 0; k4 < mth_count; ++k4) {
                this.out_begin("{ // method " + k4);
                this.out_println(in.readUnsignedByte() + "b; // token");
                int mth_flags = in.readUnsignedShort();
                this.out_print("0x");
                this.printByteHex(this.out, mth_flags >> 8);
                this.printByteHex(this.out, mth_flags);
                this.out.println("; // flags");
                this.out_println("#" + in.readUnsignedShort() + ";  // this method name");
                this.out_println("#" + in.readUnsignedShort() + ";  // this method descriptor");
                this.out_end("};");
            }
            this.out_end("} // methods");
            this.out_end("};");
        }
        this.out_end("} // classes");
        this.endComponent(in);
    }

    DataInputStream beginComponent(String inpName) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(inpName));
        this.out_println("file " + inpName);
        int tag = in.readUnsignedByte();
        this.out_print("Component(" + tag);
        int size = in.readUnsignedShort();
        if (this.printDetails) {
            this.out.print(", " + size);
        }
        this.out_begin(") { // " + Main.compName(tag));
        return in;
    }

    void endComponent(DataInputStream in) throws IOException {
        this.out_end("};");
        int avail = in.available();
        if (avail > 0) {
            this.out.println("=========== extra bytes:");
            for (int k = 0; k < 8; ++k) {
                this.printBytes(in, avail >= 8 ? 8 : avail);
                avail = in.available();
                if (avail == 0) break;
            }
            if (avail > 0) {
                this.out.println("  there is also " + avail + " bytes available");
            }
        }
        in.close();
    }

    void decodeHeader(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int magic = in.readInt();
        this.out_print(Main.toHex(magic, 4) + ";  // ");
        if (magic != -557121555) {
            this.out.print("wrong magic: 0x" + Integer.toString(-557121555, 16) + " expected");
        } else {
            this.out_print("magic");
        }
        this.out.println();
        this.out_println(in.readUnsignedByte() + "b;  // minor version");
        this.out_println(in.readUnsignedByte() + "b;  // major version");
        this.out_println(Main.toHex(in.readUnsignedByte(), 1) + ";  // flags");
        this.out_begin("{  // package info");
        this.out_println(in.readUnsignedByte() + "b;  // minor version");
        this.out_println(in.readUnsignedByte() + "b;  // major version");
        int aid_len = in.readUnsignedByte();
        this.out_begin("Bytes" + this.startArray(aid_len) + "b {");
        this.printBytes(in, aid_len);
        this.out_end("};");
        this.out_end("};");
        this.endComponent(in);
    }

    void decodeDirectory(String inpName) throws IOException {
        int i;
        DataInputStream in = this.beginComponent(inpName);
        this.out_begin("{  // component sizes");
        for (i = 0; i < 11; ++i) {
            this.out_println(in.readUnsignedShort() + ";  // " + (i + 1));
        }
        this.out_end("};");
        this.out_begin("{  // static field size");
        this.out_println(in.readUnsignedShort() + ";  // image size");
        this.out_println(in.readUnsignedShort() + ";  // array init count");
        this.out_println(in.readUnsignedShort() + ";  // array init size");
        this.out_end("};");
        this.out_println(in.readUnsignedByte() + "b;  // import count");
        this.out_println(in.readUnsignedByte() + "b;  // applet count");
        int custom_count = in.readUnsignedByte();
        this.out_begin(this.startArray(custom_count) + "b { // custom components");
        for (i = 0; i < custom_count; ++i) {
            this.out_print("Comp(" + in.readUnsignedByte());
            int size2 = in.readUnsignedShort();
            if (this.printDetails) {
                this.out_print(", " + size2);
            }
            this.out_begin(") {");
            int aid_len = in.readUnsignedByte();
            this.out_begin("Bytes" + this.startArray(aid_len) + "b {");
            this.printBytes(in, aid_len);
            this.out_end("};");
            this.out_end("};");
        }
        this.out_end("};");
        this.endComponent(in);
    }

    void decodeApplet(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int applet_count = in.readUnsignedByte();
        this.out_begin(this.startArray(applet_count) + "b { // applets");
        for (int i = 0; i < applet_count; ++i) {
            this.out_begin("{ // applet " + i);
            int aid_len = in.readUnsignedByte();
            this.out_begin("Bytes" + this.startArray(aid_len) + "b {");
            this.printBytes(in, aid_len);
            this.out_end("};");
            this.out_println(in.readUnsignedShort() + ";  // install method offset");
            this.out_end("};");
        }
        this.out_end("};");
        this.endComponent(in);
    }

    void decodeImport(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int package_count = in.readUnsignedByte();
        this.out_begin(this.startArray(package_count) + "b { //  packages");
        for (int i = 0; i < package_count; ++i) {
            this.out_begin("{ // package " + i);
            this.out_println(in.readUnsignedByte() + "b;  // minor version");
            this.out_println(in.readUnsignedByte() + "b;  // major version");
            int aid_len = in.readUnsignedByte();
            this.out_begin("Bytes" + this.startArray(aid_len) + "b {");
            this.printBytes(in, aid_len);
            this.out_end("};");
            this.out_end("};");
        }
        this.out_end("};");
        this.endComponent(in);
    }

    void decodeConstantPool(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int items_count = in.readUnsignedShort();
        this.out_begin(this.startArray(items_count) + " { //  items");
        for (int i = 0; i < items_count; ++i) {
            int tag = in.readUnsignedByte();
            int info1 = in.readUnsignedByte();
            int info2 = in.readUnsignedByte();
            int info3 = in.readUnsignedByte();
            this.out_print(tag + "b ");
            if (tag > 0 && tag <= 6) {
                if ((info1 & 0x80) == 0) {
                    if (tag <= 4) {
                        this.out_print((info1 << 8 | info2) + " " + info3 + "b;");
                    } else {
                        this.out_print(info1 + "b " + (info2 << 8 | info3) + ";");
                    }
                    this.out.print(" // internal ");
                } else {
                    this.out.print(info1 + "b " + info2 + "b " + info3 + "b;");
                    this.out.print(" // external ");
                }
                this.out.println(refNames[tag - 1]);
                continue;
            }
            this.out.print(info1 + "b " + info2 + "b " + info3 + "b;");
            this.out.println(" // unknown tag ");
        }
        this.out_end("};");
        this.endComponent(in);
    }

    void printClassref(DataInputStream in) throws IOException {
        int info1 = in.readUnsignedByte();
        int info2 = in.readUnsignedByte();
        if ((info1 & 0x80) == 0) {
            this.out_print((info1 << 8 | info2) + ";");
            this.out_print(" // internal ");
        } else {
            this.out_print(info1 + "b " + info2 + "b;");
            this.out_print(" // external ");
        }
        this.out_println(" Classref ");
    }

    void decodeClass(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int i = 0;
        while (in.available() > 0) {
            this.out_begin("{ // class " + i);
            int bitfield = in.readUnsignedByte();
            int interface_count = bitfield & 0xF;
            this.out_print("0x");
            this.printByteHex(this.out, bitfield);
            this.out.println("; // bitfield");
            if ((bitfield & 0x80) != 0) {
                for (int k = 0; k < interface_count; ++k) {
                    this.printClassref(in);
                }
            } else {
                int k;
                this.printClassref(in);
                this.out_println(in.readUnsignedByte() + "b;  // declared instance size");
                this.out_println(in.readUnsignedByte() + "b;  // first reference token");
                this.out_println(in.readUnsignedByte() + "b;  // reference count");
                this.out_println(in.readUnsignedByte() + "b;  // public method table base");
                int pumrc = in.readUnsignedByte();
                this.out_println(pumrc + "b;  // public method table count");
                this.out_println(in.readUnsignedByte() + "b;  // package method table base");
                int pamrc = in.readUnsignedByte();
                this.out_println(pamrc + "b;  // package method table count");
                this.out_begin("{ // public method table");
                for (k = 0; k < pumrc; ++k) {
                    this.out_println(in.readUnsignedShort() + ";");
                }
                this.out_end("};");
                this.out_begin("{ // package method table");
                for (k = 0; k < pamrc; ++k) {
                    this.out_println(in.readUnsignedShort() + ";");
                }
                this.out_end("};");
                this.out_begin("{ // implemented interfaces");
                for (k = 0; k < interface_count; ++k) {
                    this.out_begin("{ // interface " + k);
                    this.printClassref(in);
                    int count = in.readUnsignedByte();
                    this.out_begin("Bytes" + this.startArray(count) + "b {");
                    this.printBytes(in, count);
                    this.out_end("};");
                    this.out_end("};");
                }
                this.out_end("};");
            }
            this.out_end("};");
            ++i;
        }
        this.endComponent(in);
    }

    void decodeDescriptor(String inpName) throws IOException {
        int i;
        DataInputStream in = this.beginComponent(inpName);
        this.methodsLengths = new ArrayList();
        this.methodsOffsets = new ArrayList();
        int class_count = in.readUnsignedByte();
        this.out_begin(this.startArray(class_count) + "b { // classes");
        for (int c = 0; c < class_count; ++c) {
            int i2;
            this.out_begin("{ // class " + c);
            this.out_println(in.readUnsignedByte() + "b; // token");
            this.out_print("0x");
            this.printByteHex(this.out, in.readUnsignedByte());
            this.out.println("; // flags");
            this.printClassref(in);
            int icount = in.readUnsignedByte();
            this.out_println(icount + "b; // interface count");
            int fcount = in.readUnsignedShort();
            this.out_println(fcount + "; // field count");
            int mcount = in.readUnsignedShort();
            this.out_println(mcount + "; // method count");
            if (icount != 0) {
                this.out_begin("{ // interfaces");
                for (i2 = 0; i2 < icount; ++i2) {
                    this.printClassref(in);
                }
                this.out_end("};");
            }
            for (i2 = 0; i2 < fcount; ++i2) {
                this.out_begin("{ // field " + i2);
                this.out_println(in.readUnsignedByte() + "b; // token");
                int flags = in.readUnsignedByte();
                this.out_print("0x");
                this.printByteHex(this.out, flags);
                this.out.println("; // flags");
                if ((flags & 8) == 0) {
                    this.printClassref(in);
                    this.out_println(in.readUnsignedByte() + "b; // token");
                } else {
                    int info1 = in.readUnsignedByte();
                    int info2 = in.readUnsignedByte();
                    int info3 = in.readUnsignedByte();
                    if ((info1 & 0x80) == 0) {
                        this.out_print(info1 + "b " + (info2 << 8 | info3) + ";");
                        this.out.println(" // internal field");
                    } else {
                        this.out.print(info1 + "b " + info2 + "b " + info3 + "b;");
                        this.out.println(" // external field");
                    }
                }
                int type = in.readUnsignedShort();
                if ((type & 0x8000) == 0) {
                    this.out_println(type + "; // reference type");
                } else {
                    this.out_print("0x");
                    this.printByteHex(this.out, type >> 8);
                    this.printByteHex(this.out, type);
                    this.out.println("; // primitive type");
                }
                this.out_end("};");
            }
            for (i2 = 0; i2 < mcount; ++i2) {
                int token = in.readUnsignedByte();
                int flags = in.readUnsignedByte();
                int m_offset = in.readUnsignedShort();
                int t_offset = in.readUnsignedShort();
                int bytecode_count = in.readUnsignedShort();
                if (m_offset != 0) {
                    this.out_begin("{ // method " + i2 + " (" + this.methodsLengths.size() + ")");
                    this.methodsLengths.add(bytecode_count);
                    this.methodsOffsets.add(m_offset);
                } else {
                    this.out_begin("{ // method " + i2);
                }
                this.out_println(token + "b; // token");
                this.out_print("0x");
                this.printByteHex(this.out, flags);
                this.out.println("; // flags");
                this.out_println(m_offset + "; // method offset");
                this.out_println(t_offset + "; // type offset");
                this.out_println(bytecode_count + "; // bytecode count");
                this.out_println(in.readUnsignedShort() + "; // exception handler count");
                this.out_println(in.readUnsignedShort() + "; // exception handler index");
                this.out_end("};");
            }
            this.out_end("};");
        }
        this.out_end("}; // classes");
        int cp_count = in.readUnsignedShort();
        this.out_begin(this.startArray(cp_count) + " { // constant pool types");
        for (i = 0; i < cp_count; ++i) {
            int type = in.readUnsignedShort();
            if (type == 65535) {
                this.out_println("0xFFFF;");
                continue;
            }
            this.out_println(type + "; ");
        }
        this.out_end("}; // constant pool types");
        this.out_begin("{ // type descriptors");
        i = 0;
        while (in.available() > 0) {
            int nibble_count = in.readUnsignedByte();
            this.out_print(nibble_count + "b; ");
            this.printBytes(in, (nibble_count + 1) / 2);
            ++i;
        }
        this.out_end("}; // type descriptors");
        this.endComponent(in);
    }

    void decodeMethod(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int handler_count = in.readUnsignedByte();
        this.out_begin(this.startArray(handler_count) + "b { // exception handlers");
        for (int i = 0; i < handler_count; ++i) {
            this.out_print(in.readUnsignedShort() + ", ");
            int bitfield = in.readUnsignedShort();
            this.out.print("0x");
            this.printByteHex(this.out, bitfield >> 8);
            this.printByteHex(this.out, bitfield);
            this.out.print(", " + in.readUnsignedShort() + ", ");
            this.out.println(in.readUnsignedShort() + "; // handler " + i);
        }
        this.out_end("};");
        if (this.methodsLengths == null) {
            this.out.println("// Descriptor.cap absent - methods not printed");
        } else {
            int f_offset = 1 + handler_count * 8;
            for (int i = 0; i < this.methodsLengths.size(); ++i) {
                this.out_begin("{ // method " + i);
                int m_offset = this.methodsOffsets.get(i);
                if (m_offset != f_offset) {
                    this.out.println("file offset=" + f_offset + " but m_offset=" + m_offset);
                    break;
                }
                int bitfield = in.readUnsignedByte();
                if ((bitfield & 0x80) == 0) {
                    this.out_print("0x");
                    this.printByteHex(this.out, bitfield);
                    this.out.println("; // flags, max_stack");
                    this.out_print("0x");
                    this.printByteHex(this.out, in.readUnsignedByte());
                    this.out.println("; // nargs, max_locals");
                    f_offset += 2;
                } else {
                    this.out_print("0x");
                    this.printByteHex(this.out, bitfield);
                    this.out.println("; // flags, padding");
                    this.out_println(in.readUnsignedByte() + "b; // max_stack");
                    this.out_println(in.readUnsignedByte() + "b; // nargs");
                    this.out_println(in.readUnsignedByte() + "b; // max_locals");
                    f_offset += 4;
                }
                int bytecode_count = this.methodsLengths.get(i);
                this.out_begin("{ // bytecodes");
                this.printBytes(in, bytecode_count);
                f_offset += bytecode_count;
                this.out_end("};");
                this.out_end("};");
            }
        }
        this.endComponent(in);
    }

    void decodeStaticField(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int image_size = in.readUnsignedShort();
        this.out_println(image_size + "; // image size");
        int reference_count = in.readUnsignedShort();
        this.out_println(reference_count + "; // reference count");
        int array_init_count = in.readUnsignedShort();
        this.out_begin(this.startArray(array_init_count) + " { // array_init_info");
        for (int i = 0; i < array_init_count; ++i) {
            this.out_println(in.readUnsignedByte() + "b // type ");
            int count = in.readUnsignedShort();
            this.out_begin("Bytes" + this.startArray(count) + "s { // values");
            this.printBytes(in, count);
            this.out_end("};");
        }
        this.out_end("};");
        int default_value_count = in.readUnsignedShort();
        this.out_println(default_value_count + "; // default value count");
        int non_default_value_count = in.readUnsignedShort();
        this.out_begin("Bytes" + this.startArray(non_default_value_count) + "s { // non default values");
        this.printBytes(in, non_default_value_count);
        this.out_end("};");
        this.endComponent(in);
    }

    void decodeRefLocation(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int byte_index_count = in.readUnsignedShort();
        this.out_begin("Bytes" + this.startArray(byte_index_count) + "s { // offsets to byte indices");
        this.printBytes(in, byte_index_count);
        this.out_end("};");
        byte_index_count = in.readUnsignedShort();
        this.out_begin("Bytes" + this.startArray(byte_index_count) + "s { // offsets to byte2 indices");
        this.printBytes(in, byte_index_count);
        this.out_end("};");
        this.endComponent(in);
    }

    void decodeExport(String inpName) throws IOException {
        DataInputStream in = this.beginComponent(inpName);
        int class_count = in.readUnsignedByte();
        this.out_begin(this.startArray(class_count) + "b { // classes");
        for (int i = 0; i < class_count; ++i) {
            int j;
            this.out_begin("{ // class " + i);
            this.out_println(in.readUnsignedShort() + "; // class offset");
            int fcount = in.readUnsignedByte();
            this.out_println(fcount + "b; // static field count");
            int mcount = in.readUnsignedByte();
            this.out_println(mcount + "b; // static method count");
            this.out_begin("{ // static field offsets");
            for (j = 0; j < fcount; ++j) {
                this.out_println(in.readUnsignedShort() + "; // field " + j + " offset");
            }
            this.out_end("};");
            this.out_begin("{ // static method offsets");
            for (j = 0; j < mcount; ++j) {
                this.out_println(in.readUnsignedShort() + "; // method " + j + " offset");
            }
            this.out_end("};");
            this.out_end("};");
        }
        this.out_end("};");
        this.endComponent(in);
    }

    public Main(PrintWriter out, String program) {
        this.out = out;
        this.program = program;
    }

    public void error(String msg) {
        this.out.println(this.program + ": " + msg);
    }

    public void usage() {
        this.out.println(i18n.getString("jcdec.usage"));
        this.out.println(i18n.getString("jcdec.opt.g"));
        this.out.println(i18n.getString("jcdec.opt.version"));
    }

    public synchronized boolean decode(String[] argv) {
        long tm = System.currentTimeMillis();
        ArrayList<String> vargs = new ArrayList<String>();
        ArrayList<String> vj = new ArrayList<String>();
        boolean nowrite = false;
        boolean addOptions = false;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-g")) {
                this.printDetails = true;
                vargs.add(arg);
                continue;
            }
            if (arg.equals("-v")) {
                this.DebugFlag = true;
                vargs.add(arg);
                this.out.println("arg[" + i + "]=" + argv[i] + "/verbose");
                continue;
            }
            if (arg.equals("-version")) {
                this.out.println(ProductInfo.FULL_VERSION);
                continue;
            }
            if (arg.startsWith("-")) {
                this.error(i18n.getString("jcdec.error.invalid_flag", (Object)arg));
                this.usage();
                return false;
            }
            vargs.add(arg);
            vj.add(arg);
        }
        if (vj.isEmpty()) {
            this.usage();
            return false;
        }
        String[] names = null;
        names = (String[])vj.toArray(names);
        for (int k = 0; k < names.length; ++k) {
            String inpname = names[k];
            try {
                if (inpname.endsWith(".cap")) {
                    String shortName = inpname.substring(0, inpname.length() - 4);
                    if (shortName.endsWith("Header")) {
                        this.decodeHeader(inpname);
                    } else if (shortName.endsWith("Directory")) {
                        this.decodeDirectory(inpname);
                    } else if (shortName.endsWith("Applet")) {
                        this.decodeApplet(inpname);
                    } else if (shortName.endsWith("Import")) {
                        this.decodeImport(inpname);
                    } else if (shortName.endsWith("ConstantPool")) {
                        this.decodeConstantPool(inpname);
                    } else if (shortName.endsWith("Class")) {
                        this.decodeClass(inpname);
                    } else if (shortName.endsWith("Descriptor")) {
                        this.decodeDescriptor(inpname);
                    } else if (shortName.endsWith("Method")) {
                        this.decodeMethod(inpname);
                    } else if (shortName.endsWith("StaticField")) {
                        this.decodeStaticField(inpname);
                    } else if (shortName.endsWith("RefLocation")) {
                        this.decodeRefLocation(inpname);
                    } else {
                        if (!shortName.endsWith("Export")) continue;
                        this.decodeExport(inpname);
                    }
                    this.out.println("");
                    continue;
                }
                if (!inpname.endsWith(".exp")) continue;
                this.decodeExp(inpname);
                this.out.println("");
                continue;
            }
            catch (FileNotFoundException ee) {
                this.error(i18n.getString("jcdec.error.cannot_read", (Object)inpname));
            }
            catch (Error ee) {
                ee.printStackTrace();
                this.error(i18n.getString("jcdec.error.fatal_error"));
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.error(i18n.getString("jcdec.error.fatal_exception"));
            }
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        Main decoder = new Main(new PrintWriter(new uEscWriter(System.out)), "jcdec");
        System.exit(decoder.decode(argv) ? 0 : 1);
    }
}

