/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.HashMap;

public class OpcodeTables {
    private static final int MaxOpcodes = 301;
    private static HashMap<Integer, Opcode> IntToNormalOpcodes = new HashMap(301);
    private static HashMap<Integer, Opcode> IntToAllOpcodes = new HashMap(301);
    private static HashMap<String, Opcode> mnemocodes = new HashMap(301);
    private static HashMap<Integer, Opcode> IntToPrivOpcode = new HashMap(301);
    private static HashMap<String, Opcode> PrivMnemocodes = new HashMap(301);
    private static HashMap<Integer, Opcode> IntToNonPrivOpcode = new HashMap(301);
    private static HashMap<String, Opcode> NonPrivMnemocodes = new HashMap(301);

    private static void registerOpcode(Opcode opc) {
        IntToAllOpcodes.put(opc.value, opc);
        mnemocodes.put(opc.parsekey, opc);
        if (opc.alias != null) {
            mnemocodes.put(opc.alias, opc);
        }
        if (opc.type == OpcodeType.PRIVELEGED) {
            PrivMnemocodes.put(opc.parsekey, opc);
            IntToPrivOpcode.put(opc.baseVal, opc);
        } else if (opc.type == OpcodeType.NONPRIVELEGED) {
            NonPrivMnemocodes.put(opc.parsekey, opc);
            IntToNonPrivOpcode.put(opc.baseVal, opc);
        }
    }

    public static Opcode opcode(String mnemonic) {
        return mnemocodes.get(mnemonic);
    }

    public static Opcode opcode(Integer mnem_code) {
        return IntToAllOpcodes.get(mnem_code);
    }

    static {
        for (Opcode opc : Opcode.values()) {
            OpcodeTables.registerOpcode(opc);
        }
    }

    public static enum Opcode {
        opc_dead((Integer)-2, " opc_dead", 0),
        opc_label((Integer)-1, "opc_label", 0),
        opc_nop((Integer)0, "nop", 1),
        opc_aconst_null((Integer)1, "aconst_null", 1),
        opc_iconst_m1((Integer)2, "iconst_m1", 1),
        opc_iconst_0((Integer)3, "iconst_0", 1),
        opc_iconst_1((Integer)4, "iconst_1", 1),
        opc_iconst_2((Integer)5, "iconst_2", 1),
        opc_iconst_3((Integer)6, "iconst_3", 1),
        opc_iconst_4((Integer)7, "iconst_4", 1),
        opc_iconst_5((Integer)8, "iconst_5", 1),
        opc_lconst_0((Integer)9, "lconst_0", 1),
        opc_lconst_1((Integer)10, "lconst_1", 1),
        opc_fconst_0((Integer)11, "fconst_0", 1),
        opc_fconst_1((Integer)12, "fconst_1", 1),
        opc_fconst_2((Integer)13, "fconst_2", 1),
        opc_dconst_0((Integer)14, "dconst_0", 1),
        opc_dconst_1((Integer)15, "dconst_1", 1),
        opc_bipush((Integer)16, "bipush", 2),
        opc_sipush((Integer)17, "sipush", 3),
        opc_ldc((Integer)18, "ldc", 2),
        opc_ldc_w((Integer)19, "ldc_w", 3),
        opc_ldc2_w((Integer)20, "ldc2_w", 3),
        opc_iload((Integer)21, "iload", 2),
        opc_lload((Integer)22, "lload", 2),
        opc_fload((Integer)23, "fload", 2),
        opc_dload((Integer)24, "dload", 2),
        opc_aload((Integer)25, "aload", 2),
        opc_iload_0((Integer)26, "iload_0", 1),
        opc_iload_1((Integer)27, "iload_1", 1),
        opc_iload_2((Integer)28, "iload_2", 1),
        opc_iload_3((Integer)29, "iload_3", 1),
        opc_lload_0((Integer)30, "lload_0", 1),
        opc_lload_1((Integer)31, "lload_1", 1),
        opc_lload_2((Integer)32, "lload_2", 1),
        opc_lload_3((Integer)33, "lload_3", 1),
        opc_fload_0((Integer)34, "fload_0", 1),
        opc_fload_1((Integer)35, "fload_1", 1),
        opc_fload_2((Integer)36, "fload_2", 1),
        opc_fload_3((Integer)37, "fload_3", 1),
        opc_dload_0((Integer)38, "dload_0", 1),
        opc_dload_1((Integer)39, "dload_1", 1),
        opc_dload_2((Integer)40, "dload_2", 1),
        opc_dload_3((Integer)41, "dload_3", 1),
        opc_aload_0((Integer)42, "aload_0", 1),
        opc_aload_1((Integer)43, "aload_1", 1),
        opc_aload_2((Integer)44, "aload_2", 1),
        opc_aload_3((Integer)45, "aload_3", 1),
        opc_iaload((Integer)46, "iaload", 1),
        opc_laload((Integer)47, "laload", 1),
        opc_faload((Integer)48, "faload", 1),
        opc_daload((Integer)49, "daload", 1),
        opc_aaload((Integer)50, "aaload", 1),
        opc_baload((Integer)51, "baload", 1),
        opc_caload((Integer)52, "caload", 1),
        opc_saload((Integer)53, "saload", 1),
        opc_istore((Integer)54, "istore", 2),
        opc_lstore((Integer)55, "lstore", 2),
        opc_fstore((Integer)56, "fstore", 2),
        opc_dstore((Integer)57, "dstore", 2),
        opc_astore((Integer)58, "astore", 2),
        opc_istore_0((Integer)59, "istore_0", 1),
        opc_istore_1((Integer)60, "istore_1", 1),
        opc_istore_2((Integer)61, "istore_2", 1),
        opc_istore_3((Integer)62, "istore_3", 1),
        opc_lstore_0((Integer)63, "lstore_0", 1),
        opc_lstore_1((Integer)64, "lstore_1", 1),
        opc_lstore_2((Integer)65, "lstore_2", 1),
        opc_lstore_3((Integer)66, "lstore_3", 1),
        opc_fstore_0((Integer)67, "fstore_0", 1),
        opc_fstore_1((Integer)68, "fstore_1", 1),
        opc_fstore_2((Integer)69, "fstore_2", 1),
        opc_fstore_3((Integer)70, "fstore_3", 1),
        opc_dstore_0((Integer)71, "dstore_0", 1),
        opc_dstore_1((Integer)72, "dstore_1", 1),
        opc_dstore_2((Integer)73, "dstore_2", 1),
        opc_dstore_3((Integer)74, "dstore_3", 1),
        opc_astore_0((Integer)75, "astore_0", 1),
        opc_astore_1((Integer)76, "astore_1", 1),
        opc_astore_2((Integer)77, "astore_2", 1),
        opc_astore_3((Integer)78, "astore_3", 1),
        opc_iastore((Integer)79, "iastore", 1),
        opc_lastore((Integer)80, "lastore", 1),
        opc_fastore((Integer)81, "fastore", 1),
        opc_dastore((Integer)82, "dastore", 1),
        opc_aastore((Integer)83, "aastore", 1),
        opc_bastore((Integer)84, "bastore", 1),
        opc_castore((Integer)85, "castore", 1),
        opc_sastore((Integer)86, "sastore", 1),
        opc_pop((Integer)87, "pop", 1),
        opc_pop2((Integer)88, "pop2", 1),
        opc_dup((Integer)89, "dup", 1),
        opc_dup_x1((Integer)90, "dup_x1", 1),
        opc_dup_x2((Integer)91, "dup_x2", 1),
        opc_dup2((Integer)92, "dup2", 1),
        opc_dup2_x1((Integer)93, "dup2_x1", 1),
        opc_dup2_x2((Integer)94, "dup2_x2", 1),
        opc_swap((Integer)95, "swap", 1),
        opc_iadd((Integer)96, "iadd", 1),
        opc_ladd((Integer)97, "ladd", 1),
        opc_fadd((Integer)98, "fadd", 1),
        opc_dadd((Integer)99, "dadd", 1),
        opc_isub((Integer)100, "isub", 1),
        opc_lsub((Integer)101, "lsub", 1),
        opc_fsub((Integer)102, "fsub", 1),
        opc_dsub((Integer)103, "dsub", 1),
        opc_imul((Integer)104, "imul", 1),
        opc_lmul((Integer)105, "lmul", 1),
        opc_fmul((Integer)106, "fmul", 1),
        opc_dmul((Integer)107, "dmul", 1),
        opc_idiv((Integer)108, "idiv", 1),
        opc_ldiv((Integer)109, "ldiv", 1),
        opc_fdiv((Integer)110, "fdiv", 1),
        opc_ddiv((Integer)111, "ddiv", 1),
        opc_irem((Integer)112, "irem", 1),
        opc_lrem((Integer)113, "lrem", 1),
        opc_frem((Integer)114, "frem", 1),
        opc_drem((Integer)115, "drem", 1),
        opc_ineg((Integer)116, "ineg", 1),
        opc_lneg((Integer)117, "lneg", 1),
        opc_fneg((Integer)118, "fneg", 1),
        opc_dneg((Integer)119, "dneg", 1),
        opc_ishl((Integer)120, "ishl", 1),
        opc_lshl((Integer)121, "lshl", 1),
        opc_ishr((Integer)122, "ishr", 1),
        opc_lshr((Integer)123, "lshr", 1),
        opc_iushr((Integer)124, "iushr", 1),
        opc_lushr((Integer)125, "lushr", 1),
        opc_iand((Integer)126, "iand", 1),
        opc_land((Integer)127, "land", 1),
        opc_ior((Integer)128, "ior", 1),
        opc_lor((Integer)129, "lor", 1),
        opc_ixor((Integer)130, "ixor", 1),
        opc_lxor((Integer)131, "lxor", 1),
        opc_iinc((Integer)132, "iinc", 3),
        opc_i2l((Integer)133, "i2l", 1),
        opc_i2f((Integer)134, "i2f", 1),
        opc_i2d((Integer)135, "i2d", 1),
        opc_l2i((Integer)136, "l2i", 1),
        opc_l2f((Integer)137, "l2f", 1),
        opc_l2d((Integer)138, "l2d", 1),
        opc_f2i((Integer)139, "f2i", 1),
        opc_f2l((Integer)140, "f2l", 1),
        opc_f2d((Integer)141, "f2d", 1),
        opc_d2i((Integer)142, "d2i", 1),
        opc_d2l((Integer)143, "d2l", 1),
        opc_d2f((Integer)144, "d2f", 1),
        opc_i2b((Integer)145, "i2b", 1),
        opc_i2c((Integer)146, "i2c", 1),
        opc_i2s((Integer)147, "i2s", 1),
        opc_lcmp((Integer)148, "lcmp", 1),
        opc_fcmpl((Integer)149, "fcmpl", 1),
        opc_fcmpg((Integer)150, "fcmpg", 1),
        opc_dcmpl((Integer)151, "dcmpl", 1),
        opc_dcmpg((Integer)152, "dcmpg", 1),
        opc_ifeq((Integer)153, "ifeq", 3),
        opc_ifne((Integer)154, "ifne", 3),
        opc_iflt((Integer)155, "iflt", 3),
        opc_ifge((Integer)156, "ifge", 3),
        opc_ifgt((Integer)157, "ifgt", 3),
        opc_ifle((Integer)158, "ifle", 3),
        opc_if_icmpeq((Integer)159, "if_icmpeq", 3),
        opc_if_icmpne((Integer)160, "if_icmpne", 3),
        opc_if_icmplt((Integer)161, "if_icmplt", 3),
        opc_if_icmpge((Integer)162, "if_icmpge", 3),
        opc_if_icmpgt((Integer)163, "if_icmpgt", 3),
        opc_if_icmple((Integer)164, "if_icmple", 3),
        opc_if_acmpeq((Integer)165, "if_acmpeq", 3),
        opc_if_acmpne((Integer)166, "if_acmpne", 3),
        opc_goto((Integer)167, "goto", 3),
        opc_jsr((Integer)168, "jsr", 3),
        opc_ret((Integer)169, "ret", 2),
        opc_tableswitch((Integer)170, "tableswitch", 99),
        opc_lookupswitch((Integer)171, "lookupswitch", 99),
        opc_ireturn((Integer)172, "ireturn", 1),
        opc_lreturn((Integer)173, "lreturn", 1),
        opc_freturn((Integer)174, "freturn", 1),
        opc_dreturn((Integer)175, "dreturn", 1),
        opc_areturn((Integer)176, "areturn", 1),
        opc_return((Integer)177, "return", 1),
        opc_getstatic((Integer)178, "getstatic", 3),
        opc_putstatic((Integer)179, "putstatic", 3),
        opc_getfield((Integer)180, "getfield", 3),
        opc_putfield((Integer)181, "putfield", 3),
        opc_invokevirtual((Integer)182, "invokevirtual", 3),
        opc_invokespecial((Integer)183, "invokespecial", "invokenonvirtual", 3),
        opc_invokestatic((Integer)184, "invokestatic", 3),
        opc_invokeinterface((Integer)185, "invokeinterface", 5),
        opc_invokedynamic((Integer)186, "invokedynamic", 5),
        opc_new((Integer)187, "new", 3),
        opc_newarray((Integer)188, "newarray", 2),
        opc_anewarray((Integer)189, "anewarray", 3),
        opc_arraylength((Integer)190, "arraylength", 1),
        opc_athrow((Integer)191, "athrow", 1),
        opc_checkcast((Integer)192, "checkcast", 3),
        opc_instanceof((Integer)193, "instanceof", 3),
        opc_monitorenter((Integer)194, "monitorenter", 1),
        opc_monitorexit((Integer)195, "monitorexit", 1),
        opc_wide((Integer)196, null, 0),
        opc_multianewarray((Integer)197, "multianewarray", 4),
        opc_ifnull((Integer)198, "ifnull", 3),
        opc_ifnonnull((Integer)199, "ifnonnull", 3),
        opc_goto_w((Integer)200, "goto_w", 5),
        opc_jsr_w((Integer)201, "jsr_w", 5),
        opc_bytecode((Integer)203, "bytecode", 1),
        opc_try((Integer)204, "try", 0),
        opc_endtry((Integer)205, "endtry", 0),
        opc_catch((Integer)206, "catch", 0),
        opc_var((Integer)207, "var", 0),
        opc_endvar((Integer)208, "endvar", 0),
        opc_locals_map((Integer)209, "locals_map", 0),
        opc_stack_map((Integer)210, "stack_map", 0),
        opc_stack_frame_type((Integer)211, "stack_frame_type", 0),
        opc_nonpriv((Integer)254, "priv", 0),
        opc_priv((Integer)255, "nonpriv", 0),
        opc_iload_w(Opcode.opc_iload.value, "iload_w", 4, OpcodeType.WIDE),
        opc_lload_w(Opcode.opc_lload.value, "lload_w", 4, OpcodeType.WIDE),
        opc_fload_w(Opcode.opc_fload.value, "fload_w", 4, OpcodeType.WIDE),
        opc_dload_w(Opcode.opc_dload.value, "dload_w", 4, OpcodeType.WIDE),
        opc_aload_w(Opcode.opc_aload.value, "aload_w", 4, OpcodeType.WIDE),
        opc_istore_w(Opcode.opc_istore.value, "istore_w", 4, OpcodeType.WIDE),
        opc_lstore_w(Opcode.opc_lstore.value, "lstore_w", 4, OpcodeType.WIDE),
        opc_fstore_w(Opcode.opc_fstore.value, "fstore_w", 4, OpcodeType.WIDE),
        opc_dstore_w(Opcode.opc_dstore.value, "dstore_w", 4, OpcodeType.WIDE),
        opc_astore_w(Opcode.opc_astore.value, "astore_w", 4, OpcodeType.WIDE),
        opc_ret_w(Opcode.opc_ret.value, "ret_w", 4, OpcodeType.WIDE),
        opc_iinc_w(Opcode.opc_iinc.value, "iinc_w", 6, OpcodeType.WIDE),
        opc_load_ubyte((Integer)0, "load_ubyte", OpcodeType.NONPRIVELEGED),
        opc_priv_load_ubyte((Integer)0, "priv_load_ubyte", OpcodeType.PRIVELEGED),
        opc_load_byte((Integer)1, "load_byte", OpcodeType.NONPRIVELEGED),
        opc_priv_load_byte((Integer)1, "priv_load_byte", OpcodeType.PRIVELEGED),
        opc_load_char((Integer)2, "load_char", OpcodeType.NONPRIVELEGED),
        opc_priv_load_char((Integer)2, "priv_load_char", OpcodeType.PRIVELEGED),
        opc_load_short((Integer)3, "load_short", OpcodeType.NONPRIVELEGED),
        opc_priv_load_short((Integer)3, "priv_load_short", OpcodeType.PRIVELEGED),
        opc_load_word((Integer)4, "load_word", OpcodeType.NONPRIVELEGED),
        opc_priv_load_word((Integer)4, "priv_load_word", OpcodeType.PRIVELEGED),
        opc_load_char_oe((Integer)10, "load_char_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_load_char_oe((Integer)10, "priv_load_char_oe", OpcodeType.PRIVELEGED),
        opc_load_short_oe((Integer)11, "load_short_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_load_short_oe((Integer)11, "priv_load_short_oe", OpcodeType.PRIVELEGED),
        opc_load_word_oe((Integer)12, "load_word_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_load_word_oe((Integer)12, "priv_load_word_oe", OpcodeType.PRIVELEGED),
        opc_ncload_ubyte((Integer)16, "ncload_ubyte", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_ubyte((Integer)16, "priv_ncload_ubyte", OpcodeType.PRIVELEGED),
        opc_ncload_byte((Integer)17, "ncload_byte", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_byte((Integer)17, "priv_ncload_byte", OpcodeType.PRIVELEGED),
        opc_ncload_char((Integer)18, "ncload_char", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_char((Integer)18, "priv_ncload_char", OpcodeType.PRIVELEGED),
        opc_ncload_short((Integer)19, "ncload_short", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_short((Integer)19, "priv_ncload_short", OpcodeType.PRIVELEGED),
        opc_ncload_word((Integer)20, "ncload_word", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_word((Integer)20, "priv_ncload_word", OpcodeType.PRIVELEGED),
        opc_ncload_char_oe((Integer)26, "ncload_char_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_char_oe((Integer)26, "priv_ncload_char_oe", OpcodeType.PRIVELEGED),
        opc_ncload_short_oe((Integer)27, "ncload_short_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_short_oe((Integer)27, "priv_ncload_short_oe", OpcodeType.PRIVELEGED),
        opc_ncload_word_oe((Integer)28, "ncload_word_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_ncload_word_oe((Integer)28, "priv_ncload_word_oe", OpcodeType.PRIVELEGED),
        opc_cache_flush((Integer)30, "cache_flush", OpcodeType.NONPRIVELEGED),
        opc_priv_cache_flush((Integer)30, "priv_cache_flush", OpcodeType.PRIVELEGED),
        opc_store_byte((Integer)32, "store_byte", OpcodeType.NONPRIVELEGED),
        opc_priv_store_byte((Integer)32, "priv_store_byte", OpcodeType.PRIVELEGED),
        opc_store_short((Integer)34, "store_short", OpcodeType.NONPRIVELEGED),
        opc_priv_store_short((Integer)34, "priv_store_short", OpcodeType.PRIVELEGED),
        opc_store_word((Integer)36, "store_word", OpcodeType.NONPRIVELEGED),
        opc_priv_store_word((Integer)36, "priv_store_word", OpcodeType.PRIVELEGED),
        opc_store_short_oe((Integer)42, "store_short_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_store_short_oe((Integer)42, "priv_store_short_oe", OpcodeType.PRIVELEGED),
        opc_store_word_oe((Integer)44, "store_word_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_store_word_oe((Integer)44, "priv_store_word_oe", OpcodeType.PRIVELEGED),
        opc_ncstore_byte((Integer)48, "ncstore_byte", OpcodeType.NONPRIVELEGED),
        opc_priv_ncstore_byte((Integer)48, "priv_ncstore_byte", OpcodeType.PRIVELEGED),
        opc_ncstore_short((Integer)50, "ncstore_short", OpcodeType.NONPRIVELEGED),
        opc_priv_ncstore_short((Integer)50, "priv_ncstore_short", OpcodeType.PRIVELEGED),
        opc_ncstore_word((Integer)52, "ncstore_word", OpcodeType.NONPRIVELEGED),
        opc_priv_ncstore_word((Integer)52, "priv_ncstore_word", OpcodeType.PRIVELEGED),
        opc_ncstore_short_oe((Integer)58, "ncstore_short_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_ncstore_short_oe((Integer)58, "priv_ncstore_short_oe", OpcodeType.PRIVELEGED),
        opc_ncstore_word_oe((Integer)60, "ncstore_word_oe", OpcodeType.NONPRIVELEGED),
        opc_priv_ncstore_word_oe((Integer)60, "priv_ncstore_word_oe", OpcodeType.PRIVELEGED),
        opc_zero_line((Integer)62, "zero_line", OpcodeType.NONPRIVELEGED),
        opc_priv_zero_line((Integer)62, "priv_zero_line", OpcodeType.PRIVELEGED),
        opc_ret_from_sub((Integer)5, "ret_from_sub", OpcodeType.NONPRIVELEGED),
        opc_enter_sync_method((Integer)63, "enter_sync_method", OpcodeType.NONPRIVELEGED),
        opc_priv_ret_from_trap((Integer)5, "priv_ret_from_trap", OpcodeType.PRIVELEGED),
        opc_priv_read_dcache_tag((Integer)6, "priv_read_dcache_tag", OpcodeType.PRIVELEGED),
        opc_priv_read_dcache_data((Integer)7, "priv_read_dcache_data", OpcodeType.PRIVELEGED),
        opc_priv_read_icache_tag((Integer)14, "priv_read_icache_tag", OpcodeType.PRIVELEGED),
        opc_priv_read_icache_data((Integer)15, "priv_read_icache_data", OpcodeType.PRIVELEGED),
        opc_priv_powerdown((Integer)22, "priv_powerdown", OpcodeType.PRIVELEGED),
        opc_priv_read_scache_data((Integer)23, "priv_read_scache_data", OpcodeType.PRIVELEGED),
        opc_priv_cache_index_flush((Integer)31, "priv_cache_index_flush", OpcodeType.PRIVELEGED),
        opc_priv_write_dcache_tag((Integer)38, "priv_write_dcache_tag", OpcodeType.PRIVELEGED),
        opc_priv_write_dcache_data((Integer)39, "priv_write_dcache_data", OpcodeType.PRIVELEGED),
        opc_priv_write_icache_tag((Integer)46, "priv_write_icache_tag", OpcodeType.PRIVELEGED),
        opc_priv_write_icache_data((Integer)47, "priv_write_icache_data", OpcodeType.PRIVELEGED),
        opc_priv_reset((Integer)54, "priv_reset", OpcodeType.PRIVELEGED),
        opc_priv_write_scache_data((Integer)55, "priv_write_scache_data", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_0((Integer)64, "priv_read_reg_0", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_1((Integer)65, "priv_read_reg_1", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_2((Integer)66, "priv_read_reg_2", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_3((Integer)67, "priv_read_reg_3", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_4((Integer)68, "priv_read_reg_4", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_5((Integer)69, "priv_read_reg_5", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_6((Integer)70, "priv_read_reg_6", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_7((Integer)71, "priv_read_reg_7", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_8((Integer)72, "priv_read_reg_8", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_9((Integer)73, "priv_read_reg_9", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_10((Integer)74, "priv_read_reg_10", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_11((Integer)75, "priv_read_reg_11", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_12((Integer)76, "priv_read_reg_12", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_13((Integer)77, "priv_read_reg_13", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_14((Integer)78, "priv_read_reg_14", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_15((Integer)79, "priv_read_reg_15", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_16((Integer)80, "priv_read_reg_16", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_17((Integer)81, "priv_read_reg_17", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_18((Integer)82, "priv_read_reg_18", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_19((Integer)83, "priv_read_reg_19", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_20((Integer)84, "priv_read_reg_20", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_21((Integer)85, "priv_read_reg_21", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_22((Integer)86, "priv_read_reg_22", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_23((Integer)87, "priv_read_reg_23", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_24((Integer)88, "priv_read_reg_24", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_25((Integer)89, "priv_read_reg_25", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_26((Integer)90, "priv_read_reg_26", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_27((Integer)91, "priv_read_reg_27", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_28((Integer)92, "priv_read_reg_28", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_29((Integer)93, "priv_read_reg_29", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_30((Integer)94, "priv_read_reg_30", OpcodeType.PRIVELEGED),
        opc_priv_read_reg_31((Integer)95, "priv_read_reg_31", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_0((Integer)96, "priv_write_reg_0", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_1((Integer)97, "priv_write_reg_1", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_2((Integer)98, "priv_write_reg_2", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_3((Integer)99, "priv_write_reg_3", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_4((Integer)100, "priv_write_reg_4", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_5((Integer)101, "priv_write_reg_5", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_6((Integer)102, "priv_write_reg_6", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_7((Integer)103, "priv_write_reg_7", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_8((Integer)104, "priv_write_reg_8", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_9((Integer)105, "priv_write_reg_9", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_10((Integer)106, "priv_write_reg_10", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_11((Integer)107, "priv_write_reg_11", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_12((Integer)108, "priv_write_reg_12", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_13((Integer)109, "priv_write_reg_13", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_14((Integer)110, "priv_write_reg_14", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_15((Integer)111, "priv_write_reg_15", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_16((Integer)112, "priv_write_reg_16", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_17((Integer)113, "priv_write_reg_17", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_18((Integer)114, "priv_write_reg_18", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_19((Integer)115, "priv_write_reg_19", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_20((Integer)116, "priv_write_reg_20", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_21((Integer)117, "priv_write_reg_21", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_22((Integer)118, "priv_write_reg_22", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_23((Integer)119, "priv_write_reg_23", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_24((Integer)120, "priv_write_reg_24", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_25((Integer)121, "priv_write_reg_25", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_26((Integer)122, "priv_write_reg_26", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_27((Integer)123, "priv_write_reg_27", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_28((Integer)124, "priv_write_reg_28", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_29((Integer)125, "priv_write_reg_29", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_30((Integer)126, "priv_write_reg_30", OpcodeType.PRIVELEGED),
        opc_priv_write_reg_31((Integer)127, "priv_write_reg_31", OpcodeType.PRIVELEGED);

        private Integer value;
        private String parsekey;
        private String alias;
        private Integer length;
        private Integer baseVal;
        private OpcodeType type;

        private Opcode(Integer val, String parse, OpcodeType tp) {
            this.init(val, parse, null, 2, tp);
        }

        private Opcode(Integer val, String parse, int len, OpcodeType tp) {
            this.init(val, parse, null, len, tp);
        }

        private Opcode(Integer val, String parse) {
            this.init(val, parse, null, 2, OpcodeType.NORMAL);
        }

        private Opcode(Integer val, String parse, int len) {
            this.init(val, parse, null, len, OpcodeType.NORMAL);
        }

        private Opcode(Integer val, String parse, String als, int len) {
            this.init(val, parse, als, len, OpcodeType.NORMAL);
        }

        private Opcode(Integer val, String parse, String als, int len, OpcodeType tp) {
            this.init(val, parse, als, len, tp);
        }

        private void init(Integer val, String parse, String als, int len, OpcodeType tp) {
            this.type = tp;
            this.baseVal = null;
            switch (tp.ordinal()) {
                case 0: {
                    this.value = val;
                    break;
                }
                case 3: {
                    this.value = Opcode.opc_wide.value << 8 | val;
                    break;
                }
                case 2: {
                    this.value = Opcode.opc_priv.value * 255 + val;
                    this.baseVal = val;
                    break;
                }
                case 1: {
                    this.value = Opcode.opc_nonpriv.value * 255 + val;
                    this.baseVal = val;
                }
            }
            this.parsekey = parse;
            this.alias = als;
            this.length = len;
        }

        public Integer value() {
            return this.value;
        }

        public int length() {
            return this.length;
        }

        public String parsekey() {
            return this.parsekey;
        }

        public OpcodeType type() {
            return this.type;
        }
    }

    public static enum OpcodeType {
        NORMAL(0, "Normal"),
        NONPRIVELEGED(1, "NonPriv"),
        PRIVELEGED(2, "Priv"),
        WIDE(3, "Wide");

        private final Integer value;
        private final String printval;

        private OpcodeType(Integer val, String print) {
            this.value = val;
            this.printval = print;
        }

        public String printval() {
            return this.printval;
        }
    }
}

