/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Tables;

class FieldData
extends MemberData {
    private ConstantPool.ConstValue_Pair nape;
    private AttrData initValue;

    public FieldData(ClassData cls, int acc, ConstantPool.ConstValue_Pair nape) {
        super(cls, acc);
        this.nape = nape;
        if (Modifiers.hasPseudoMod(acc)) {
            this.createPseudoMod();
        }
    }

    public ConstantPool.ConstValue_Pair getNameDesc() {
        return this.nape;
    }

    public void SetValue(Argument value_cpx) {
        this.initValue = new CPXAttr(this.cls, Tables.AttrTag.ATT_ConstantValue.parsekey(), value_cpx);
    }

    @Override
    protected DataVector getAttrVector() {
        return this.getDataVector(this.initValue, this.syntheticAttr, this.deprecatedAttr, this.signatureAttr);
    }

    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        out.writeShort(this.access);
        out.writeShort(this.nape.left.arg);
        out.writeShort(this.nape.right.arg);
        DataVector attrs = this.getAttrVector();
        attrs.write(out);
    }
}

