/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class IconFactory {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int FILTERED_OUT = 4;
    public static final int NUM_STATES = 5;
    private static final int NOT_FILLED = 0;
    private static final int PARTIALLY_FILLED = 1;
    private static final int ALL_FILLED = 2;
    private static final Dimension folderIcon16Size = new Dimension(16, 16);
    private static final Dimension fileIcon16Size = new Dimension(16, 16);
    private static final Color semiWhite = new Color(255, 255, 255, 128);
    static int testIconWidth = 20;
    static int testIconHeight = 16;
    static int lightX = 5;
    static int lightY = 1;
    static int arrowWidth = 7;
    static int arrowHeight = 8;
    static int testImageWidth = 11;
    static int testImageHeight = 15;
    static int testCornerSize = 4;
    static int testFolderImageWidth = 16;
    static int testFolderImageHeight = 13;
    static int testFolderTabWidth = 8;
    static int testFolderTabHeight = 2;
    static int sectIconWidth = 16;
    static int sectIconHeight = 16;
    static int sectImageSize = 11;
    static int sectHighlightSize = 4;
    private static Icon file;
    private static Icon report;
    private static Icon openableFolder;
    private static Icon selectableFolder;
    private static Icon upFolder;
    private static I18NResourceBundle i18n;
    private static Icon[] testIcons;
    private static Icon[] testFolderIcons;
    private static Icon[] testSectionIcons;
    private static Color arrowColor;
    private static Color arrowShadowColor;

    public static Icon getFileIcon() {
        if (file == null) {
            file = new FileIcon16();
        }
        return file;
    }

    public static Icon getReportIcon() {
        if (report == null) {
            report = new ReportIcon16();
        }
        return report;
    }

    public static Icon getFolderIcon() {
        return IconFactory.getOpenableFolderIcon();
    }

    public static Icon getUpFolderIcon() {
        if (upFolder == null) {
            upFolder = new UpFolderIcon16();
        }
        return upFolder;
    }

    public static Icon getOpenableFolderIcon() {
        if (openableFolder == null) {
            openableFolder = new FolderIcon16(2);
        }
        return openableFolder;
    }

    public static Icon getSelectableFolderIcon() {
        if (selectableFolder == null) {
            selectableFolder = new FolderIcon16(0);
        }
        return selectableFolder;
    }

    public static Icon getTestIcon(int state, boolean active, boolean glyph) {
        if (state < 0 || state >= 5) {
            throw new IllegalArgumentException(Integer.toString(state));
        }
        int index = 4 * state + 2 * (active ? 1 : 0) + (glyph ? 1 : 0);
        Icon testIcon = testIcons[index];
        if (testIcon == null) {
            IconFactory.testIcons[index] = testIcon = new TestIcon(state, active, glyph);
        }
        return testIcon;
    }

    public static Icon getTestFolderIcon(int state, boolean active, boolean glyph) {
        if (state < 0 || state >= 5) {
            throw new IllegalArgumentException(Integer.toString(state));
        }
        int index = 4 * state + 2 * (active ? 1 : 0) + (glyph ? 1 : 0);
        Icon testFolderIcon = testFolderIcons[index];
        if (testFolderIcon == null) {
            IconFactory.testFolderIcons[index] = testFolderIcon = new TestFolderIcon(state, active, glyph);
        }
        return testFolderIcon;
    }

    public static Icon getTestSectionIcon(int state) {
        if (state < 0 || state >= 5) {
            throw new IllegalArgumentException(Integer.toString(state));
        }
        Icon testSectionIcon = testSectionIcons[state];
        if (testSectionIcon == null) {
            IconFactory.testSectionIcons[state] = testSectionIcon = new TestSectionIcon(state);
        }
        return testSectionIcon;
    }

    private static void drawArrow(int x, int y, int w, int h, Graphics g) {
        IconFactory.drawArrow(x + 1, y + 1, w, h, g, arrowColor);
        IconFactory.drawArrow(x, y, w, h, g, arrowShadowColor);
    }

    private static void drawArrow(int x, int y, int w, int h, Graphics g, Color c) {
        g.setColor(c);
        int[] xx = new int[]{x, x + w, x};
        int[] yy = new int[]{y, y + h / 2, y + h};
        g.fillPolygon(xx, yy, 3);
    }

    private static void drawGlyph(int state, int x, int y, Graphics g) {
        IconFactory.drawGlyph(state, x + 1, y + 1, g, semiWhite);
        IconFactory.drawGlyph(state, x, y, g, Color.black);
    }

    private static void drawGlyph(int state, int x, int y, Graphics g, Color c) {
        g.setColor(c);
        switch (state) {
            case 0: {
                g.drawLine(x + 0, y + 3, x + 2, y + 5);
                g.drawLine(x + 1, y + 3, x + 2, y + 4);
                g.drawLine(x + 2, y + 4, x + 5, y + 1);
                g.drawLine(x + 2, y + 5, x + 5, y + 2);
                break;
            }
            case 1: {
                g.drawLine(x + 0, y + 0, x + 4, y + 4);
                g.drawLine(x + 0, y + 1, x + 4, y + 5);
                g.drawLine(x + 0, y + 4, x + 4, y + 0);
                g.drawLine(x + 0, y + 5, x + 4, y + 1);
                break;
            }
            case 2: {
                g.drawLine(x + 2, y + 0, x + 2, y + 3);
                g.drawLine(x + 2, y + 5, x + 2, y + 5);
                g.drawLine(x + 3, y + 0, x + 3, y + 3);
                g.drawLine(x + 3, y + 5, x + 3, y + 5);
                break;
            }
            case 3: {
                g.drawLine(x + 1, y + 3, x + 4, y + 3);
            }
        }
    }

    private static void fill(BufferedImage image, int x1, int y1, int x2, int y2, Color refColor) {
        int refX = testIconWidth;
        int refY = testIconHeight;
        int dRefX = refX - lightX;
        int dRefY = refY - lightY;
        float d0 = (float)Math.sqrt(dRefX * dRefX + dRefY * dRefY);
        int refRed = refColor.getRed();
        int refGreen = refColor.getGreen();
        int refBlue = refColor.getBlue();
        float[] refHSB = Color.RGBtoHSB(refRed, refGreen, refBlue, null);
        float s0 = refHSB[1];
        float b0 = refHSB[2];
        float cb = 1.0f;
        float mb = (b0 - cb) / d0;
        float cs = 0.0f;
        float ms = (s0 - cs) / d0;
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                int dx = x - lightX;
                int dy = y - lightY;
                float d = (float)Math.sqrt(dx * dx + dy * dy);
                float s = ms * d + cs;
                float b = mb * d + cb;
                int rgb = Color.HSBtoRGB(refHSB[0], s, b);
                image.setRGB(x, y, rgb);
            }
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(IconFactory.class);
        testIcons = new Icon[20];
        testFolderIcons = new Icon[20];
        testSectionIcons = new Icon[5];
        arrowColor = UIFactory.Colors.PRIMARY_CONTROL.getValue();
        arrowShadowColor = UIFactory.Colors.PRIMARY_CONTROL_SHADOW.getValue();
    }

    private static class FileIcon16
    implements Icon {
        private Image image;

        private FileIcon16() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y + this.getShift(), null);
        }

        protected void paintMe(Component c, Graphics g) {
            int right = fileIcon16Size.width - 1;
            int bottom = fileIcon16Size.height - 1;
            g.setColor(UIFactory.Colors.WINDOW_BACKGROUND.getValue());
            g.fillRect(4, 2, 9, 12);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_INFO.getValue());
            g.drawLine(2, 0, 2, bottom);
            g.drawLine(2, 0, right - 4, 0);
            g.drawLine(2, bottom, right - 1, bottom);
            g.drawLine(right - 1, 6, right - 1, bottom);
            g.drawLine(right - 6, 2, right - 2, 6);
            g.drawLine(right - 5, 1, right - 4, 1);
            g.drawLine(right - 3, 2, right - 3, 3);
            g.drawLine(right - 2, 4, right - 2, 5);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL.getValue());
            g.drawLine(3, 1, 3, bottom - 1);
            g.drawLine(3, 1, right - 6, 1);
            g.drawLine(right - 2, 7, right - 2, bottom - 1);
            g.drawLine(right - 5, 2, right - 3, 4);
            g.drawLine(3, bottom - 1, right - 2, bottom - 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        @Override
        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    private static class ReportIcon16
    extends FileIcon16 {
        private ReportIcon16() {
        }

        @Override
        protected void paintMe(Component c, Graphics g) {
            int[][] blacks = new int[][]{new int[0], new int[0], {5, 7, 8, 9}, new int[0], {5, 6, 7, 9}, new int[0], {5, 6, 7, 9, 10, 11}, new int[0], {5, 7, 8, 9, 10, 11}, new int[0], {5, 7, 8, 9, 10, 11}, new int[0], {5, 6, 7, 8, 9, 10, 11}};
            super.paintMe(c, g);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_INFO.getValue());
            for (int i = 0; i < blacks.length; ++i) {
                for (int j = 0; j < blacks[i].length; ++j) {
                    int x = blacks[i][j];
                    g.drawLine(x, i, x, i);
                }
            }
        }
    }

    private static class UpFolderIcon16
    implements Icon {
        private UpFolderIcon16() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL.getValue());
            g.fillRect(3, 5, 12, 9);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_INFO.getValue());
            g.drawLine(1, 6, 1, 14);
            g.drawLine(2, 14, 15, 14);
            g.drawLine(15, 13, 15, 5);
            g.drawLine(2, 5, 9, 5);
            g.drawLine(10, 6, 14, 6);
            g.drawLine(8, 13, 8, 16);
            g.drawLine(8, 9, 8, 9);
            g.drawLine(7, 10, 9, 10);
            g.drawLine(6, 11, 10, 11);
            g.drawLine(5, 12, 11, 12);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_HIGHLIGHT.getValue());
            g.drawLine(2, 6, 2, 13);
            g.drawLine(3, 6, 9, 6);
            g.drawLine(10, 7, 14, 7);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_DARK_SHADOW.getValue());
            g.drawLine(11, 3, 15, 3);
            g.drawLine(10, 4, 15, 4);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    private static class FolderIcon16
    implements Icon {
        private int style;
        private Image image;

        FolderIcon16(int style) {
            this.style = style;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y + this.getShift(), null);
        }

        private void paintMe(Component c, Graphics g) {
            int right = folderIcon16Size.width - 1;
            int bottom = folderIcon16Size.height - 1;
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_DARK_SHADOW.getValue());
            g.drawLine(right - 5, 3, right, 3);
            g.drawLine(right - 6, 4, right, 4);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL.getValue());
            g.fillRect(2, 7, 13, 8);
            switch (this.style) {
                case 0: {
                    g.setColor(Color.white);
                    g.fillRect(2, 7, 13, 8);
                    break;
                }
                case 1: {
                    g.setColor(Color.white);
                    for (int i = 0; i < 8; ++i) {
                        g.drawLine(4 + i, 7 + i, 18, 7 + i);
                    }
                    break;
                }
            }
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_SHADOW.getValue());
            g.drawLine(right - 6, 5, right - 1, 5);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_INFO.getValue());
            g.drawLine(0, 6, 0, bottom);
            g.drawLine(1, 5, right - 7, 5);
            g.drawLine(right - 6, 6, right - 1, 6);
            g.drawLine(right, 5, right, bottom);
            g.drawLine(0, bottom, right, bottom);
            g.setColor(UIFactory.Colors.PRIMARY_CONTROL_HIGHLIGHT.getValue());
            g.drawLine(1, 6, 1, bottom - 1);
            g.drawLine(1, 6, right - 7, 6);
            g.drawLine(right - 6, 7, right - 1, 7);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        @Override
        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    private static class TestIcon
    implements Icon {
        private int state;
        private boolean active;
        private boolean glyph;
        private BufferedImage image;

        TestIcon(int state, boolean active, boolean glyph) {
            this.state = state;
            this.active = active;
            this.glyph = glyph;
        }

        @Override
        public int getIconWidth() {
            return testIconWidth;
        }

        @Override
        public int getIconHeight() {
            return testIconHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            g.drawImage(this.image, x, y, null);
        }

        private void paintMe(BufferedImage image) {
            Graphics g = image.getGraphics();
            Color baseColor = I18NUtils.getColorForState(this.state);
            int left = 2 + (testIconWidth - testImageWidth) / 2;
            int right = left + testImageWidth - 1;
            int top = (testIconHeight - testImageHeight) / 2;
            int bottom = top + testImageHeight - 1;
            int cornerLeft = right - testCornerSize;
            Color borderColor = baseColor.darker().darker();
            g.setColor(borderColor);
            g.drawLine(left, top, cornerLeft, top);
            g.drawLine(left, top, left, bottom - 1);
            g.drawLine(left, bottom - 1, right - 1, bottom - 1);
            g.drawLine(right - 1, top + testCornerSize, right - 1, bottom - 1);
            for (int i = 0; i < testCornerSize; ++i) {
                g.drawLine(cornerLeft, top + i, cornerLeft + i, top + i);
            }
            IconFactory.fill(image, left + 1, top + 1, cornerLeft, top + testCornerSize, baseColor);
            IconFactory.fill(image, left + 1, top + testCornerSize, right - 1, bottom - 1, baseColor);
            if (this.glyph) {
                IconFactory.drawGlyph(this.state, (left + right) / 2 - 3, (top + bottom) / 2 - 3, g);
            }
            if (this.active) {
                IconFactory.drawArrow(0, (testIconHeight - arrowHeight) / 2, arrowWidth, arrowHeight, g);
            }
            g.dispose();
        }
    }

    private static class TestFolderIcon
    implements Icon {
        private int state;
        private boolean active;
        private boolean glyph;
        private BufferedImage image;

        TestFolderIcon(int state, boolean active, boolean glyph) {
            this.state = state;
            this.active = active;
            this.glyph = glyph;
        }

        @Override
        public int getIconWidth() {
            return testIconWidth;
        }

        @Override
        public int getIconHeight() {
            return testIconHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            g.drawImage(this.image, x, y, null);
        }

        private void paintMe(BufferedImage image) {
            Graphics g = image.getGraphics();
            Color baseColor = I18NUtils.getColorForState(this.state);
            int left = 2 + (testIconWidth - testFolderImageWidth) / 2;
            int right = left + testFolderImageWidth - 1;
            int top = (testIconHeight - testFolderImageHeight) / 2;
            int bottom = top + testFolderImageHeight - 1;
            Color borderColor = baseColor.darker().darker();
            g.setColor(borderColor);
            g.drawRect(left, top + testFolderTabHeight, right - left, bottom - top - testFolderTabHeight);
            IconFactory.fill(image, left + 1, top + testFolderTabHeight + 1, right, bottom, baseColor);
            g.setColor(borderColor);
            for (int i = 0; i < testFolderTabHeight; ++i) {
                int fth_i = testFolderTabHeight - i;
                g.drawLine(right - testFolderTabWidth + fth_i, top + i, right - fth_i, top + i);
                g.drawLine(right - testFolderTabWidth + i, top + testFolderTabHeight + i, right, top + testFolderTabHeight + i);
            }
            if (this.glyph) {
                IconFactory.drawGlyph(this.state, (left + right) / 2 - 3, testFolderTabHeight + 1 + (top - testFolderTabHeight + bottom) / 2 - 3, g);
            }
            if (this.active) {
                IconFactory.drawArrow(0, (testIconHeight - arrowHeight) / 2, arrowWidth, arrowHeight, g);
            }
            g.dispose();
        }
    }

    private static class TestSectionIcon
    implements Icon {
        private int state;
        private BufferedImage image;

        TestSectionIcon(int state) {
            this.state = state;
        }

        @Override
        public int getIconWidth() {
            return sectIconWidth;
        }

        @Override
        public int getIconHeight() {
            return sectIconHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            g.drawImage(this.image, x, y, null);
        }

        private void paintMe(BufferedImage image) {
            Graphics g = image.getGraphics();
            Color baseColor = I18NUtils.getColorForState(this.state);
            Color borderColor = baseColor.darker().darker();
            int left = (sectIconWidth - sectImageSize) / 2;
            int right = left + sectImageSize;
            int top = (sectIconHeight - sectImageSize) / 2;
            int bottom = top + sectImageSize;
            g.setColor(borderColor);
            g.fillOval(left, top, right - left, bottom - top);
            g.setColor(baseColor);
            g.fillOval(left + 1, top + 1, right - left - 2, bottom - top - 2);
            int hCenterX = left + sectImageSize / 3;
            int hCenterY = top + sectImageSize / 3;
            for (int x = hCenterX - sectHighlightSize; x <= hCenterX + sectHighlightSize; ++x) {
                for (int y = hCenterY - sectHighlightSize; y <= hCenterY + sectHighlightSize; ++y) {
                    int dx = x - hCenterX;
                    int dy = y - hCenterY;
                    float d = (float)Math.sqrt(dx * dx + dy * dy);
                    int t = Math.min((int)(d * 255.0f / (float)sectHighlightSize), 255);
                    g.setColor(new Color(255, 255, 255, 255 - t));
                    g.drawLine(x, y, x, y);
                }
            }
            g.dispose();
        }
    }

    private static class TreeLeafIcon
    extends FileIcon16 {
        private TreeLeafIcon() {
        }

        @Override
        public int getShift() {
            return 2;
        }

        @Override
        public int getAdditionalHeight() {
            return 4;
        }
    }

    private static class TreeFolderIcon
    extends FolderIcon16 {
        TreeFolderIcon(int style) {
            super(style);
        }

        @Override
        public int getShift() {
            return -1;
        }

        @Override
        public int getAdditionalHeight() {
            return 2;
        }
    }
}

