/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class InterviewSet
extends Interview {
    private FinalQuestion qEnd = new FinalQuestion(this);
    private List<Interview> children = new ArrayList<Interview>();
    private Map<Interview, Set<Interview>> dependencies = new HashMap<Interview, Set<Interview>>();
    private Question sortedCalls;
    private NullQuestion sorter = new NullQuestion(this){

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public Question getNext() {
            if (InterviewSet.this.sortedCalls == null) {
                Interview[] cc = InterviewSet.this.sortChildren();
                Question q = InterviewSet.this.qEnd;
                for (int i = cc.length - 1; i >= 0; --i) {
                    q = InterviewSet.this.callInterview(cc[i], q);
                }
                InterviewSet.this.sortedCalls = q;
            }
            return InterviewSet.this.sortedCalls;
        }
    };

    protected InterviewSet(Interview parent, String baseTag) {
        super(parent, baseTag);
        this.setFirstQuestion(this.sorter);
    }

    @Override
    void add(Interview child) {
        super.add(child);
        this.children.add(child);
        this.sortedCalls = null;
    }

    @Override
    void add(Question q) {
        throw new UnsupportedOperationException();
    }

    protected void addDependency(Interview child, Interview dependency) throws CycleFault {
        if (child == null) {
            throw new NullPointerException();
        }
        if (dependency == null) {
            throw new NullPointerException();
        }
        Set<Interview> allDeps = this.getAllDependencies(dependency);
        if (allDeps != null && allDeps.contains(child)) {
            throw new CycleFault(child, dependency);
        }
        Set<Interview> deps = this.getDependencies(child, true);
        deps.add(dependency);
        this.sortedCalls = null;
    }

    protected void removeDependency(Interview child, Interview dependency) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (dependency == null) {
            throw new NullPointerException();
        }
        Set<Interview> deps = this.getDependencies(child, false);
        if (deps != null) {
            deps.remove(dependency);
        }
        if (deps.isEmpty()) {
            this.dependencies.remove(child);
        }
        this.sortedCalls = null;
    }

    private Set<Interview> getDependencies(Interview child, boolean create) {
        Set<Interview> deps = this.dependencies.get(child);
        if (deps == null && create) {
            deps = new TreeSet<Interview>(new ChildComparator());
            this.dependencies.put(child, deps);
        }
        return deps;
    }

    private Set<Interview> getAllDependencies(Interview child) {
        HashSet<Interview> s = new HashSet<Interview>();
        this.getAllDependencies(child, s);
        return s;
    }

    private void getAllDependencies(Interview child, Set<Interview> s) {
        if (s.contains(child)) {
            return;
        }
        Set<Interview> deps = this.getDependencies(child, false);
        if (deps != null) {
            for (Interview i : deps) {
                this.getAllDependencies(i, s);
                s.add(i);
            }
        }
    }

    private Interview[] sortChildren() {
        ArrayList<Interview> list = new ArrayList<Interview>();
        HashSet<Interview> cycleSet = new HashSet<Interview>();
        for (Interview child : this.children) {
            if (list.contains(child)) continue;
            this.addToList(list, child, cycleSet);
        }
        for (Interview i : list) {
            System.err.println(i.getTag() + " " + i);
        }
        return list.toArray(new Interview[list.size()]);
    }

    private void addToList(List<Interview> list, Interview child, Set<Interview> cycleSet) {
        if (cycleSet.contains(child)) {
            throw new IllegalArgumentException();
        }
        cycleSet.add(child);
        Set<Interview> deps = this.dependencies.get(child);
        if (deps != null) {
            for (Interview dep : deps) {
                this.addToList(list, dep, cycleSet);
            }
        }
        list.add(child);
        cycleSet.remove(child);
    }

    public static class CycleFault
    extends Interview.Fault {
        CycleFault(Interview dependent, Interview dependency) {
            super(Interview.i18n, "iset.cycle", dependent.getTag(), dependency.getTag());
        }
    }

    private class ChildComparator
    implements Comparator<Interview> {
        private ChildComparator() {
        }

        @Override
        public int compare(Interview o1, Interview o2) {
            if (!InterviewSet.this.children.contains(o1) || !InterviewSet.this.children.contains(o2)) {
                throw new IllegalArgumentException();
            }
            if (o1 == o2) {
                return 0;
            }
            for (Interview o : InterviewSet.this.children) {
                if (o == o1) {
                    return -1;
                }
                if (o != o2) continue;
                return 1;
            }
            throw new IllegalStateException();
        }
    }
}

