/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.interview.Interview;
import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Keywords;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.GroupManager;
import com.sun.javatest.regtest.config.IgnoreKind;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.config.TestManager;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.regtest.report.ElapsedTimeHandler;
import com.sun.javatest.regtest.report.RegressionReporter;
import com.sun.javatest.regtest.report.TestStats;
import com.sun.javatest.regtest.report.Verbose;
import com.sun.javatest.regtest.report.VerboseHandler;
import com.sun.javatest.regtest.report.XMLWriter;
import com.sun.javatest.regtest.tool.Help;
import com.sun.javatest.regtest.tool.JCovManager;
import com.sun.javatest.regtest.tool.JarFinder;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.OptionDecoder;
import com.sun.javatest.regtest.tool.Startup;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.NaturalComparator;
import com.sun.javatest.regtest.util.StringUtils;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.swing.Timer;

public class Tool {
    public static final String MAIN = "main";
    public static final String SELECT = "select";
    public static final String JDK = "jdk";
    public static final String MODE = "mode";
    public static final String VERBOSE = "verbose";
    public static final String DOC = "doc";
    public static final String TIMEOUT = "timeout";
    public static final String AGENT_POOL = "pool";
    public List<Option> options = Arrays.asList(new Option(Option.ArgType.OPT, "verbose", "verbose", new String[]{"-v", "-verbose"}){

        @Override
        public String[] getChoices() {
            String[] stringArray = new String[Verbose.values().length];
            int n = 0;
            for (String string : Verbose.values()) {
                stringArray[n++] = string;
            }
            return stringArray;
        }

        @Override
        public void process(String string, String string2) throws BadArgs {
            if (string2 == null) {
                Tool.verbose = Verbose.DEFAULT;
            } else {
                Tool.verbose = Verbose.decode(string2);
                if (verbose == null) {
                    throw new BadArgs(i18n, "main.unknownVerbose", string2);
                }
            }
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-v1"}){

        @Override
        public void process(String string, String string2) {
            Tool.verbose = Verbose.SUMMARY;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-va"}){

        @Override
        public void process(String string, String string2) {
            Tool.verbose = Verbose.ALL;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-vp"}){

        @Override
        public void process(String string, String string2) {
            Tool.verbose = Verbose.PASS;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-vf"}){

        @Override
        public void process(String string, String string2) {
            Tool.verbose = Verbose.FAIL;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-ve"}){

        @Override
        public void process(String string, String string2) {
            Tool.verbose = Verbose.ERROR;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-vt"}){

        @Override
        public void process(String string, String string2) {
            Tool.verbose = Verbose.TIME;
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"-t", "-tagspec"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.help.setTagSpec(true);
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"-n", "-relnote"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.help.setReleaseNotes(true);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-w", "-workDir"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.workDirArg = new File(string2);
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"-retain"}){

        @Override
        public String[] getChoices() {
            return new String[]{"none", "lastRun", "pass", "fail", "error", "all", "file-pattern"};
        }

        @Override
        public void process(String string, String string2) throws BadArgs {
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (string2 == null || string2.length() == 0) {
                Tool.this.retainArgs = Collections.singletonList("all");
            } else {
                Tool.this.retainArgs = Arrays.asList(string2.split(","));
            }
            if (Tool.this.retainArgs.contains("none") && Tool.this.retainArgs.size() > 1) {
                throw new BadArgs(i18n, "main.badRetainNone", string2);
            }
            if (Tool.this.retainArgs.contains("lastRun") && Tool.this.retainArgs.size() > 1) {
                throw new BadArgs(i18n, "main.badRetainLastRun", string2);
            }
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-r", "-reportDir"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.reportDirArg = new File(string2);
        }
    }, new Option(Option.ArgType.NONE, "main", "ro-nr", new String[]{"-ro", "-reportOnly"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.reportOnlyFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ro-nr", new String[]{"-nr", "-noreport"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.reportMode = ReportMode.NONE;
        }
    }, new Option(Option.ArgType.STD, "main", "ro-nr", new String[]{"-show"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.reportMode = ReportMode.NONE;
            Tool.this.showStream = string2;
        }
    }, new Option(Option.ArgType.STD, "main", "ro-nr", new String[]{"-report"}){

        @Override
        public String[] getChoices() {
            String[] stringArray = new String[ReportMode.values().length];
            int n = 0;
            for (ReportMode reportMode : ReportMode.values()) {
                stringArray[n++] = reportMode.toString().toLowerCase(Locale.US).replace("_", "-");
            }
            return stringArray;
        }

        @Override
        public void process(String string, String string2) throws BadArgs {
            switch (string2) {
                case "none": {
                    Tool.this.reportMode = ReportMode.NONE;
                    break;
                }
                case "executed": {
                    Tool.this.reportMode = ReportMode.EXECUTED;
                    break;
                }
                case "all-executed": {
                    Tool.this.reportMode = ReportMode.ALL_EXECUTED;
                    break;
                }
                case "all": {
                    Tool.this.reportMode = ReportMode.ALL;
                }
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-timeout", "-timeoutFactor"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            try {
                Tool.this.timeoutFactorArg = Float.valueOf(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadArgs(i18n, "main.badTimeoutFactor", new Object[0]);
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-tl", "-timelimit"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.timeLimitArg = string2;
        }
    }, new Option(Option.ArgType.GNU, "pool", null, new String[]{"--max-pool-size"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            try {
                Tool.this.maxPoolSize = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadArgs(i18n, "main.badMaxPoolSize", string2);
            }
        }
    }, new Option(Option.ArgType.GNU, "pool", null, new String[]{"--pool-idle-timeout"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            try {
                Tool.this.poolIdleTimeout = Duration.ofMillis((long)(1000.0f * Float.parseFloat(string2)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadArgs(i18n, "main.badPoolIdleTimeout", string2);
            }
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-conc", "-concurrency"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.concurrencyArg = string2;
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"-xml"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.xmlFlag = true;
            Tool.this.xmlVerifyFlag = "verify".equals(string2);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-dir"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.baseDirArg = new File(string2);
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"-allowSetSecurityManager"}){

        @Override
        public String[] getChoices() {
            return new String[]{"yes", "no", "on", "off", "true", "false"};
        }

        @Override
        public void process(String string, String string2) {
            boolean bl = string2 == null || Arrays.asList("yes", "on", "true").contains(string2);
            Tool.this.allowSetSecurityManagerFlag = bl;
        }
    }, new Option(Option.ArgType.STD, "select", "", new String[]{"-status"}){

        @Override
        public String[] getChoices() {
            return new String[]{"pass", "fail", "notRun", "error"};
        }

        @Override
        public void process(String string, String string2) {
            Tool.this.priorStatusValuesArg = string2.toLowerCase();
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-exclude", "-Xexclude"}){

        @Override
        public void process(String string, String string2) {
            File file = Tool.getNormalizedFile(new File(string2));
            Tool.this.excludeListArgs.add(file);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-match"}){

        @Override
        public void process(String string, String string2) {
            File file = Tool.getNormalizedFile(new File(string2));
            Tool.this.matchListArgs.add(file);
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-startHttpd"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.httpdFlag = true;
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-o", "-observer"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.observerClassName = string2;
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-od", "-observerDir", "-op", "-observerPath"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.observerPathArg = new ArrayList();
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Tool.this.observerPathArg.add(new File(string3));
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-th", "-timeoutHandler"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.timeoutHandlerClassName = string2;
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-thd", "-timeoutHandlerDir"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.timeoutHandlerPathArg = new ArrayList();
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Tool.this.timeoutHandlerPathArg.add(new File(string3));
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-thtimeout", "-timeoutHandlerTimeout"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            try {
                Tool.this.timeoutHandlerTimeoutArg = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadArgs(i18n, "main.badTimeoutHandlerTimeout", new Object[0]);
            }
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-g", "-gui"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.guiFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-c", "-check"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.checkFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-l", "-listtests"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.listTestsFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-showGroups"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.showGroupsFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ignore", new String[]{"-noignore"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.ignoreKind = IgnoreKind.RUN;
        }
    }, new Option(Option.ArgType.STD, "main", "ignore", new String[]{"-ignore"}){

        @Override
        public String[] getChoices() {
            String[] stringArray = new String[IgnoreKind.values().length];
            int n = 0;
            for (IgnoreKind ignoreKind : IgnoreKind.values()) {
                stringArray[n++] = ignoreKind.toString().toLowerCase();
            }
            return stringArray;
        }

        @Override
        public void process(String string, String string2) throws BadArgs {
            for (IgnoreKind ignoreKind : IgnoreKind.values()) {
                if (!string2.equalsIgnoreCase(ignoreKind.toString())) continue;
                if (ignoreKind == IgnoreKind.QUIET) {
                    Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "!ignore");
                }
                Tool.this.ignoreKind = ignoreKind;
                return;
            }
            throw new BadArgs(i18n, "main.unknownIgnore", string2);
        }
    }, new Option(Option.ArgType.OLD, "main", null, new String[]{"-e"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.envVarArgs.addAll(Arrays.asList(string2.split(",")));
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-lock"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            File file = Tool.getNormalizedFile(new File(string2));
            try {
                if (!(!file.exists() ? file.createNewFile() : file.isFile() && file.canRead())) {
                    throw new BadArgs(i18n, "main.badLockFile", string2);
                }
            }
            catch (IOException iOException) {
                throw new BadArgs(i18n, "main.cantCreateLockFile", string2);
            }
            Tool.this.exclusiveLockArg = file;
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-nativepath"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            if (string2.contains(File.pathSeparator)) {
                throw new BadArgs(i18n, "main.nativePathMultiplePath", string2);
            }
            File file = new File(string2);
            if (!file.exists()) {
                throw new BadArgs(i18n, "main.nativePathNotExist", string2);
            }
            if (!file.isDirectory()) {
                throw new BadArgs(i18n, "main.nativePathNotDir", string2);
            }
            Tool.this.nativeDirArg = file;
        }
    }, new Option(Option.ArgType.NONE, "main", "wsl-cygwin", new String[]{"-wsl"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            if (!Tool.this.isWindows()) {
                throw new BadArgs(i18n, "main.windowsOnly", string);
            }
            if (Tool.this.isCygwinDetected()) {
                Tool.this.out.println(i18n.getString("main.warn.wsl.specified.found.cygwin"));
            }
            Tool.this.useWindowsSubsystemForLinux = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "wsl-cygwin", new String[]{"-cygwin"}){

        @Override
        public void process(String string, String string2) throws BadArgs {
            if (!Tool.this.isWindows()) {
                throw new BadArgs(i18n, "main.windowsOnly", string);
            }
            if (Tool.this.isWindowsSubsystemForLinuxDetected()) {
                Tool.this.out.println(i18n.getString("main.warn.cygwin.specified.found.wsl"));
            }
            Tool.this.useWindowsSubsystemForLinux = false;
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"-a", "-automatic", "-automagic"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, Tool.AUTOMATIC);
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"-m", "-manual"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, Tool.MANUAL);
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"-shell"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "shell");
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"-noshell"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "!shell");
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-bug"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "bug" + string2);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-k", "-keywords"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.userKeywordExpr = Tool.combineKeywords(Tool.this.userKeywordExpr, '(' + string2 + ')');
        }
    }, new Option(Option.ArgType.NONE, "mode", "avm-ovm", new String[]{"-ovm", "-othervm"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.execMode = ExecMode.OTHERVM;
        }
    }, new Option(Option.ArgType.NONE, "mode", "avm-ovm", new String[]{"-avm", "-agentvm", "-s", "-svm", "-samevm"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.execMode = ExecMode.AGENTVM;
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"-jdk", "-testjdk"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testJDK = com.sun.javatest.regtest.config.JDK.of(string2);
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"-compilejdk"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.compileJDK = com.sun.javatest.regtest.config.JDK.of(string2);
        }
    }, new Option(Option.ArgType.STD, "jdk", "", new String[]{"-cpa", "-classpathappend"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Tool.this.classPathAppendArg.add(new File(string3));
            }
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"-jit"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.jitFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"-nojit"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.jitFlag = false;
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-Xrunjcov"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"-classic", "-green", "-native", "-hotspot", "-client", "-server", "-d32", "-d64"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.OPT, "jdk", null, new String[]{"-enableassertions", "-ea", "-disableassertions", "-da"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"-enablesystemassertions", "-esa", "-disablesystemassertions", "-dsa"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.GNU, "jdk", null, new String[]{"--add-modules"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
            Tool.this.testVMOpts.add(string2);
        }
    }, new Option(Option.ArgType.GNU, "jdk", null, new String[]{"--limit-modules"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
            Tool.this.testVMOpts.add(string2);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-XX", "-Xms", "-Xmx"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-Xint", "-Xmixed", "-Xcomp"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-Xbootclasspath"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add("-Xbootclasspath:" + Tool.filesToAbsolutePath(Tool.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-Xbootclasspath/a"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add("-Xbootclasspath/a:" + Tool.filesToAbsolutePath(Tool.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-Xbootclasspath/p"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add("-Xbootclasspath/p:" + Tool.filesToAbsolutePath(Tool.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.GNU, "jdk", null, new String[]{"--patch-module"}){

        @Override
        public void process(String string, String string2) {
            int n = string2.indexOf("=");
            Tool.this.testVMOpts.add("--patch-module");
            Tool.this.testVMOpts.add(string2.substring(0, n + 1) + Tool.filesToAbsolutePath(Tool.pathToFiles(string2.substring(n + 1))));
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-X"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-D"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-vmoption"}){

        @Override
        public void process(String string, String string2) {
            if (string2.length() > 0) {
                Tool.this.testVMOpts.add(string2);
            }
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-vmoptions"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.testVMOpts.addAll(Arrays.asList(string2.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-agentlib"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-agentpath"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javaagent"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javacoption"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.testCompilerOpts.add(string2);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javacoptions"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.testCompilerOpts.addAll(Arrays.asList(string2.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javaoption"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.testJavaOpts.add(string2);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javaoptions"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.testJavaOpts.addAll(Arrays.asList(string2.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-debug"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Tool.this.testDebugOpts.addAll(Arrays.asList(string2.split("\\s+")));
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"--help", "-h", "-help", "-usage"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.help.setCommandLineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.NONE, "doc", "help", new String[]{"-version"}){

        @Override
        public void process(String string, String string2) {
            Tool.this.help.setVersionFlag(true);
        }
    }, new Option(Option.ArgType.FILE, "main", null, new String[0]){
        Pattern groupPtn;
        Pattern fileIdPtn;
        {
            this.groupPtn = System.getProperty("os.name").matches("(?i)windows.*") ? Pattern.compile("(|[^A-Za-z]|.{2,}):[A-Za-z0-9_,]+") : Pattern.compile(".*:[A-Za-z0-9_,]+");
            this.fileIdPtn = Pattern.compile("(?i).*#[a-z0-9]+");
        }

        @Override
        public void process(String string, String string2) {
            if (this.groupPtn.matcher(string2).matches()) {
                Tool.this.testGroupArgs.add(string2);
            } else if (this.fileIdPtn.matcher(string2).matches()) {
                int n = string2.lastIndexOf("#");
                File file = new File(string2.substring(0, n));
                String string3 = string2.substring(n + 1);
                Tool.this.testFileIdArgs.add(new TestManager.FileId(file, string3));
            } else {
                Tool.this.testFileArgs.add(new File(string2));
            }
        }
    });
    int errors;
    private PrintWriter out;
    private PrintWriter err;
    private List<String> expandedArgs;
    private File workDirArg;
    private List<String> retainArgs;
    private List<File> excludeListArgs = new ArrayList<File>();
    private String userKeywordExpr;
    private String extraKeywordExpr;
    private String concurrencyArg;
    private Float timeoutFactorArg;
    private String priorStatusValuesArg;
    private File reportDirArg;
    public List<String> testGroupArgs = new ArrayList<String>();
    public List<File> testFileArgs = new ArrayList<File>();
    public List<TestManager.FileId> testFileIdArgs = new ArrayList<TestManager.FileId>();
    public final List<File> antFileArgs = new ArrayList<File>();
    private File baseDirArg;
    private ExecMode execMode;
    private JDK compileJDK;
    private JDK testJDK;
    private boolean guiFlag;
    private boolean reportOnlyFlag;
    private String showStream;
    private ReportMode reportMode;
    private boolean allowSetSecurityManagerFlag = true;
    private static Verbose verbose;
    private boolean httpdFlag;
    private String timeLimitArg;
    private String observerClassName;
    private List<File> observerPathArg;
    private String timeoutHandlerClassName;
    private List<File> timeoutHandlerPathArg;
    private long timeoutHandlerTimeoutArg = -1L;
    private int maxPoolSize = -1;
    private Duration poolIdleTimeout = Duration.ofSeconds(30L);
    private List<String> testCompilerOpts = new ArrayList<String>();
    private List<String> testJavaOpts = new ArrayList<String>();
    private List<String> testVMOpts = new ArrayList<String>();
    private List<String> testDebugOpts = new ArrayList<String>();
    private boolean checkFlag;
    private boolean listTestsFlag;
    private boolean showGroupsFlag;
    private List<String> envVarArgs = new ArrayList<String>();
    private IgnoreKind ignoreKind;
    private List<File> classPathAppendArg = new ArrayList<File>();
    private File nativeDirArg;
    private Boolean useWindowsSubsystemForLinux;
    private boolean jitFlag = true;
    private Help help;
    private boolean xmlFlag;
    private boolean xmlVerifyFlag;
    private File exclusiveLockArg;
    private List<File> matchListArgs = new ArrayList<File>();
    private File javatest_jar;
    private File jtreg_jar;
    private SearchPath junitPath;
    private SearchPath testngPath;
    private SearchPath asmtoolsPath;
    private File policyFile;
    JCovManager jcovManager;
    private TestStats testStats;
    private static final String AUTOMATIC = "!manual";
    private static final String MANUAL = "manual";
    private static final String[] DEFAULT_UNIX_ENV_VARS;
    private static final String[] DEFAULT_WINDOWS_ENV_VARS;
    private static final String JAVATEST_ANT_FILE_LIST = "javatest.ant.file.list";
    private static I18NResourceBundle i18n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        Tool tool = new Tool(printWriter, printWriter2);
        try {
            int n;
            try {
                n = tool.run(stringArray);
            }
            finally {
                printWriter.flush();
                printWriter2.flush();
            }
            if (!tool.guiFlag || n != 0) {
                Tool.exit(n);
            }
        }
        catch (TestManager.NoTests noTests) {
            printWriter2.println(i18n.getString("main.error", (Object)noTests.getMessage()));
            Tool.exit(1);
        }
        catch (Harness.Fault | Main.Fault exception) {
            printWriter2.println(i18n.getString("main.error", (Object)exception.getMessage()));
            Tool.exit(5);
        }
        catch (BadArgs badArgs) {
            printWriter2.println(i18n.getString("main.badArgs", (Object)badArgs.getMessage()));
            new Help(tool.options).showCommandLineHelp(printWriter);
            Tool.exit(4);
        }
        catch (InterruptedException interruptedException) {
            printWriter2.println(i18n.getString("main.interrupted"));
            Tool.exit(6);
        }
        catch (SecurityException securityException) {
            printWriter2.println(i18n.getString("main.securityException", (Object)securityException.getMessage()));
            securityException.printStackTrace(System.err);
            Tool.exit(6);
        }
        catch (Error | RuntimeException throwable) {
            printWriter2.println(i18n.getString("main.unexpectedException", (Object)throwable.toString()));
            throwable.printStackTrace(System.err);
            Tool.exit(6);
        }
    }

    private static void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof JavaTestSecurityManager) {
            JavaTestSecurityManager cfr_ignored_0 = (JavaTestSecurityManager)securityManager;
            JavaTestSecurityManager.setAllowExit(true);
        }
        System.exit(n);
    }

    public Tool() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Tool(PrintWriter printWriter2, PrintWriter printWriter3) {
        this.out = printWriter2;
        this.err = printWriter3;
        this.javatest_jar = new JarFinder("javatest.jar", new String[0]).classes(Harness.class).getFile();
        if (this.javatest_jar != null) {
            System.setProperty("javatestClassDir", this.javatest_jar.getPath());
        }
        this.jtreg_jar = new JarFinder("jtreg.jar", new String[0]).classes(this.getClass()).getFile();
        if (this.jtreg_jar != null) {
            this.jcovManager = new JCovManager(this.jtreg_jar.getParentFile());
            if (this.jcovManager.isJCovInstalled()) {
                this.options = new ArrayList<Option>(this.options);
                this.options.addAll(this.jcovManager.options);
            }
        }
        this.help = new Help(this.options);
        if (this.javatest_jar != null) {
            this.help.addVersionHelper(printWriter -> {
                block26: {
                    try (JarFile jarFile = new JarFile(this.javatest_jar);){
                        JarEntry jarEntry = jarFile.getJarEntry("META-INF/buildInfo.txt");
                        if (jarEntry == null) break block26;
                        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            String string = properties.getProperty("version");
                            String string2 = "JT Harness, version " + string + " " + properties.getProperty("milestone") + " " + properties.getProperty("build") + " (" + properties.getProperty("date") + ")";
                            printWriter.println(string2);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        if (this.jcovManager != null && this.jcovManager.isJCovInstalled()) {
            this.help.addVersionHelper(new Help.VersionHelper(){

                @Override
                public void showVersion(PrintWriter printWriter) {
                    printWriter.println(Tool.this.jcovManager.version());
                }
            });
        }
    }

    public final int run(String[] stringArray) throws BadArgs, Main.Fault, Harness.Fault, InterruptedException {
        if (stringArray.length > 0) {
            this.expandedArgs = Tool.expandAtFiles(stringArray);
            new OptionDecoder(this.options).decodeArgs(this.expandedArgs);
        } else {
            this.help = new Help(this.options);
            this.help.setCommandLineHelpQuery(null);
        }
        return this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int run() throws BadArgs, Main.Fault, Harness.Fault, InterruptedException {
        int n;
        Object object;
        JDK_Version jDK_Version;
        Object object2;
        Object object32;
        File file;
        this.findSystemJarFiles();
        if (this.help.isEnabled()) {
            this.guiFlag = this.help.show(this.out);
            return 0;
        }
        if (this.userKeywordExpr != null) {
            this.userKeywordExpr = this.userKeywordExpr.replace("-", "_");
            try {
                Keywords.create("expr", this.userKeywordExpr);
            }
            catch (Keywords.Fault fault) {
                throw new Main.Fault(i18n, "main.badKeywords", fault.getMessage());
            }
        }
        if (this.baseDirArg == null) {
            file = new File(System.getProperty("user.dir"));
        } else {
            if (!this.baseDirArg.exists()) {
                throw new Main.Fault(i18n, "main.cantFindFile", this.baseDirArg);
            }
            file = this.baseDirArg.getAbsoluteFile();
        }
        String string = System.getProperty(JAVATEST_ANT_FILE_LIST);
        if (string != null) {
            this.antFileArgs.addAll(Tool.readFileList(new File(string)));
        }
        final TestManager testManager = new TestManager(this.out, file, new TestFinder.ErrorHandler(){

            @Override
            public void error(String string) {
                Tool.this.error(string);
            }
        });
        testManager.addTestFiles(this.testFileArgs, false);
        testManager.addTestFileIds(this.testFileIdArgs, false);
        testManager.addTestFiles(this.antFileArgs, true);
        testManager.addGroups(this.testGroupArgs);
        if (testManager.isEmpty()) {
            throw testManager.new TestManager.NoTests();
        }
        boolean bl = testManager.isMultiRun();
        for (RegressionTestSuite object52 : testManager.getTestSuites()) {
            Version version;
            object32 = object52.getRequiredVersion();
            if (((Version)object32).compareTo(version = Version.getCurrent()) <= 0) continue;
            throw new Main.Fault(i18n, "main.requiredVersion", object52.getPath(), ((Version)object32).getVersionBuildString(), version.getVersionBuildString());
        }
        if (this.execMode == null) {
            object2 = EnumSet.noneOf(ExecMode.class);
            for (Object object32 : testManager.getTestSuites()) {
                ExecMode execMode = ((RegressionTestSuite)object32).getDefaultExecMode();
                if (execMode == null) continue;
                object2.add(execMode);
            }
            switch (object2.size()) {
                case 0: {
                    this.execMode = ExecMode.OTHERVM;
                    break;
                }
                case 1: {
                    this.execMode = (ExecMode)((Object)object2.iterator().next());
                    break;
                }
                default: {
                    throw new Main.Fault(i18n, "main.cantDetermineExecMode", new Object[0]);
                }
            }
        }
        if (this.testJDK == null) {
            void var6_12;
            object2 = System.getenv("JAVA_HOME");
            if (!(object2 != null && ((String)object2).length() != 0 || (object2 = System.getProperty("java.home")) != null && ((String)object2).length() != 0)) {
                throw new BadArgs(i18n, "main.jdk.not.set", new Object[0]);
            }
            File file2 = new File((String)object2);
            if (this.compileJDK == null && file2.getName().toLowerCase().equals("jre") && file2.getParentFile() != null) {
                File file3 = file2.getParentFile();
            }
            this.testJDK = com.sun.javatest.regtest.config.JDK.of((File)var6_12);
        }
        object2 = this.checkJDK(this.testJDK);
        if (this.compileJDK != null && !(jDK_Version = this.checkJDK(this.compileJDK)).equals(object2)) {
            this.out.println("Warning: compileJDK has a different version (" + jDK_Version + ") from testJDK (" + object2 + ")");
        }
        if (this.isWindows()) {
            if (this.useWindowsSubsystemForLinux == null) {
                this.useWindowsSubsystemForLinux = this.isCygwinDetected() ? false : this.isWindowsSubsystemForLinuxDetected();
            }
        } else {
            this.useWindowsSubsystemForLinux = false;
        }
        if (!this.jitFlag) {
            this.envVarArgs.add("JAVA_COMPILER=");
        }
        if (this.classPathAppendArg.size() > 0) {
            this.envVarArgs.add("CPAPPEND=" + Tool.filesToAbsolutePath(this.classPathAppendArg));
        }
        if (this.reportMode == null) {
            this.reportMode = ReportMode.ALL_EXECUTED;
        }
        if (this.workDirArg == null) {
            this.workDirArg = new File("JTwork");
        }
        if (this.reportDirArg == null && this.reportMode != ReportMode.NONE) {
            this.reportDirArg = new File("JTreport");
        }
        this.makeDir(this.workDirArg, false);
        testManager.setWorkDirectory(this.workDirArg);
        RegressionTestSuite.setParametersFactory(new RegressionTestSuite.ParametersFactory(){

            @Override
            public RegressionParameters create(RegressionTestSuite regressionTestSuite) throws TestSuite.Fault {
                try {
                    return Tool.this.createParameters(testManager, regressionTestSuite);
                }
                catch (BadArgs badArgs) {
                    throw new TestSuite.Fault(i18n, "main.cantCreateParameters", (Object)badArgs.getMessage());
                }
                catch (Main.Fault fault) {
                    throw new TestSuite.Fault(i18n, "main.cantCreateParameters", (Object)fault.getMessage());
                }
            }
        });
        if (this.showGroupsFlag) {
            this.showGroups(testManager);
            return 0;
        }
        if (this.listTestsFlag) {
            this.listTests(testManager);
            return 0;
        }
        this.makeDir(new File(this.workDirArg, "scratch"), true);
        if (this.reportMode != ReportMode.NONE) {
            this.makeDir(this.reportDirArg, false);
            testManager.setReportDirectory(this.reportDirArg);
            if (this.expandedArgs != null) {
                File file4 = new File(this.reportDirArg, "text");
                this.makeDir(file4, true);
                object32 = new File(file4, "cmdArgs.txt");
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((File)object32));
                    object = null;
                    try {
                        for (String string2 : this.expandedArgs) {
                            bufferedWriter.append(string2);
                            bufferedWriter.newLine();
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (bufferedWriter != null) {
                            if (object != null) {
                                try {
                                    bufferedWriter.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                bufferedWriter.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Error writing " + object32 + ": " + iOException);
                }
            }
        }
        if (this.jcovManager.isEnabled()) {
            this.jcovManager.setTestJDK(this.testJDK);
            this.jcovManager.setWorkDir(Tool.getNormalizedFile(this.workDirArg));
            this.jcovManager.setReportDir(Tool.getNormalizedFile(this.reportDirArg));
            this.jcovManager.instrumentClasses();
            object = this.jcovManager.instrClasses + File.pathSeparator + this.jcovManager.jcov_network_saver_jar;
            boolean bl2 = false;
            boolean bl3 = false;
            for (n = 0; n < this.testVMOpts.size(); ++n) {
                String string3 = this.testVMOpts.get(n);
                if (string3.startsWith("-Xbootclasspath/p:")) {
                    string3 = string3.substring(0, "-Xbootclasspath/p:".length()) + (String)object + File.pathSeparator + string3.substring("-Xbootclasspath/p:".length());
                    this.testVMOpts.set(n, string3);
                    bl2 = true;
                    break;
                }
                if (!string3.startsWith("-Xms")) continue;
                bl3 = true;
            }
            if (!bl2) {
                if (this.jcovManager.instrModules.exists()) {
                    this.patchModulesInVMOpts(this.jcovManager.instrModules);
                } else {
                    this.testVMOpts.add("-Xbootclasspath/p:" + (String)object);
                }
            }
            if (!bl3) {
                this.testVMOpts.add("-Xms64m");
            }
            this.jcovManager.startGrabber();
            this.testVMOpts.add("-Djcov.port=" + this.jcovManager.grabberPort);
            if (JCovManager.showJCov) {
                System.err.println("Modified VM opts: " + this.testVMOpts);
            }
        }
        try {
            boolean bl4;
            Harness.setClassDir(ProductInfo.getJavaTestClassDir());
            Keywords.setAllowNumericKeywords(true);
            if (this.httpdFlag) {
                this.startHttpServer();
            }
            if (bl && this.guiFlag) {
                throw new Main.Fault(i18n, "main.onlyOneTestSuiteInGuiMode", new Object[0]);
            }
            this.testStats = new TestStats();
            boolean bl5 = false;
            for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
                String[] stringArray;
                if (bl && verbose != null && Tool.verbose.multiRun) {
                    this.out.println("Running tests in " + regressionTestSuite.getRootDir());
                }
                if ((stringArray = ((InterviewParameters)(object = this.createParameters(testManager, regressionTestSuite))).getTests()) != null && stringArray.length == 0) {
                    bl4 = true;
                }
                this.checkLockFiles(((BasicInterviewParameters)object).getWorkDirectory().getRoot(), "start");
                switch (this.execMode) {
                    case AGENTVM: {
                        Agent.Pool pool = Agent.Pool.instance((RegressionParameters)object);
                        if (this.allowSetSecurityManagerFlag) {
                            this.initPolicyFile();
                            pool.setSecurityPolicy(this.policyFile);
                        }
                        if (this.timeoutFactorArg != null) {
                            pool.setTimeoutFactor(this.timeoutFactorArg.floatValue());
                        }
                        if (this.maxPoolSize == -1) {
                            n = 2;
                            this.maxPoolSize = ((InterviewParameters)object).getConcurrency() * n;
                        }
                        pool.setMaxPoolSize(this.maxPoolSize);
                        pool.setIdleTimeout(this.poolIdleTimeout);
                        break;
                    }
                    case OTHERVM: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                TestEnvironment.addDefaultPropTable("(system properties)", System.getProperties());
                if (this.guiFlag) {
                    this.showTool((InterviewParameters)object);
                    int n2 = 0;
                    return n2;
                }
                try {
                    boolean bl6 = bl && (verbose == null || !Tool.verbose.multiRun);
                    this.testStats.addAll(this.batchHarness((RegressionParameters)object, bl6));
                }
                finally {
                    this.checkLockFiles(((BasicInterviewParameters)object).getWorkDirectory().getRoot(), "done");
                }
                if (verbose == null || !Tool.verbose.multiRun) continue;
                this.out.println();
            }
            if (bl) {
                if (verbose != null && Tool.verbose.multiRun) {
                    this.out.println("Overall summary:");
                }
                this.testStats.showResultStats(this.out);
                if (this.reportMode != ReportMode.NONE) {
                    object32 = new RegressionReporter(this.out);
                    ((RegressionReporter)object32).report(testManager);
                }
                if (!this.reportOnlyFlag) {
                    this.out.println("Results written to " + Tool.canon(this.workDirArg));
                }
            }
            int n3 = this.testStats.counts[2] > 0 ? 3 : (this.testStats.counts[1] > 0 ? 2 : (this.testStats.counts[0] == 0 && !bl4 ? 1 : (this.errors != 0 ? 5 : 0)));
            return n3;
        }
        finally {
            if (this.jcovManager.isEnabled()) {
                this.jcovManager.stopGrabber();
                if (this.jcovManager.results.exists()) {
                    this.jcovManager.writeReport();
                    this.out.println("JCov report written to " + Tool.canon(new File(this.jcovManager.report, "index.html")));
                } else {
                    this.out.println("Note: no jcov results found; no report generated");
                }
            }
        }
    }

    private void patchModulesInVMOpts(File file) {
        if (file.exists()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory() || file2.getName().equals("java.base")) continue;
                arrayList.add(file2.getName());
            }
            for (File file2 : file.listFiles()) {
                if (!file2.isDirectory()) continue;
                String string = file2.getName() + "=" + file2.getAbsolutePath();
                if (file2.getName().equals("java.base")) {
                    string = string + File.pathSeparator + this.jcovManager.jcov_network_saver_jar;
                    if (!arrayList.isEmpty()) {
                        this.testVMOpts.add("--add-exports");
                        String string2 = "java.base/com.sun.tdk.jcov.runtime=" + StringUtils.join(arrayList, ",");
                        this.testVMOpts.add(string2);
                    }
                }
                this.testVMOpts.add("--patch-module");
                this.testVMOpts.add(string);
            }
        }
    }

    JDK_Version checkJDK(JDK jDK) throws Main.Fault {
        if (!jDK.exists()) {
            throw new Main.Fault(i18n, "main.jdk.not.found", jDK);
        }
        JDK jDK2 = com.sun.javatest.regtest.config.JDK.of(System.getProperty("java.home"));
        File file = jDK2.getProg("java", true);
        File file2 = jDK.getProg("java", true);
        if (!file2.getName().equals(file.getName())) {
            throw new Main.Fault(i18n, "main.incompatibleJDK", jDK, jDK2);
        }
        JDK_Version jDK_Version = jDK.getJDKVersion(new SearchPath(this.jtreg_jar, this.javatest_jar), this.out::println);
        if (jDK_Version == null) {
            throw new Main.Fault(i18n, "main.jdk.unknown.version", jDK);
        }
        if (jDK_Version.compareTo(JDK_Version.V1_1) <= 0) {
            throw new Main.Fault(i18n, "main.jdk.unsupported.version", jDK, jDK_Version.name());
        }
        return jDK_Version;
    }

    void showGroups(TestManager testManager) throws Main.Fault {
        for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
            this.out.println(i18n.getString("main.tests.suite", (Object)regressionTestSuite.getRootDir()));
            try {
                Set<String> set = testManager.getGroups(regressionTestSuite);
                GroupManager groupManager = regressionTestSuite.getGroupManager(this.out);
                TreeSet<String> treeSet = new TreeSet<String>(new NaturalComparator(false));
                if (set.isEmpty()) {
                    treeSet.addAll(groupManager.getGroups());
                } else {
                    for (String string : groupManager.getGroups()) {
                        if (!set.contains(string)) continue;
                        treeSet.add(string);
                    }
                }
                if (treeSet.isEmpty()) {
                    this.out.println(i18n.getString("main.groups.nogroups"));
                    continue;
                }
                for (String string : treeSet) {
                    try {
                        Set<File> set2 = groupManager.getFiles(string);
                        this.out.print(string);
                        this.out.print(":");
                        TreeSet<String> treeSet2 = new TreeSet<String>(new NaturalComparator(false));
                        for (File file : set2) {
                            treeSet2.add(regressionTestSuite.getRootDir().toURI().relativize(file.toURI()).getPath());
                        }
                        for (String string2 : treeSet2) {
                            this.out.print(" ");
                            this.out.print(string2);
                        }
                        this.out.println();
                    }
                    catch (GroupManager.InvalidGroup invalidGroup) {
                        this.out.println(i18n.getString("tm.invalidGroup", (Object)string));
                    }
                }
            }
            catch (IOException iOException) {
                throw new Main.Fault(i18n, "main.cantReadGroups", regressionTestSuite.getRootDir(), iOException);
            }
        }
    }

    void listTests(TestManager testManager) throws BadArgs, Main.Fault {
        int n = 0;
        for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
            int n2 = 0;
            this.out.println(i18n.getString("main.tests.suite", (Object)regressionTestSuite.getRootDir()));
            RegressionParameters regressionParameters = this.createParameters(testManager, regressionTestSuite);
            Iterator<TestResult> iterator = this.getResultsIterator(regressionParameters);
            while (iterator.hasNext()) {
                TestResult testResult = iterator.next();
                this.out.println(testResult.getTestName());
                ++n2;
            }
            this.out.println(i18n.getString("main.tests.found", (Object)n2));
            n += n2;
        }
        if (testManager.isMultiRun()) {
            this.out.println(i18n.getString("main.tests.total", (Object)n));
        }
    }

    private static List<String> expandAtFiles(String[] stringArray) throws Main.Fault {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.length() > 1 && string.charAt(0) == '@') {
                if ((string = string.substring(1)).charAt(0) == '@') {
                    arrayList.add(string);
                    continue;
                }
                Tool.loadCmdFile(string, arrayList);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private static void loadCmdFile(String string, List<String> list) throws Main.Fault {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Main.Fault(i18n, "main.cantOpenFile", string);
        }
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(32, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            while (streamTokenizer.nextToken() != -1) {
                list.add(streamTokenizer.sval);
            }
        }
        catch (IOException iOException) {
            throw new Main.Fault(i18n, "main.cantRead", string, iOException);
        }
        finally {
            try {
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {}
        }
    }

    private static List<File> readFileList(File file) throws Main.Fault {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Main.Fault(i18n, "main.cantOpenFile", file);
        }
        try {
            String string;
            ArrayList<File> arrayList = new ArrayList<File>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(new File(string));
            }
            ArrayList<File> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (IOException iOException) {
            throw new Main.Fault(i18n, "main.cantRead", file, iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int[] getTestStats() {
        return this.testStats.counts;
    }

    void findSystemJarFiles() throws Main.Fault {
        if (this.javatest_jar == null) {
            throw new Main.Fault(i18n, "main.cantFind.javatest.jar", new Object[0]);
        }
        if (this.jtreg_jar == null) {
            throw new Main.Fault(i18n, "main.cantFind.jtreg.jar", new Object[0]);
        }
        File file = this.jtreg_jar.getParentFile();
        this.junitPath = new JarFinder("junit.jar", "hamcrest.jar").classes("org.junit.runner.JUnitCore", "org.hamcrest.SelfDescribing").libDir(file).getPath();
        this.testngPath = new JarFinder("testng.jar", "jcommander.jar", "guice.jar").classes("org.testng.annotations.Test", "com.beust.jcommander.JCommander", "com.google.inject.Stage").libDir(file).getPath();
        this.help.addPathVersionHelper("TestNG", this.testngPath);
        this.asmtoolsPath = new JarFinder("asmtools.jar", new String[0]).classes("org.openjdk.asmtools.Main").libDir(file).getPath();
        this.help.addVersionHelper(printWriter -> {
            for (File file : this.asmtoolsPath.asList()) {
                try {
                    JarFile jarFile = new JarFile(file);
                    Throwable throwable = null;
                    try {
                        JarEntry jarEntry = jarFile.getJarEntry("org/openjdk/asmtools/util/productinfo.properties");
                        if (jarEntry == null) continue;
                        InputStream inputStream = jarFile.getInputStream(jarEntry);
                        Throwable throwable2 = null;
                        try {
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            String string = properties.getProperty("PRODUCT_VERSION");
                            String string2 = properties.getProperty("PRODUCT_NAME_LONG") + ", version " + string + " " + properties.getProperty("PRODUCT_MILESTONE") + " " + properties.getProperty("PRODUCT_BUILDNUMBER") + " (" + properties.getProperty("PRODUCT_DATE") + ")";
                            printWriter.println(string2);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        });
    }

    void initPolicyFile() throws Main.Fault {
        File file = new File(this.workDirArg, "jtreg.policy");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            String string = System.getProperty("line.separator");
            for (File file2 : Arrays.asList(this.jtreg_jar, this.javatest_jar)) {
                bufferedWriter.write("grant codebase \"" + file2.toURI().toURL() + "\" {" + string);
                bufferedWriter.write("    permission java.security.AllPermission;" + string);
                bufferedWriter.write("};" + string);
            }
        }
        catch (IOException iOException) {
            throw new Main.Fault(i18n, "main.cantWritePolicyFile", iOException);
        }
        this.policyFile = file;
    }

    private void makeDir(File file, boolean bl) throws Main.Fault {
        if (file.isDirectory()) {
            return;
        }
        if (!bl) {
            this.out.println("Directory \"" + file + "\" not found: creating");
        }
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new Main.Fault(i18n, "main.cantCreateDir", file);
        }
    }

    private static List<File> pathToFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    private static SearchPath filesToAbsolutePath(List<File> list) {
        SearchPath searchPath = new SearchPath();
        for (File file : list) {
            searchPath.append(Tool.getNormalizedFile(file));
        }
        return searchPath;
    }

    private RegressionParameters createParameters(TestManager testManager, RegressionTestSuite regressionTestSuite) throws BadArgs, Main.Fault {
        try {
            File file;
            Object object;
            RegressionParameters regressionParameters = new RegressionParameters("regtest", regressionTestSuite, this.out::println);
            WorkDirectory workDirectory = testManager.getWorkDirectory(regressionTestSuite);
            regressionParameters.setWorkDirectory(workDirectory);
            regressionParameters.setFile(workDirectory.getFile("config.jti"));
            regressionParameters.setRetainArgs(this.retainArgs);
            regressionParameters.setTests(testManager.getTests(regressionTestSuite));
            if (this.userKeywordExpr != null || this.extraKeywordExpr != null) {
                object = this.userKeywordExpr == null ? this.extraKeywordExpr : (this.extraKeywordExpr == null ? this.userKeywordExpr : "(" + this.userKeywordExpr + ") & " + this.extraKeywordExpr);
                regressionParameters.setKeywordsExpr((String)object);
            }
            regressionParameters.setExcludeLists(this.excludeListArgs.toArray(new File[this.excludeListArgs.size()]));
            regressionParameters.setMatchLists(this.matchListArgs.toArray(new File[this.matchListArgs.size()]));
            if (this.priorStatusValuesArg == null || this.priorStatusValuesArg.length() == 0) {
                regressionParameters.setPriorStatusValues(null);
            } else {
                object = new boolean[4];
                object[0] = this.priorStatusValuesArg.contains("pass");
                object[1] = this.priorStatusValuesArg.contains("fail");
                object[2] = this.priorStatusValuesArg.contains("erro");
                object[3] = this.priorStatusValuesArg.contains("notr");
                regressionParameters.setPriorStatusValues((boolean[])object);
            }
            if (this.concurrencyArg != null) {
                try {
                    int n = this.concurrencyArg.equals("auto") ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(this.concurrencyArg);
                    regressionParameters.setConcurrency(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badConcurrency", new Object[0]);
                }
            }
            if (this.timeoutFactorArg != null) {
                try {
                    regressionParameters.setTimeoutFactor(this.timeoutFactorArg.floatValue());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badTimeoutFactor", new Object[0]);
                }
            }
            if (this.timeoutHandlerClassName != null) {
                regressionParameters.setTimeoutHandler(this.timeoutHandlerClassName);
            }
            if (this.timeoutHandlerPathArg != null) {
                regressionParameters.setTimeoutHandlerPath(this.timeoutHandlerPathArg);
            }
            if (this.timeoutHandlerTimeoutArg != 0L) {
                regressionParameters.setTimeoutHandlerTimeout(this.timeoutHandlerTimeoutArg);
            }
            if ((file = testManager.getReportDirectory(regressionTestSuite)) != null) {
                regressionParameters.setReportDir(file);
            }
            if (this.exclusiveLockArg != null) {
                regressionParameters.setExclusiveLock(this.exclusiveLockArg);
            }
            if (!regressionParameters.isValid()) {
                throw new Main.Fault(i18n, "main.badParams", regressionParameters.getErrorMessage());
            }
            for (String string : this.testVMOpts) {
                if (!string.startsWith("-Xrunjcov")) continue;
                if (this.testVMOpts.contains("-XX:+EnableJVMPIInstructionStartEvent")) break;
                this.testVMOpts.add("-XX:+EnableJVMPIInstructionStartEvent");
                break;
            }
            if (this.testVMOpts.size() > 0) {
                regressionParameters.setTestVMOptions(this.testVMOpts);
            }
            if (this.testCompilerOpts.size() > 0) {
                regressionParameters.setTestCompilerOptions(this.testCompilerOpts);
            }
            if (this.testJavaOpts.size() > 0) {
                regressionParameters.setTestJavaOptions(this.testJavaOpts);
            }
            if (this.testDebugOpts.size() > 0) {
                regressionParameters.setTestDebugOptions(this.testDebugOpts);
            }
            regressionParameters.setCheck(this.checkFlag);
            regressionParameters.setExecMode(this.execMode);
            regressionParameters.setEnvVars(this.getEnvVars());
            regressionParameters.setCompileJDK(this.compileJDK != null ? this.compileJDK : this.testJDK);
            regressionParameters.setTestJDK(this.testJDK);
            if (this.ignoreKind != null) {
                regressionParameters.setIgnoreKind(this.ignoreKind);
            }
            if (this.junitPath != null) {
                regressionParameters.setJUnitPath(this.junitPath);
            }
            if (this.testngPath != null) {
                regressionParameters.setTestNGPath(this.testngPath);
            }
            if (this.asmtoolsPath != null) {
                regressionParameters.setAsmToolsPath(this.asmtoolsPath);
            }
            if (this.timeLimitArg != null) {
                try {
                    regressionParameters.setTimeLimit(Integer.parseInt(this.timeLimitArg));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badTimeLimit", new Object[0]);
                }
            }
            if (this.nativeDirArg != null) {
                regressionParameters.setNativeDir(this.nativeDirArg);
            }
            regressionParameters.setUseWindowsSubsystemForLinux(this.useWindowsSubsystemForLinux);
            regressionParameters.initExprContext();
            return regressionParameters;
        }
        catch (Interview.Fault fault) {
            throw new Main.Fault(i18n, "main.cantOpenTestSuite", regressionTestSuite.getRootDir(), fault);
        }
        catch (JDK.Fault fault) {
            throw new Main.Fault(i18n, "main.cantGetJDKProperties", this.testJDK, fault.getMessage());
        }
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return Tool.getNormalizedFile(file);
        }
    }

    private static Harness.Observer getObserver(List<File> list, String string) throws Main.Fault {
        try {
            Class<?> clazz;
            if (list == null) {
                clazz = Class.forName(string);
            } else {
                URL[] uRLArray = new URL[list.size()];
                int n = 0;
                for (File file : list) {
                    try {
                        uRLArray[n++] = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                clazz = uRLClassLoader.loadClass(string);
            }
            return clazz.asSubclass(Harness.Observer.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException classCastException) {
            throw new Main.Fault(i18n, "main.obsvrType", Harness.Observer.class.getName(), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Main.Fault(i18n, "main.obsvrNotFound", string);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Main.Fault(i18n, "main.obsvrFault", reflectiveOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestStats batchHarness(RegressionParameters regressionParameters, boolean bl) throws Main.Fault, Harness.Fault, InterruptedException {
        boolean bl2 = this.reportMode != ReportMode.NONE && !Boolean.getBoolean("javatest.noReportRequired");
        try {
            Object object;
            Object object2;
            boolean bl3;
            Object object3;
            TestStats testStats = new TestStats();
            ElapsedTimeHandler elapsedTimeHandler = null;
            if (this.reportOnlyFlag) {
                object3 = this.getResultsIterator(regressionParameters);
                while (object3.hasNext()) {
                    TestResult testResult = (TestResult)object3.next();
                    testStats.add(testResult);
                }
                bl3 = testStats.isOK();
            } else if (this.showStream != null) {
                object3 = null;
                Iterator<TestResult> iterator = this.getResultsIterator(regressionParameters);
                while (iterator.hasNext()) {
                    if (object3 != null) {
                        this.out.println("More than one test specified");
                        object3 = null;
                        break;
                    }
                    object3 = iterator.next();
                }
                if (object3 != null && ((TestResult)object3).getFile() == null && regressionParameters.getWorkDirectory().getFile(((TestResult)object3).getWorkRelativePath()).exists()) {
                    try {
                        object3 = new TestResult(regressionParameters.getWorkDirectory(), ((TestResult)object3).getWorkRelativePath());
                    }
                    catch (TestResult.Fault fault) {
                        this.out.println("Cannot reload results for test " + ((TestResult)object3).getTestName());
                    }
                }
                if (object3 == null) {
                    this.out.println("No test specified");
                    bl3 = false;
                } else if (((TestResult)object3).getStatus().isNotRun()) {
                    this.out.println("Test has not been run");
                    bl3 = false;
                } else {
                    try {
                        ((TestResult)object3).getProperty("sections");
                        for (int i = 0; i < ((TestResult)object3).getSectionCount(); ++i) {
                            object2 = ((TestResult)object3).getSection(i);
                            object = ((TestResult.Section)object2).getOutput(this.showStream);
                            if (object == null) continue;
                            this.out.println("### Section " + ((TestResult.Section)object2).getTitle());
                            this.out.println((String)object);
                        }
                        bl3 = true;
                    }
                    catch (TestResult.Fault fault) {
                        this.out.println("Cannot reload test results: " + fault.getMessage());
                        bl3 = false;
                    }
                }
                bl = true;
            } else {
                object3 = this.createBackupPolicy();
                Harness harness = new Harness();
                harness.setBackupPolicy((BackupPolicy)object3);
                if (this.xmlFlag) {
                    this.out.println("XML output " + (this.xmlVerifyFlag ? "with verification to " : " to ") + regressionParameters.getWorkDirectory().getPath());
                    harness.addObserver(new XMLWriter.XMLHarnessObserver(this.xmlVerifyFlag, this.out, this.err));
                }
                if (this.observerClassName != null) {
                    harness.addObserver(Tool.getObserver(this.observerPathArg, this.observerClassName));
                }
                if (verbose != null) {
                    new VerboseHandler(verbose, this.out, this.err).register(harness);
                }
                testStats.register(harness);
                harness.addObserver(new BasicObserver(){

                    @Override
                    public void error(String string) {
                        Tool.this.error(string);
                    }
                });
                if (bl2) {
                    elapsedTimeHandler = new ElapsedTimeHandler();
                    elapsedTimeHandler.register(harness);
                }
                if (regressionParameters.getTestJDK().hasModules()) {
                    this.initModuleHelper(regressionParameters.getWorkDirectory());
                }
                object2 = regressionParameters.getWorkDirectory().getSystemFile("jtreg.version");
                try {
                    object = new PrintWriter(new BufferedWriter(new FileWriter((File)object2)));
                    Throwable throwable = null;
                    try {
                        this.help.showVersion((PrintWriter)object);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    this.err.println(i18n.getString("main.errorReportingVersion", (Object)iOException));
                }
                object = regressionParameters.getTests();
                bl3 = object != null && ((boolean[])object).length == 0 || harness.batch(regressionParameters);
                Agent.Pool.flush(regressionParameters);
                try {
                    Agent.Logger.close(regressionParameters);
                }
                catch (IOException iOException) {
                    this.err.println(i18n.getString("main.errorClosingAgentLog", (Object)iOException));
                }
                Lock.get(regressionParameters).close();
            }
            if (!bl) {
                testStats.showResultStats(this.out);
            }
            if (bl2) {
                Object object4;
                object3 = new RegressionReporter(this.out);
                if (this.reportOnlyFlag) {
                    object2 = new ParameterFilter();
                    ((ParameterFilter)object2).update(regressionParameters);
                    object4 = object2;
                } else {
                    switch (this.reportMode) {
                        default: {
                            throw new IllegalStateException();
                        }
                        case EXECUTED: {
                            object2 = new ParameterFilter();
                            ((ParameterFilter)object2).update(regressionParameters);
                            object4 = object2;
                            break;
                        }
                        case ALL_EXECUTED: {
                            object = new boolean[]{true, true, true, false};
                            object4 = new StatusFilter((boolean[])object, regressionParameters.getWorkDirectory().getTestResultTable());
                            break;
                        }
                        case ALL: {
                            object4 = new AllTestsFilter();
                        }
                    }
                }
                ((RegressionReporter)object3).report(regressionParameters, elapsedTimeHandler, testStats, (TestFilter)object4, bl);
            }
            if (!this.reportOnlyFlag && !bl) {
                this.out.println("Results written to " + regressionParameters.getWorkDirectory().getPath());
            }
            if (!bl3 && !bl) {
                this.err.println(i18n.getString("main.testsFailed"));
            }
            object3 = testStats;
            return object3;
        }
        finally {
            this.out.flush();
            this.err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModuleHelper(WorkDirectory workDirectory) {
        String[] stringArray;
        File file = workDirectory.getFile("patches");
        File file2 = new File(file, "java.base");
        for (String string : stringArray = new String[]{"java/lang/JTRegModuleHelper.class"}) {
            File file3 = new File(file2, string);
            if (file3.exists()) continue;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                if (inputStream == null) {
                    this.out.println("Cannot find class " + string + " to init patch directory");
                    continue;
                }
                file3.getParentFile().mkdirs();
                outputStream = new FileOutputStream(file3);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                this.out.println("Cannot init module patch directory: " + iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.out.println("Cannot init module patch directory: " + iOException);
                }
            }
        }
    }

    private Iterator<TestResult> getResultsIterator(InterviewParameters interviewParameters) {
        TestResultTable testResultTable = interviewParameters.getWorkDirectory().getTestResultTable();
        testResultTable.waitUntilReady();
        String[] stringArray = interviewParameters.getTests();
        TestFilter[] testFilterArray = interviewParameters.getFilters();
        if (stringArray == null) {
            return testResultTable.getIterator(testFilterArray);
        }
        if (stringArray.length == 0) {
            return Collections.emptySet().iterator();
        }
        return testResultTable.getIterator(stringArray, testFilterArray);
    }

    private void showTool(final InterviewParameters interviewParameters) throws BadArgs {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Frame frame = this.showStartup();
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.showGUI();
                        frame.dispose();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }

            Frame showStartup() {
                Version version = Version.getCurrent();
                String string = String.format("%s %s %s %s", version.product, version.version, version.milestone, version.build);
                URL uRL = this.getClass().getResource("jtlogo.png");
                String string2 = i18n.getString("help.copyright.txt").replace("\n", " ");
                return new Startup(string, uRL, "", string, string2).show();
            }

            void showGUI() {
                Desktop desktop = new Desktop();
                ExecToolManager execToolManager = (ExecToolManager)desktop.getToolManager(ExecToolManager.class);
                if (execToolManager == null) {
                    throw new AssertionError((Object)"Cannot find ExecToolManager");
                }
                execToolManager.startTool(interviewParameters);
                desktop.setVisible(true);
            }
        });
    }

    private BackupPolicy createBackupPolicy() {
        return new BackupPolicy(){
            private final int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private final String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            @Override
            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            @Override
            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (String string : this.ignoreExtns) {
                        if (!file.getPath().endsWith(string)) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private void startHttpServer() {
        HttpdServer httpdServer = new HttpdServer();
        Thread thread = new Thread(httpdServer);
        PageGenerator.setSWName(ProductInfo.getName());
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Date date = ProductInfo.getBuildDate();
        String string = date != null ? dateFormat.format(date) : i18n.getString("main.noDate");
        PageGenerator.setSWBuildDate(string);
        PageGenerator.setSWVersion(ProductInfo.getVersion());
        thread.start();
    }

    private Map<String, String> getEnvVars() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        OS oS = OS.current();
        if (oS.family.equals("windows")) {
            this.addEnvVars(treeMap, DEFAULT_WINDOWS_ENV_VARS);
            this.addEnvVars(treeMap, "PATH");
        } else {
            this.addEnvVars(treeMap, DEFAULT_UNIX_ENV_VARS);
            this.addEnvVars(treeMap, "PATH=/bin:/usr/bin:/usr/sbin");
        }
        this.addEnvVars(treeMap, this.envVarArgs);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (!string.startsWith("JTREG_")) continue;
            treeMap.put(string, string2);
        }
        return treeMap;
    }

    private void addEnvVars(Map<String, String> map, String string) {
        this.addEnvVars(map, string.split(","));
    }

    private void addEnvVars(Map<String, String> map, String[] stringArray) {
        this.addEnvVars(map, Arrays.asList(stringArray));
    }

    private void addEnvVars(Map<String, String> map, List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            String string2;
            if ((string = string.trim()).length() == 0) continue;
            int n = string.indexOf("=");
            if (n == -1) {
                string2 = System.getenv(string);
                if (string2 == null) continue;
                map.put(string, string2);
                continue;
            }
            if (n <= 0) continue;
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            map.put(string2, string3);
        }
    }

    private static String combineKeywords(String string, String string2) {
        return string == null ? string2 : string + " & " + string2;
    }

    private boolean isWindows() {
        return OS.current().family.equals("windows");
    }

    private boolean isCygwinDetected() {
        if (this.isWindows()) {
            String string = System.getenv("PATH");
            return string != null && string.matches("(?i).*;[a-z]:[^;]*\\\\cygwin.*");
        }
        return false;
    }

    private boolean isWindowsSubsystemForLinuxDetected() {
        String string;
        if (this.isWindows() && (string = System.getenv("PATH")) != null) {
            for (File file : new SearchPath(string).asList()) {
                if (!new File(file, "wsl.exe").exists()) continue;
                return true;
            }
        }
        return false;
    }

    private void error(String string) {
        this.err.println(i18n.getString("main.error", (Object)string));
        ++this.errors;
    }

    private void checkLockFiles(File file, String string) {
    }

    private static File getNormalizedFile(File file) {
        return new File(file.getAbsoluteFile().toURI().normalize());
    }

    static {
        DEFAULT_UNIX_ENV_VARS = new String[]{"DISPLAY", "GNOME_DESKTOP_SESSION_ID", "HOME", "LANG", "LC_ALL", "LC_CTYPE", "LPDEST", "PRINTER", "TZ", "XMODIFIERS"};
        DEFAULT_WINDOWS_ENV_VARS = new String[]{"SystemDrive", "SystemRoot", "windir", "TMP", "TEMP", "TZ"};
        i18n = I18NResourceBundle.getBundleForClass(Tool.class);
    }

    public static enum ReportMode {
        NONE,
        EXECUTED,
        ALL_EXECUTED,
        ALL;

    }
}

