/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.TestFilter;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.config.TestManager;
import com.sun.javatest.regtest.report.ElapsedTimeHandler;
import com.sun.javatest.regtest.report.TestNGReporter;
import com.sun.javatest.regtest.report.TestStats;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.util.HTMLWriter;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegressionReporter {
    final PrintWriter log;
    private File reportDir;
    private TestManager testManager;
    private File parent;
    DateFormat df = DateFormat.getDateTimeInstance();
    String backups = System.getProperty("javatest.report.backups");
    List<String> reportKinds = Arrays.asList(System.getProperty("javatest.report.kinds", "html text").split("[ ,]+"));

    public RegressionReporter(PrintWriter printWriter) {
        this.log = printWriter;
    }

    public void report(RegressionParameters regressionParameters, ElapsedTimeHandler elapsedTimeHandler, TestStats testStats, TestFilter testFilter, boolean bl) {
        File file = regressionParameters.getReportDir();
        File file2 = regressionParameters.getWorkDirectory().getRoot();
        try {
            if (Thread.interrupted()) {
                this.log.println("WARNING: interrupt status cleared prior to writing report");
            }
            Report report = new Report();
            ReportSettings reportSettings = new ReportSettings(regressionParameters);
            if (this.reportKinds.contains("html")) {
                reportSettings.setEnableHtmlReport(true);
                reportSettings.setHtmlMainReport(true, true);
                reportSettings.setShowKflReport(false);
            }
            if (this.reportKinds.contains("text")) {
                reportSettings.setEnablePlainReport(true);
            }
            if (this.reportKinds.contains("xml")) {
                reportSettings.setEnableXmlReport(true);
            }
            reportSettings.setFilter(testFilter);
            if (this.backups == null) {
                reportSettings.setEnableBackups(false);
            } else {
                try {
                    reportSettings.setBackupLevels(Integer.parseInt(this.backups));
                    reportSettings.setEnableBackups(true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            file.mkdirs();
            report.writeReports(reportSettings, file);
            if (reportSettings.isPlainEnabled()) {
                TestNGReporter testNGReporter;
                if (elapsedTimeHandler != null) {
                    elapsedTimeHandler.report(report);
                }
                if (testStats != null) {
                    testStats.report(report);
                }
                if (!(testNGReporter = TestNGReporter.instance(regressionParameters.getWorkDirectory())).isEmpty()) {
                    testNGReporter.writeReport(file);
                }
            }
            this.fixupReports(file, file2);
            if (!bl) {
                this.logReportWritten(file);
            }
        }
        catch (IOException iOException) {
            this.log.println("Error while writing report: " + iOException);
        }
        catch (SecurityException securityException) {
            this.log.println("Error while writing report: " + securityException);
        }
    }

    public void report(TestManager testManager) throws Main.Fault {
        this.testManager = testManager;
        this.reportDir = testManager.getReportDirectory();
        this.parent = RegressionReporter.getCommonParent(testManager.getTestSuites());
        if (this.parent != null && this.parent.getParentFile() == null) {
            this.parent = null;
        }
        try {
            if (this.reportKinds.contains("html")) {
                this.writeHTMLReport();
            }
            if (this.reportKinds.contains("text")) {
                this.writeCombinedSummary();
            }
            this.writeIndex();
            this.fixupReports(this.reportDir, testManager.getWorkDirectory());
            this.logReportWritten(this.reportDir);
        }
        catch (IOException iOException) {
            this.log.println("Error while writing report: " + iOException);
        }
    }

    private void logReportWritten(File file) {
        File file2 = new File(new File(file, "html"), "report.html");
        if (file2.exists()) {
            this.log.println("Report written to " + RegressionReporter.canon(file2));
        }
    }

    private void writeHTMLReport() throws IOException, Main.Fault {
        String string = this.parent == null ? "MultiRun Report" : "MultiRun Report: " + this.parent;
        File file = new File(this.reportDir, "html");
        file.mkdirs();
        File file2 = new File(file, "report.html");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));){
            HTMLWriter hTMLWriter = new HTMLWriter(bufferedWriter);
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("head");
            hTMLWriter.startTag("title");
            hTMLWriter.write(string);
            hTMLWriter.endTag("title");
            hTMLWriter.endTag("head");
            hTMLWriter.startTag("body");
            hTMLWriter.startTag("h1");
            hTMLWriter.write(string);
            hTMLWriter.endTag("h1");
            hTMLWriter.startTag("p");
            hTMLWriter.write("Date of report: " + this.df.format(new Date()));
            hTMLWriter.endTag("p");
            hTMLWriter.startTag("table");
            hTMLWriter.writeAttr("border", "1");
            hTMLWriter.startTag("tr");
            for (String object : new String[]{"Test Suite", "Results", "Report"}) {
                hTMLWriter.startTag("th");
                hTMLWriter.write(object);
                hTMLWriter.endTag("th");
            }
            hTMLWriter.endTag("tr");
            for (RegressionTestSuite regressionTestSuite : this.testManager.getTestSuites()) {
                hTMLWriter.startTag("tr");
                hTMLWriter.startTag("td");
                hTMLWriter.startTag("a");
                File file3 = regressionTestSuite.getRootDir();
                hTMLWriter.writeAttr("href", this.getURIPath(file3));
                hTMLWriter.write(RegressionReporter.relativize(this.parent, file3).getPath());
                hTMLWriter.endTag("a");
                hTMLWriter.endTag("td");
                hTMLWriter.startTag("td");
                hTMLWriter.startTag("a");
                File file4 = this.testManager.getWorkDirectory(regressionTestSuite).getRoot();
                hTMLWriter.writeAttr("href", this.getURIPath(file4));
                hTMLWriter.write(file4.getName());
                hTMLWriter.endTag("a");
                hTMLWriter.endTag("td");
                hTMLWriter.startTag("td");
                hTMLWriter.startTag("a");
                File file5 = this.testManager.getReportDirectory(regressionTestSuite);
                hTMLWriter.writeAttr("href", "../" + this.encode(file5.getName()) + "/index.html");
                hTMLWriter.write(file5.getName());
                hTMLWriter.endTag("a");
                hTMLWriter.endTag("td");
                hTMLWriter.endTag("tr");
            }
            hTMLWriter.endTag("table");
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
        }
    }

    private void fixupReports(File file, File file2) throws IOException {
        file2 = this.getCanonicalFile(file2);
        file = this.getCanonicalFile(file);
        File file3 = file2.getParentFile();
        File file4 = file.getParentFile();
        File file5 = new File(file, "html");
        if (RegressionReporter.equal(file2, file)) {
            this.fixupReportFiles(file, file2, ".");
            this.fixupReportFiles(file5, file2, "..");
        } else if (RegressionReporter.equal(file, file3)) {
            String string = this.encode(file2.getName());
            this.fixupReportFiles(file, file2, string);
            this.fixupReportFiles(file5, file2, "../" + string);
        } else if (RegressionReporter.equal(file2, file4)) {
            this.fixupReportFiles(file, file2, "..");
            this.fixupReportFiles(file5, file2, "../..");
        } else if (RegressionReporter.equal(file3, file4)) {
            String string = this.encode(file2.getName());
            this.fixupReportFiles(file, file2, "../" + string);
            this.fixupReportFiles(file5, file2, "../../" + string);
        } else if (RegressionReporter.equal(file3.getParentFile(), file4.getParentFile())) {
            String string = "../../" + this.encode(file3.getName()) + "/" + this.encode(file2.getName());
            this.fixupReportFiles(file, file2, string);
            this.fixupReportFiles(file5, file2, "../" + string);
        }
    }

    private String encode(String string) throws IOException {
        return URLEncoder.encode(string, "UTF-8");
    }

    private void fixupReportFiles(File file, File file2, String string) throws IOException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("href=\"" + this.getURIPath(file2) + "/", "href=\"" + string + "/");
        linkedHashMap.put("href=\"" + this.getURIPath(file2) + "\"", "href=\"" + string + "\"");
        linkedHashMap.put("href=\"" + this.getCanonicalURIPath(file2) + "/", "href=\"" + string + "/");
        linkedHashMap.put("href=\"" + this.getCanonicalURIPath(file2) + "\"", "href=\"" + string + "\"");
        linkedHashMap.put("href=\"" + this.getURIPath(file) + "/", "href=\"");
        linkedHashMap.put("href=\"" + this.getURIPath(file) + "\"", "href=\".\"");
        linkedHashMap.put("href=\"" + this.getCanonicalURIPath(file) + "/", "href=\"");
        linkedHashMap.put("href=\"" + this.getCanonicalURIPath(file) + "\"", "href=\".\"");
        linkedHashMap.put("href=\"#Configuration and Other Settings\"", "href=\"#Configuration%20and%20Other%20Settings\"");
        linkedHashMap.put("href=\"#Known Failure Analysis\"", "href=\"#Known%20Failure%20Analysis\"");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            this.log.println("Cannot update report files for " + file);
        } else {
            for (File file3 : fileArray) {
                if (!file3.getName().endsWith(".html")) continue;
                try {
                    String string2 = this.read(file3);
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        string2 = string2.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                    this.write(file3, string2);
                }
                catch (IOException iOException) {
                    this.log.println("Error while updating report: " + iOException);
                }
            }
        }
    }

    String getURIPath(File file) {
        String string = file.toURI().getRawPath();
        return string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
    }

    String getCanonicalURIPath(File file) throws IOException {
        File file2 = this.getCanonicalFile(file);
        StringBuilder stringBuilder = new StringBuilder();
        String string = file2.getPath();
        if (file2.isAbsolute() && !string.startsWith("/")) {
            stringBuilder.append('/');
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = c == File.separatorChar ? "/" : URLEncoder.encode(String.valueOf(c), "UTF-8");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    private void writeCombinedSummary() throws IOException, Main.Fault {
        File file = new File(this.reportDir, "text");
        file.mkdirs();
        File file2 = new File(file, "summary.txt");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));){
            for (RegressionTestSuite regressionTestSuite : this.testManager.getTestSuites()) {
                File file3 = new File(new File(this.testManager.getReportDirectory(regressionTestSuite), "text"), "summary.txt");
                if (!file3.exists()) continue;
                String string = this.read(file3);
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                bufferedWriter.write(string);
            }
        }
    }

    private void writeIndex() throws IOException {
        String string = this.parent == null ? "MultiRun Report" : "MultiRun Report: " + this.parent;
        File file = new File(this.reportDir, "index.html");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            HTMLWriter hTMLWriter = new HTMLWriter(bufferedWriter);
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("head");
            hTMLWriter.startTag("title");
            hTMLWriter.write(string);
            hTMLWriter.endTag("title");
            hTMLWriter.endTag("head");
            hTMLWriter.startTag("body");
            hTMLWriter.startTag("h1");
            hTMLWriter.write(string);
            hTMLWriter.endTag("h1");
            hTMLWriter.startTag("p");
            hTMLWriter.write("Date of report: " + this.df.format(new Date()));
            hTMLWriter.endTag("p");
            if (this.reportKinds.contains("html")) {
                hTMLWriter.startTag("p");
                hTMLWriter.startTag("a");
                hTMLWriter.writeAttr("href", "html/report.html");
                hTMLWriter.write("HTML Report");
                hTMLWriter.endTag("a");
                hTMLWriter.startTag("br");
                hTMLWriter.write("Contains links to the reports for the tests grouped by test suite.");
                hTMLWriter.endTag("p");
            }
            if (this.reportKinds.contains("text")) {
                hTMLWriter.startTag("p");
                hTMLWriter.startTag("a");
                hTMLWriter.writeAttr("href", "text/summary.txt");
                hTMLWriter.write("Plain Text Report");
                hTMLWriter.endTag("a");
                hTMLWriter.startTag("br");
                hTMLWriter.write("Combined text report for all the tests.");
                hTMLWriter.endTag("p");
            }
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
        }
    }

    private String read(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            dataInputStream.readFully(byArray);
            String string = new String(byArray);
            return string;
        }
    }

    private void write(File file, String string) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(string.getBytes());
        }
    }

    private static File getCommonParent(Set<RegressionTestSuite> set) {
        String string = File.separator;
        String string2 = null;
        for (RegressionTestSuite regressionTestSuite : set) {
            int n;
            File file = regressionTestSuite.getRootDir();
            File file2 = file.isDirectory() ? file : file.getParentFile();
            File file3 = file2 == null ? new File(System.getProperty("user.dir")) : file2.getAbsoluteFile();
            String string3 = file3.getPath();
            if (!string3.endsWith(string)) {
                string3 = string3 + string;
            }
            if (string2 == null || string2.startsWith(string3)) {
                string2 = string3;
                continue;
            }
            if (string3.startsWith(string2)) continue;
            int n2 = -1;
            while ((n = string2.indexOf(string, n2 + 1)) != -1 && n < string3.length() && string3.substring(n2 + 1, n).equals(string2.substring(n2 + 1, n))) {
                n2 = n;
            }
            if (n2 == -1) {
                return null;
            }
            string2 = string2.substring(0, n2 + 1);
        }
        return string2 == null ? null : new File(string2);
    }

    private static File relativize(File file, File file2) {
        if (file != null) {
            StringBuilder stringBuilder = new StringBuilder();
            while (file2 != null) {
                if (file2.equals(file)) {
                    return new File(stringBuilder.toString());
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.insert(0, File.separator);
                }
                stringBuilder.insert(0, file2.getName());
                file2 = file2.getParentFile();
            }
        }
        return file2;
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    private static <T> boolean equal(T t, T t2) {
        return t == null ? t2 == null : t.equals(t2);
    }
}

