/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ShellAction
extends Action {
    public static final String NAME = "shell";
    private static final String sep = ShellAction.getSeparator();
    private String shellFN;
    private List<String> shellArgs;
    private boolean reverseStatus = false;
    private int timeout = -1;
    private String manual = "unset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> map, List<String> list, String string, RegressionScript regressionScript) throws ParseException {
        super.init(map, list, string, regressionScript);
        if (list.isEmpty()) {
            throw new ParseException("No script name provided for `shell'");
        }
        block10: for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            switch (string2) {
                case "fail": {
                    this.reverseStatus = this.parseFail(string3);
                    continue block10;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(string3);
                    continue block10;
                }
                case "manual": {
                    this.manual = this.parseShellManual(string3);
                    continue block10;
                }
            }
            throw new ParseException("Bad option for shell: " + string2);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = regressionScript.getActionTimeout(-1);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        this.shellFN = list.get(0);
        this.shellArgs = new ArrayList<String>();
        Object object = null;
        for (int i = 1; i < list.size(); ++i) {
            if (object == null) {
                object = new StringBuilder(list.get(i));
            } else {
                ((StringBuilder)object).append(" ").append(list.get(i));
            }
            if (!ShellAction.isEvenQuotes((StringBuilder)object)) continue;
            this.shellArgs.add(((StringBuilder)object).toString().replace("'", ""));
            object = null;
        }
        if (object != null) {
            this.shellArgs.add(((StringBuilder)object).toString());
        }
    }

    private static boolean isEvenQuotes(StringBuilder stringBuilder) {
        int n = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != '\'') continue;
            ++n;
        }
        return n % 2 == 0;
    }

    @Override
    public Set<File> getSourceFiles() {
        return Collections.singleton(new File(this.script.absTestSrcDir(), this.shellFN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run() throws TestRunException {
        Status status;
        this.startAction(false);
        File file = new File(this.script.absTestSrcDir(), this.shellFN);
        if (!file.exists()) {
            throw new TestRunException("Can't find source file: " + file);
        }
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            Object object;
            Object object2;
            Object object3;
            File file2;
            ShellAction.mkdirs(this.script.absTestClsDir());
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.putAll(this.getEnvVars(true));
            Locations locations = this.script.locations;
            linkedHashMap.put("TESTFILE", this.fixupSep(locations.absTestFile()));
            linkedHashMap.put("TESTSRC", this.fixupSep(locations.absTestSrcDir()));
            linkedHashMap.put("TESTSRCPATH", this.fixupSep(locations.absTestSrcPath()));
            linkedHashMap.put("TESTCLASSES", this.fixupSep(locations.absTestClsDir()));
            linkedHashMap.put("TESTCLASSPATH", this.fixupSep(locations.absTestClsPath()));
            linkedHashMap.put("COMPILEJAVA", this.fixupSep(this.script.getCompileJDK().getAbsolutePath()));
            linkedHashMap.put("TESTJAVA", this.fixupSep(this.script.getTestJDK().getAbsolutePath()));
            List<String> list = this.script.getTestVMOptions();
            linkedHashMap.put("TESTVMOPTS", this.fixupSep(StringUtils.join(list, " ")));
            List<String> list2 = this.script.getTestToolVMOptions();
            linkedHashMap.put("TESTTOOLVMOPTS", this.fixupSep(StringUtils.join(list2, " ")));
            List<String> list3 = this.script.getTestCompilerOptions();
            linkedHashMap.put("TESTJAVACOPTS", this.fixupSep(StringUtils.join(list3, " ")));
            List<String> list4 = this.script.getTestJavaOptions();
            linkedHashMap.put("TESTJAVAOPTS", this.fixupSep(StringUtils.join(list4, " ")));
            linkedHashMap.put("TESTTIMEOUTFACTOR", String.valueOf(this.script.getTimeoutFactor()));
            linkedHashMap.put("TESTROOT", this.script.getTestRootDir().getPath());
            Modules modules = this.script.getModules();
            if (!modules.isEmpty()) {
                linkedHashMap.put("TESTMODULES", modules.toString());
            }
            if ((file2 = this.script.getNativeDir()) != null) {
                linkedHashMap.put("TESTNATIVEPATH", file2.getAbsolutePath());
            }
            if (this.script.enablePreview()) {
                linkedHashMap.put("TESTENABLEPREVIEW", "true");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.script.useWindowsSubsystemForLinux()) {
                object3 = new File(new File(this.script.getTestJDK().getFile(), "bin"), "java.exe");
                linkedHashMap.put("NULL", "/dev/null");
                if (((File)object3).exists()) {
                    linkedHashMap.put("EXE_SUFFIX", ".exe");
                    linkedHashMap.put("FS", "/");
                    linkedHashMap.put("PS", File.pathSeparator);
                    linkedHashMap.put("WSLENV", this.getWSLENV(linkedHashMap, true));
                } else {
                    linkedHashMap.put("FS", "/");
                    linkedHashMap.put("PS", ";");
                    linkedHashMap.put("WSLENV", this.getWSLENV(linkedHashMap, false));
                }
                arrayList.add("wsl.exe");
                arrayList.add("sh");
                arrayList.add(this.getWSLPath(file));
            } else {
                object3 = File.separator;
                object2 = File.pathSeparator;
                object = "/dev/null";
                if (OS.current().family.equals("windows")) {
                    if (System.getenv("PATH").contains("/cygwin")) {
                        object3 = "/";
                    } else {
                        object = "NUL";
                    }
                }
                linkedHashMap.put("FS", (String)object3);
                linkedHashMap.put("PS", (String)object2);
                linkedHashMap.put("NULL", (String)object);
                arrayList.add("sh");
                arrayList.add(file.getPath());
            }
            arrayList.addAll(this.shellArgs);
            object3 = this.section.createOutput("System.out");
            object2 = this.section.createOutput("System.err");
            object = this.script.getLockIfRequired();
            if (object != null) {
                ((Lock)object).lock();
            }
            try {
                if (showCmd) {
                    this.showCmd(NAME, arrayList, this.section);
                }
                this.recorder.exec(arrayList, linkedHashMap);
                TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
                ProcessCommand processCommand = new ProcessCommand().setExecDir(this.script.absTestScratchDir()).setCommand(arrayList).setEnvironment(linkedHashMap).setStreams((PrintWriter)object3, (PrintWriter)object2).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
                status = RStatus.normalize(processCommand.exec());
            }
            finally {
                if (object != null) {
                    ((Lock)object).unlock();
                }
                if (object3 != null) {
                    ((PrintWriter)object3).close();
                }
                if (object2 != null) {
                    ((PrintWriter)object2).close();
                }
            }
            if (!status.isError()) {
                String string;
                boolean bl = status.isPassed();
                int n = status.getType();
                if (bl && this.reverseStatus) {
                    string = "Execution passed unexpectedly";
                    n = 1;
                } else if (bl && !this.reverseStatus) {
                    string = "Execution successful";
                } else if (!bl && this.reverseStatus) {
                    string = "Execution failed as expected";
                    n = 0;
                } else {
                    string = "Execution failed";
                }
                if (n == 1 && !status.getReason().equals("") && !status.getReason().equals("Execution successful")) {
                    string = string + ": " + status.getReason();
                }
                status = RStatus.createStatus(n, string);
            }
        }
        this.endAction(status);
        return status;
    }

    private String fixupSep(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(this.fixupSep(file));
        }
        return stringBuilder.toString();
    }

    private String fixupSep(File file) {
        return this.fixupSep(file.getPath());
    }

    private String fixupSep(String string) {
        return sep == null ? string : string.replace(File.separator, sep);
    }

    private static String getSeparator() {
        return File.separatorChar == '\\' ? System.getProperty("javatest.shell.separator", "/") : null;
    }

    private String parseShellManual(String string) throws ParseException {
        if (string != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + string);
        }
        string = "novalue";
        return string;
    }

    private String getWSLENV(Map<String, String> map, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        Iterator<String> iterator = map.keySet().iterator();
        block15: while (iterator.hasNext()) {
            String string2;
            String string3;
            switch (string3 = iterator.next()) {
                case "COMPILEJAVA": 
                case "TESTJAVA": 
                case "TESTROOT": {
                    string2 = "/p";
                    break;
                }
                case "TESTSRC": 
                case "TESTCLASSES": {
                    string2 = bl ? "" : "/p";
                    break;
                }
                case "TESTSRCPATH": 
                case "TESTCLASSPATH": 
                case "TESTNATIVEPATH": {
                    string2 = bl ? "" : "/l";
                    break;
                }
                default: {
                    if (string3.equalsIgnoreCase("PATH")) continue block15;
                    string2 = "";
                }
            }
            stringBuilder.append(string).append(string3).append(string2);
            string = ":";
        }
        return stringBuilder.toString();
    }

    private String getWSLPath(File file) {
        Path path = file.toPath().toAbsolutePath();
        char c = Character.toLowerCase(path.getRoot().toString().charAt(0));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/mnt/").append(c);
        for (Path path2 : path) {
            stringBuilder.append("/").append(path2);
        }
        return stringBuilder.toString();
    }
}

