/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.AgentServer;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.ProcessUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Agent {
    static final boolean showAgent = Flags.get("showAgent");
    static final boolean traceAgent = Flags.get("traceAgent");
    private TestResult.Section currentTestResultSection;
    private Map<String, PrintWriter> processStreamWriters = new HashMap<String, PrintWriter>();
    final JDK jdk;
    final List<String> vmOpts;
    final File execDir;
    final Process process;
    final DataInputStream in;
    final DataOutputStream out;
    final AgentServer.KeepAlive keepAlive;
    final int id;
    final Logger logger;
    Instant idleStartTime;
    static int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Agent(File file, JDK jDK, List<String> list, Map<String, String> map, File file2, float f, Logger logger) throws Fault {
        try {
            this.id = ++count;
            this.jdk = jDK;
            this.execDir = file;
            this.vmOpts = list;
            this.logger = logger;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(jDK.getJavaProg().getPath());
            arrayList.addAll(list);
            if (file2 != null) {
                arrayList.add("-Djava.security.policy=" + file2.toURI());
            }
            arrayList.add(AgentServer.class.getName());
            arrayList.add("-id");
            arrayList.add(String.valueOf(this.id));
            arrayList.add("-logfile");
            arrayList.add(logger.getAgentServerLogFile(this.id).getPath());
            if (file2 != null) {
                arrayList.add("-allowSetSecurityManager");
            }
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(0), 1);
            arrayList.add("-port");
            arrayList.add(String.valueOf(serverSocket.getLocalPort()));
            if (f != 1.0f) {
                arrayList.add("-timeoutFactor");
                arrayList.add(String.valueOf(f));
            }
            this.log("Started " + arrayList);
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(file);
            Map<String, String> map2 = processBuilder.environment();
            map2.clear();
            map2.putAll(map);
            this.process = processBuilder.start();
            this.copyAgentProcessStream("stdout", this.process.getInputStream());
            this.copyAgentProcessStream("stderr", this.process.getErrorStream());
            try {
                int n = (int)(60000.0f * f);
                serverSocket.setSoTimeout(n);
                Socket socket = serverSocket.accept();
                socket.setSoTimeout((int)(120000.0f * f));
                this.in = new DataInputStream(socket.getInputStream());
                this.out = new DataOutputStream(socket.getOutputStream());
            }
            finally {
                serverSocket.close();
            }
            this.keepAlive = new AgentServer.KeepAlive(this.out, traceAgent);
            this.keepAlive.setEnabled(true);
        }
        catch (IOException iOException) {
            throw new Fault(iOException);
        }
    }

    void copyAgentProcessStream(final String string, final InputStream inputStream) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        Agent.this.handleProcessStreamLine(string, string2);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private synchronized void captureProcessStreams(TestResult.Section section) {
        this.currentTestResultSection = section;
        if (this.currentTestResultSection == null) {
            for (PrintWriter printWriter : this.processStreamWriters.values()) {
                printWriter.close();
            }
            this.processStreamWriters.clear();
        }
    }

    private synchronized void handleProcessStreamLine(String string, String string2) {
        if (this.currentTestResultSection == null) {
            this.log(string + ": " + string2);
        } else {
            this.processStreamWriters.computeIfAbsent(string, this.currentTestResultSection::createOutput).println(string2);
        }
    }

    public boolean matches(File file, JDK jDK, List<String> list) {
        return this.execDir.getName().equals(file.getName()) && this.jdk.equals(jDK) && this.vmOpts.equals(list);
    }

    public Status doCompileAction(final String string, final Map<String, String> map, final List<String> list, int n, TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        this.trace("doCompileAction " + string + " " + list);
        return this.doAction("doCompileAction", new AgentAction(){

            @Override
            public void send() throws IOException {
                Agent.this.out.writeByte(1);
                Agent.this.out.writeUTF(string);
                Agent.this.writeMap(map);
                Agent.this.writeCollection(list);
                Agent.this.out.flush();
            }
        }, n, timeoutHandler, section);
    }

    public Status doMainAction(final String string, final Map<String, String> map, final Set<String> set, final Set<String> set2, final Set<String> set3, final SearchPath searchPath, final SearchPath searchPath2, final String string2, final List<String> list, int n, TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        this.trace("doMainAction: " + string + " " + searchPath + " " + searchPath2 + " " + string2 + " " + list);
        return this.doAction("doMainAction", new AgentAction(){

            @Override
            public void send() throws IOException {
                Agent.this.out.writeByte(2);
                Agent.this.out.writeUTF(string);
                Agent.this.writeMap(map);
                Agent.this.writeCollection(set);
                Agent.this.writeCollection(set2);
                Agent.this.writeCollection(set3);
                Agent.this.out.writeUTF(searchPath.toString());
                Agent.this.out.writeUTF(searchPath2.toString());
                Agent.this.out.writeUTF(string2);
                Agent.this.writeCollection(list);
                Agent.this.out.flush();
            }
        }, n, timeoutHandler, section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status doAction(String string, AgentAction agentAction, int n, final TimeoutHandler timeoutHandler, TestResult.Section section) throws Fault {
        final PrintWriter printWriter = section.getMessageWriter();
        Alarm alarm = Alarm.NONE;
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        if (n > 0) {
            if (timeoutHandler == null) {
                throw new NullPointerException("TimeoutHandler is required");
            }
            this.trace(string + ": scheduling timeout handler in " + n + " seconds");
            alarm = Alarm.schedule(n, TimeUnit.SECONDS, printWriter, new Runnable(){

                @Override
                public void run() {
                    Agent.this.invokeTimeoutHandler(timeoutHandler, countDownLatch, printWriter);
                }
            });
        }
        this.keepAlive.setEnabled(false);
        try {
            this.captureProcessStreams(section);
            Object object = this.out;
            synchronized (object) {
                agentAction.send();
            }
            this.trace(string + ": request sent");
            object = this.readResults(section);
            return object;
        }
        catch (IOException iOException) {
            this.trace(string + ":  error " + iOException);
            throw new Fault(iOException);
        }
        finally {
            this.captureProcessStreams(null);
            alarm.cancel();
            this.keepAlive.setEnabled(true);
            if (alarm.didFire()) {
                this.waitForTimeoutHandler(string, timeoutHandler, countDownLatch);
                throw new Fault(new Exception("Agent " + this.id + " timed out with a timeout of " + n + " seconds"));
            }
        }
    }

    private void invokeTimeoutHandler(final TimeoutHandler timeoutHandler, final CountDownLatch countDownLatch, final PrintWriter printWriter) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Agent.this.trace("timeout handler triggered");
                timeoutHandler.handleTimeout(Agent.this.process);
                try {
                    Agent.this.out.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(printWriter);
                }
                try {
                    Agent.this.in.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(printWriter);
                }
                Agent.this.trace("timeout handler finished");
                countDownLatch.countDown();
            }
        };
        thread.setName("Timeout Handler for Agent " + this.getId());
        thread.start();
    }

    private void waitForTimeoutHandler(String string, TimeoutHandler timeoutHandler, CountDownLatch countDownLatch) {
        this.trace(string + ":  waiting for timeout handler to complete.");
        try {
            if (timeoutHandler.getTimeout() <= 0L) {
                countDownLatch.await();
            } else {
                boolean bl = countDownLatch.await(timeoutHandler.getTimeout() + 10L, TimeUnit.SECONDS);
                if (!bl) {
                    this.trace(string + ": timeout handler did not complete within its own timeout.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.trace(string + ":  interrupted while waiting for timeout handler to complete: " + interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.log("Closing...");
        this.keepAlive.finished();
        try {
            this.out.write(6);
            this.out.close();
        }
        catch (IOException iOException) {
            this.trace("Killing process (" + iOException + ")");
            ProcessUtils.destroyForcibly(this.process);
        }
        PrintWriter printWriter = new PrintWriter(System.err, true);
        Alarm alarm = Alarm.schedulePeriodicInterrupt(60L, TimeUnit.SECONDS, printWriter, Thread.currentThread());
        try {
            int n = this.process.waitFor();
            if (n != 0) {
                this.trace("Exited, process exit code: " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.log("Interrupted while closing");
            this.log("Killing process");
            ProcessUtils.destroyForcibly(this.process);
        }
        finally {
            alarm.cancel();
            Thread.interrupted();
        }
        this.log("Closed");
    }

    void writeCollection(Collection<String> collection) throws IOException {
        this.out.writeShort(collection.size());
        for (String string : collection) {
            this.out.writeUTF(string);
        }
    }

    void writeOptionalString(String string) throws IOException {
        if (string == null) {
            this.out.writeByte(0);
        } else {
            this.out.writeByte(1);
            this.out.writeUTF(string);
        }
    }

    static String readOptionalString(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by == 0 ? null : dataInputStream.readUTF();
    }

    void writeMap(Map<String, String> map) throws IOException {
        this.out.writeShort(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.out.writeUTF(entry.getKey());
            this.out.writeUTF(entry.getValue());
        }
    }

    Status readResults(TestResult.Section section) throws IOException {
        byte by;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block5: while ((by = this.in.readByte()) != -1) {
            switch (by) {
                case 3: {
                    String string = this.in.readUTF();
                    String string2 = this.in.readUTF();
                    this.trace("readResults: OUTPUT '" + string + "' '" + string2 + "\"");
                    Object object = (PrintWriter)hashMap.get(string);
                    if (object == null) {
                        object = string.equals(ActionHelper.OutputHandler.OutputKind.LOG.name) ? section.getMessageWriter() : section.createOutput(string);
                        hashMap.put(string, object);
                    }
                    ((PrintWriter)object).write(string2);
                    continue block5;
                }
                case 4: {
                    byte by2 = this.in.readByte();
                    String string2 = this.in.readUTF();
                    this.trace("readResults: STATUS '" + by2 + "' '" + string2 + "\"");
                    for (PrintWriter printWriter : hashMap.values()) {
                        if (printWriter == section.getMessageWriter()) continue;
                        printWriter.close();
                    }
                    Object object = RStatus.createStatus(by2, string2);
                    return object;
                }
                case 5: {
                    continue block5;
                }
            }
            throw new IOException("Agent: unexpected op: " + by);
        }
        throw new EOFException("unexpected EOF");
    }

    public int getId() {
        return this.id;
    }

    private void log(String string) {
        this.logger.log(this, string);
        this.show(string);
    }

    private void show(String string) {
        if (showAgent || traceAgent) {
            this.log(string, System.err);
        }
    }

    private void trace(String string) {
        if (traceAgent) {
            this.log(string, System.err);
        }
    }

    private void log(String string, PrintStream printStream) {
        printStream.println("[" + AgentServer.logDateFormat.format(new Date()) + "] Agent[" + this.getId() + "]: " + string);
    }

    static class Stats {
        Set<File> allDirs = new TreeSet<File>();
        Set<JDK> allJDKs = new TreeSet<JDK>(Comparator.comparing(jDK -> jDK.getPath()));
        Set<List<String>> allVMOpts = new TreeSet<List>(Comparator.comparing(Objects::toString));
        Map<Integer, Integer> useCounts = new TreeMap<Integer, Integer>();
        Map<Integer, Integer> sizeCounts = new TreeMap<Integer, Integer>();

        Stats() {
        }

        void add(Agent agent) {
            this.allDirs.add(agent.execDir);
            this.allJDKs.add(agent.jdk);
            this.allVMOpts.add(agent.vmOpts);
            this.useCounts.put(agent.id, 1);
        }

        void reuse(Agent agent) {
            this.useCounts.put(agent.id, this.useCounts.get(agent.id) + 1);
        }

        void trackPoolSize(int n2) {
            this.sizeCounts.put(n2, this.sizeCounts.computeIfAbsent(n2, n -> 0) + 1);
        }

        void clear() {
            this.allDirs.clear();
            this.allJDKs.clear();
            this.allVMOpts.clear();
            this.useCounts.clear();
            this.sizeCounts.clear();
        }

        void report(File file, Logger logger) {
            try (PrintWriter printWriter = new PrintWriter(new FileWriter(file));){
                this.report(printWriter, "Execution Directories", this.allDirs);
                printWriter.println();
                this.report(printWriter, "JDKs", this.allJDKs);
                printWriter.println();
                this.report(printWriter, "VM Options", this.allVMOpts);
                printWriter.println();
                printWriter.format("Agent Usage:%n", new Object[0]);
                this.useCounts.forEach((n, n2) -> printWriter.format("    %3d: %3d%n", n, n2));
                double[] dArray = this.getSimpleMeanStandardDeviation(this.useCounts.values());
                printWriter.format("Mean:          %5.1f%n", dArray[0]);
                printWriter.format("Std Deviation: %5.1f%n", dArray[1]);
                printWriter.println();
                printWriter.format("Pool Size:%n", new Object[0]);
                this.sizeCounts.forEach((n, n2) -> printWriter.format("    %3d: %3d%n", n, n2));
                double[] dArray2 = this.getWeightedMeanStandardDeviation(this.sizeCounts);
                printWriter.format("Mean          %5.1f%n", dArray2[0]);
                printWriter.format("Std Deviation %5.1f%n", dArray2[1]);
            }
            catch (IOException iOException) {
                logger.log(null, "STATS: can't write stats file " + file + ": " + iOException);
            }
        }

        private <T> void report(PrintWriter printWriter, String string, Set<T> set) {
            printWriter.format("%s: %d%n", string, set.size());
            set.forEach(object -> printWriter.format("    %s%n", object));
        }

        double[] getSimpleMeanStandardDeviation(Collection<Integer> collection) {
            double d = 0.0;
            for (Integer n : collection) {
                d += (double)n.intValue();
            }
            double d2 = d / (double)collection.size();
            double d3 = 0.0;
            for (Integer n : collection) {
                double d4 = (double)n.intValue() - d2;
                d3 += d4 * d4;
            }
            double d5 = Math.sqrt(d3 / (double)collection.size());
            return new double[]{d2, d5};
        }

        double[] getWeightedMeanStandardDeviation(Map<Integer, Integer> map) {
            long l = 0L;
            double d = 0.0;
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                int n = entry.getKey();
                int n2 = entry.getValue();
                d += (double)(n * n2);
                l += (long)n2;
            }
            double d2 = d / (double)l;
            double d3 = 0.0;
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                int n = entry.getKey();
                int n3 = entry.getValue();
                double d4 = (double)n - d2;
                d3 += d4 * d4 * (double)n3;
            }
            double d5 = Math.sqrt(d3 / (double)l);
            return new double[]{d2, d5};
        }
    }

    public static class Pool {
        private static WeakHashMap<RegressionParameters, Pool> instances = new WeakHashMap();
        private Stats stats = new Stats();
        private final Logger logger;
        private final Map<String, Deque<Agent>> agentsByKey = new HashMap<String, Deque<Agent>>();
        private final Deque<Agent> allAgents = new LinkedList<Agent>();
        private File policyFile;
        private float timeoutFactor = 1.0f;
        private int maxPoolSize;
        private Duration idleTimeout;

        public static synchronized Pool instance(RegressionParameters regressionParameters) {
            return instances.computeIfAbsent(regressionParameters, Pool::new);
        }

        private Pool(RegressionParameters regressionParameters) {
            this.logger = Logger.instance(regressionParameters);
        }

        public void setSecurityPolicy(File file) {
            this.policyFile = file;
        }

        public void setTimeoutFactor(float f) {
            this.timeoutFactor = f;
        }

        public void setIdleTimeout(Duration duration) {
            this.idleTimeout = duration;
            this.logger.log(null, "POOL: idle timeout: " + duration);
        }

        public void setMaxPoolSize(int n) {
            this.maxPoolSize = n;
            this.logger.log(null, "POOL: max pool size: " + this.maxPoolSize);
        }

        synchronized Agent getAgent(File file, JDK jDK, List<String> list, Map<String, String> map) throws Fault {
            Agent agent;
            this.logger.log(null, "POOL: get agent for:\n   directory: " + file + "\n         JDK: " + jDK + "\n  VM options: " + list + "\n");
            Deque<Agent> deque = this.agentsByKey.get(Pool.getKey(file, jDK, list));
            Agent agent2 = agent = deque == null ? null : deque.pollLast();
            if (agent != null) {
                this.logger.log(null, "POOL: Reusing Agent[" + agent.getId() + "]");
                this.allAgents.remove(agent);
                this.stats.reuse(agent);
            } else {
                this.logger.log(null, "POOL: Creating new agent");
                agent = new Agent(file, jDK, list, map, this.policyFile, this.timeoutFactor, this.logger);
                this.stats.add(agent);
            }
            return agent;
        }

        synchronized void save(Agent agent) {
            Instant instant;
            this.logger.log(agent, "Saving agent to pool");
            String string2 = Pool.getKey(agent.execDir, agent.jdk, agent.vmOpts);
            this.agentsByKey.computeIfAbsent(string2, string -> new LinkedList()).add(agent);
            this.allAgents.addLast(agent);
            agent.idleStartTime = instant = Instant.now();
            this.cleanOldEntries(instant);
            this.stats.trackPoolSize(this.allAgents.size());
        }

        private synchronized void cleanOldEntries(Instant instant) {
            Agent agent;
            while (this.allAgents.size() > this.maxPoolSize) {
                agent = this.allAgents.getFirst();
                this.logger.log(agent, "Removing excess agent from pool");
                this.removeAgent(agent);
            }
            while (!this.allAgents.isEmpty() && this.isIdleTooLong(this.allAgents.peekFirst(), instant)) {
                agent = this.allAgents.getFirst();
                this.logger.log(agent, "Removing idle agent from pool");
                this.removeAgent(agent);
            }
        }

        private void removeAgent(Agent agent) {
            this.agentsByKey.get(Pool.getKey(agent)).remove(agent);
            this.allAgents.remove(agent);
            agent.close();
        }

        private boolean isIdleTooLong(Agent agent, Instant instant) {
            return Duration.between(agent.idleStartTime, instant).compareTo(this.idleTimeout) > 0;
        }

        public static synchronized void flush(RegressionParameters regressionParameters) {
            Pool pool = instances.get(regressionParameters);
            if (pool != null) {
                pool.flush();
            }
        }

        public synchronized void flush() {
            this.logger.log(null, "POOL: closing all agents");
            for (Agent agent : this.allAgents) {
                agent.close();
            }
            this.allAgents.clear();
            this.agentsByKey.clear();
            this.stats.report(new File(this.logger.agentLogFileDirectory, "agent.summary"), this.logger);
        }

        static synchronized void close(RegressionParameters regressionParameters, File file) {
            Pool pool = instances.get(regressionParameters);
            if (pool != null) {
                pool.close(file);
            }
        }

        synchronized void close(File file) {
            this.logger.log(null, "POOL: closing agents using directory " + file);
            Iterator<Agent> iterator = this.allAgents.iterator();
            while (iterator.hasNext()) {
                Agent agent = iterator.next();
                if (!agent.execDir.equals(file)) continue;
                iterator.remove();
                String string = Pool.getKey(agent);
                Deque<Agent> deque = this.agentsByKey.get(string);
                deque.remove(agent);
                if (deque.isEmpty()) {
                    this.agentsByKey.remove(string);
                }
                agent.close();
            }
        }

        private static String getKey(Agent agent) {
            return Pool.getKey(agent.execDir, agent.jdk, agent.vmOpts);
        }

        private static String getKey(File file, JDK jDK, List<String> list) {
            return file.getAbsolutePath() + " " + jDK.getAbsoluteFile() + " " + StringUtils.join(list, " ");
        }
    }

    public static class Logger {
        private static WeakHashMap<RegressionParameters, Logger> instances = new WeakHashMap();
        private File agentLogFileDirectory;
        private final PrintWriter agentLogWriter;

        public static synchronized Logger instance(RegressionParameters regressionParameters) {
            return instances.computeIfAbsent(regressionParameters, Logger::new);
        }

        public static void close(RegressionParameters regressionParameters) throws IOException {
            Logger logger = instances.get(regressionParameters);
            if (logger != null) {
                logger.close();
            }
        }

        Logger(RegressionParameters regressionParameters) {
            PrintWriter printWriter;
            WorkDirectory workDirectory = regressionParameters.getWorkDirectory();
            this.agentLogFileDirectory = workDirectory.getJTData();
            File file = new File(this.agentLogFileDirectory, "agent.trace");
            try {
                printWriter = new PrintWriter(new FileWriter(file));
            }
            catch (IOException iOException) {
                System.err.println("Cannot open agent log file: " + iOException);
                printWriter = new PrintWriter(System.err, true){

                    @Override
                    public void close() {
                        this.flush();
                    }
                };
            }
            this.agentLogWriter = printWriter;
        }

        void log(Agent agent, String string) {
            String string2;
            String string3 = AgentServer.logDateFormat.format(new Date());
            String string4 = string2 = agent == null ? "" : " Agent[" + agent.getId() + "]";
            if (string.contains("\n")) {
                String[] stringArray = string.split("\\R");
                int n = 0;
                for (String string5 : stringArray) {
                    this.agentLogWriter.printf("[%s]%s: #%d/%d %s%n", string3, string2, ++n, stringArray.length, string5);
                }
            } else {
                this.agentLogWriter.printf("[%s]%s: %s%n", string3, string2, string);
            }
        }

        File getAgentServerLogFile(int n) {
            return new File(this.agentLogFileDirectory, "agentServer." + n + ".trace");
        }

        public void close() throws IOException {
            this.agentLogWriter.close();
        }
    }

    static interface AgentAction {
        public void send() throws IOException;
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(Throwable throwable) {
            super(throwable);
        }
    }
}

