/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class JDKOpts {
    private final MergeHandler mergeHandler = new MergeHandler();
    private String pending;
    private static final char COMMA = ',';
    private static final char EQUALS = '=';
    private static final char NUL = '\u0000';
    private static final char PATHSEP = File.pathSeparatorChar;

    public static boolean hasFollowingArg(String string) {
        for (Option option : Option.values()) {
            for (String string2 : option.names) {
                if (!string.equals(string2) || string2.endsWith(":") || string2.endsWith("=")) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> toList() {
        return Collections.unmodifiableList(this.mergeHandler.opts);
    }

    public void addAll(List<String> list) {
        for (String string : list) {
            this.add(string);
        }
    }

    public void addAll(String ... stringArray) {
        for (String string : stringArray) {
            this.add(string);
        }
    }

    public void add(String string) {
        if (this.pending != null) {
            this.mergeHandler.handleOption(this.pending, string);
            this.pending = null;
        } else if (JDKOpts.hasFollowingArg(string)) {
            this.pending = string;
        } else {
            this.mergeHandler.handleOption(string);
        }
    }

    public void addPath(String string, SearchPath searchPath) {
        if (searchPath != null && !searchPath.isEmpty()) {
            if (string.endsWith(":")) {
                this.add(string + searchPath);
            } else {
                this.add(string);
                this.add(searchPath.toString());
            }
        }
    }

    public void addAllPatchModules(SearchPath searchPath) {
        if (searchPath != null) {
            for (File file : searchPath.asList()) {
                Object[] objectArray = file.listFiles();
                if (objectArray == null) continue;
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    if (!((File)object).isDirectory()) continue;
                    this.mergeHandler.handleOption(Option.PATCH_MODULE, "--patch-module", ((File)object).getName() + "=" + object);
                }
            }
        }
    }

    public static abstract class OptionHandler {
        public void handleOptions(String ... stringArray) {
            this.handleOptions(Arrays.asList(stringArray));
        }

        public void handleOptions(List<String> list) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.handleOption(string, iterator);
            }
        }

        void handleOption(String string) {
            this.handleOption(string, Collections.emptyIterator());
        }

        void handleOption(String string, String string2) {
            this.handleOption(string, Collections.singleton(string2).iterator());
        }

        void handleOption(String string, Iterator<String> iterator) {
            for (Option option : Option.values()) {
                for (String string2 : option.names) {
                    if (string2.startsWith("--")) {
                        if (string.equals(string2)) {
                            this.handleOption(option, string, iterator.next());
                            return;
                        }
                        if (!string.startsWith(string2 + "=")) continue;
                        this.handleOption(option, string, string.substring(string2.length() + 1));
                        return;
                    }
                    if (string2.endsWith(":")) {
                        if (!string.startsWith(string2)) continue;
                        this.handleOption(option, string, string.substring(string2.length()));
                        return;
                    }
                    if (!string.equals(string2)) continue;
                    this.handleOption(option, string, iterator.next());
                    return;
                }
            }
            this.handleUnknown(string);
        }

        protected abstract void handleOption(Option var1, String var2, String var3);

        protected abstract void handleUnknown(String var1);
    }

    private static class MergeHandler
    extends OptionHandler {
        private final List<String> opts = new ArrayList<String>();
        private final Map<String, Integer> index = new HashMap<String, Integer>();

        MergeHandler() {
        }

        @Override
        protected void handleOption(Option option, String string, String string2) {
            switch (option) {
                case ADD_EXPORTS: {
                    this.updateOptWhitespaceArg("--add-exports", string2, '=', ',');
                    break;
                }
                case ADD_EXPORTS_PRIVATE: 
                case ADD_OPENS: {
                    this.updateOptWhitespaceArg("--add-opens", string2, '=', ',');
                    break;
                }
                case ADD_MODULES: {
                    this.updateOptWhitespaceArg("--add-modules", string2, '\u0000', ',');
                    break;
                }
                case ADD_READS: {
                    this.updateOptWhitespaceArg("--add-reads", string2, '=', ',');
                    break;
                }
                case CLASS_PATH: {
                    this.updateOptWhitespaceArg("-classpath", string2, '\u0000', PATHSEP);
                    break;
                }
                case LIMIT_MODULES: {
                    this.updateOptWhitespaceArg("--limit-modules", string2, '\u0000', ',');
                    break;
                }
                case MODULE_PATH: {
                    this.updateOptWhitespaceArg("--module-path", string2, '\u0000', PATHSEP);
                    break;
                }
                case MODULE_SOURCE_PATH: {
                    this.updateOptWhitespaceArg("--module-source-path", string2, '\u0000', PATHSEP);
                    break;
                }
                case PATCH_MODULE: {
                    this.updateOptWhitespaceArg("--patch-module", string2, '=', PATHSEP);
                    break;
                }
                case SOURCE_PATH: {
                    this.updateOptWhitespaceArg("-sourcepath", string2, '\u0000', PATHSEP);
                }
            }
        }

        @Override
        protected void handleUnknown(String string) {
            this.opts.add(string);
        }

        private void updateOptAdjacentArg(String string, char c, char c2) {
            int n = string.indexOf(c);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            Integer n2 = this.index.get(string2);
            if (n2 == null) {
                n2 = this.opts.size();
                this.opts.add(string);
                this.index.put(string2, n2);
            } else {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                String[] stringArray = this.opts.get(n2).substring(n + 1).split(String.valueOf(c2));
                linkedHashSet.addAll(Arrays.asList(stringArray));
                linkedHashSet.addAll(Arrays.asList(string3.split(String.valueOf(c2))));
                StringBuilder stringBuilder = new StringBuilder(string2);
                for (String string4 : linkedHashSet) {
                    if (stringBuilder.length() > string2.length()) {
                        stringBuilder.append(c2);
                    }
                    stringBuilder.append(string4);
                }
                this.opts.set(n2, stringBuilder.toString());
            }
        }

        private void updateOptWhitespaceArg(String string, String string2, char c, char c2) {
            List<String> list;
            String string3;
            if (c != '\u0000' && string2.indexOf(c) != -1) {
                string3 = StringUtils.beforePart(string2, c);
                list = StringUtils.split(StringUtils.afterPart(string2, c), c2);
            } else {
                string3 = null;
                list = StringUtils.split(string2, c2);
            }
            String string4 = string3 == null ? string : string + "=" + string3;
            Integer n = this.index.get(string4);
            if (n == null) {
                n = this.opts.size();
                this.opts.add(string);
                this.opts.add(MergeHandler.join(string3, c, list, c2));
                this.index.put(string4, n);
            } else {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                String string5 = this.opts.get(n + 1);
                List<String> list2 = StringUtils.split(string3 == null ? string5 : StringUtils.afterPart(string5, c), c2);
                linkedHashSet.addAll(list2);
                linkedHashSet.addAll(list);
                this.opts.set(n + 1, MergeHandler.join(string3, c, linkedHashSet, c2));
            }
        }

        static String join(String string, char c, Collection<String> collection, char c2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                stringBuilder.append(string).append(c);
            }
            boolean bl = false;
            for (String string2 : collection) {
                if (bl) {
                    stringBuilder.append(c2);
                }
                stringBuilder.append(string2);
                bl = true;
            }
            return stringBuilder.toString();
        }
    }

    public static enum Option {
        ADD_EXPORTS("--add-exports"),
        ADD_EXPORTS_PRIVATE("--add-exports-private"),
        ADD_MODULES("--add-modules"),
        ADD_OPENS("--add-opens"),
        ADD_READS("--add-reads"),
        CLASS_PATH("--class-path", "-classpath", "-cp"),
        LIMIT_MODULES("--limit-modules"),
        MODULE_PATH("--module-path", "-p"),
        MODULE_SOURCE_PATH("--module-source-path"),
        PATCH_MODULE("--patch-module"),
        SOURCE_PATH("--source-path", "-sourcepath");

        final String[] names;

        private Option(String ... stringArray) {
            this.names = stringArray;
        }
    }
}

