/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.GetJDKProperties;
import com.sun.javatest.regtest.agent.GetSystemProperty;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExtraPropDefns;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JDK {
    private static final Map<File, JDK> cache = new HashMap<File, JDK>();
    private final File jdk;
    private final File absJDK;
    private String javaSpecificationVersion;
    private JDK_Version jdkVersion;
    private Map<Set<String>, String> fullVersions;
    private Boolean hasOldSymbolFile = null;
    private final Map<RegressionParameters, Info> infoMap = new HashMap<RegressionParameters, Info>();
    private static final boolean showModules = Flags.get("showModules");

    public static JDK of(String string) {
        return JDK.of(new File(string));
    }

    public static synchronized JDK of(File file) {
        JDK jDK = cache.get(file);
        if (jDK == null) {
            jDK = new JDK(file);
            cache.put(file, jDK);
        }
        return jDK;
    }

    private JDK(File file) {
        this.jdk = file;
        this.absJDK = file.getAbsoluteFile();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDK)) {
            return false;
        }
        JDK jDK = (JDK)object;
        return this.absJDK.equals(jDK.absJDK);
    }

    public int hashCode() {
        return this.absJDK.hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    public File getFile() {
        return this.jdk;
    }

    public File getAbsoluteFile() {
        return this.absJDK;
    }

    public File getJavaProg() {
        return this.getProg("java", false);
    }

    public File getJavacProg() {
        return this.getProg("javac", false);
    }

    public File getProg(String string, boolean bl) {
        File file;
        File file2 = new File(this.absJDK, "bin");
        File file3 = new File(file2, string);
        if (!file3.exists() && bl && (file = new File(file2, string + ".exe")).exists()) {
            return file;
        }
        return file3;
    }

    public boolean exists() {
        return this.jdk.exists();
    }

    public String getPath() {
        return this.jdk.getPath();
    }

    public String getAbsolutePath() {
        return this.absJDK.getPath();
    }

    public SearchPath getJDKClassPath() {
        return new SearchPath(new File(new File(this.absJDK, "lib"), "tools.jar"));
    }

    public JDK_Version getVersion(RegressionParameters regressionParameters, Consumer<String> consumer) {
        return this.getJDKVersion(regressionParameters.getJavaTestClassPath(), consumer);
    }

    public synchronized JDK_Version getJDKVersion(SearchPath searchPath, Consumer<String> consumer) {
        if (this.jdkVersion == null) {
            this.jdkVersion = JDK_Version.forName(this.getJavaSpecificationVersion(searchPath, consumer));
        }
        return this.jdkVersion;
    }

    private synchronized String getJavaSpecificationVersion(SearchPath searchPath, Consumer<String> consumer) {
        if (this.javaSpecificationVersion != null) {
            return this.javaSpecificationVersion;
        }
        for (Info object : this.infoMap.values()) {
            if (object.jdkProperties == null) continue;
            this.javaSpecificationVersion = object.jdkProperties.getProperty("java.specification.version");
            if (this.javaSpecificationVersion == null) continue;
            return this.javaSpecificationVersion;
        }
        this.javaSpecificationVersion = "unknown";
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.environment().put("CLASSPATH", searchPath.toString());
        processBuilder.command(this.getJavaProg().getPath(), GetSystemProperty.class.getName(), "java.specification.version");
        processBuilder.redirectErrorStream(true);
        try {
            Process interruptedException = processBuilder.start();
            List<String> list = this.getOutput(interruptedException, consumer);
            int n = interruptedException.waitFor();
            if (n == 0) {
                for (String string : list) {
                    String[] stringArray = string.trim().split("=", 2);
                    if (stringArray.length != 2 || !stringArray[0].equals("java.specification.version")) continue;
                    this.javaSpecificationVersion = stringArray[1];
                    break;
                }
                if (this.javaSpecificationVersion.equals("unknown")) {
                    consumer.accept("Error getting java.specification.version for " + this.jdk + ": property not found in output");
                    list.forEach(consumer::accept);
                }
            } else {
                consumer.accept("Error getting java.specification.version for " + this.jdk + ": exit code " + n);
                list.forEach(consumer::accept);
            }
        }
        catch (InterruptedException iOException) {
            consumer.accept("Error getting java.specification.version for " + this.jdk + ": " + iOException);
        }
        catch (IOException iOException) {
            consumer.accept("Error getting java.specification.version for " + this.jdk + ": " + iOException);
        }
        if (this.javaSpecificationVersion == null || this.javaSpecificationVersion.length() == 0) {
            this.javaSpecificationVersion = "1.1";
        }
        return this.javaSpecificationVersion;
    }

    public synchronized String getVersionText(Collection<String> collection, Consumer<String> consumer) {
        LinkedHashSet<String> linkedHashSet;
        String string;
        if (this.fullVersions == null) {
            this.fullVersions = new HashMap<Set<String>, String>();
        }
        if ((string = this.fullVersions.get(linkedHashSet = new LinkedHashSet<String>(collection))) == null) {
            string = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getJavaProg().getPath());
            arrayList.addAll(collection);
            arrayList.add("-version");
            try {
                Process process = new ProcessBuilder(arrayList).redirectErrorStream(true).start();
                List<String> list = this.getOutput(process, consumer);
                int n = process.waitFor();
                if (n == 0) {
                    string = StringUtils.join(list, "\n");
                } else {
                    consumer.accept("Error running 'java -version' for " + this.jdk + ": exit code " + n);
                    list.forEach(consumer::accept);
                }
            }
            catch (InterruptedException interruptedException) {
                consumer.accept("Error running 'java -version' for " + this.jdk + ": " + interruptedException);
            }
            catch (IOException iOException) {
                consumer.accept("Error running 'java -version' for " + this.jdk + ": " + iOException);
            }
            this.fullVersions.put(linkedHashSet, string);
        }
        return string;
    }

    public synchronized Properties getProperties(RegressionParameters regressionParameters, Consumer<String> consumer) throws Fault {
        Info info = this.getInfo(regressionParameters);
        if (info.jdkProperties == null) {
            info.jdkProperties = this.execGetProperties(regressionParameters, Collections.emptyList(), Arrays.asList("--system-properties", "--modules=boot-layer"), true, consumer);
        }
        return info.jdkProperties;
    }

    public boolean hasModules() {
        Consumer<String> consumer = System.err::println;
        Iterator<RegressionParameters> iterator = this.infoMap.keySet().iterator();
        if (iterator.hasNext()) {
            RegressionParameters regressionParameters = iterator.next();
            return !this.getDefaultModules(regressionParameters, consumer).isEmpty();
        }
        throw new IllegalStateException();
    }

    public synchronized Set<String> getDefaultModules(RegressionParameters regressionParameters, Consumer<String> consumer) {
        Info info = this.getInfo(regressionParameters);
        if (info.defaultModules == null) {
            try {
                Properties properties = this.getProperties(regressionParameters, consumer);
                String string = properties.getProperty("jtreg.modules");
                info.defaultModules = string == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(string.split(" +"))));
            }
            catch (Fault fault) {
                throw new IllegalStateException(fault);
            }
            if (showModules) {
                System.err.println("default modules: " + new TreeSet<String>(info.defaultModules));
            }
        }
        return info.defaultModules;
    }

    public synchronized Set<String> getSystemModules(RegressionParameters regressionParameters, Consumer<String> consumer) {
        Info info = this.getInfo(regressionParameters);
        if (info.systemModules == null) {
            if (this.getVersion(regressionParameters, consumer).compareTo(JDK_Version.V9) >= 0) {
                try {
                    String string;
                    String string2 = "--modules=all-system";
                    Object object = regressionParameters.getTestVMJavaOptions().iterator();
                    while (object.hasNext()) {
                        string = object.next();
                        if (!string.matches("--(add|limit)-modules(=.*)?")) continue;
                        string2 = "--modules=boot-layer";
                        break;
                    }
                    if ((string = ((Properties)(object = this.execGetProperties(regressionParameters, Collections.emptyList(), Arrays.asList(string2), false, consumer))).getProperty("jtreg.modules")) == null) {
                        info.systemModules = Collections.emptySet();
                    }
                    info.systemModules = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(string.split(" +"))));
                }
                catch (Fault fault) {
                    throw new IllegalStateException(fault);
                }
            } else {
                info.systemModules = Collections.emptySet();
            }
            if (showModules) {
                System.err.println("system modules: " + new TreeSet<String>(info.systemModules));
            }
        }
        return info.systemModules;
    }

    public boolean hasOldSymbolFile() {
        if (this.hasOldSymbolFile == null) {
            Comparable<JDK_Version> comparable;
            if (this.javaSpecificationVersion != null && (((JDK_Version)(comparable = JDK_Version.forName(this.javaSpecificationVersion))).compareTo(JDK_Version.V1_5) <= 0 || ((JDK_Version)comparable).compareTo(JDK_Version.V10) >= 0)) {
                this.hasOldSymbolFile = false;
                return this.hasOldSymbolFile;
            }
            comparable = new File(new File(this.absJDK, "lib"), "ct.sym");
            if (((File)comparable).exists()) {
                try (JarFile jarFile = new JarFile((File)comparable);){
                    JarEntry jarEntry = jarFile.getJarEntry("META-INF/sym/rt.jar/java/lang/Object.class");
                    this.hasOldSymbolFile = jarEntry != null;
                }
                catch (IOException iOException) {
                    this.hasOldSymbolFile = false;
                }
            } else {
                this.hasOldSymbolFile = false;
            }
        }
        return this.hasOldSymbolFile;
    }

    private Properties execGetProperties(RegressionParameters regressionParameters, List<String> list, List<String> list2, boolean bl, Consumer<String> consumer) throws Fault {
        ExtraPropDefns extraPropDefns = bl ? regressionParameters.getTestSuite().getExtraPropDefns() : new ExtraPropDefns();
        try {
            extraPropDefns.compile(regressionParameters, regressionParameters.getCompileJDK(), regressionParameters.getWorkDirectory().getFile("extraPropDefns"));
        }
        catch (ExtraPropDefns.Fault fault) {
            throw new Fault(fault.getMessage(), fault);
        }
        JDKOpts jDKOpts = new JDKOpts();
        jDKOpts.add("--class-path");
        SearchPath searchPath = new SearchPath(regressionParameters.getJavaTestClassPath());
        searchPath.append(extraPropDefns.getClassDir());
        jDKOpts.add(searchPath.toString());
        SearchPath searchPath2 = new SearchPath(extraPropDefns.getBootClassDir());
        if (!searchPath2.isEmpty()) {
            jDKOpts.add("-Xbootclasspath/a:" + searchPath2);
        }
        regressionParameters.getBasicTestProperties().forEach((string, string2) -> jDKOpts.add("-D" + string + "=" + string2));
        List<String> list3 = regressionParameters.getTestVMJavaOptions();
        jDKOpts.addAll(list3);
        jDKOpts.addAll(list);
        jDKOpts.addAll(extraPropDefns.getVMOpts());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getJavaProg().getPath());
        arrayList.addAll(jDKOpts.toList());
        arrayList.add(GetJDKProperties.class.getName());
        arrayList.addAll(list2);
        arrayList.addAll(extraPropDefns.getClasses());
        try {
            File file = regressionParameters.getWorkDirectory().getFile("scratch");
            file.mkdirs();
            Process process = new ProcessBuilder(arrayList).directory(file).start();
            this.asyncCopy(process.getErrorStream(), consumer);
            List<String> list4 = this.readLines(process.getInputStream());
            int n = process.waitFor();
            if (n != 0) {
                String string3 = "failed to get JDK properties for " + this.getJavaProg() + " " + StringUtils.join(list3, " ") + "; exit code " + n;
                consumer.accept(string3);
                throw new Fault(string3);
            }
            return this.loadProperties(list4, consumer);
        }
        catch (InterruptedException interruptedException) {
            consumer.accept("Error accessing extra property definitions: " + interruptedException);
            throw new Fault("Error accessing extra property definitions: " + interruptedException, interruptedException);
        }
        catch (IOException iOException) {
            consumer.accept("Error accessing extra property definitions: " + iOException);
            throw new Fault("Error accessing extra property definitions: " + iOException, iOException);
        }
    }

    private List<String> readLines(InputStream inputStream) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private Properties loadProperties(List<String> list, Consumer<String> consumer) throws Fault {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(String.join((CharSequence)"\n", list)));
        }
        catch (IOException iOException) {
            consumer.accept("Error loading extra property definitions: " + iOException);
            list.forEach(consumer::accept);
            throw new Fault("Error loading extra property definitions: " + iOException);
        }
        return properties;
    }

    private void asyncCopy(InputStream inputStream, Consumer<String> consumer) {
        new Thread(() -> {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    consumer.accept(string);
                }
            }
            catch (IOException iOException) {
                consumer.accept("Error reading stderr while accessing properties: " + iOException);
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getOutput(Process process, Consumer<String> consumer) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList2.add(string);
            }
            ArrayList<String> arrayList = arrayList2;
            return arrayList;
        }
        catch (IOException iOException) {
            consumer.accept("Error getting output from process: " + iOException);
            consumer.accept("Output so far:");
            arrayList2.forEach(consumer::accept);
            return Collections.singletonList(iOException.getMessage());
        }
    }

    private Info getInfo(RegressionParameters regressionParameters) {
        Info info = this.infoMap.get(regressionParameters);
        if (info == null) {
            info = new Info();
            this.infoMap.put(regressionParameters, info);
        }
        return info;
    }

    static class Info {
        Properties jdkProperties;
        Set<String> defaultModules;
        Set<String> systemModules;

        Info() {
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        Fault(String string) {
            super(string);
        }

        Fault(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

